/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.BaseUtils;
import com.fr.base.Icon;
import com.fr.data.NetworkHelper;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralContext;
import com.fr.general.IOUtils;
import com.fr.plugin.ExtraClassManager;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.ListMap;
import com.fr.stable.StringUtils;
import com.fr.stable.fun.Service;
import com.fr.stable.web.BrowserProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IconManager
implements XMLable,
Service {
    public static final String XML_TAG = "IM";
    private static ListMap iconMap = new ListMap();
    private static List<String> systemIconList = new ArrayList<String>();
    public static final Icon SUBMIT;
    public static final Icon SUBMITALL;
    public static final Icon SUBMITFORCILY;
    public static final Icon FIRST;
    public static final Icon PREVIOUS;
    public static final Icon NEXT;
    public static final Icon LAST;
    public static final Icon RELOAD;
    public static final Icon PAGESETUP;
    public static final Icon FLASHPRINT;
    public static final Icon PDFPRINT;
    public static final Icon APPLETPRINT;
    public static final Icon PDF;
    public static final Icon EXCEL;
    public static final Icon WORD;
    public static final Icon IMAGE;
    public static final Icon HTML;
    public static final Icon BMP;
    public static final Icon JPG;
    public static final Icon GIF;
    public static final Icon PNG;
    public static final Icon PRINT;
    public static final Icon EXPORT;
    public static final Icon EMAIL;
    public static final Icon FROZEN;
    public static final Icon DEFAULT;
    public static final Icon DELETECOLUMN;
    public static final Icon DELETEROW;
    public static final Icon APPENDCOLUMN;
    public static final Icon APPENDROW;
    public static final Icon VERIFY;
    public static final Icon WRITEOFFLINE;
    public static final Icon CLEAR;
    public static final Icon UNDO;
    public static final Icon REDO;
    public static final Icon VIEWPROCESS;
    public static final Icon ADD;
    public static final Icon DELETE;
    public static final Icon OK;
    public static final Icon PREVIEW;
    public static final Icon EDIT;
    public static final Icon SORT;
    public static final Icon ASCEND;
    public static final Icon DESCEND;
    public static final Icon FILTER;
    public static final Icon SETPRINTEROFFSET;
    public static final Icon FORM_PREVIOUS;
    public static final Icon FORM_NEXT;
    public static final Icon STASH;
    public static final Icon CLEARSTASH;
    public static final String OP = "toolbar_icon";
    private static final String ICONCLASSNAME = "x-emb-";
    private static final int REINIT_CSS = 0;
    private IconInfo[] iis = null;
    private byte[] allInOneImageBytes = null;
    private Map iconImageBytesCacheMap = new HashMap();
    private StringBuffer iconCss = new StringBuffer();
    private StringBuffer iconCss4IE = new StringBuffer();
    private int mark4Init = 0;
    public static final int DEFAULT_ICONWIDTH = 16;
    public static final int DEFAULT_ICONHEIGHT = 16;
    public static final String ICONRESOURCE = "icon_name_";
    private static final int SPACING = 2;
    private static long lastModified;
    private static boolean cssChange;
    private static IconManager manager;

    public static synchronized IconManager getIconManager() {
        if (manager == null) {
            manager = new IconManager();
        }
        return manager;
    }

    private IconManager() {
    }

    public void refreshCss() {
        this.mark4Init = 0;
        this.iconCss = new StringBuffer();
        this.iconCss4IE = new StringBuffer();
    }

    private static Icon getDefaultIcon(String string, String string2) {
        string = string.toLowerCase();
        Icon icon = new Icon(string, string2);
        icon.setImage(IconManager.getIconManager().getDefaultIconImage(icon));
        iconMap.put(string, icon);
        systemIconList.add(string);
        return icon;
    }

    private void init4Image() {
        try {
            Object object;
            Map<String, String> map;
            Object object222;
            Dimension dimension = new Dimension(0, 0);
            Set set = ExtraClassManager.getInstance().getArray("IconProvider");
            for (Object object222 : set) {
                map = object222.map4Icons();
                if (map == null || map.isEmpty()) continue;
                for (Map.Entry<String, String> object3 : map.entrySet()) {
                    IconManager.getDefaultIcon(object3.getKey(), object3.getValue());
                }
            }
            this.iis = new IconInfo[iconMap.size()];
            ImageInfo[] imageInfoArray = new ImageInfo[iconMap.size()];
            this.collectImageInfo(imageInfoArray, dimension);
            object222 = CoreGraphHelper.createBufferedImage(dimension.width, dimension.height);
            map = ((BufferedImage)object222).createGraphics();
            for (int i = 0; i < this.iis.length; ++i) {
                if (imageInfoArray[i] == null) continue;
                object = imageInfoArray[i].getRectangle();
                Image image = imageInfoArray[i].getImage();
                Shape shape = ((Graphics)((Object)map)).getClip();
                ((Graphics2D)((Object)map)).clip((Shape)object);
                ((Graphics)((Object)map)).drawImage(image, ((Rectangle)object).x, ((Rectangle)object).y, null);
                ((Graphics)((Object)map)).setClip(shape);
            }
            ((Image)object222).flush();
            ((Graphics)((Object)map)).dispose();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            IOUtils.writeImage((Image)object222, "png", byteArrayOutputStream);
            this.allInOneImageBytes = byteArrayOutputStream.toByteArray();
            for (int i = 0; i < this.iis.length; ++i) {
                if (imageInfoArray[i] == null || this.iis[i] == null) continue;
                object = imageInfoArray[i].getRectangle();
                this.iis[i].setCss(((Rectangle)object).x + "px -" + ((Rectangle)object).y + "px");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void collectImageInfo(ImageInfo[] imageInfoArray, Dimension dimension) {
        try {
            Image image = null;
            for (int i = 0; i < iconMap.size(); ++i) {
                Icon icon = (Icon)iconMap.getByIndex(i);
                if (icon == null) continue;
                String string = icon.getPath();
                String string2 = icon.getName();
                if (StringUtils.isBlank(string2)) continue;
                if (this.isSystemIcon(string2)) {
                    if (!string.startsWith("/") && !string.startsWith("\\")) {
                        string = File.separator + string;
                    }
                    image = BaseUtils.readImage(string);
                    icon.setImage(image);
                } else {
                    image = icon.getImage();
                    if (image != null) {
                        string = ICONRESOURCE + string2;
                    }
                }
                this.iis[i] = new IconInfo(string2, ICONRESOURCE + string2);
                if (image != null) {
                    int n = image.getWidth(null);
                    n = n > -1 ? n : 16;
                    int n2 = image.getHeight(null);
                    n2 = n2 > -1 ? n2 : 16;
                    Rectangle rectangle = new Rectangle(0, dimension.height, n, n2);
                    dimension.height += n2 + 2;
                    dimension.width = dimension.width > n ? dimension.width : n;
                    imageInfoArray[i] = new ImageInfo(image, rectangle);
                    continue;
                }
                imageInfoArray[i] = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void init4Css(String string) {
        for (int i = 0; i < this.iis.length; ++i) {
            if (this.iis[i] == null || this.iis[i].getCss() == null) continue;
            this.iconCss.append('.').append(ICONCLASSNAME).append(this.iis[i].getName()).append("{background-image:").append("url(").append(this.getAllInOneImageUrl(string)).append(") !important;").append("background-repeat:no-repeat !important;").append("background-position:").append(this.iis[i].getCss()).append(" !important").append(";\n}\n");
            this.iconCss4IE.append('.').append(ICONCLASSNAME).append(this.iis[i].getName()).append("{\n").append("filter: progid:DXImageTransform.Microsoft.AlphaImageLoader(src='").append(this.getAllInOneImagePath(string, this.iis[i].getPath())).append("') !important;\n}\n");
        }
    }

    public String getCssInfo(String string, String string2) {
        if (string == null) {
            return "";
        }
        string = string.toLowerCase();
        this.checkInit(string2);
        if (this.iis != null) {
            for (int i = 0; i < this.iis.length; ++i) {
                if (this.iis[i] == null || this.iis[i].getName() == null || !ComparatorUtils.equals(this.iis[i].getName(), string)) continue;
                return new StringBuffer().append("css:").append(ICONCLASSNAME).append(this.iis[i].getName()).toString();
            }
        }
        return "";
    }

    private void checkInit(String string) {
        if (this.mark4Init <= 0) {
            this.init4Image();
            if (StringUtils.isNotBlank(string)) {
                this.init4Css(string);
                this.mark4Init = 1;
            }
        }
    }

    public String getCssFile(String string, BrowserProvider browserProvider) {
        this.checkInit(string);
        if (browserProvider.supportTransparentImage()) {
            return this.iconCss.toString();
        }
        return this.iconCss4IE.toString();
    }

    public static long getLastModified() {
        return lastModified;
    }

    public static boolean isCssChange() {
        return cssChange;
    }

    public static void setCssChange(boolean bl) {
        cssChange = bl;
    }

    public byte[] getAllInOneImageBytes(String string) {
        this.checkInit(string);
        if (this.allInOneImageBytes != null) {
            return this.allInOneImageBytes;
        }
        return new byte[0];
    }

    public byte[] getIconImage4Web(String string, String string2) {
        this.checkInit(string);
        String string3 = string2.substring(ICONRESOURCE.length());
        if (string3 == null) {
            return new byte[0];
        }
        if (this.iconImageBytesCacheMap.containsKey(string3 = string3.toLowerCase())) {
            return (byte[])this.iconImageBytesCacheMap.get(string3);
        }
        Image image = this.getIconImage(string3);
        if (image != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            IOUtils.writeImage(image, "png", byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.iconImageBytesCacheMap.put(string3, byArray);
            return byArray;
        }
        return new byte[0];
    }

    private String getAllInOneImageUrl(String string) {
        return new StringBuffer().append(string).append("?op=").append(OP).append("&id=toolbar-image.png").toString();
    }

    private String getAllInOneImagePath(String string, String string2) {
        return new StringBuffer().append(string).append("?op=").append(OP).append("&id=").append(string2).toString();
    }

    public boolean contains(String string) {
        if (string == null) {
            return false;
        }
        string = string.toLowerCase();
        return iconMap.containsKey(string);
    }

    public boolean addIcon(Icon icon, boolean bl) {
        if (icon == null || StringUtils.isBlank(icon.getName()) || icon.getImage() == null) {
            return false;
        }
        String string = icon.getName().toLowerCase();
        icon.setName(string);
        if (iconMap.containsKey(string) && !bl) {
            return false;
        }
        iconMap.put(string, icon);
        this.refreshCss();
        lastModified = System.currentTimeMillis();
        cssChange = true;
        return true;
    }

    public boolean removeIcon(String string) {
        if (StringUtils.isBlank(string)) {
            return false;
        }
        if (iconMap.remove(string = string.toLowerCase()) != null) {
            this.refreshCss();
            lastModified = System.currentTimeMillis();
            cssChange = true;
            return true;
        }
        return false;
    }

    public int getIconCount() {
        return iconMap.size();
    }

    public boolean isSystemIcon(String string) {
        if (string == null) {
            return false;
        }
        string = string.toLowerCase();
        return systemIconList.contains(string);
    }

    public Image getIconImage(String string) {
        Image image;
        if (string == null) {
            return null;
        }
        Icon icon = this.getIcon4Self(string = string.toLowerCase());
        if (icon == null) {
            return null;
        }
        if (icon.getImage() != null) {
            image = icon.getImage();
        } else {
            String string2 = icon.getPath();
            if (StringUtils.isBlank(string2)) {
                return null;
            }
            if (!string2.startsWith("/") && !string2.startsWith("\\")) {
                string2 = File.separator + string2;
            }
            image = BaseUtils.readImage(string2);
            icon.setImage(image);
        }
        return image;
    }

    public Image getDefaultIconImage(Icon icon) {
        Image image;
        if (icon.getImage() != null) {
            image = icon.getImage();
        } else {
            String string = icon.getPath();
            if (StringUtils.isBlank(string)) {
                return null;
            }
            if (!string.startsWith("/") && !string.startsWith("\\")) {
                string = File.separator + string;
            }
            image = BaseUtils.readImage(string);
            icon.setImage(image);
        }
        return image;
    }

    public Icon getIcon(Object object) throws CloneNotSupportedException {
        if (object == null || !(object instanceof String)) {
            return null;
        }
        String string = ((String)object).toLowerCase();
        return iconMap.get(string) == null ? null : (Icon)((Icon)iconMap.get(string)).clone();
    }

    private Icon getIcon4Self(Object object) {
        if (object == null || !(object instanceof String)) {
            return null;
        }
        String string = ((String)object).toLowerCase();
        return (Icon)iconMap.get(string);
    }

    public Object[] getIconNames() {
        return iconMap.keySet().toArray();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            Icon icon = new Icon();
            if (Icon.XML_TAG.equals(string)) {
                xMLableReader.readXMLObject(icon);
            }
            this.addIcon(icon, false);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (iconMap != null && iconMap.size() > 0) {
            for (int i = 0; i < iconMap.size(); ++i) {
                Icon icon = (Icon)iconMap.getByIndex(i);
                if (this.isSystemIcon(icon.getName())) continue;
                icon.writeXML(xMLPrintWriter);
            }
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        IconManager iconManager = (IconManager)super.clone();
        return iconManager;
    }

    public String actionOP() {
        return OP;
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws Exception {
        httpServletResponse.setContentType("image/png");
        String string3 = NetworkHelper.getHTTPRequestParameter(httpServletRequest, "id");
        byte[] byArray = null;
        if (string3 != null) {
            if (string3.startsWith(ICONRESOURCE)) {
                byArray = this.getIconImage4Web(NetworkHelper.createServletURL(httpServletRequest), string3);
            } else if (ComparatorUtils.equals(string3, "toolbar-image.png")) {
                byArray = this.getAllInOneImageBytes(NetworkHelper.createServletURL(httpServletRequest));
            }
        }
        if (byArray == null) {
            byArray = new byte[]{};
        }
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        try {
            servletOutputStream.write(byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                manager = null;
            }
        });
        SUBMIT = IconManager.getDefaultIcon("submit", "/com/fr/web/images/save.png");
        SUBMITALL = IconManager.getDefaultIcon("submitall", "/com/fr/web/images/save.png");
        SUBMITFORCILY = IconManager.getDefaultIcon("submitforcily", "/com/fr/web/images/save2.png");
        FIRST = IconManager.getDefaultIcon("first", "/com/fr/web/images/first.png");
        PREVIOUS = IconManager.getDefaultIcon("previous", "/com/fr/web/images/previous.png");
        NEXT = IconManager.getDefaultIcon("next", "/com/fr/web/images/next.png");
        LAST = IconManager.getDefaultIcon("last", "/com/fr/web/images/last.png");
        RELOAD = IconManager.getDefaultIcon("reload", "/com/fr/web/images/reload.png");
        PAGESETUP = IconManager.getDefaultIcon("pagesetup", "/com/fr/web/images/pageSetup.png");
        FLASHPRINT = IconManager.getDefaultIcon("flashprint", "/com/fr/web/images/flashPrint.png");
        PDFPRINT = IconManager.getDefaultIcon("pdfprint", "/com/fr/web/images/pdfPrint.png");
        APPLETPRINT = IconManager.getDefaultIcon("appletprint", "/com/fr/web/images/appletPrint.png");
        PDF = IconManager.getDefaultIcon("pdf", "/com/fr/web/images/pdf.png");
        EXCEL = IconManager.getDefaultIcon("excel", "/com/fr/web/images/excel.png");
        WORD = IconManager.getDefaultIcon("word", "/com/fr/web/images/word.png");
        IMAGE = IconManager.getDefaultIcon("image", "/com/fr/web/images/image.png");
        HTML = IconManager.getDefaultIcon("html", "/com/fr/web/images/html.png");
        BMP = IconManager.getDefaultIcon("bmp", "/com/fr/web/images/bmp.png");
        JPG = IconManager.getDefaultIcon("jpg", "/com/fr/web/images/jpg.png");
        GIF = IconManager.getDefaultIcon("gif", "/com/fr/web/images/gif.png");
        PNG = IconManager.getDefaultIcon("png", "/com/fr/web/images/png.png");
        PRINT = IconManager.getDefaultIcon("print", "/com/fr/web/images/print.png");
        EXPORT = IconManager.getDefaultIcon("export", "/com/fr/web/images/export.png");
        EMAIL = IconManager.getDefaultIcon("email", "/com/fr/web/images/email.png");
        FROZEN = IconManager.getDefaultIcon("frozzen", "/com/fr/web/images/frozen.png");
        DEFAULT = IconManager.getDefaultIcon("default", "/com/fr/web/images/default.png");
        DELETECOLUMN = IconManager.getDefaultIcon("deletecolumn", "/com/fr/web/images/deleteColumn.png");
        DELETEROW = IconManager.getDefaultIcon("deleterow", "/com/fr/web/images/deleteRow.png");
        APPENDCOLUMN = IconManager.getDefaultIcon("appendcolumn", "/com/fr/web/images/appendColumn.png");
        APPENDROW = IconManager.getDefaultIcon("appendrow", "/com/fr/web/images/appendRow.png");
        VERIFY = IconManager.getDefaultIcon("verify", "/com/fr/web/images/verify.gif");
        WRITEOFFLINE = IconManager.getDefaultIcon("writeoffline", "/com/fr/web/images/writeOffline.png");
        CLEAR = IconManager.getDefaultIcon("clear", "/com/fr/web/images/writeClear.png");
        UNDO = IconManager.getDefaultIcon("undo", "/com/fr/web/images/writeUndo.png");
        REDO = IconManager.getDefaultIcon("redo", "/com/fr/web/images/writeRedo.png");
        VIEWPROCESS = IconManager.getDefaultIcon("viewprocess", "/com/fr/web/core/process/reportprocess/web/images/viewprocess.png");
        ADD = IconManager.getDefaultIcon("add", "/com/fr/web/images/add.png");
        DELETE = IconManager.getDefaultIcon("delete", "/com/fr/web/images/delete.png");
        OK = IconManager.getDefaultIcon("ok", "/com/fr/web/images/ok.png");
        PREVIEW = IconManager.getDefaultIcon("preview", "/com/fr/web/images/preview.png");
        EDIT = IconManager.getDefaultIcon("edit", "/com/fr/web/images/edit.png");
        SORT = IconManager.getDefaultIcon("sort", "/com/fr/web/images/sort.png");
        ASCEND = IconManager.getDefaultIcon("ascend", "/com/fr/web/images/ascend.png");
        DESCEND = IconManager.getDefaultIcon("descend", "/com/fr/web/images/descend.png");
        FILTER = IconManager.getDefaultIcon("filter", "/com/fr/web/images/filter.png");
        SETPRINTEROFFSET = IconManager.getDefaultIcon("setprinteroffset", "/com/fr/web/images/pianyi.png");
        FORM_PREVIOUS = IconManager.getDefaultIcon("formPre", "/com/fr/web/images/formPre.png");
        FORM_NEXT = IconManager.getDefaultIcon("formNext", "/com/fr/web/images/formNext.png");
        STASH = IconManager.getDefaultIcon("stash", "/com/fr/web/images/edit/stash.png");
        CLEARSTASH = IconManager.getDefaultIcon("clearstash", "/com/fr/web/images/edit/clearstash.png");
        lastModified = System.currentTimeMillis();
        cssChange = false;
        manager = null;
    }

    private static class ImageInfo {
        private Image image;
        private Rectangle rectangle;

        public ImageInfo(Image image, Rectangle rectangle) {
            this.setImage(image);
            this.setRectangle(rectangle);
        }

        public Image getImage() {
            return this.image;
        }

        public void setImage(Image image) {
            this.image = image;
        }

        public Rectangle getRectangle() {
            return this.rectangle;
        }

        public void setRectangle(Rectangle rectangle) {
            this.rectangle = rectangle;
        }
    }

    private static class IconInfo
    implements Serializable {
        private String name;
        private String path;
        private String css;

        public IconInfo(String string, String string2, String string3) {
            this.setName(string);
            this.setPath(string2);
            this.setCss(string3);
        }

        public IconInfo(String string, String string2) {
            this(string, string2, null);
        }

        public String getCss() {
            return this.css;
        }

        public void setCss(String string) {
            this.css = string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String string) {
            this.path = string;
        }
    }
}

