/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.jaxws.runtime.client;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundPortType;
import com.sun.xml.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Engine;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.client.ClientTransportException;
import com.sun.xml.ws.rm.MessageSender;
import com.sun.xml.ws.rm.RMException;
import com.sun.xml.ws.rm.RMMessage;
import com.sun.xml.ws.rm.jaxws.runtime.TubeBase;
import com.sun.xml.ws.rm.jaxws.runtime.client.ClientOutboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.client.ClientSession;
import com.sun.xml.ws.rm.jaxws.runtime.client.RMSource;
import com.sun.xml.ws.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.security.secconv.SecureConversationInitiator;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.bind.JAXBElement;
import javax.xml.soap.SOAPException;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;

public final class RMClientTube
extends TubeBase {
    private static final RmLogger LOGGER = RmLogger.getLogger(RMClientTube.class);
    private static final String CREATE_SEQUENCE_URI = "http://com.sun/createSequence";
    private SecureConversationInitiator securityPipe;
    private ClientOutboundSequence outboundSequence;
    private boolean secureReliableMessaging;
    private BindingProvider proxy;
    private boolean isOneWayMessage = false;
    private TubelineHelper tubelineHelper;

    public RMClientTube(WSDLPort wsdlPort, WSBinding binding, SecureConversationInitiator securityPipe, Tube nextTube) {
        super(wsdlPort, binding, nextTube);
        this.securityPipe = securityPipe;
        this.secureReliableMessaging = securityPipe != null;
    }

    private RMClientTube(RMClientTube toCopy, TubeCloner cloner) {
        super(toCopy, cloner);
        this.securityPipe = toCopy.securityPipe;
        this.secureReliableMessaging = toCopy.secureReliableMessaging;
        this.outboundSequence = toCopy.outboundSequence;
    }

    private synchronized void initialize(Packet packet) throws RMException {
        String dest = packet.endpointAddress.toString();
        if (this.outboundSequence != null) {
            if (dest != null && !dest.equals("") && !dest.equals(this.outboundSequence.getDestination().toString())) {
                throw LOGGER.logSevereException(new RMException(LocalizationMessages.WSRM_2017_UNCHANGEABLE_ENDPOINT_ADDRESS()));
            }
        } else {
            URI destURI;
            if (this.getConfig().getAddressingVersion() == AddressingVersion.MEMBER) {
                throw LOGGER.logSevereException(new RMException(LocalizationMessages.WSRM_2008_UNSUPPORTED_ADDRESSING_VERSION()));
            }
            this.proxy = packet.proxy;
            if (dest == null) {
                dest = this.getWsdlPort().getAddress().toString();
            }
            try {
                destURI = new URI(dest);
            }
            catch (URISyntaxException e) {
                throw LOGGER.logSevereException(new RMException(LocalizationMessages.WSRM_2018_INVALID_DEST_URI(dest), e));
            }
            this.outboundSequence = (ClientOutboundSequence)packet.proxy.getRequestContext().get("com.sun.xml.ws.sequence");
            if (this.outboundSequence == null) {
                JAXBElement str = null;
                if (this.secureReliableMessaging) {
                    try {
                        str = this.securityPipe.startSecureConversation(packet);
                    }
                    catch (Exception e) {
                        LOGGER.severe("Starting secure conversation failed", e);
                    }
                    if (str == null) {
                        this.secureReliableMessaging = false;
                    }
                }
                this.outboundSequence = new ClientOutboundSequence(this.getConfig(), str, destURI, this.getConfig().getAnonymousAddressingUri(), this.checkForTwoWayOperation(), this.getUnmarshaller(), this.next, packet.proxy, packet.contentNegotiation);
                RMSource.getRMSource().addOutboundSequence(this.outboundSequence);
                packet.proxy.getRequestContext().put("com.sun.xml.ws.sequence", this.outboundSequence);
                this.proxy.getRequestContext().put("rmsession", new ClientSession(this.outboundSequence.getId(), this));
            }
        }
    }

    private boolean checkForTwoWayOperation() {
        WSDLBoundPortType portType;
        if (this.getWsdlPort() == null || null == (portType = this.getWsdlPort().getBinding())) {
            return false;
        }
        for (WSDLBoundOperation wSDLBoundOperation : portType.getBindingOperations()) {
            WSDLOperation operation = wSDLBoundOperation.getOperation();
            if (operation.isOneWay()) continue;
            return true;
        }
        return false;
    }

    private RMMessage prepareRequestMessage(Packet requestPacket) throws RMException {
        RMMessage outboundMessage = null;
        Object mn = requestPacket.proxy.getRequestContext().get("com.sun.xml.ws.messagenumber");
        if (mn != null) {
            requestPacket.invocationProperties.put("com.sun.xml.ws.messagenumber", mn);
        }
        if (!requestPacket.getMessage().isOneWay(this.getWsdlPort())) {
            outboundMessage = this.handleOutboundMessage(this.outboundSequence, requestPacket, true, false);
            this.isOneWayMessage = false;
        } else {
            outboundMessage = this.handleOutboundMessage(this.outboundSequence, requestPacket, false, false);
            this.isOneWayMessage = true;
        }
        requestPacket.expectReply = true;
        this.tubelineHelper = new TubelineHelper(requestPacket, outboundMessage);
        outboundMessage.setMessageSender(this.tubelineHelper);
        return outboundMessage;
    }

    private void completeFaultedMessage(RMMessage message) {
        try {
            this.outboundSequence.acknowledge(message.getMessageNumber());
        }
        catch (RMException e) {
            LOGGER.warning("Error acknowledging message [" + message.getMessageNumber() + "] in sequence [" + message.getSequence().getId() + "]", e);
        }
    }

    public synchronized void preDestroy() {
        try {
            RMSource.getRMSource().terminateSequence(this.outboundSequence);
            this.next.preDestroy();
        }
        catch (Exception e) {
            LOGGER.warning(LocalizationMessages.WSRM_2007_UNEXPECTED_PREDESTROY_EXCEPTION(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMClientTube copy(TubeCloner cloner) {
        RMClientTube rMClientTube = this;
        synchronized (rMClientTube) {
            return new RMClientTube(this, cloner);
        }
    }

    @NotNull
    public NextAction processRequest(Packet request) {
        RMMessage rmMessage = null;
        try {
            if (this.tubelineHelper == null) {
                this.initialize(request);
                if (CREATE_SEQUENCE_URI.equals(request.getMessage().getPayloadNamespaceURI())) {
                    request.proxy.getRequestContext().put("com.sun.xml.ws.sequence", this.outboundSequence);
                    Message mess = Messages.createEmpty(this.getConfig().getSoapVersion());
                    request.setMessage(mess);
                    this.doReturnWith(request);
                }
            }
            rmMessage = this.prepareRequestMessage(request);
            if (RMSource.getRMSource().getProcessingFilter() == null || RMSource.getRMSource().getProcessingFilter().handleClientRequestMessage(rmMessage)) {
                this.outboundSequence.resetLastActivityTime();
                this.tubelineHelper.send();
            }
            return this.doSuspend();
        }
        catch (RMException e) {
            Message faultMessage = e.getFaultMessage();
            if (faultMessage != null) {
                try {
                    Packet ret = new Packet(Messages.create(faultMessage.readAsSOAPMessage()));
                    ret.invocationProperties.putAll(request.invocationProperties);
                    return this.doReturnWith(ret);
                }
                catch (SOAPException e1) {
                    return this.doThrow(new WebServiceException(e));
                }
            }
            return this.processException(e);
        }
        catch (Throwable ee) {
            LOGGER.severe(LocalizationMessages.WSRM_2006_UNEXPECTED_PROCESS_EXCEPTION(), ee);
            return this.processException(new WebServiceException(ee));
        }
    }

    @NotNull
    public NextAction processResponse(Packet response) {
        if (response != null) {
            return this.doReturnWith(response);
        }
        if (this.tubelineHelper != null) {
            return this.doThrow(this.tubelineHelper.throwable);
        }
        throw LOGGER.logSevereException(new IllegalStateException("'null' Packet in processResponse()"));
    }

    @NotNull
    public NextAction processException(Throwable t) {
        if (!(t instanceof WebServiceException)) {
            t = new WebServiceException(t);
        }
        return this.doThrow(t);
    }

    public class TubelineHelper
    implements MessageSender {
        private final Fiber fiber;
        private final Fiber parentFiber;
        private final TubelineHelperCallback callback;
        private Packet packet;
        private RMMessage requestMessage;
        private Throwable throwable;

        public TubelineHelper(Packet packet, RMMessage message) {
            this.requestMessage = message;
            this.packet = packet;
            this.parentFiber = Fiber.current();
            if (this.parentFiber == null) {
                throw LOGGER.logSevereException(new IllegalStateException("No current fiber."));
            }
            Engine engine = this.parentFiber.owner;
            this.fiber = engine.createFiber();
            this.callback = new TubelineHelperCallback();
        }

        public void send() {
            this.requestMessage.setBusy(true);
            if (this.packet == null) {
                throw LOGGER.logSevereException(new IllegalStateException("Request not set in TubelineHelper"));
            }
            Message copy = this.requestMessage.getCopy();
            this.packet.setMessage(copy);
            this.fiber.start(TubeCloner.clone(RMClientTube.this.next), this.packet, this.callback);
        }

        private class TubelineHelperCallback
        implements Fiber.CompletionCallback {
            TubelineHelperCallback() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCompletion(@NotNull Packet responsePacket) {
                try {
                    if (responsePacket != null) {
                        Message responseMessage = responsePacket.getMessage();
                        RMMessage rmResponseMessage = null;
                        if (responseMessage != null) {
                            rmResponseMessage = RMClientTube.this.handleInboundMessage(responsePacket, RMSource.getRMSource());
                        }
                        if (RMSource.getRMSource().getProcessingFilter() != null) {
                            RMSource.getRMSource().getProcessingFilter().handleClientResponseMessage(rmResponseMessage);
                        }
                        if (rmResponseMessage != null && rmResponseMessage.getSequence() != null) {
                            rmResponseMessage.complete();
                        }
                        if (responseMessage != null && responseMessage.isFault()) {
                            LOGGER.fine(LocalizationMessages.WSRM_2004_ACKING_FAULTED_MESSAGE(TubelineHelper.this.requestMessage.getMessageNumber()));
                            RMClientTube.this.outboundSequence.acknowledge(TubelineHelper.this.requestMessage.getMessageNumber());
                        }
                        if (responseMessage != null && !RMClientTube.this.isOneWayMessage && responseMessage.getPayloadNamespaceURI() == null) {
                            LOGGER.fine(LocalizationMessages.WSRM_2005_RESENDING_DROPPED_MESSAGE());
                            return;
                        }
                        if (TubelineHelper.this.requestMessage.isTwoWayRequest()) {
                            RMClientTube.this.outboundSequence.acknowledgeResponse(TubelineHelper.this.requestMessage.getMessageNumber());
                        }
                    }
                    TubelineHelper.this.parentFiber.resume(responsePacket);
                }
                catch (Exception e) {
                    this.onCompletion(e);
                }
                finally {
                    TubelineHelper.this.requestMessage.setBusy(false);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCompletion(@NotNull Throwable t) {
                TubelineHelper.this.throwable = t;
                try {
                    if (t instanceof ClientTransportException) {
                        LOGGER.fine(LocalizationMessages.WSRM_2000_QUEUE_FOR_RESEND(t.getMessage()), t);
                        return;
                    }
                    if (t instanceof WebServiceException) {
                        Throwable cause = t.getCause();
                        if (cause != null && (cause instanceof IOException || cause instanceof SocketTimeoutException)) {
                            LOGGER.fine(LocalizationMessages.WSRM_2000_QUEUE_FOR_RESEND(t.getMessage()), t);
                            return;
                        }
                        LOGGER.severe(LocalizationMessages.WSRM_2003_UNEXPECTED_WRAPPED_EXCEPTION(), t);
                        RMClientTube.this.completeFaultedMessage(TubelineHelper.this.requestMessage);
                        TubelineHelper.this.parentFiber.resume(null);
                    } else {
                        LOGGER.severe(LocalizationMessages.WSRM_2001_UNEXPECTED_TRY_SEND_EXCEPTION(), t);
                        TubelineHelper.this.parentFiber.resume(null);
                    }
                }
                finally {
                    TubelineHelper.this.requestMessage.setBusy(false);
                }
            }
        }
    }
}

