/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.KEKIdentifier;
import org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.IntRecipientInfoGenerator;

class KEKIntRecipientInfoGenerator
implements IntRecipientInfoGenerator {
    private SecretKey keyEncryptionKey;
    private KEKIdentifier kekIdentifier;
    private AlgorithmIdentifier keyEncryptionAlgorithm;

    KEKIntRecipientInfoGenerator() {
    }

    void setKeyEncryptionKey(SecretKey keyEncryptionKey) {
        this.keyEncryptionKey = keyEncryptionKey;
        this.keyEncryptionAlgorithm = KEKIntRecipientInfoGenerator.determineKeyEncAlg(keyEncryptionKey);
    }

    void setKEKIdentifier(KEKIdentifier kekIdentifier) {
        this.kekIdentifier = kekIdentifier;
    }

    public RecipientInfo generate(SecretKey contentEncryptionKey, SecureRandom random, Provider prov) throws GeneralSecurityException {
        Cipher keyEncryptionCipher = CMSEnvelopedHelper.INSTANCE.createSymmetricCipher(this.keyEncryptionAlgorithm.getObjectId().getId(), prov);
        keyEncryptionCipher.init(3, (Key)this.keyEncryptionKey, random);
        byte[] encryptedKeyBytes = keyEncryptionCipher.wrap(contentEncryptionKey);
        DEROctetString encryptedKey = new DEROctetString(encryptedKeyBytes);
        return new RecipientInfo(new KEKRecipientInfo(this.kekIdentifier, this.keyEncryptionAlgorithm, encryptedKey));
    }

    /*
     * WARNING - void declaration
     */
    private static AlgorithmIdentifier determineKeyEncAlg(SecretKey key) {
        String algorithm = key.getAlgorithm();
        if (algorithm.startsWith("DES")) {
            return new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.9.16.3.6"), new DERNull());
        }
        if (algorithm.startsWith("RC2")) {
            return new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.9.16.3.7"), new DERInteger(58));
        }
        if (algorithm.startsWith("AES")) {
            ASN1ObjectIdentifier wrapOid;
            int length = key.getEncoded().length * 8;
            if (length == 128) {
                wrapOid = NISTObjectIdentifiers.id_aes128_wrap;
            } else if (length == 192) {
                wrapOid = NISTObjectIdentifiers.id_aes192_wrap;
            } else if (length == 256) {
                wrapOid = NISTObjectIdentifiers.id_aes256_wrap;
            } else {
                throw new IllegalArgumentException("illegal keysize in AES");
            }
            return new AlgorithmIdentifier(wrapOid);
        }
        if (algorithm.startsWith("SEED")) {
            return new AlgorithmIdentifier(KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap);
        }
        if (algorithm.startsWith("Camellia")) {
            void var3_5;
            ASN1ObjectIdentifier wrapOid;
            int length = key.getEncoded().length * 8;
            if (length == 128) {
                wrapOid = NTTObjectIdentifiers.id_camellia128_wrap;
            } else if (length == 192) {
                wrapOid = NTTObjectIdentifiers.id_camellia192_wrap;
            } else if (length == 256) {
                wrapOid = NTTObjectIdentifiers.id_camellia256_wrap;
            } else {
                throw new IllegalArgumentException("illegal keysize in Camellia");
            }
            return new AlgorithmIdentifier((DERObjectIdentifier)var3_5);
        }
        throw new IllegalArgumentException("unknown algorithm");
    }
}

