/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;

public class FITS_Writer
implements PlugIn {
    public void run(String path) {
        ImagePlus imp = IJ.getImage();
        ImageProcessor ip = imp.getProcessor();
        int numImages = imp.getImageStackSize();
        int bitDepth = imp.getBitDepth();
        if (bitDepth == 24) {
            IJ.error("RGB images are not supported");
            return;
        }
        if (path == null || path.trim().length() == 0) {
            String title = "image.fits";
            SaveDialog sd = new SaveDialog("Write FITS image", title, ".fits");
            path = String.valueOf(sd.getDirectory()) + sd.getFileName();
        }
        File f = new File(path);
        String directory = String.valueOf(f.getParent()) + File.separator;
        String name = f.getName();
        if (f.exists()) {
            f.delete();
        }
        int numBytes = 0;
        if (bitDepth == 8) {
            ip = ip.convertToShort(false);
        } else if (imp.getCalibration().isSigned16Bit()) {
            ip = ip.convertToFloat();
        }
        if (ip instanceof ShortProcessor) {
            numBytes = 2;
        } else if (ip instanceof FloatProcessor) {
            numBytes = 4;
        }
        int fillerLength = 2880 - numBytes * imp.getWidth() * imp.getHeight() % 2880;
        String[] hdr = FITS_Writer.getHeader(imp);
        if (hdr == null) {
            this.createHeader(path, ip, numBytes);
        } else {
            this.copyHeader(hdr, path, ip, numBytes);
        }
        this.writeData(path, ip);
        char[] endFiller = new char[fillerLength];
        this.appendFile(endFiller, path);
    }

    void createHeader(String path, ImageProcessor ip, int numBytes) {
        int numCards = 7;
        String bitperpix = "";
        if (numBytes == 2) {
            bitperpix = "                  16";
        } else if (numBytes == 4) {
            bitperpix = "                 -32";
        } else if (numBytes == 1) {
            bitperpix = "                   8";
        }
        this.appendFile(this.writeCard("SIMPLE", "                   T", "Created by ImageJ FITS_Writer"), path);
        this.appendFile(this.writeCard("BITPIX", bitperpix, "number of bits per data pixel"), path);
        this.appendFile(this.writeCard("NAXIS", "                   2", "number of data axes"), path);
        this.appendFile(this.writeCard("NAXIS1", "                " + ip.getWidth(), "length of data axis 1"), path);
        this.appendFile(this.writeCard("NAXIS2", "                " + ip.getHeight(), "length of data axis 2"), path);
        if (numBytes == 2) {
            this.appendFile(this.writeCard("BZERO", "               32768", "data range offset"), path);
        } else {
            this.appendFile(this.writeCard("BZERO", "                   0", "data range offset"), path);
        }
        this.appendFile(this.writeCard("BSCALE", "                   1", "default scaling factor"), path);
        int fillerSize = 2880 - (numCards * 80 + 3) % 2880;
        char[] end = new char[]{'E', 'N', 'D'};
        char[] filler = new char[fillerSize];
        int i = 0;
        while (i < fillerSize) {
            filler[i] = 32;
            ++i;
        }
        this.appendFile(end, path);
        this.appendFile(filler, path);
    }

    char[] writeCard(String title, String value, String comment) {
        char[] card = new char[80];
        int i = 0;
        while (i < 80) {
            card[i] = 32;
            ++i;
        }
        this.s2ch(title, card, 0);
        card[8] = 61;
        this.s2ch(value, card, 10);
        card[31] = 47;
        card[32] = 32;
        this.s2ch(comment, card, 33);
        return card;
    }

    void s2ch(String str, char[] ch, int offset) {
        int j = 0;
        int i = offset;
        while (i < 80 && i < str.length() + offset) {
            ch[i] = str.charAt(j++);
            ++i;
        }
    }

    void appendFile(char[] line, String path) {
        try {
            FileWriter output = new FileWriter(path, true);
            output.write(line);
            output.close();
        }
        catch (IOException e) {
            IJ.showStatus("Error writing file!");
            return;
        }
    }

    void writeData(String path, ImageProcessor ip) {
        int w = ip.getWidth();
        int h = ip.getHeight();
        if (ip instanceof ShortProcessor) {
            short[] pixels = (short[])ip.getPixels();
            try {
                DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path, true)));
                int i = h - 1;
                while (i >= 0) {
                    int j = i * w;
                    while (j < w * (i + 1)) {
                        dos.writeShort(pixels[j] ^ 0x8000);
                        ++j;
                    }
                    --i;
                }
                dos.close();
            }
            catch (IOException e) {
                IJ.showStatus("Error writing file!");
                return;
            }
        }
        if (ip instanceof FloatProcessor) {
            float[] pixels = (float[])ip.getPixels();
            try {
                DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path, true)));
                int i = h - 1;
                while (i >= 0) {
                    int j = i * w;
                    while (j < w * (i + 1)) {
                        dos.writeFloat(pixels[j]);
                        ++j;
                    }
                    --i;
                }
                dos.close();
            }
            catch (IOException e) {
                IJ.showStatus("Error writing file!");
                return;
            }
        }
    }

    public static String[] getHeader(ImagePlus img) {
        String content = null;
        int depth = img.getStackSize();
        if (depth == 1) {
            Properties props = img.getProperties();
            if (props == null) {
                return null;
            }
            content = props.getProperty("Info");
        } else if (depth > 1) {
            int slice = img.getCurrentSlice();
            ImageStack stack = img.getStack();
            content = stack.getSliceLabel(slice);
        }
        if (content == null) {
            return null;
        }
        String[] lines = content.split("\n");
        int istart = 0;
        while (istart < lines.length) {
            if (lines[istart].startsWith("SIMPLE")) break;
            ++istart;
        }
        if (istart == lines.length) {
            return null;
        }
        int iend = istart + 1;
        while (iend < lines.length) {
            String s = lines[iend].trim();
            if (s.equals("END") || s.startsWith("END ")) break;
            ++iend;
        }
        if (iend >= lines.length) {
            return null;
        }
        int l = iend - istart + 1;
        String header = "";
        int i = 0;
        while (i < l) {
            header = String.valueOf(header) + lines[istart + i] + "\n";
            ++i;
        }
        return header.split("\n");
    }

    char[] eighty(String s) {
        char[] c = new char[80];
        int l = s.length();
        int i = 0;
        while (i < l && i < 80) {
            c[i] = s.charAt(i);
            ++i;
        }
        if (l < 80) {
            while (l < 80) {
                c[l] = 32;
                ++l;
            }
        }
        return c;
    }

    void copyHeader(String[] hdr, String path, ImageProcessor ip, int numBytes) {
        int numCards = 7;
        String bitperpix = "";
        if (numBytes == 2) {
            bitperpix = "                  16";
        } else if (numBytes == 4) {
            bitperpix = "                 -32";
        } else if (numBytes == 1) {
            bitperpix = "                   8";
        }
        this.appendFile(this.writeCard("SIMPLE", "                   T", "Created by ImageJ FITS_Writer"), path);
        this.appendFile(this.writeCard("BITPIX", bitperpix, "number of bits per data pixel"), path);
        this.appendFile(this.writeCard("NAXIS", "                   2", "number of data axes"), path);
        this.appendFile(this.writeCard("NAXIS1", "                " + ip.getWidth(), "length of data axis 1"), path);
        this.appendFile(this.writeCard("NAXIS2", "                " + ip.getHeight(), "length of data axis 2"), path);
        if (numBytes == 2) {
            this.appendFile(this.writeCard("BZERO", "               32768", "data range offset"), path);
        } else {
            this.appendFile(this.writeCard("BZERO", "                   0", "data range offset"), path);
        }
        this.appendFile(this.writeCard("BSCALE", "                   1", "default scaling factor"), path);
        int i = 0;
        while (i < hdr.length) {
            String s = hdr[i];
            char[] card = this.eighty(s);
            if (!(s.startsWith("SIMPLE") || s.startsWith("BITPIX") || s.startsWith("NAXIS") || s.startsWith("BZERO") || s.startsWith("BSCALE") || s.startsWith("END") || s.trim().length() <= 1)) {
                this.appendFile(card, path);
                ++numCards;
            }
            ++i;
        }
        int fillerSize = 2880 - (numCards * 80 + 3) % 2880;
        char[] end = new char[]{'E', 'N', 'D'};
        char[] filler = new char[fillerSize];
        int i2 = 0;
        while (i2 < fillerSize) {
            filler[i2] = 32;
            ++i2;
        }
        this.appendFile(end, path);
        this.appendFile(filler, path);
    }
}

