/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.xssf.usermodel.helpers;

import com.fr.third.v2.org.apache.poi.poifs.crypt.CryptoFunctions;
import com.fr.third.v2.org.apache.poi.poifs.crypt.HashAlgorithm;
import com.fr.third.v2.org.apache.xmlbeans.XmlCursor;
import com.fr.third.v2.org.apache.xmlbeans.XmlObject;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Locale;
import javax.xml.bind.DatatypeConverter;
import javax.xml.namespace.QName;

public class XSSFPaswordHelper {
    public static void setPassword(XmlObject xobj, String password, HashAlgorithm hashAlgo, String prefix) {
        XmlCursor cur = xobj.newCursor();
        if (password == null) {
            cur.removeAttribute(XSSFPaswordHelper.getAttrName(prefix, "password"));
            cur.removeAttribute(XSSFPaswordHelper.getAttrName(prefix, "algorithmName"));
            cur.removeAttribute(XSSFPaswordHelper.getAttrName(prefix, "hashValue"));
            cur.removeAttribute(XSSFPaswordHelper.getAttrName(prefix, "saltValue"));
            cur.removeAttribute(XSSFPaswordHelper.getAttrName(prefix, "spinCount"));
            return;
        }
        cur.toFirstContentToken();
        if (hashAlgo == null) {
            int hash = CryptoFunctions.createXorVerifier1(password);
            cur.insertAttributeWithValue(XSSFPaswordHelper.getAttrName(prefix, "password"), Integer.toHexString(hash).toUpperCase(Locale.ROOT));
        } else {
            SecureRandom random = new SecureRandom();
            byte[] salt = random.generateSeed(16);
            int spinCount = 100000;
            byte[] hash = CryptoFunctions.hashPassword(password, hashAlgo, salt, spinCount, false);
            cur.insertAttributeWithValue(XSSFPaswordHelper.getAttrName(prefix, "algorithmName"), hashAlgo.jceId);
            cur.insertAttributeWithValue(XSSFPaswordHelper.getAttrName(prefix, "hashValue"), DatatypeConverter.printBase64Binary((byte[])hash));
            cur.insertAttributeWithValue(XSSFPaswordHelper.getAttrName(prefix, "saltValue"), DatatypeConverter.printBase64Binary((byte[])salt));
            cur.insertAttributeWithValue(XSSFPaswordHelper.getAttrName(prefix, "spinCount"), "" + spinCount);
        }
        cur.dispose();
    }

    public static boolean validatePassword(XmlObject xobj, String password, String prefix) {
        if (password == null) {
            return false;
        }
        XmlCursor cur = xobj.newCursor();
        String xorHashVal = cur.getAttributeText(XSSFPaswordHelper.getAttrName(prefix, "password"));
        String algoName = cur.getAttributeText(XSSFPaswordHelper.getAttrName(prefix, "algorithmName"));
        String hashVal = cur.getAttributeText(XSSFPaswordHelper.getAttrName(prefix, "hashValue"));
        String saltVal = cur.getAttributeText(XSSFPaswordHelper.getAttrName(prefix, "saltValue"));
        String spinCount = cur.getAttributeText(XSSFPaswordHelper.getAttrName(prefix, "spinCount"));
        cur.dispose();
        if (xorHashVal != null) {
            int hash2;
            int hash1 = Integer.parseInt(xorHashVal, 16);
            return hash1 == (hash2 = CryptoFunctions.createXorVerifier1(password));
        }
        if (hashVal == null || algoName == null || saltVal == null || spinCount == null) {
            return false;
        }
        byte[] hash1 = DatatypeConverter.parseBase64Binary((String)hashVal);
        HashAlgorithm hashAlgo = HashAlgorithm.fromString(algoName);
        byte[] salt = DatatypeConverter.parseBase64Binary((String)saltVal);
        int spinCnt = Integer.parseInt(spinCount);
        byte[] hash2 = CryptoFunctions.hashPassword(password, hashAlgo, salt, spinCnt, false);
        return Arrays.equals(hash1, hash2);
    }

    private static QName getAttrName(String prefix, String name) {
        if (prefix == null || "".equals(prefix)) {
            return new QName(name);
        }
        return new QName(prefix + Character.toUpperCase(name.charAt(0)) + name.substring(1));
    }
}

