/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.xssf.usermodel.charts;

import com.fr.third.v2.org.apache.poi.ss.usermodel.charts.AxisCrossBetween;
import com.fr.third.v2.org.apache.poi.ss.usermodel.charts.AxisCrosses;
import com.fr.third.v2.org.apache.poi.ss.usermodel.charts.AxisOrientation;
import com.fr.third.v2.org.apache.poi.ss.usermodel.charts.AxisPosition;
import com.fr.third.v2.org.apache.poi.ss.usermodel.charts.AxisTickMark;
import com.fr.third.v2.org.apache.poi.ss.usermodel.charts.ChartAxis;
import com.fr.third.v2.org.apache.poi.ss.usermodel.charts.ValueAxis;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFChart;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.charts.XSSFChartAxis;
import com.fr.third.v2.org.openxmlformats.schemas.drawingml.x2006.chart.CTAxPos;
import com.fr.third.v2.org.openxmlformats.schemas.drawingml.x2006.chart.CTBoolean;
import com.fr.third.v2.org.openxmlformats.schemas.drawingml.x2006.chart.CTCrosses;
import com.fr.third.v2.org.openxmlformats.schemas.drawingml.x2006.chart.CTNumFmt;
import com.fr.third.v2.org.openxmlformats.schemas.drawingml.x2006.chart.CTScaling;
import com.fr.third.v2.org.openxmlformats.schemas.drawingml.x2006.chart.CTTickMark;
import com.fr.third.v2.org.openxmlformats.schemas.drawingml.x2006.chart.CTValAx;
import com.fr.third.v2.org.openxmlformats.schemas.drawingml.x2006.chart.STCrossBetween;
import com.fr.third.v2.org.openxmlformats.schemas.drawingml.x2006.chart.STTickLblPos;

public class XSSFValueAxis
extends XSSFChartAxis
implements ValueAxis {
    private CTValAx ctValAx;

    public XSSFValueAxis(XSSFChart chart, long id, AxisPosition pos) {
        super(chart);
        this.createAxis(id, pos);
    }

    public XSSFValueAxis(XSSFChart chart, CTValAx ctValAx) {
        super(chart);
        this.ctValAx = ctValAx;
    }

    public long getId() {
        return this.ctValAx.getAxId().getVal();
    }

    public void setCrossBetween(AxisCrossBetween crossBetween) {
        this.ctValAx.getCrossBetween().setVal(XSSFValueAxis.fromCrossBetween(crossBetween));
    }

    public AxisCrossBetween getCrossBetween() {
        return XSSFValueAxis.toCrossBetween(this.ctValAx.getCrossBetween().getVal());
    }

    protected CTAxPos getCTAxPos() {
        return this.ctValAx.getAxPos();
    }

    protected CTNumFmt getCTNumFmt() {
        if (this.ctValAx.isSetNumFmt()) {
            return this.ctValAx.getNumFmt();
        }
        return this.ctValAx.addNewNumFmt();
    }

    protected CTScaling getCTScaling() {
        return this.ctValAx.getScaling();
    }

    protected CTCrosses getCTCrosses() {
        return this.ctValAx.getCrosses();
    }

    protected CTBoolean getDelete() {
        return this.ctValAx.getDelete();
    }

    protected CTTickMark getMajorCTTickMark() {
        return this.ctValAx.getMajorTickMark();
    }

    protected CTTickMark getMinorCTTickMark() {
        return this.ctValAx.getMinorTickMark();
    }

    public void crossAxis(ChartAxis axis) {
        this.ctValAx.getCrossAx().setVal(axis.getId());
    }

    private void createAxis(long id, AxisPosition pos) {
        this.ctValAx = this.chart.getCTChart().getPlotArea().addNewValAx();
        this.ctValAx.addNewAxId().setVal(id);
        this.ctValAx.addNewAxPos();
        this.ctValAx.addNewScaling();
        this.ctValAx.addNewCrossBetween();
        this.ctValAx.addNewCrosses();
        this.ctValAx.addNewCrossAx();
        this.ctValAx.addNewTickLblPos().setVal(STTickLblPos.NEXT_TO);
        this.ctValAx.addNewDelete();
        this.ctValAx.addNewMajorTickMark();
        this.ctValAx.addNewMinorTickMark();
        this.setPosition(pos);
        this.setOrientation(AxisOrientation.MIN_MAX);
        this.setCrossBetween(AxisCrossBetween.MIDPOINT_CATEGORY);
        this.setCrosses(AxisCrosses.AUTO_ZERO);
        this.setVisible(true);
        this.setMajorTickMark(AxisTickMark.CROSS);
        this.setMinorTickMark(AxisTickMark.NONE);
    }

    private static STCrossBetween.Enum fromCrossBetween(AxisCrossBetween crossBetween) {
        switch (crossBetween) {
            case BETWEEN: {
                return STCrossBetween.BETWEEN;
            }
            case MIDPOINT_CATEGORY: {
                return STCrossBetween.MID_CAT;
            }
        }
        throw new IllegalArgumentException();
    }

    private static AxisCrossBetween toCrossBetween(STCrossBetween.Enum ctCrossBetween) {
        switch (ctCrossBetween.intValue()) {
            case 1: {
                return AxisCrossBetween.BETWEEN;
            }
            case 2: {
                return AxisCrossBetween.MIDPOINT_CATEGORY;
            }
        }
        throw new IllegalArgumentException();
    }
}

