/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.hssf.usermodel;

import com.fr.third.v2.org.apache.poi.hssf.record.CFRule12Record;
import com.fr.third.v2.org.apache.poi.hssf.record.cf.ColorGradientFormatting;
import com.fr.third.v2.org.apache.poi.hssf.record.cf.ColorGradientThreshold;
import com.fr.third.v2.org.apache.poi.hssf.record.common.ExtendedColor;
import com.fr.third.v2.org.apache.poi.hssf.usermodel.HSSFConditionalFormattingThreshold;
import com.fr.third.v2.org.apache.poi.hssf.usermodel.HSSFExtendedColor;
import com.fr.third.v2.org.apache.poi.hssf.usermodel.HSSFSheet;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Color;
import com.fr.third.v2.org.apache.poi.ss.usermodel.ColorScaleFormatting;
import com.fr.third.v2.org.apache.poi.ss.usermodel.ConditionalFormattingThreshold;

public final class HSSFColorScaleFormatting
implements ColorScaleFormatting {
    private final HSSFSheet sheet;
    private final CFRule12Record cfRule12Record;
    private final ColorGradientFormatting colorFormatting;

    protected HSSFColorScaleFormatting(CFRule12Record cfRule12Record, HSSFSheet sheet) {
        this.sheet = sheet;
        this.cfRule12Record = cfRule12Record;
        this.colorFormatting = this.cfRule12Record.getColorGradientFormatting();
    }

    public int getNumControlPoints() {
        return this.colorFormatting.getNumControlPoints();
    }

    public void setNumControlPoints(int num) {
        this.colorFormatting.setNumControlPoints(num);
    }

    public HSSFExtendedColor[] getColors() {
        ExtendedColor[] colors = this.colorFormatting.getColors();
        HSSFExtendedColor[] hcolors = new HSSFExtendedColor[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            hcolors[i] = new HSSFExtendedColor(colors[i]);
        }
        return hcolors;
    }

    public void setColors(Color[] colors) {
        ExtendedColor[] cr = new ExtendedColor[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            cr[i] = ((HSSFExtendedColor)colors[i]).getExtendedColor();
        }
        this.colorFormatting.setColors(cr);
    }

    public HSSFConditionalFormattingThreshold[] getThresholds() {
        ColorGradientThreshold[] t = this.colorFormatting.getThresholds();
        HSSFConditionalFormattingThreshold[] ht = new HSSFConditionalFormattingThreshold[t.length];
        for (int i = 0; i < t.length; ++i) {
            ht[i] = new HSSFConditionalFormattingThreshold(t[i], this.sheet);
        }
        return ht;
    }

    public void setThresholds(ConditionalFormattingThreshold[] thresholds) {
        ColorGradientThreshold[] t = new ColorGradientThreshold[thresholds.length];
        for (int i = 0; i < t.length; ++i) {
            HSSFConditionalFormattingThreshold hssfT = (HSSFConditionalFormattingThreshold)thresholds[i];
            t[i] = (ColorGradientThreshold)hssfT.getThreshold();
        }
        this.colorFormatting.setThresholds(t);
    }

    public HSSFConditionalFormattingThreshold createThreshold() {
        return new HSSFConditionalFormattingThreshold(new ColorGradientThreshold(), this.sheet);
    }
}

