/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.scriptio;

import com.fr.third.org.hsqldb.Database;
import com.fr.third.org.hsqldb.HsqlException;
import com.fr.third.org.hsqldb.HsqlNameManager;
import com.fr.third.org.hsqldb.NumberSequence;
import com.fr.third.org.hsqldb.Session;
import com.fr.third.org.hsqldb.Table;
import com.fr.third.org.hsqldb.rowio.RowOutputTextLog;
import com.fr.third.org.hsqldb.scriptio.ScriptWriterBase;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class ScriptWriterText
extends ScriptWriterBase {
    RowOutputTextLog rowOut;
    public static final byte[] BYTES_LINE_SEP;
    static final byte[] BYTES_COMMIT;
    static final byte[] BYTES_INSERT_INTO;
    static final byte[] BYTES_VALUES;
    static final byte[] BYTES_TERM;
    static final byte[] BYTES_DELETE_FROM;
    static final byte[] BYTES_WHERE;
    static final byte[] BYTES_SEQUENCE;
    static final byte[] BYTES_SEQUENCE_MID;
    static final byte[] BYTES_C_ID_INIT;
    static final byte[] BYTES_C_ID_TERM;
    static final byte[] BYTES_SCHEMA;

    ScriptWriterText() {
    }

    public ScriptWriterText(Database db, String file, boolean includeCachedData, boolean newFile, boolean isDump) throws HsqlException {
        super(db, file, includeCachedData, newFile, isDump);
    }

    protected void initBuffers() {
        this.rowOut = new RowOutputTextLog();
    }

    protected void writeDataTerm() throws IOException {
    }

    protected void addSessionId(Session session) throws IOException {
        if (session == null) {
            return;
        }
        if (session != this.currentSession) {
            this.rowOut.write(BYTES_C_ID_INIT);
            this.rowOut.writeIntData(session.getId());
            this.rowOut.write(BYTES_C_ID_TERM);
            this.currentSession = session;
        }
        if (this.schemaToLog != session.loggedSchema) {
            this.writeSchemaStatement(this.schemaToLog);
            session.loggedSchema = this.schemaToLog;
        }
    }

    private void writeSchemaStatement(HsqlNameManager.HsqlName schema) {
        this.rowOut.write(BYTES_SCHEMA);
        this.rowOut.writeString(schema.statementName);
        this.rowOut.write(BYTES_LINE_SEP);
    }

    public void writeLogStatement(Session session, String s) throws IOException, HsqlException {
        this.schemaToLog = session.currentSchema;
        this.busyWriting = true;
        this.rowOut.reset();
        this.addSessionId(session);
        this.rowOut.writeString(s);
        this.rowOut.write(BYTES_LINE_SEP);
        this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
        this.byteCount += (long)this.rowOut.size();
        this.needsSync = true;
        this.busyWriting = false;
        if (this.forceSync || this.writeDelay == 0) {
            this.sync();
        }
    }

    protected void writeRow(Session session, Table table, Object[] data) throws HsqlException, IOException {
        this.busyWriting = true;
        this.rowOut.reset();
        this.rowOut.setMode(0);
        this.addSessionId(session);
        this.rowOut.write(BYTES_INSERT_INTO);
        this.rowOut.writeString(table.getName().statementName);
        this.rowOut.write(BYTES_VALUES);
        this.rowOut.writeData(data, table);
        this.rowOut.write(BYTES_TERM);
        this.rowOut.write(BYTES_LINE_SEP);
        this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
        this.byteCount += (long)this.rowOut.size();
        this.needsSync |= session.isAutoCommit();
        this.busyWriting = false;
        if (this.forceSync || this.writeDelay == 0) {
            this.sync();
        }
    }

    protected void writeTableInit(Table t) throws HsqlException, IOException {
        if (t.isEmpty(this.currentSession)) {
            return;
        }
        if (this.schemaToLog == this.currentSession.loggedSchema) {
            return;
        }
        this.rowOut.reset();
        this.writeSchemaStatement(t.getName().schema);
        this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
        this.currentSession.loggedSchema = this.schemaToLog;
    }

    public void writeInsertStatement(Session session, Table table, Object[] data) throws HsqlException, IOException {
        this.schemaToLog = table.getName().schema;
        this.writeRow(session, table, data);
    }

    public void writeDeleteStatement(Session session, Table table, Object[] data) throws HsqlException, IOException {
        this.schemaToLog = table.getName().schema;
        this.busyWriting = true;
        this.rowOut.reset();
        this.rowOut.setMode(1);
        this.addSessionId(session);
        this.rowOut.write(BYTES_DELETE_FROM);
        this.rowOut.writeString(table.getName().statementName);
        this.rowOut.write(BYTES_WHERE);
        this.rowOut.writeData(table.getColumnCount(), table.getColumnTypes(), data, table.columnList, table.getPrimaryKey());
        this.rowOut.write(BYTES_LINE_SEP);
        this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
        this.byteCount += (long)this.rowOut.size();
        this.needsSync |= session.isAutoCommit();
        this.busyWriting = false;
        if (this.forceSync || this.writeDelay == 0) {
            this.sync();
        }
    }

    public void writeSequenceStatement(Session session, NumberSequence seq) throws HsqlException, IOException {
        this.schemaToLog = seq.getName().schema;
        this.busyWriting = true;
        this.rowOut.reset();
        this.addSessionId(session);
        this.rowOut.write(BYTES_SEQUENCE);
        this.rowOut.writeString(seq.getName().statementName);
        this.rowOut.write(BYTES_SEQUENCE_MID);
        this.rowOut.writeLongData(seq.peek());
        this.rowOut.write(BYTES_LINE_SEP);
        this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
        this.byteCount += (long)this.rowOut.size();
        this.needsSync = true;
        this.busyWriting = false;
        if (this.forceSync || this.writeDelay == 0) {
            this.sync();
        }
    }

    public void writeCommitStatement(Session session) throws HsqlException, IOException {
        this.busyWriting = true;
        this.rowOut.reset();
        this.addSessionId(session);
        this.rowOut.write(BYTES_COMMIT);
        this.rowOut.write(BYTES_LINE_SEP);
        this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
        this.byteCount += (long)this.rowOut.size();
        this.needsSync = true;
        this.busyWriting = false;
        if (this.forceSync || this.writeDelay == 0) {
            this.sync();
        }
    }

    protected void finalize() {
        this.sync();
    }

    static {
        String sLineSep = System.getProperty("line.separator", "\n");
        try {
            BYTES_LINE_SEP = sLineSep.getBytes("ISO8859-1");
            BYTES_COMMIT = "COMMIT".getBytes("ISO8859-1");
            BYTES_INSERT_INTO = "INSERT INTO ".getBytes("ISO8859-1");
            BYTES_VALUES = " VALUES(".getBytes("ISO8859-1");
            BYTES_TERM = ")".getBytes("ISO8859-1");
            BYTES_DELETE_FROM = "DELETE FROM ".getBytes("ISO8859-1");
            BYTES_WHERE = " WHERE ".getBytes("ISO8859-1");
            BYTES_SEQUENCE = "ALTER SEQUENCE ".getBytes("ISO8859-1");
            BYTES_SEQUENCE_MID = " RESTART WITH ".getBytes("ISO8859-1");
            BYTES_C_ID_INIT = "/*C".getBytes("ISO8859-1");
            BYTES_C_ID_TERM = "*/".getBytes("ISO8859-1");
            BYTES_SCHEMA = "SET SCHEMA ".getBytes("ISO8859-1");
        }
        catch (UnsupportedEncodingException uuex) {
            throw new RuntimeException(uuex.getMessage());
        }
    }
}

