/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb;

import com.fr.third.org.hsqldb.Constraint;
import com.fr.third.org.hsqldb.Database;
import com.fr.third.org.hsqldb.DatabaseObjectNames;
import com.fr.third.org.hsqldb.HsqlException;
import com.fr.third.org.hsqldb.HsqlNameManager;
import com.fr.third.org.hsqldb.Index;
import com.fr.third.org.hsqldb.NumberSequence;
import com.fr.third.org.hsqldb.SequenceManager;
import com.fr.third.org.hsqldb.Session;
import com.fr.third.org.hsqldb.Table;
import com.fr.third.org.hsqldb.TableWorks;
import com.fr.third.org.hsqldb.Trace;
import com.fr.third.org.hsqldb.View;
import com.fr.third.org.hsqldb.lib.ArrayUtil;
import com.fr.third.org.hsqldb.lib.HashMappedList;
import com.fr.third.org.hsqldb.lib.HsqlArrayList;
import com.fr.third.org.hsqldb.lib.Iterator;
import com.fr.third.org.hsqldb.lib.WrapperIterator;
import com.fr.third.org.hsqldb.persist.Logger;

public class SchemaManager {
    static final String SYSTEM_SCHEMA = "SYSTEM_SCHEMA";
    static final String DEFINITION_SCHEMA = "DEFINITION_SCHEMA";
    static final String INFORMATION_SCHEMA = "INFORMATION_SCHEMA";
    static final String PUBLIC_SCHEMA = "PUBLIC";
    static HsqlNameManager.HsqlName INFORMATION_SCHEMA_HSQLNAME = HsqlNameManager.newHsqlSystemObjectName("INFORMATION_SCHEMA");
    static HsqlNameManager.HsqlName SYSTEM_SCHEMA_HSQLNAME = HsqlNameManager.newHsqlSystemObjectName("SYSTEM_SCHEMA");
    Database database;
    HsqlNameManager.HsqlName defaultSchemaHsqlName;
    HashMappedList schemaMap = new HashMappedList();

    SchemaManager(Database database) {
        this.database = database;
        Schema schema = new Schema(PUBLIC_SCHEMA, false);
        this.defaultSchemaHsqlName = schema.name;
        this.schemaMap.put(PUBLIC_SCHEMA, schema);
    }

    void createSchema(String name, boolean isQuoted) throws HsqlException {
        if (DEFINITION_SCHEMA.equals(name) || INFORMATION_SCHEMA.equals(name) || SYSTEM_SCHEMA.equals(name)) {
            throw Trace.error(227);
        }
        Schema schema = new Schema(name, isQuoted);
        this.schemaMap.add(name, schema);
    }

    void dropSchema(String name, boolean cascade) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(name);
        if (schema == null) {
            throw Trace.error(227);
        }
        if (!cascade && !schema.isEmpty()) {
            throw Trace.error(228);
        }
        Iterator tableIterator = schema.tablesIterator();
        while (tableIterator.hasNext()) {
            Table table = (Table)tableIterator.next();
            this.database.getUserManager().removeDbObject(table.getName());
            table.drop();
        }
        Iterator sequenceIterator = schema.sequencesIterator();
        while (tableIterator.hasNext()) {
            NumberSequence sequence = (NumberSequence)sequenceIterator.next();
            this.database.getUserManager().removeDbObject(sequence.getName());
        }
        schema.clearStructures();
        this.schemaMap.remove(name);
        if (this.defaultSchemaHsqlName.name.equals(name)) {
            schema = this.schemaMap.isEmpty() ? new Schema(PUBLIC_SCHEMA, false) : (Schema)this.schemaMap.get(0);
            this.defaultSchemaHsqlName = schema.name;
            this.schemaMap.put(this.defaultSchemaHsqlName.name, schema);
        }
        this.database.getUserManager().removeSchemaReference(schema);
        this.database.getSessionManager().removeSchemaReference(schema);
    }

    void renameSchema(String name, String newName, boolean isQuoted) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(name);
        Schema exists = (Schema)this.schemaMap.get(newName);
        if (schema == null || exists != null || INFORMATION_SCHEMA.equals(newName)) {
            throw Trace.error(227, schema == null ? name : newName);
        }
        schema.name.rename(newName, isQuoted);
        int index = this.schemaMap.getIndex(name);
        this.schemaMap.set(index, newName, schema);
    }

    void clearStructures() {
        Iterator it = this.schemaMap.values().iterator();
        while (it.hasNext()) {
            Schema schema = (Schema)it.next();
            schema.clearStructures();
        }
    }

    public Iterator userSchemaNameIterator() {
        return this.schemaMap.keySet().iterator();
    }

    HsqlNameManager.HsqlName toSchemaHsqlName(String name) {
        Schema schema = (Schema)this.schemaMap.get(name);
        return schema == null ? null : schema.name;
    }

    HsqlNameManager.HsqlName getDefaultSchemaHsqlName() {
        return this.defaultSchemaHsqlName;
    }

    public String getDefaultSchemaName() {
        return this.defaultSchemaHsqlName.name;
    }

    boolean schemaExists(String name) {
        if (INFORMATION_SCHEMA.equals(name)) {
            return true;
        }
        return this.schemaMap.containsKey(name);
    }

    HsqlNameManager.HsqlName getSchemaHsqlName(String name) throws HsqlException {
        if (name == null) {
            return this.defaultSchemaHsqlName;
        }
        if (INFORMATION_SCHEMA.equals(name)) {
            return INFORMATION_SCHEMA_HSQLNAME;
        }
        Schema schema = (Schema)this.schemaMap.get(name);
        if (schema == null) {
            throw Trace.error(227, name);
        }
        return schema.name;
    }

    String getSchemaName(String name) throws HsqlException {
        return this.getSchemaHsqlName((String)name).name;
    }

    Iterator fullSchemaNamesIterator() {
        return new WrapperIterator(new WrapperIterator(INFORMATION_SCHEMA), this.schemaMap.keySet().iterator());
    }

    public boolean isSystemSchema(HsqlNameManager.HsqlName schema) {
        return INFORMATION_SCHEMA_HSQLNAME.equals(schema) || SYSTEM_SCHEMA_HSQLNAME.equals(schema);
    }

    public Iterator tablesIterator(String schema) {
        Schema temp = (Schema)this.schemaMap.get(schema);
        return temp.tablesIterator();
    }

    public Iterator allTablesIterator() {
        Iterator schemas = this.userSchemaNameIterator();
        WrapperIterator tables = new WrapperIterator();
        while (schemas.hasNext()) {
            String name = (String)schemas.next();
            Iterator t = this.tablesIterator(name);
            tables = new WrapperIterator(tables, t);
        }
        return tables;
    }

    Iterator sequenceIterator(String schema) {
        Schema temp = (Schema)this.schemaMap.get(schema);
        return temp.sequencesIterator();
    }

    public Iterator allSequencesIterator() {
        Iterator it = this.schemaMap.values().iterator();
        WrapperIterator sequences = new WrapperIterator();
        while (it.hasNext()) {
            Schema temp = (Schema)it.next();
            sequences = new WrapperIterator(sequences, temp.sequencesIterator());
        }
        return sequences;
    }

    public HsqlArrayList getAllTables() {
        Iterator schemas = this.userSchemaNameIterator();
        HsqlArrayList alltables = new HsqlArrayList();
        while (schemas.hasNext()) {
            String name = (String)schemas.next();
            HashMappedList current = this.getTables(name);
            alltables.addAll(current.values());
        }
        return alltables;
    }

    public HashMappedList getTables(String schema) {
        Schema temp = (Schema)this.schemaMap.get(schema);
        return temp.tableList;
    }

    void checkUserViewNotExists(Session session, String viewName, String schema) throws HsqlException {
        boolean exists;
        boolean bl = exists = this.database.schemaManager.findUserTable(session, viewName, schema) != null;
        if (exists) {
            throw Trace.error(52, viewName);
        }
    }

    void checkUserTableNotExists(Session session, String tableName, String schema) throws HsqlException {
        boolean exists;
        boolean bl = exists = this.findUserTable(session, tableName, schema) != null;
        if (exists) {
            throw Trace.error(21, tableName);
        }
    }

    public Table getTable(Session session, String name, String schema) throws HsqlException {
        Table t = this.findUserTable(session, name, schema);
        if (t == null) {
            if (!INFORMATION_SCHEMA.equals(schema)) {
                throw Trace.error(22);
            }
            if (this.database.dbInfo != null) {
                t = this.database.dbInfo.getSystemTable(session, name);
            }
        }
        if (t == null) {
            throw Trace.error(22, name);
        }
        return t;
    }

    public Table getUserTable(Session session, String name, String schema) throws HsqlException {
        Table t = this.findUserTable(session, name, schema);
        if (t == null) {
            throw Trace.error(22, name);
        }
        return t;
    }

    Table findUserTable(Session session, String name, String schemaName) {
        Schema schema = (Schema)this.schemaMap.get(schemaName);
        if (schema == null) {
            return null;
        }
        int tsize = schema.tableList.size();
        for (int i = 0; i < tsize; ++i) {
            Table t = (Table)schema.tableList.get(i);
            if (!t.equals(session, name)) continue;
            return t;
        }
        return null;
    }

    void linkTable(Table t) {
        Schema schema = (Schema)this.schemaMap.get(t.getSchemaName());
        schema.tableList.add(t.getName().name, t);
    }

    NumberSequence getSequence(String name, String schemaName) throws HsqlException {
        NumberSequence sequence = this.findSequence(name, schemaName);
        if (sequence == null) {
            throw Trace.error(191, name);
        }
        return sequence;
    }

    public NumberSequence findSequence(String name, String schemaName) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(schemaName);
        NumberSequence sequence = schema.sequenceManager.getSequence(name);
        return sequence;
    }

    Table findUserTableForIndex(Session session, String name, String schemaName) {
        Schema schema = (Schema)this.schemaMap.get(schemaName);
        HsqlNameManager.HsqlName tablename = schema.indexNameList.getOwner(name);
        if (tablename == null) {
            return null;
        }
        return this.findUserTable(session, tablename.name, schemaName);
    }

    int getTableIndex(Table table) {
        Schema schema = (Schema)this.schemaMap.get(table.getSchemaName());
        int tsize = schema.tableList.size();
        for (int i = 0; i < tsize; ++i) {
            Table t = (Table)schema.tableList.get(i);
            if (t != table) continue;
            return i;
        }
        return -1;
    }

    void dropIndex(Session session, String indexname, String schema, boolean ifExists) throws HsqlException {
        Table t = this.findUserTableForIndex(session, indexname, schema);
        if (t == null) {
            if (ifExists) {
                return;
            }
            throw Trace.error(26, indexname);
        }
        t.checkDropIndex(indexname, null, false);
        session.commit();
        session.setScripting(true);
        TableWorks tw = new TableWorks(session, t);
        tw.dropIndex(indexname);
    }

    void checkTriggerExists(String name, String schemaName, boolean yes) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(schemaName);
        boolean exists = schema.triggerNameList.containsName(name);
        if (exists != yes) {
            int code = yes ? 43 : 164;
            throw Trace.error(code, name);
        }
    }

    void registerTriggerName(String name, HsqlNameManager.HsqlName tableName) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(tableName.schema.name);
        schema.triggerNameList.addName(name, tableName, 164);
    }

    void checkIndexExists(String name, String schemaName, boolean yes) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(schemaName);
        boolean exists = schema.indexNameList.containsName(name);
        if (exists != yes) {
            int code = yes ? 26 : 23;
            throw Trace.error(code, name);
        }
    }

    void registerIndexName(String name, HsqlNameManager.HsqlName tableName) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(tableName.schema.name);
        schema.indexNameList.addName(name, tableName, 23);
    }

    void removeIndexName(String name, HsqlNameManager.HsqlName tableName) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(tableName.schema.name);
        schema.indexNameList.removeName(name);
    }

    void removeIndexNames(HsqlNameManager.HsqlName tableName) {
        Schema schema = (Schema)this.schemaMap.get(tableName.schema.name);
        schema.indexNameList.removeOwner(tableName);
    }

    void renameIndex(String oldName, String newName, HsqlNameManager.HsqlName tableName) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(tableName.schema.name);
        schema.indexNameList.rename(oldName, newName, 23);
    }

    void checkConstraintExists(String name, String schemaName, boolean yes) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(schemaName);
        boolean exists = schema.constraintNameList.containsName(name);
        if (exists != yes) {
            int code = yes ? 61 : 60;
            throw Trace.error(code, name);
        }
    }

    void registerConstraintName(String name, HsqlNameManager.HsqlName tableName) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(tableName.schema.name);
        schema.constraintNameList.addName(name, tableName, 60);
    }

    void removeConstraintName(String name, HsqlNameManager.HsqlName tableName) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(tableName.schema.name);
        schema.constraintNameList.removeName(name);
    }

    void removeConstraintNames(HsqlNameManager.HsqlName tableName) {
        Schema schema = (Schema)this.schemaMap.get(tableName.schema.name);
        schema.constraintNameList.removeOwner(tableName);
    }

    NumberSequence createSequence(HsqlNameManager.HsqlName hsqlname, long start, long increment, int type) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(hsqlname.schema.name);
        return schema.sequenceManager.createSequence(hsqlname, start, increment, type);
    }

    void dropSequence(NumberSequence sequence) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(sequence.getSchemaName());
        schema.sequenceManager.dropSequence(sequence.getName().name);
    }

    void logSequences(Session session, Logger logger) throws HsqlException {
        int size = this.schemaMap.size();
        for (int i = 0; i < size; ++i) {
            Schema schema = (Schema)this.schemaMap.get(i);
            schema.sequenceManager.logSequences(session, logger);
        }
    }

    void clearTempTables(Session exclude, Table table) {
        Session[] sessions = this.database.sessionManager.getAllSessions();
        Index[] indexes = table.getIndexes();
        for (int i = 0; i < sessions.length; ++i) {
            if (sessions[i] == exclude) continue;
            for (int j = 0; j < indexes.length; ++j) {
                sessions[i].dropIndex(indexes[j].getName(), false);
            }
        }
    }

    void dropTable(Session session, String name, String schemaName, boolean ifExists, boolean isView, boolean cascade) throws HsqlException {
        Table table = null;
        int dropIndex = -1;
        Schema schema = (Schema)this.schemaMap.get(schemaName);
        for (int i = 0; i < schema.tableList.size(); ++i) {
            table = (Table)schema.tableList.get(i);
            if (table.equals(session, name) && isView == table.isView()) {
                dropIndex = i;
                break;
            }
            table = null;
        }
        if (dropIndex == -1) {
            if (ifExists) {
                return;
            }
            throw Trace.error(isView ? 53 : 22, name);
        }
        session.checkAdmin();
        session.checkDDLWrite();
        session.commit();
        this.dropTable(table, cascade);
        session.setScripting(true);
    }

    void dropTable(Table table, boolean cascade) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(table.getSchemaName());
        int dropIndex = schema.tableList.getIndex(table.getName().name);
        if (table.isView()) {
            this.checkCascadeDropViews((View)table, cascade);
        } else {
            this.checkCascadeDropReferenced(table, cascade);
            this.checkCascadeDropViews(table, cascade);
        }
        table = (Table)schema.tableList.remove(dropIndex);
        this.removeExportedKeys(table);
        this.database.getUserManager().removeDbObject(table.getName());
        schema.triggerNameList.removeOwner(table.tableName);
        schema.indexNameList.removeOwner(table.tableName);
        schema.constraintNameList.removeOwner(table.tableName);
        table.dropTriggers();
        table.drop();
    }

    void setTable(int index, Table table) {
        Schema schema = (Schema)this.schemaMap.get(table.getSchemaName());
        schema.tableList.set(index, table.getName().name, table);
    }

    void renameTable(Session session, Table table, String newName, boolean isQuoted) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(table.tableName.schema.name);
        int i = schema.tableList.getIndex(table.tableName.name);
        this.checkCascadeDropViews(table, false);
        table.rename(session, newName, isQuoted);
        schema.tableList.setKey(i, newName);
    }

    private void checkCascadeDropReferenced(Table table, boolean cascade) throws HsqlException {
        Constraint[] constraints = table.getConstraints();
        Constraint currentConstraint = null;
        Table refTable = null;
        boolean isSelfRef = false;
        for (int i = constraints.length - 1; i >= 0; --i) {
            currentConstraint = constraints[i];
            if (currentConstraint.getType() != 1) continue;
            refTable = currentConstraint.getRef();
            boolean bl = isSelfRef = refTable != null && table.equals(refTable);
            if (isSelfRef) continue;
            if (cascade) {
                Constraint refConst = refTable.getConstraint(currentConstraint.getFkName());
                TableWorks tw = new TableWorks(null, refTable);
                tw.dropFKConstraint(refConst);
                constraints = table.constraintList;
                i = constraints.length;
                continue;
            }
            throw Trace.error(193, 101, new Object[]{currentConstraint.getName().name, refTable.getName().name});
        }
    }

    void checkCascadeDropViews(View view, boolean cascade) throws HsqlException {
        View[] views = this.getViewsWithView(view);
        if (views != null) {
            if (cascade) {
                for (int i = views.length - 1; i >= 0; --i) {
                    this.dropTable(views[i], cascade);
                }
            } else {
                throw Trace.error(194, views[0].getName().name);
            }
        }
    }

    void checkCascadeDropViews(Table table, boolean cascade) throws HsqlException {
        View[] views = this.getViewsWithTable(table, null);
        if (views != null) {
            if (cascade) {
                for (int i = views.length - 1; i >= 0; --i) {
                    this.dropTable(views[i], cascade);
                }
            } else {
                throw Trace.error(194, views[0].getName().name);
            }
        }
    }

    void checkCascadeDropViews(NumberSequence sequence, boolean cascade) throws HsqlException {
        View[] views = this.getViewsWithSequence(sequence);
        if (views != null) {
            if (cascade) {
                for (int i = views.length - 1; i >= 0; --i) {
                    this.dropTable(views[i], cascade);
                }
            } else {
                throw Trace.error(186, views[0].getName().name);
            }
        }
    }

    void checkColumnIsInView(Table table, String column) throws HsqlException {
        View[] views = this.getViewsWithTable(table, column);
        if (views != null) {
            throw Trace.error(197, views[0].getName().name);
        }
    }

    private View[] getViewsWithView(View view) {
        HsqlArrayList list = null;
        Schema schema = (Schema)this.schemaMap.get(view.getSchemaName());
        for (int i = 0; i < schema.tableList.size(); ++i) {
            boolean found;
            Table t = (Table)schema.tableList.get(i);
            if (!t.isView() || !(found = ((View)t).hasView(view))) continue;
            if (list == null) {
                list = new HsqlArrayList();
            }
            list.add(t);
        }
        return list == null ? null : (View[])list.toArray(new View[list.size()]);
    }

    private View[] getViewsWithTable(Table table, String column) {
        HsqlArrayList list = null;
        Iterator it = this.allTablesIterator();
        while (it.hasNext()) {
            boolean found;
            Table t = (Table)it.next();
            if (!t.isView() || !(found = column == null ? ((View)t).hasTable(table) : ((View)t).hasColumn(table, column))) continue;
            if (list == null) {
                list = new HsqlArrayList();
            }
            list.add(t);
        }
        return list == null ? null : (View[])list.toArray(new View[list.size()]);
    }

    View[] getViewsWithSequence(NumberSequence sequence) {
        HsqlArrayList list = null;
        Iterator it = this.allTablesIterator();
        while (it.hasNext()) {
            boolean found;
            Table t = (Table)it.next();
            if (!t.isView() || !(found = ((View)t).hasSequence(sequence))) continue;
            if (list == null) {
                list = new HsqlArrayList();
            }
            list.add(t);
        }
        return list == null ? null : (View[])list.toArray(new View[list.size()]);
    }

    void recompileViews(Table table) throws HsqlException {
        View[] viewlist = this.getViewsWithTable(table, null);
        if (viewlist != null) {
            for (int i = 0; i < viewlist.length; ++i) {
                String schema = viewlist[i].compileTimeSchema.name;
                if (!this.schemaExists(schema)) {
                    schema = null;
                }
                Session session = this.database.sessionManager.getSysSession(schema, false);
                viewlist[i].compile(session);
            }
        }
    }

    void removeExportedKeys(Table toDrop) {
        Schema schema = (Schema)this.schemaMap.get(toDrop.getSchemaName());
        for (int i = 0; i < schema.tableList.size(); ++i) {
            Table table = (Table)schema.tableList.get(i);
            for (int j = table.constraintList.length - 1; j >= 0; --j) {
                Table refTable = table.constraintList[j].getRef();
                if (toDrop != refTable) continue;
                table.constraintList = (Constraint[])ArrayUtil.toAdjustedArray(table.constraintList, null, j, -1);
            }
        }
    }

    void dropTrigger(Session session, String name, String schemaName) throws HsqlException {
        Schema schema = (Schema)this.schemaMap.get(schemaName);
        boolean found = schema.triggerNameList.containsName(name);
        Trace.check(found, 43, name);
        HsqlNameManager.HsqlName tableName = (HsqlNameManager.HsqlName)schema.triggerNameList.removeName(name);
        Table t = this.findUserTable(session, tableName.name, schemaName);
        t.dropTrigger(name);
        session.setScripting(true);
    }

    public class Schema {
        HsqlNameManager.HsqlName name;
        DatabaseObjectNames triggerNameList;
        DatabaseObjectNames constraintNameList;
        DatabaseObjectNames indexNameList;
        SequenceManager sequenceManager;
        HashMappedList tableList;

        Schema(String name, boolean isquoted) {
            this.name = SchemaManager.this.database.nameManager.newHsqlName(name, isquoted);
            this.triggerNameList = new DatabaseObjectNames();
            this.indexNameList = new DatabaseObjectNames();
            this.constraintNameList = new DatabaseObjectNames();
            this.sequenceManager = new SequenceManager();
            this.tableList = new HashMappedList();
        }

        boolean isEmpty() {
            return this.sequenceManager.sequenceMap.isEmpty() && this.tableList.isEmpty();
        }

        Iterator tablesIterator() {
            return this.tableList.values().iterator();
        }

        Iterator sequencesIterator() {
            return this.sequenceManager.sequenceMap.values().iterator();
        }

        void clearStructures() {
            if (this.tableList != null) {
                for (int i = 0; i < this.tableList.size(); ++i) {
                    Table table = (Table)this.tableList.get(i);
                    table.dropTriggers();
                }
            }
            this.triggerNameList = null;
            this.indexNameList = null;
            this.constraintNameList = null;
            this.sequenceManager = null;
            this.tableList = null;
        }
    }
}

