/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb;

import com.fr.third.org.hsqldb.Collation;
import com.fr.third.org.hsqldb.Constraint;
import com.fr.third.org.hsqldb.DINameSpace;
import com.fr.third.org.hsqldb.DIProcedureInfo;
import com.fr.third.org.hsqldb.DITypeInfo;
import com.fr.third.org.hsqldb.Database;
import com.fr.third.org.hsqldb.DatabaseInformationMain;
import com.fr.third.org.hsqldb.Expression;
import com.fr.third.org.hsqldb.Function;
import com.fr.third.org.hsqldb.Grantee;
import com.fr.third.org.hsqldb.HsqlDateTime;
import com.fr.third.org.hsqldb.HsqlException;
import com.fr.third.org.hsqldb.Result;
import com.fr.third.org.hsqldb.Session;
import com.fr.third.org.hsqldb.SubQuery;
import com.fr.third.org.hsqldb.Table;
import com.fr.third.org.hsqldb.TableFilter;
import com.fr.third.org.hsqldb.TriggerDef;
import com.fr.third.org.hsqldb.Types;
import com.fr.third.org.hsqldb.User;
import com.fr.third.org.hsqldb.UserManager;
import com.fr.third.org.hsqldb.View;
import com.fr.third.org.hsqldb.lib.FileUtil;
import com.fr.third.org.hsqldb.lib.HashMap;
import com.fr.third.org.hsqldb.lib.HashSet;
import com.fr.third.org.hsqldb.lib.HsqlArrayList;
import com.fr.third.org.hsqldb.lib.Iterator;
import com.fr.third.org.hsqldb.persist.DataFileCache;
import com.fr.third.org.hsqldb.persist.HsqlDatabaseProperties;
import com.fr.third.org.hsqldb.persist.TextCache;
import com.fr.third.org.hsqldb.scriptio.ScriptWriterBase;
import com.fr.third.org.hsqldb.store.ValuePool;
import java.lang.reflect.Method;

final class DatabaseInformationFull
extends DatabaseInformationMain {
    protected DIProcedureInfo pi;

    DatabaseInformationFull(Database db) throws HsqlException {
        super(db);
        this.pi = new DIProcedureInfo(this.ns);
    }

    protected Table generateTable(int tableIndex) throws HsqlException {
        switch (tableIndex) {
            case 7: {
                return this.SYSTEM_PROCEDURECOLUMNS();
            }
            case 8: {
                return this.SYSTEM_PROCEDURES();
            }
            case 10: {
                return this.SYSTEM_SUPERTABLES();
            }
            case 11: {
                return this.SYSTEM_SUPERTYPES();
            }
            case 16: {
                return this.SYSTEM_UDTATTRIBUTES();
            }
            case 17: {
                return this.SYSTEM_UDTS();
            }
            case 19: {
                return this.SYSTEM_VERSIONCOLUMNS();
            }
            case 20: {
                return this.SYSTEM_ALIASES();
            }
            case 22: {
                return this.SYSTEM_CACHEINFO();
            }
            case 23: {
                return this.SYSTEM_CLASSPRIVILEGES();
            }
            case 24: {
                return this.SYSTEM_SESSIONINFO();
            }
            case 25: {
                return this.SYSTEM_PROPERTIES();
            }
            case 26: {
                return this.SYSTEM_SESSIONS();
            }
            case 27: {
                return this.SYSTEM_TRIGGERCOLUMNS();
            }
            case 28: {
                return this.SYSTEM_TRIGGERS();
            }
            case 30: {
                return this.SYSTEM_VIEWS();
            }
            case 31: {
                return this.SYSTEM_TEXTTABLES();
            }
            case 33: {
                return this.SYSTEM_USAGE_PRIVILEGES();
            }
            case 36: {
                return this.SYSTEM_CHECK_COLUMN_USAGE();
            }
            case 37: {
                return this.SYSTEM_CHECK_ROUTINE_USAGE();
            }
            case 38: {
                return this.SYSTEM_CHECK_TABLE_USAGE();
            }
            case 35: {
                return this.SYSTEM_TABLE_CONSTRAINTS();
            }
            case 40: {
                return this.SYSTEM_VIEW_TABLE_USAGE();
            }
            case 39: {
                return this.SYSTEM_VIEW_COLUMN_USAGE();
            }
            case 41: {
                return this.SYSTEM_VIEW_ROUTINE_USAGE();
            }
            case 42: {
                return this.SYSTEM_AUTHORIZATIONS();
            }
            case 44: {
                return this.SYSTEM_ROLE_AUTHORIZATION_DESCRIPTORS();
            }
            case 45: {
                return this.SYSTEM_SCHEMATA();
            }
            case 43: {
                return this.SYSTEM_COLLATIONS();
            }
        }
        return super.generateTable(tableIndex);
    }

    Table SYSTEM_ALIASES() throws HsqlException {
        String schem;
        String cat;
        String objName;
        String alias;
        Object[] row;
        Table t = this.sysTables[20];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[20]);
            this.addColumn(t, "OBJECT_TYPE", 12, 32, false);
            this.addColumn(t, "OBJECT_CAT", 12);
            this.addColumn(t, "OBJECT_SCHEM", 12);
            this.addColumn(t, "OBJECT_NAME", 12, false);
            this.addColumn(t, "ALIAS_CAT", 12);
            this.addColumn(t, "ALIAS_SCHEM", 12);
            this.addColumn(t, "ALIAS", 12, false);
            t.createPrimaryKey(null, new int[]{0, 3, 6}, true);
            return t;
        }
        boolean ialias_object_type = false;
        boolean ialias_object_cat = true;
        int ialias_object_schem = 2;
        int ialias_object_name = 3;
        int ialias_cat = 4;
        int ialias_schem = 5;
        int ialias = 6;
        HashMap hAliases = this.database.getAliasMap();
        Iterator aliases = hAliases.keySet().iterator();
        String objType = "ROUTINE";
        while (aliases.hasNext()) {
            String className;
            row = t.getEmptyRowData();
            alias = (String)aliases.next();
            objName = (String)hAliases.get(alias);
            int pos = objName.lastIndexOf(46);
            if (pos <= 0 || !this.session.isAccessible(className = objName.substring(0, pos))) continue;
            cat = this.ns.getCatalogName(objName);
            schem = this.ns.getSchemaName(className);
            row[0] = objType;
            row[1] = cat;
            row[2] = schem;
            row[3] = objName;
            row[4] = cat;
            row[5] = schem;
            row[6] = alias;
            t.insertSys(row);
        }
        if (this.session.isAdmin()) {
            Iterator typeAliases = Types.typeAliases.keySet().iterator();
            objType = "DOMAIN";
            while (typeAliases.hasNext()) {
                int tn;
                row = t.getEmptyRowData();
                alias = (String)typeAliases.next();
                if (alias.equals(objName = Types.getTypeString(tn = Types.typeAliases.get((Object)alias, Integer.MIN_VALUE)))) continue;
                cat = this.ns.getCatalogName(objName);
                schem = this.ns.getSchemaName(objName);
                row[0] = objType;
                row[1] = cat;
                row[2] = schem;
                row[3] = objName;
                row[4] = cat;
                row[5] = schem;
                row[6] = alias;
                t.insertSys(row);
            }
        }
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_CACHEINFO() throws HsqlException {
        DataFileCache cache;
        Table t = this.sysTables[22];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[22]);
            this.addColumn(t, "CACHE_FILE", 12, false);
            this.addColumn(t, "MAX_CACHE_COUNT", 4, false);
            this.addColumn(t, "MAX_CACHE_BYTES", -5, false);
            this.addColumn(t, "CACHE_SIZE", 4, false);
            this.addColumn(t, "CACHE_BYTES", -5, false);
            this.addColumn(t, "FILE_FREE_BYTES", 4, false);
            this.addColumn(t, "FILE_FREE_COUNT", 4, false);
            this.addColumn(t, "FILE_FREE_POS", -5, false);
            t.createPrimaryKey(null, new int[]{0}, true);
            return t;
        }
        boolean icache_file = false;
        boolean imax_cache_sz = true;
        int imax_cache_bytes = 2;
        int icache_size = 3;
        int icache_length = 4;
        int ifree_bytes = 5;
        int ifree_count = 6;
        int ifree_pos = 7;
        HashSet cacheSet = new HashSet();
        Iterator tables = this.database.schemaManager.allTablesIterator();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (!table.isFileBased() || !this.isAccessibleTable(table) || (cache = table.getCache()) == null) continue;
            cacheSet.add(cache);
        }
        Iterator caches = cacheSet.iterator();
        while (caches.hasNext()) {
            cache = (DataFileCache)caches.next();
            Object[] row = t.getEmptyRowData();
            row[0] = FileUtil.getDefaultInstance().canonicalOrAbsolutePath(cache.getFileName());
            row[1] = ValuePool.getInt(cache.capacity());
            row[2] = ValuePool.getLong(cache.bytesCapacity());
            row[3] = ValuePool.getInt(cache.getCachedObjectCount());
            row[4] = ValuePool.getLong(cache.getTotalCachedBlockSize());
            row[5] = ValuePool.getInt(cache.getTotalFreeBlockSize());
            row[6] = ValuePool.getInt(cache.getFreeBlockCount());
            row[7] = ValuePool.getLong(cache.getFileFreePos());
            t.insertSys(row);
        }
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_CLASSPRIVILEGES() throws HsqlException {
        Table t = this.sysTables[23];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[23]);
            this.addColumn(t, "CLASS_CAT", 12);
            this.addColumn(t, "CLASS_SCHEM", 12);
            this.addColumn(t, "CLASS_NAME", 12, false);
            this.addColumn(t, "GRANTOR", 12, false);
            this.addColumn(t, "GRANTEE", 12, false);
            this.addColumn(t, "PRIVILEGE", 12, 7, false);
            this.addColumn(t, "IS_GRANTABLE", 12, 3, false);
            t.createPrimaryKey(null, new int[]{2, 4, 5}, true);
            return t;
        }
        boolean icls_cat = false;
        boolean icls_schem = true;
        int icls_name = 2;
        int igrantor = 3;
        int igrantee = 4;
        int iprivilege = 5;
        int iis_grntbl = 6;
        String grantorName = "DBA";
        UserManager um = this.database.getUserManager();
        HsqlArrayList users = um.listVisibleUsers(this.session, true);
        for (int i = 0; i < users.size(); ++i) {
            Object[] row;
            String clsSchem;
            String clsCat;
            String clsName;
            User granteeUser = (User)users.get(i);
            String granteeName = granteeUser.getName();
            String isGrantable = granteeUser.isAdmin() ? "YES" : "NO";
            HashSet classNameSet = granteeUser.getGrantedClassNames(false);
            if (granteeUser.isPublic()) {
                this.ns.addBuiltinToSet(classNameSet);
            }
            Iterator classNames = classNameSet.iterator();
            String privilege = "EXECUTE";
            while (classNames.hasNext()) {
                clsName = (String)classNames.next();
                clsCat = this.ns.getCatalogName(clsName);
                clsSchem = this.ns.getSchemaName(clsName);
                row = t.getEmptyRowData();
                row[0] = clsCat;
                row[1] = clsSchem;
                row[2] = clsName;
                row[3] = grantorName;
                row[4] = granteeName;
                row[5] = privilege;
                row[6] = isGrantable;
                t.insertSys(row);
            }
            classNames = this.ns.iterateAccessibleTriggerClassNames(granteeUser);
            privilege = "TRIGGER";
            while (classNames.hasNext()) {
                clsName = (String)classNames.next();
                clsCat = this.ns.getCatalogName(clsName);
                clsSchem = this.ns.getSchemaName(clsName);
                row = t.getEmptyRowData();
                row[0] = clsCat;
                row[1] = clsSchem;
                row[2] = clsName;
                row[3] = grantorName;
                row[4] = granteeName;
                row[5] = privilege;
                row[6] = isGrantable;
                t.insertSys(row);
            }
        }
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_SESSIONINFO() throws HsqlException {
        Table t = this.sysTables[24];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[24]);
            this.addColumn(t, "KEY", 12, false);
            this.addColumn(t, "VALUE", 12, false);
            t.createPrimaryKey(null);
            return t;
        }
        Object[] row = t.getEmptyRowData();
        row[0] = "SESSION_ID";
        row[1] = String.valueOf(this.session.getId());
        t.insertSys(row);
        row = t.getEmptyRowData();
        row[0] = "AUTOCOMMIT";
        row[1] = this.session.isAutoCommit() ? "TRUE" : "FALSE";
        t.insertSys(row);
        row = t.getEmptyRowData();
        row[0] = "USER";
        row[1] = this.session.getUsername();
        t.insertSys(row);
        row = t.getEmptyRowData();
        row[0] = "SESSION_READONLY";
        row[1] = this.session.isReadOnly() ? "TRUE" : "FALSE";
        t.insertSys(row);
        row = t.getEmptyRowData();
        row[0] = "DATABASE_READONLY";
        row[1] = this.database.databaseReadOnly ? "TRUE" : "FALSE";
        t.insertSys(row);
        row = t.getEmptyRowData();
        row[0] = "MAXROWS";
        row[1] = String.valueOf(this.session.getSQLMaxRows());
        t.insertSys(row);
        row = t.getEmptyRowData();
        row[0] = "DATABASE";
        row[1] = this.database.getURI();
        t.insertSys(row);
        row = t.getEmptyRowData();
        row[0] = "IDENTITY";
        row[1] = String.valueOf(this.session.getLastIdentity());
        t.insertSys(row);
        row = t.getEmptyRowData();
        row[0] = "SCHEMA";
        row[1] = String.valueOf(this.session.getSchemaName(null));
        t.insertSys(row);
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_PROPERTIES() throws HsqlException {
        Object[] row;
        Table t = this.sysTables[25];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[25]);
            this.addColumn(t, "PROPERTY_SCOPE", 12, false);
            this.addColumn(t, "PROPERTY_NAMESPACE", 12, false);
            this.addColumn(t, "PROPERTY_NAME", 12, false);
            this.addColumn(t, "PROPERTY_VALUE", 12);
            this.addColumn(t, "PROPERTY_CLASS", 12, false);
            t.createPrimaryKey(null, new int[]{0, 1, 2}, true);
            return t;
        }
        boolean iscope = false;
        boolean ins = true;
        int iname = 2;
        int ivalue = 3;
        int iclass = 4;
        String scope = "SESSION";
        HsqlDatabaseProperties props = this.database.getProperties();
        String nameSpace = "database.properties";
        Iterator it = props.getUserDefinedPropertyData().iterator();
        while (it.hasNext()) {
            Object[] metaData = (Object[])it.next();
            row = t.getEmptyRowData();
            row[0] = scope;
            row[1] = nameSpace;
            row[2] = metaData[0];
            row[3] = props.getProperty((String)row[2]);
            row[4] = metaData[2];
            t.insertSys(row);
        }
        row = t.getEmptyRowData();
        row[0] = scope;
        row[1] = nameSpace;
        row[2] = "SCRIPTFORMAT";
        try {
            row[3] = ScriptWriterBase.LIST_SCRIPT_FORMATS[this.database.logger.getScriptType()];
        }
        catch (Exception e) {
            // empty catch block
        }
        row[4] = "java.lang.String";
        t.insertSys(row);
        row = t.getEmptyRowData();
        row[0] = scope;
        row[1] = nameSpace;
        row[2] = "WRITE_DELAY";
        row[3] = "" + this.database.logger.getWriteDelay();
        row[4] = "int";
        t.insertSys(row);
        row = t.getEmptyRowData();
        row[0] = scope;
        row[1] = nameSpace;
        row[2] = "IGNORECASE";
        row[3] = this.database.isIgnoreCase() ? "true" : "false";
        row[4] = "boolean";
        t.insertSys(row);
        row = t.getEmptyRowData();
        row[0] = scope;
        row[1] = nameSpace;
        row[2] = "REFERENTIAL_INTEGRITY";
        row[3] = this.database.isReferentialIntegrity() ? "true" : "false";
        row[4] = "boolean";
        t.insertSys(row);
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_SESSIONS() throws HsqlException {
        Table t = this.sysTables[26];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[26]);
            this.addColumn(t, "SESSION_ID", 4, false);
            this.addColumn(t, "CONNECTED", 93, false);
            this.addColumn(t, "USER_NAME", 12, false);
            this.addColumn(t, "IS_ADMIN", 16, false);
            this.addColumn(t, "AUTOCOMMIT", 16, false);
            this.addColumn(t, "READONLY", 16, false);
            this.addColumn(t, "MAXROWS", 4, false);
            this.addColumn(t, "LAST_IDENTITY", -5);
            this.addColumn(t, "TRANSACTION_SIZE", 4, false);
            this.addColumn(t, "SCHEMA", 12, false);
            t.createPrimaryKey(null, new int[]{0}, true);
            return t;
        }
        boolean isid = false;
        boolean ict = true;
        int iuname = 2;
        int iis_admin = 3;
        int iautocmt = 4;
        int ireadonly = 5;
        int imaxrows = 6;
        int ilast_id = 7;
        int it_size = 8;
        int it_schema = 9;
        Session[] sessions = this.ns.listVisibleSessions(this.session);
        for (int i = 0; i < sessions.length; ++i) {
            Session s = sessions[i];
            Object[] row = t.getEmptyRowData();
            row[0] = ValuePool.getInt(s.getId());
            row[1] = HsqlDateTime.getTimestamp(s.getConnectTime());
            row[2] = s.getUsername();
            row[3] = ValuePool.getBoolean(s.isAdmin());
            row[4] = ValuePool.getBoolean(s.isAutoCommit());
            row[5] = ValuePool.getBoolean(s.isReadOnly());
            row[6] = ValuePool.getInt(s.getSQLMaxRows());
            row[7] = ValuePool.getLong(s.getLastIdentity().longValue());
            row[8] = ValuePool.getInt(s.getTransactionSize());
            row[9] = s.getSchemaName(null);
            t.insertSys(row);
        }
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_SUPERTABLES() throws HsqlException {
        Table t = this.sysTables[10];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[10]);
            this.addColumn(t, "TABLE_CAT", 12);
            this.addColumn(t, "TABLE_SCHEM", 12);
            this.addColumn(t, "TABLE_NAME", 12, false);
            this.addColumn(t, "SUPERTABLE_NAME", 12, false);
            t.createPrimaryKey(null);
            return t;
        }
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_SUPERTYPES() throws HsqlException {
        Table t = this.sysTables[11];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[11]);
            this.addColumn(t, "TYPE_CAT", 12);
            this.addColumn(t, "TYPE_SCHEM", 12);
            this.addColumn(t, "TYPE_NAME", 12, false);
            this.addColumn(t, "SUPERTYPE_CAT", 12);
            this.addColumn(t, "SUPERTYPE_SCHEM", 12);
            this.addColumn(t, "SUPERTYPE_NAME", 12, false);
            t.createPrimaryKey(null);
            return t;
        }
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_TEXTTABLES() throws HsqlException {
        Table t = this.sysTables[31];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[31]);
            this.addColumn(t, "TABLE_CAT", 12);
            this.addColumn(t, "TABLE_SCHEM", 12);
            this.addColumn(t, "TABLE_NAME", 12, false);
            this.addColumn(t, "DATA_SOURCE_DEFINTION", 12);
            this.addColumn(t, "FILE_PATH", 12);
            this.addColumn(t, "FILE_ENCODING", 12);
            this.addColumn(t, "FIELD_SEPARATOR", 12);
            this.addColumn(t, "VARCHAR_SEPARATOR", 12);
            this.addColumn(t, "LONGVARCHAR_SEPARATOR", 12);
            this.addColumn(t, "IS_IGNORE_FIRST", 16);
            this.addColumn(t, "IS_ALL_QUOTED", 16);
            this.addColumn(t, "IS_QUOTED", 16);
            this.addColumn(t, "IS_DESC", 16);
            t.createPrimaryKey();
            return t;
        }
        boolean itable_cat = false;
        boolean itable_schem = true;
        int itable_name = 2;
        int idsd = 3;
        int ifile_path = 4;
        int ifile_enc = 5;
        int ifs = 6;
        int ivfs = 7;
        int ilvfs = 8;
        int iif = 9;
        int iiq = 10;
        int iiaq = 11;
        int iid = 12;
        Iterator tables = this.database.schemaManager.allTablesIterator();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (!table.isText() || !this.isAccessibleTable(table)) continue;
            Object[] row = t.getEmptyRowData();
            row[0] = this.ns.getCatalogName(table);
            row[1] = table.getSchemaName();
            row[2] = table.getName().name;
            row[3] = table.getDataSource();
            if (table.getCache() instanceof TextCache) {
                TextCache tc = (TextCache)table.getCache();
                row[4] = FileUtil.getDefaultInstance().canonicalOrAbsolutePath(tc.getFileName());
                row[5] = tc.stringEncoding;
                row[6] = tc.fs;
                row[7] = tc.vs;
                row[8] = tc.lvs;
                row[9] = ValuePool.getBoolean(tc.ignoreFirst);
                row[10] = ValuePool.getBoolean(tc.isQuoted);
                row[11] = ValuePool.getBoolean(tc.isAllQuoted);
                row[12] = ValuePool.getBoolean(table.isDescDataSource());
            }
            t.insertSys(row);
        }
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_TRIGGERCOLUMNS() throws HsqlException {
        Table t = this.sysTables[27];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[27]);
            this.addColumn(t, "TRIGGER_CAT", 12);
            this.addColumn(t, "TRIGGER_SCHEM", 12);
            this.addColumn(t, "TRIGGER_NAME", 12);
            this.addColumn(t, "TABLE_CAT", 12);
            this.addColumn(t, "TABLE_SCHEM", 12);
            this.addColumn(t, "TABLE_NAME", 12);
            this.addColumn(t, "COLUMN_NAME", 12);
            this.addColumn(t, "COLUMN_LIST", 12);
            this.addColumn(t, "COLUMN_USAGE", 12);
            t.createPrimaryKey(null, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8}, false);
            return t;
        }
        Result rs = this.session.sqlExecuteDirectNoPreChecks("select a.TRIGGER_CAT,a.TRIGGER_SCHEM,a.TRIGGER_NAME, a.TABLE_CAT,a.TABLE_SCHEM,a.TABLE_NAME,b.COLUMN_NAME,'Y','IN' from INFORMATION_SCHEMA.SYSTEM_TRIGGERS a, INFORMATION_SCHEMA.SYSTEM_COLUMNS b where a.TABLE_NAME=b.TABLE_NAME and a.TABLE_SCHEM=b.TABLE_SCHEM");
        t.insertSys(rs);
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_TRIGGERS() throws HsqlException {
        Table t = this.sysTables[28];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[28]);
            this.addColumn(t, "TRIGGER_CAT", 12);
            this.addColumn(t, "TRIGGER_SCHEM", 12);
            this.addColumn(t, "TRIGGER_NAME", 12, false);
            this.addColumn(t, "TRIGGER_TYPE", 12, 15, false);
            this.addColumn(t, "TRIGGERING_EVENT", 12, 10, false);
            this.addColumn(t, "TABLE_CAT", 12);
            this.addColumn(t, "TABLE_SCHEM", 12);
            this.addColumn(t, "BASE_OBJECT_TYPE", 12, 8, false);
            this.addColumn(t, "TABLE_NAME", 12, false);
            this.addColumn(t, "COLUMN_NAME", 12);
            this.addColumn(t, "REFERENCING_NAMES", 12, false);
            this.addColumn(t, "WHEN_CLAUSE", 12);
            this.addColumn(t, "STATUS", 12, 8, false);
            this.addColumn(t, "DESCRIPTION", 12, false);
            this.addColumn(t, "ACTION_TYPE", 12, false);
            this.addColumn(t, "TRIGGER_BODY", 12, false);
            t.createPrimaryKey(null, new int[]{3, 1, 2, 0}, false);
            return t;
        }
        boolean itrigger_cat = false;
        boolean itrigger_schem = true;
        int itrigger_name = 2;
        int itrigger_type = 3;
        int itriggering_event = 4;
        int itable_cat = 5;
        int itable_schem = 6;
        int ibase_object_type = 7;
        int itable_name = 8;
        int icolumn_name = 9;
        int ireferencing_names = 10;
        int iwhen_clause = 11;
        int istatus = 12;
        int idescription = 13;
        int iaction_type = 14;
        int itrigger_body = 15;
        Iterator tables = this.database.schemaManager.allTablesIterator();
        String actionType = "CALL";
        String baseObjectType = "TABLE";
        Object columnName = null;
        String referencingNames = "ROW";
        Object whenClause = null;
        while (tables.hasNext()) {
            String tableSchema;
            String tableCatalog;
            Table table = (Table)tables.next();
            HsqlArrayList[] vTrigs = table.triggerLists;
            if (vTrigs == null || !this.isAccessibleTable(table)) continue;
            String triggerCatalog = tableCatalog = this.ns.getCatalogName(table);
            String triggerSchema = tableSchema = table.getSchemaName();
            String tableName = table.getName().name;
            for (int i = 0; i < vTrigs.length; ++i) {
                HsqlArrayList triggerList = vTrigs[i];
                if (triggerList == null) continue;
                for (int j = 0; j < triggerList.size(); ++j) {
                    TriggerDef def = (TriggerDef)triggerList.get(j);
                    if (def == null) continue;
                    String triggerName = def.name.name;
                    String description = def.getDDL().toString();
                    String status = def.valid ? "ENABLED" : "DISABLED";
                    String triggerBody = def.triggerClassName;
                    String triggerType = def.when;
                    if (def.forEachRow) {
                        triggerType = triggerType + " EACH ROW";
                    }
                    String triggeringEvent = def.operation;
                    Object[] row = t.getEmptyRowData();
                    row[0] = triggerCatalog;
                    row[1] = triggerSchema;
                    row[2] = triggerName;
                    row[3] = triggerType;
                    row[4] = triggeringEvent;
                    row[5] = tableCatalog;
                    row[6] = tableSchema;
                    row[7] = baseObjectType;
                    row[8] = tableName;
                    row[9] = columnName;
                    row[10] = referencingNames;
                    row[11] = whenClause;
                    row[12] = status;
                    row[13] = description;
                    row[14] = actionType;
                    row[15] = triggerBody;
                    t.insertSys(row);
                }
            }
        }
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_UDTATTRIBUTES() throws HsqlException {
        Table t = this.sysTables[16];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[16]);
            this.addColumn(t, "TYPE_CAT", 12);
            this.addColumn(t, "TYPE_SCHEM", 12);
            this.addColumn(t, "TYPE_NAME", 12, false);
            this.addColumn(t, "ATTR_NAME", 12, false);
            this.addColumn(t, "DATA_TYPE", 5, false);
            this.addColumn(t, "ATTR_TYPE_NAME", 12, false);
            this.addColumn(t, "ATTR_SIZE", 4);
            this.addColumn(t, "DECIMAL_DIGITS", 4);
            this.addColumn(t, "NUM_PREC_RADIX", 4);
            this.addColumn(t, "NULLABLE", 4);
            this.addColumn(t, "REMARKS", 12);
            this.addColumn(t, "ATTR_DEF", 12);
            this.addColumn(t, "SQL_DATA_TYPE", 4);
            this.addColumn(t, "SQL_DATETIME_SUB", 4);
            this.addColumn(t, "CHAR_OCTET_LENGTH", 4);
            this.addColumn(t, "ORDINAL_POSITION", 4, false);
            this.addColumn(t, "IS_NULLABLE", 12, false);
            this.addColumn(t, "SCOPE_CATALOG", 12);
            this.addColumn(t, "SCOPE_SCHEMA", 12);
            this.addColumn(t, "SCOPE_TABLE", 12);
            this.addColumn(t, "SOURCE_DATA_TYPE", 5);
            t.createPrimaryKey(null);
            return t;
        }
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_UDTS() throws HsqlException {
        Table t = this.sysTables[17];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[17]);
            this.addColumn(t, "TYPE_CAT", 12);
            this.addColumn(t, "TYPE_SCHEM", 12);
            this.addColumn(t, "TYPE_NAME", 12, false);
            this.addColumn(t, "CLASS_NAME", 12, false);
            this.addColumn(t, "DATA_TYPE", 12, false);
            this.addColumn(t, "REMARKS", 12);
            this.addColumn(t, "BASE_TYPE", 5);
            t.createPrimaryKey(null);
            return t;
        }
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_VERSIONCOLUMNS() throws HsqlException {
        Table t = this.sysTables[19];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[19]);
            this.addColumn(t, "SCOPE", 4);
            this.addColumn(t, "COLUMN_NAME", 12, false);
            this.addColumn(t, "DATA_TYPE", 5, false);
            this.addColumn(t, "TYPE_NAME", 12, false);
            this.addColumn(t, "COLUMN_SIZE", 5);
            this.addColumn(t, "BUFFER_LENGTH", 4);
            this.addColumn(t, "DECIMAL_DIGITS", 5);
            this.addColumn(t, "PSEUDO_COLUMN", 5, false);
            this.addColumn(t, "TABLE_CAT", 12);
            this.addColumn(t, "TABLE_SCHEM", 12);
            this.addColumn(t, "TABLE_NAME", 12, false);
            t.createPrimaryKey(null);
            return t;
        }
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_VIEWS() throws HsqlException {
        Table t = this.sysTables[30];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[30]);
            this.addColumn(t, "TABLE_CATALOG", 12);
            this.addColumn(t, "TABLE_SCHEMA", 12);
            this.addColumn(t, "TABLE_NAME", 12, true);
            this.addColumn(t, "VIEW_DEFINITION", 12, true);
            this.addColumn(t, "CHECK_OPTION", 12, 8, true);
            this.addColumn(t, "IS_UPDATABLE", 12, 3, true);
            this.addColumn(t, "VALID", 16, true);
            t.createPrimaryKey(null, new int[]{1, 2, 0}, false);
            return t;
        }
        boolean icat = false;
        boolean ischem = true;
        int iname = 2;
        int idefn = 3;
        int icopt = 4;
        int iiupd = 5;
        int ivalid = 6;
        Iterator tables = this.database.schemaManager.allTablesIterator();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (!table.isView() || !this.isAccessibleTable(table)) continue;
            Object[] row = t.getEmptyRowData();
            String defn = ((View)table).getStatement();
            row[0] = this.ns.getCatalogName(table);
            row[1] = table.getSchemaName();
            row[2] = table.getName().name;
            row[3] = defn;
            row[4] = "NONE";
            row[5] = "NO";
            row[6] = Boolean.TRUE;
            t.insertSys(row);
        }
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_PROCEDURECOLUMNS() throws HsqlException {
        Table t = this.sysTables[7];
        if (t == null) {
            return super.SYSTEM_PROCEDURECOLUMNS();
        }
        Iterator methods = this.ns.iterateAllAccessibleMethods(this.session, true);
        DITypeInfo ti = new DITypeInfo();
        ti.setTypeSub(1);
        while (methods.hasNext()) {
            Object[] info = (Object[])methods.next();
            Method method = (Method)info[0];
            HsqlArrayList aliasList = (HsqlArrayList)info[1];
            String procedureCatalog = this.ns.getCatalogName(method);
            String procedureSchema = this.ns.getSchemaName(method);
            this.pi.setMethod(method);
            String specificName = this.pi.getSpecificName();
            String procedureName = this.pi.getFQN();
            int colCount = this.pi.getColCount();
            for (int i = 0; i < colCount; ++i) {
                ti.setTypeCode(this.pi.getColTypeCode(i));
                String columnName = this.pi.getColName(i);
                Integer columnType = this.pi.getColUsage(i);
                Integer dataType = this.pi.getColDataType(i);
                String dataTypeName = ti.getTypeName();
                Integer precision = ti.getPrecision();
                Integer length = this.pi.getColLen(i);
                Integer scale = ti.getDefaultScale();
                Integer radix = ti.getNumPrecRadix();
                Integer nullability = this.pi.getColNullability(i);
                String remark = this.pi.getColRemark(i);
                int colSequence = this.pi.getColSequence(i);
                this.addPColRows(t, aliasList, procedureCatalog, procedureSchema, procedureName, columnName, columnType, dataType, dataTypeName, precision, length, scale, radix, nullability, remark, specificName, colSequence);
            }
        }
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_PROCEDURES() throws HsqlException {
        Table t = this.sysTables[8];
        if (t == null) {
            return super.SYSTEM_PROCEDURES();
        }
        Iterator methods = this.ns.iterateAllAccessibleMethods(this.session, true);
        while (methods.hasNext()) {
            Object[] methodInfo = (Object[])methods.next();
            Method method = (Method)methodInfo[0];
            HsqlArrayList aliasList = (HsqlArrayList)methodInfo[1];
            String methodOrigin = (String)methodInfo[2];
            this.pi.setMethod(method);
            String catalog = this.ns.getCatalogName(method);
            String schema = this.ns.getSchemaName(method);
            String procName = this.pi.getFQN();
            Integer numInputParams = this.pi.getInputParmCount();
            Integer numOutputParams = this.pi.getOutputParmCount();
            Integer numResultSets = this.pi.getResultSetCount();
            String remarks = this.pi.getRemark();
            Integer procRType = this.pi.getResultType(methodOrigin);
            String procOrigin = this.pi.getOrigin(methodOrigin);
            String specificName = this.pi.getSpecificName();
            this.addProcRows(t, aliasList, catalog, schema, procName, numInputParams, numOutputParams, numResultSets, remarks, procRType, procOrigin, specificName);
        }
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_USAGE_PRIVILEGES() throws HsqlException {
        Table t = this.sysTables[33];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[33]);
            this.addColumn(t, "GRANTOR", 12, false);
            this.addColumn(t, "GRANTEE", 12, false);
            this.addColumn(t, "OBJECT_CATALOG", 12);
            this.addColumn(t, "OBJECT_SCHEMA", 12);
            this.addColumn(t, "OBJECT_NAME", 12, false);
            this.addColumn(t, "OBJECT_TYPE", 12, 32, false);
            this.addColumn(t, "IS_GRANTABLE", 12, 3, false);
            t.createPrimaryKey(null, new int[]{0, 1, 2, 3, 4, 5}, false);
            return t;
        }
        Result rs = this.session.sqlExecuteDirectNoPreChecks("SELECT '_SYSTEM', 'PUBLIC', SEQUENCE_CATALOG, SEQUENCE_SCHEMA, SEQUENCE_NAME, 'SEQUENCE', 'FALSE' FROM  INFORMATION_SCHEMA.SYSTEM_SEQUENCES");
        t.insertSys(rs);
        rs = this.session.sqlExecuteDirectNoPreChecks("SELECT '_SYSTEM', 'PUBLIC', COLLATION_CATALOG, COLLATION_SCHEMA, COLLATION_NAME, 'COLLATION', 'FALSE' FROM  INFORMATION_SCHEMA.SYSTEM_COLLATIONS");
        t.insertSys(rs);
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_CHECK_COLUMN_USAGE() throws HsqlException {
        Table t = this.sysTables[36];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[36]);
            this.addColumn(t, "CONSTRAINT_CATALOG", 12);
            this.addColumn(t, "CONSTRAINT_SCHEMA", 12);
            this.addColumn(t, "CONSTRAINT_NAME", 12, false);
            this.addColumn(t, "TABLE_CATALOG", 12);
            this.addColumn(t, "TABLE_SCHEMA", 12);
            this.addColumn(t, "TABLE_NAME", 12, false);
            this.addColumn(t, "COLUMN_NAME", 12, false);
            t.createPrimaryKey(null, new int[]{0, 1, 2, 3, 4, 5, 6}, false);
            return t;
        }
        boolean icons_cat = false;
        boolean icons_schem = true;
        int icons_name = 2;
        int itab_cat = 3;
        int itab_schem = 4;
        int itab_name = 5;
        int itab_col = 6;
        Iterator tables = this.database.schemaManager.allTablesIterator();
        Expression.Collector collector = new Expression.Collector();
        Result result = new Result(3, 4);
        result.metaData.colTypes[3] = 12;
        result.metaData.colTypes[2] = 12;
        result.metaData.colTypes[1] = 12;
        result.metaData.colTypes[0] = 12;
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (!this.isAccessibleTable(table)) continue;
            Constraint[] constraints = table.getConstraints();
            int constraintCount = constraints.length;
            String constraintCatalog = this.ns.getCatalogName(table);
            String constraintSchema = table.getSchemaName();
            for (int i = 0; i < constraintCount; ++i) {
                Constraint constraint = constraints[i];
                if (constraint.getType() != 3) continue;
                String constraintName = constraint.getName().name;
                result.setRows(null);
                collector.clear();
                collector.addAll(constraint.core.check, 2);
                Iterator iterator = collector.iterator();
                while (iterator.hasNext()) {
                    Expression expression = (Expression)iterator.next();
                    TableFilter tableFilter = expression.getFilter();
                    Table columnTable = tableFilter.getTable();
                    if (columnTable.getTableType() == 1 || !this.isAccessibleTable(columnTable)) continue;
                    result.add(new Object[]{this.ns.getCatalogName(columnTable), columnTable.getSchemaName(), columnTable.getName().name, expression.getColumnName()});
                }
                result.removeDuplicates(this.session);
                iterator = result.iterator();
                while (iterator.hasNext()) {
                    Object[] row = t.getEmptyRowData();
                    Object[] resultRow = (Object[])iterator.next();
                    row[0] = constraintCatalog;
                    row[1] = constraintSchema;
                    row[2] = constraintName;
                    row[3] = resultRow[0];
                    row[4] = resultRow[1];
                    row[5] = resultRow[2];
                    row[6] = resultRow[3];
                    t.insertSys(row);
                }
            }
        }
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_CHECK_ROUTINE_USAGE() throws HsqlException {
        Table t = this.sysTables[37];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[37]);
            this.addColumn(t, "CONSTRAINT_CATALOG", 12);
            this.addColumn(t, "CONSTRAINT_SCHEMA", 12);
            this.addColumn(t, "CONSTRAINT_NAME", 12, false);
            this.addColumn(t, "SPECIFIC_CATALOG", 12);
            this.addColumn(t, "SPECIFIC_SCHEMA", 12);
            this.addColumn(t, "SPECIFIC_NAME", 12, false);
            t.createPrimaryKey(null, new int[]{0, 1, 2, 3, 4, 5}, false);
            return t;
        }
        boolean icons_cat = false;
        boolean icons_schem = true;
        int icons_name = 2;
        int ir_cat = 3;
        int ir_schem = 4;
        int ir_name = 5;
        Iterator tables = this.database.schemaManager.allTablesIterator();
        Expression.Collector collector = new Expression.Collector();
        while (tables.hasNext()) {
            collector.clear();
            Table table = (Table)tables.next();
            if (!this.isAccessibleTable(table)) continue;
            Constraint[] constraints = table.getConstraints();
            int constraintCount = constraints.length;
            String constraintCatalog = this.ns.getCatalogName(table);
            String constraintSchema = table.getSchemaName();
            for (int i = 0; i < constraintCount; ++i) {
                Constraint constraint = constraints[i];
                if (constraint.getType() != 3) continue;
                String constraintName = constraint.getName().name;
                collector.addAll(constraint.core.check, 7);
                HashSet methodSet = new HashSet();
                Iterator iterator = collector.iterator();
                while (iterator.hasNext()) {
                    Expression expression = (Expression)iterator.next();
                    Function function = expression.function;
                    if (!this.session.isAccessible(function.getMethod().getDeclaringClass().getName())) continue;
                    methodSet.add(function.getMethod());
                }
                iterator = methodSet.iterator();
                while (iterator.hasNext()) {
                    Method method = (Method)iterator.next();
                    Object[] row = t.getEmptyRowData();
                    row[0] = constraintCatalog;
                    row[1] = constraintSchema;
                    row[2] = constraintName;
                    row[3] = this.ns.getCatalogName(method);
                    row[4] = this.ns.getSchemaName(method);
                    row[5] = DINameSpace.getMethodSpecificName(method);
                    t.insertSys(row);
                }
            }
        }
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_CHECK_TABLE_USAGE() throws HsqlException {
        Table t = this.sysTables[38];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[38]);
            this.addColumn(t, "CONSTRAINT_CATALOG", 12);
            this.addColumn(t, "CONSTRAINT_SCHEMA", 12);
            this.addColumn(t, "CONSTRAINT_NAME", 12, false);
            this.addColumn(t, "TABLE_CATALOG", 12);
            this.addColumn(t, "TABLE_SCHEMA", 12);
            this.addColumn(t, "TABLE_NAME", 12, false);
            t.createPrimaryKey(null, new int[]{0, 1, 2, 3, 4, 5}, false);
            return t;
        }
        Result rs = this.session.sqlExecuteDirectNoPreChecks("select DISTINCT CONSTRAINT_CATALOG, CONSTRAINT_SCHEMA, CONSTRAINT_NAME, TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME from INFORMATION_SCHEMA.SYSTEM_CHECK_COLUMN_USAGE");
        t.insertSys(rs);
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_TABLE_CONSTRAINTS() throws HsqlException {
        Constraint constraint;
        Table t = this.sysTables[35];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[35]);
            this.addColumn(t, "CONSTRAINT_CATALOG", 12);
            this.addColumn(t, "CONSTRAINT_SCHEMA", 12);
            this.addColumn(t, "CONSTRAINT_NAME", 12, false);
            this.addColumn(t, "CONSTRAINT_TYPE", 12, 11, false);
            this.addColumn(t, "TABLE_CATALOG", 12);
            this.addColumn(t, "TABLE_SCHEMA", 12);
            this.addColumn(t, "TABLE_NAME", 12, false);
            this.addColumn(t, "IS_DEFERRABLE", 12, 3, false);
            this.addColumn(t, "INITIALLY_DEFERRED", 12, 3, false);
            t.createPrimaryKey(null, new int[]{0, 1, 2, 4, 5, 6}, false);
            return t;
        }
        boolean icons_cat = false;
        boolean icons_schem = true;
        int icons_name = 2;
        int icons_type = 3;
        int itab_cat = 4;
        int itab_schem = 5;
        int itab_name = 6;
        int iis_defr = 7;
        int iinit_defr = 8;
        Iterator tables = this.database.schemaManager.allTablesIterator();
        HashSet constraintSet = new HashSet();
        Table table = null;
        while (tables.hasNext()) {
            table = (Table)tables.next();
            if (table.isView() || !this.isAccessibleTable(table)) continue;
            Constraint[] constraints = table.getConstraints();
            int constraintCount = constraints.length;
            for (int i = 0; i < constraintCount; ++i) {
                constraint = constraints[i];
                if (constraint.getType() == 0 && !this.isAccessibleTable(constraint.getRef())) continue;
                constraintSet.add(constraint);
            }
        }
        Iterator it = constraintSet.iterator();
        block8: while (it.hasNext()) {
            Object[] row = t.getEmptyRowData();
            constraint = (Constraint)it.next();
            switch (constraint.getType()) {
                case 3: {
                    row[3] = "CHECK";
                    table = constraint.getMain();
                    break;
                }
                case 2: {
                    row[3] = "UNIQUE";
                    table = constraint.getMain();
                    break;
                }
                case 0: {
                    row[3] = "FOREIGN KEY";
                    table = constraint.getRef();
                    break;
                }
                case 4: {
                    row[3] = "PRIMARY KEY";
                    table = constraint.getMain();
                    break;
                }
                default: {
                    continue block8;
                }
            }
            String cat = this.ns.getCatalogName(table);
            String schem = table.getSchemaName();
            row[0] = cat;
            row[1] = schem;
            row[2] = constraint.constName.name;
            row[4] = cat;
            row[5] = schem;
            row[6] = table.getName().name;
            row[7] = "NO";
            row[8] = "NO";
            t.insertSys(row);
        }
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_VIEW_TABLE_USAGE() throws HsqlException {
        Table t = this.sysTables[40];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[40]);
            this.addColumn(t, "VIEW_CATALOG", 12);
            this.addColumn(t, "VIEW_SCHEMA", 12);
            this.addColumn(t, "VIEW_NAME", 12, true);
            this.addColumn(t, "TABLE_CATALOG", 12);
            this.addColumn(t, "TABLE_SCHEMA", 12);
            this.addColumn(t, "TABLE_NAME", 12, true);
            t.createPrimaryKey(null, new int[]{0, 1, 2, 3, 4, 5}, false);
            return t;
        }
        Result rs = this.session.sqlExecuteDirectNoPreChecks("select DISTINCT VIEW_CATALOG, VIEW_SCHEMA, VIEW_NAME, TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME from INFORMATION_SCHEMA.SYSTEM_VIEW_COLUMN_USAGE");
        t.insertSys(rs);
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_VIEW_COLUMN_USAGE() throws HsqlException {
        Table t = this.sysTables[39];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[39]);
            this.addColumn(t, "VIEW_CATALOG", 12);
            this.addColumn(t, "VIEW_SCHEMA", 12);
            this.addColumn(t, "VIEW_NAME", 12, true);
            this.addColumn(t, "TABLE_CATALOG", 12);
            this.addColumn(t, "TABLE_SCHEMA", 12);
            this.addColumn(t, "TABLE_NAME", 12, true);
            this.addColumn(t, "COLUMN_NAME", 12, true);
            t.createPrimaryKey(null, new int[]{0, 1, 2, 3, 4, 5, 6}, false);
            return t;
        }
        boolean iv_cat = false;
        boolean iv_schem = true;
        int iv_name = 2;
        int it_cat = 3;
        int it_schem = 4;
        int it_name = 5;
        int it_cname = 6;
        Iterator tables = this.database.schemaManager.allTablesIterator();
        Expression.Collector collector = new Expression.Collector();
        Result result = new Result(3, 4);
        result.metaData.colTypes[3] = 12;
        result.metaData.colTypes[2] = 12;
        result.metaData.colTypes[1] = 12;
        result.metaData.colTypes[0] = 12;
        while (tables.hasNext()) {
            collector.clear();
            result.setRows(null);
            Table table = (Table)tables.next();
            if (!table.isView() || !this.isAccessibleTable(table)) continue;
            String viewCatalog = this.ns.getCatalogName(table);
            String viewSchema = table.getSchemaName();
            String viewName = table.getName().name;
            View view = (View)table;
            SubQuery[] subqueries = view.viewSubqueries;
            collector.addAll(view.viewSelect, 2);
            for (int i = 0; i < subqueries.length; ++i) {
                collector.addAll(subqueries[i].select, 2);
            }
            Iterator iterator = collector.iterator();
            while (iterator.hasNext()) {
                Expression expression = (Expression)iterator.next();
                TableFilter tableFilter = expression.getFilter();
                Table columnTable = tableFilter.getTable();
                if (columnTable.getTableType() == 1 || !this.isAccessibleTable(columnTable)) continue;
                result.add(new Object[]{this.ns.getCatalogName(columnTable), columnTable.getSchemaName(), columnTable.getName().name, expression.getColumnName()});
            }
            result.removeDuplicates(this.session);
            iterator = result.iterator();
            while (iterator.hasNext()) {
                Object[] row = t.getEmptyRowData();
                Object[] resultRow = (Object[])iterator.next();
                row[0] = viewCatalog;
                row[1] = viewSchema;
                row[2] = viewName;
                row[3] = resultRow[0];
                row[4] = resultRow[1];
                row[5] = resultRow[2];
                row[6] = resultRow[3];
                t.insertSys(row);
            }
        }
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_VIEW_ROUTINE_USAGE() throws HsqlException {
        Table t = this.sysTables[41];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[41]);
            this.addColumn(t, "TABLE_CATALOG", 12);
            this.addColumn(t, "TABLE_SCHEMA", 12);
            this.addColumn(t, "TABLE_NAME", 12, true);
            this.addColumn(t, "SPECIFIC_CATALOG", 12);
            this.addColumn(t, "SPECIFIC_SCHEMA", 12);
            this.addColumn(t, "SPECIFIC_NAME", 12, true);
            t.createPrimaryKey(null, new int[]{0, 1, 2, 3, 4, 5}, false);
            return t;
        }
        boolean iv_cat = false;
        boolean iv_schem = true;
        int iv_name = 2;
        int ir_cat = 3;
        int ir_schem = 4;
        int ir_name = 5;
        int ir_sig = 6;
        Iterator tables = this.database.schemaManager.allTablesIterator();
        Expression.Collector collector = new Expression.Collector();
        while (tables.hasNext()) {
            collector.clear();
            Table table = (Table)tables.next();
            if (!table.isView() || !this.isAccessibleTable(table)) continue;
            String viewCat = this.ns.getCatalogName(table);
            String viewSchem = table.getSchemaName();
            String viewName = table.getName().name;
            View view = (View)table;
            SubQuery[] subqueries = view.viewSubqueries;
            collector.addAll(view.viewSelect, 7);
            for (int i = 0; i < subqueries.length; ++i) {
                collector.addAll(subqueries[i].select, 7);
            }
            HashSet methodSet = new HashSet();
            Iterator iterator = collector.iterator();
            while (iterator.hasNext()) {
                Expression expression = (Expression)iterator.next();
                Function function = expression.function;
                if (!this.session.isAccessible(function.getMethod().getDeclaringClass().getName())) continue;
                methodSet.add(function.getMethod());
            }
            iterator = methodSet.iterator();
            while (iterator.hasNext()) {
                Method method = (Method)iterator.next();
                Object[] row = t.getEmptyRowData();
                row[0] = viewCat;
                row[1] = viewSchem;
                row[2] = viewName;
                row[3] = this.ns.getCatalogName(method);
                row[4] = this.ns.getSchemaName(method);
                row[5] = DINameSpace.getMethodSpecificName(method);
                t.insertSys(row);
            }
        }
        t.setDataReadOnly(true);
        return t;
    }

    protected void addPColRows(Table t, HsqlArrayList l, String cat, String schem, String pName, String cName, Integer cType, Integer dType, String tName, Integer prec, Integer len, Integer scale, Integer radix, Integer nullability, String remark, String specificName, int seq) throws HsqlException {
        boolean icat = false;
        boolean ischem = true;
        int iname = 2;
        int icol_name = 3;
        int icol_type = 4;
        int idata_type = 5;
        int itype_name = 6;
        int iprec = 7;
        int ilength = 8;
        int iscale = 9;
        int iradix = 10;
        int inullable = 11;
        int iremark = 12;
        int isn = 13;
        int iseq = 14;
        Object[] row = t.getEmptyRowData();
        Integer sequence = ValuePool.getInt(seq);
        row[0] = cat;
        row[1] = schem;
        row[2] = pName;
        row[3] = cName;
        row[4] = cType;
        row[5] = dType;
        row[6] = tName;
        row[7] = prec;
        row[8] = len;
        row[9] = scale;
        row[10] = radix;
        row[11] = nullability;
        row[12] = remark;
        row[13] = specificName;
        row[14] = sequence;
        t.insertSys(row);
        if (l != null) {
            int size = l.size();
            for (int i = 0; i < size; ++i) {
                row = t.getEmptyRowData();
                pName = (String)l.get(i);
                row[0] = cat;
                row[1] = schem;
                row[2] = pName;
                row[3] = cName;
                row[4] = cType;
                row[5] = dType;
                row[6] = tName;
                row[7] = prec;
                row[8] = len;
                row[9] = scale;
                row[10] = radix;
                row[11] = nullability;
                row[12] = remark;
                row[13] = specificName;
                row[14] = sequence;
                t.insertSys(row);
            }
        }
    }

    protected void addProcRows(Table t, HsqlArrayList l, String cat, String schem, String pName, Integer ip, Integer op, Integer rs, String remark, Integer pType, String origin, String specificName) throws HsqlException {
        boolean icat = false;
        boolean ischem = true;
        int ipname = 2;
        int iinput_parms = 3;
        int ioutput_parms = 4;
        int iresult_sets = 5;
        int iremark = 6;
        int iptype = 7;
        int iporigin = 8;
        int isn = 9;
        Object[] row = t.getEmptyRowData();
        row[0] = cat;
        row[1] = schem;
        row[2] = pName;
        row[3] = ip;
        row[4] = op;
        row[5] = rs;
        row[6] = remark;
        row[7] = pType;
        row[8] = origin;
        row[9] = specificName;
        t.insertSys(row);
        if (l != null) {
            int size = l.size();
            for (int i = 0; i < size; ++i) {
                row = t.getEmptyRowData();
                pName = (String)l.get(i);
                row[0] = cat;
                row[1] = schem;
                row[2] = pName;
                row[3] = ip;
                row[4] = op;
                row[5] = rs;
                row[6] = remark;
                row[7] = pType;
                row[8] = "ALIAS";
                row[9] = specificName;
                t.insertSys(row);
            }
        }
    }

    Table SYSTEM_AUTHORIZATIONS() throws HsqlException {
        Object[] row;
        Table t = this.sysTables[42];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[42]);
            this.addColumn(t, "AUTHORIZATION_NAME", 12, true);
            this.addColumn(t, "AUTHORIZATION_TYPE", 12, true);
            t.createPrimaryKey(null, new int[]{0}, true);
            return t;
        }
        HsqlArrayList users = this.database.getUserManager().listVisibleUsers(this.session, false);
        int userCount = users.size();
        for (int i = 0; i < users.size(); ++i) {
            row = t.getEmptyRowData();
            User user = (User)users.get(i);
            row[0] = user.getName();
            row[1] = "USER";
            t.insertSys(row);
        }
        Iterator roles = this.database.getGranteeManager().getRoleNames().iterator();
        while (roles.hasNext()) {
            row = t.getEmptyRowData();
            row[0] = roles.next().toString();
            row[1] = "ROLE";
            t.insertSys(row);
        }
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_COLLATIONS() throws HsqlException {
        Table t = this.sysTables[43];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[43]);
            this.addColumn(t, "COLLATION_CATALOG", 12);
            this.addColumn(t, "COLLATION_SCHEMA", 12, true);
            this.addColumn(t, "COLLATION_NAME", 12, true);
            this.addColumn(t, "PAD_ATTRIBUTE", 12, 9, true);
            this.addColumn(t, "COLLATION_TYPE", 12, true);
            this.addColumn(t, "COLLATION_DEFINITION", 12);
            this.addColumn(t, "COLLATION_DICTIONARY", 12);
            this.addColumn(t, "CHARACTER_REPERTOIRE_NAME", 12, true);
            t.createPrimaryKey(null, new int[]{0, 1, 2}, false);
            return t;
        }
        String collationSchema = "PUBLIC";
        String padAttribute = "NO PAD";
        String characterRepertoireName = "UNICODE";
        boolean icolcat = false;
        boolean icolschem = true;
        int icolname = 2;
        int ipadattr = 3;
        int icoltype = 4;
        int icoldef = 5;
        int icoldict = 6;
        int icharrep = 7;
        Iterator collations = Collation.nameToJavaName.keySet().iterator();
        while (collations.hasNext()) {
            Object[] row = t.getEmptyRowData();
            String collation = (String)collations.next();
            row[0] = this.ns.getCatalogName(collation);
            row[1] = collationSchema;
            row[2] = collation;
            row[3] = padAttribute;
            row[7] = characterRepertoireName;
            t.insertSys(row);
        }
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_ROLE_AUTHORIZATION_DESCRIPTORS() throws HsqlException {
        Table t = this.sysTables[44];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[44]);
            this.addColumn(t, "ROLE_NAME", 12, true);
            this.addColumn(t, "GRANTEE", 12, true);
            this.addColumn(t, "GRANTOR", 12, true);
            this.addColumn(t, "IS_GRANTABLE", 12, true);
            t.createPrimaryKey(null, new int[]{0, 1}, true);
            return t;
        }
        String grantorName = "_SYSTEM";
        boolean irole = false;
        boolean igrantee = true;
        int igrantor = 2;
        int igrantable = 3;
        Iterator grantees = this.database.getGranteeManager().getGrantees().iterator();
        while (grantees.hasNext()) {
            Grantee grantee = (Grantee)grantees.next();
            String granteeName = grantee.getName();
            Iterator roles = grantee.getDirectRoles().iterator();
            while (roles.hasNext()) {
                Object[] row = t.getEmptyRowData();
                String roleName = (String)roles.next();
                String isGrantable = grantee.hasRole("DBA") ? "YES" : "NO";
                row[0] = roleName;
                row[1] = granteeName;
                row[2] = grantorName;
                row[3] = isGrantable;
                t.insertSys(row);
            }
        }
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_SCHEMATA() throws HsqlException {
        Table t = this.sysTables[45];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[45]);
            this.addColumn(t, "CATALOG_NAME", 12);
            this.addColumn(t, "SCHEMA_NAME", 12, true);
            this.addColumn(t, "SCHEMA_OWNER", 12, true);
            this.addColumn(t, "DEFAULT_CHARACTER_SET_CATALOG", 12);
            this.addColumn(t, "DEFAULT_CHARACTER_SET_SCHEMA", 12, true);
            this.addColumn(t, "DEFAULT_CHARACTER_SET_NAME", 12);
            this.addColumn(t, "SQL_PATH", 12);
            t.createPrimaryKey(null, new int[]{0, 1}, false);
            return t;
        }
        String schemaOwner = "DBA";
        String dcsSchema = "INFORMATION_SCHEMA";
        String dcsName = ValuePool.getString("UTF16");
        Object sqlPath = null;
        boolean ischema_catalog = false;
        boolean ischema_name = true;
        int ischema_owner = 2;
        int idef_charset_cat = 3;
        int idef_charset_schem = 4;
        int idef_charset_name = 5;
        int isql_path = 6;
        Iterator schemas = this.database.schemaManager.fullSchemaNamesIterator();
        while (schemas.hasNext()) {
            Object[] row = t.getEmptyRowData();
            String schema = (String)schemas.next();
            row[0] = this.ns.getCatalogName(schema);
            row[1] = schema;
            row[2] = schemaOwner;
            row[3] = this.ns.getCatalogName(dcsSchema);
            row[4] = dcsSchema;
            row[5] = dcsName;
            row[6] = sqlPath;
            t.insertSys(row);
        }
        t.setDataReadOnly(true);
        return t;
    }
}

