/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.eval;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.BlankEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.BoolEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.OperandResolver;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.RefEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.StringEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;

public final class ValueEvalToNumericXlator {
    public static final int STRING_IS_PARSED = 1;
    public static final int BOOL_IS_PARSED = 2;
    public static final int BLANK_IS_PARSED = 4;
    public static final int REF_STRING_IS_PARSED = 8;
    public static final int REF_BOOL_IS_PARSED = 16;
    public static final int REF_BLANK_IS_PARSED = 32;
    public static final int STRING_IS_INVALID_VALUE = 2048;
    private final int flags;

    public ValueEvalToNumericXlator(int flags) {
        this.flags = flags;
    }

    public ValueEval attemptXlateToNumeric(ValueEval eval) {
        ValueEval retval = null;
        if (eval == null) {
            retval = BlankEval.INSTANCE;
        } else if (eval instanceof NumberEval) {
            retval = eval;
        } else if (eval instanceof BoolEval) {
            retval = (this.flags & 2) > 0 ? (NumericValueEval)eval : this.xlateBlankEval(4);
        } else if (eval instanceof StringEval) {
            retval = this.xlateStringEval((StringEval)eval);
        } else if (eval instanceof RefEval) {
            retval = this.xlateRefEval((RefEval)eval);
        } else if (eval instanceof ErrorEval) {
            retval = eval;
        } else if (eval instanceof BlankEval) {
            retval = this.xlateBlankEval(4);
        } else {
            throw new RuntimeException("Invalid ValueEval type passed for conversion: " + eval.getClass());
        }
        return retval;
    }

    private ValueEval xlateBlankEval(int flag) {
        return (this.flags & flag) > 0 ? NumberEval.ZERO : BlankEval.INSTANCE;
    }

    private ValueEval xlateRefEval(RefEval reval) {
        ValueEval eval = reval.getInnerValueEval();
        if (eval instanceof NumberEval) {
            return eval;
        }
        if (eval instanceof BoolEval) {
            return (this.flags & 0x10) > 0 ? eval : BlankEval.INSTANCE;
        }
        if (eval instanceof StringEval) {
            return this.xlateRefStringEval((StringEval)eval);
        }
        if (eval instanceof ErrorEval) {
            return eval;
        }
        if (eval instanceof BlankEval) {
            return this.xlateBlankEval(32);
        }
        throw new RuntimeException("Invalid ValueEval type passed for conversion: (" + eval.getClass().getName() + ")");
    }

    private ValueEval xlateStringEval(StringEval eval) {
        if ((this.flags & 1) > 0) {
            String s = eval.getStringValue();
            Double d = OperandResolver.parseDouble(s);
            if (d == null) {
                return ErrorEval.VALUE_INVALID;
            }
            return new NumberEval(d);
        }
        if ((this.flags & 0x800) > 0) {
            return ErrorEval.VALUE_INVALID;
        }
        return this.xlateBlankEval(4);
    }

    private ValueEval xlateRefStringEval(StringEval sve) {
        if ((this.flags & 8) > 0) {
            String s = sve.getStringValue();
            Double d = OperandResolver.parseDouble(s);
            if (d == null) {
                return ErrorEval.VALUE_INVALID;
            }
            return new NumberEval(d);
        }
        return BlankEval.INSTANCE;
    }
}

