/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.pdfa.checker;

import com.fr.third.fr.pdf.kernel.pdf.PdfAConformanceLevel;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfStream;
import com.fr.third.fr.pdf.pdfa.PdfAConformanceException;
import com.fr.third.fr.pdf.pdfa.checker.PdfA2Checker;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class PdfA3Checker
extends PdfA2Checker {
    protected static final Set<PdfName> allowedAFRelationships = new HashSet<PdfName>(Arrays.asList(PdfName.Source, PdfName.Data, PdfName.Alternative, PdfName.Supplement, PdfName.Unspecified));

    public PdfA3Checker(PdfAConformanceLevel conformanceLevel) {
        super(conformanceLevel);
    }

    protected void checkFileSpec(PdfDictionary fileSpec) {
        PdfName relationship = fileSpec.getAsName(PdfName.AFRelationship);
        if (relationship == null || !allowedAFRelationships.contains(relationship)) {
            throw new PdfAConformanceException("file.specification.dictionary.shall.contain.one.of.the.predefined.afrelationship.keys");
        }
        if (fileSpec.containsKey(PdfName.EF)) {
            if (!(fileSpec.containsKey(PdfName.F) && fileSpec.containsKey(PdfName.UF) && fileSpec.containsKey(PdfName.Desc))) {
                throw new PdfAConformanceException("file.specification.dictionary.shall.contain.f.key.uf.key.and.desc.key");
            }
            PdfDictionary ef = fileSpec.getAsDictionary(PdfName.EF);
            PdfStream embeddedFile = ef.getAsStream(PdfName.F);
            if (embeddedFile == null) {
                throw new PdfAConformanceException("ef.key.of.file.specification.dictionary.shall.contain.dictionary.with.valid.f.key");
            }
            if (!embeddedFile.containsKey(PdfName.Subtype)) {
                throw new PdfAConformanceException("mime.type.shall.be.specified.using.the.subtype.key.of.the.file.specification.stream.dictionary");
            }
            PdfDictionary params = embeddedFile.getAsDictionary(PdfName.Params);
            if (params == null) {
                throw new PdfAConformanceException("embedded.file.shall.contain.params.key.with.dictionary.as.value");
            }
            if (params.getAsString(PdfName.ModDate) == null) {
                throw new PdfAConformanceException("embedded.file.shall.contain.params.key.with.valid.moddate.key");
            }
        }
    }
}

