/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf;

import com.fr.third.fr.pdf.kernel.pdf.PdfArray;
import com.fr.third.fr.pdf.kernel.pdf.PdfBoolean;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfNumber;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfObjectWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfViewerPreferences
extends PdfObjectWrapper<PdfDictionary> {
    private static final long serialVersionUID = -6885879361985241602L;

    public PdfViewerPreferences() {
        this(new PdfDictionary());
    }

    public PdfViewerPreferences(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    public PdfViewerPreferences setHideToolbar(boolean hideToolbar) {
        return this.put(PdfName.HideToolbar, new PdfBoolean(hideToolbar));
    }

    public PdfViewerPreferences setHideMenubar(boolean hideMenubar) {
        return this.put(PdfName.HideMenubar, new PdfBoolean(hideMenubar));
    }

    public PdfViewerPreferences setHideWindowUI(boolean hideWindowUI) {
        return this.put(PdfName.HideWindowUI, new PdfBoolean(hideWindowUI));
    }

    public PdfViewerPreferences setFitWindow(boolean fitWindow) {
        return this.put(PdfName.FitWindow, new PdfBoolean(fitWindow));
    }

    public PdfViewerPreferences setCenterWindow(boolean centerWindow) {
        return this.put(PdfName.CenterWindow, new PdfBoolean(centerWindow));
    }

    public PdfViewerPreferences setDisplayDocTitle(boolean displayDocTitle) {
        return this.put(PdfName.DisplayDocTitle, new PdfBoolean(displayDocTitle));
    }

    public PdfViewerPreferences setNonFullScreenPageMode(PdfViewerPreferencesConstants nonFullScreenPageMode) {
        switch (nonFullScreenPageMode) {
            case USE_NONE: {
                this.put(PdfName.NonFullScreenPageMode, PdfName.UseNone);
                break;
            }
            case USE_OUTLINES: {
                this.put(PdfName.NonFullScreenPageMode, PdfName.UseOutlines);
                break;
            }
            case USE_THUMBS: {
                this.put(PdfName.NonFullScreenPageMode, PdfName.UseThumbs);
                break;
            }
            case USE_OC: {
                this.put(PdfName.NonFullScreenPageMode, PdfName.UseOC);
                break;
            }
        }
        return this;
    }

    public PdfViewerPreferences setDirection(PdfViewerPreferencesConstants direction) {
        switch (direction) {
            case LEFT_TO_RIGHT: {
                this.put(PdfName.Direction, PdfName.L2R);
                break;
            }
            case RIGHT_TO_LEFT: {
                this.put(PdfName.Direction, PdfName.R2L);
                break;
            }
        }
        return this;
    }

    public PdfViewerPreferences setViewArea(PdfViewerPreferencesConstants pageBoundary) {
        return this.setPageBoundary(PdfViewerPreferencesConstants.VIEW_AREA, pageBoundary);
    }

    public PdfViewerPreferences setViewClip(PdfViewerPreferencesConstants pageBoundary) {
        return this.setPageBoundary(PdfViewerPreferencesConstants.VIEW_CLIP, pageBoundary);
    }

    public PdfViewerPreferences setPrintArea(PdfViewerPreferencesConstants pageBoundary) {
        return this.setPageBoundary(PdfViewerPreferencesConstants.PRINT_AREA, pageBoundary);
    }

    public PdfViewerPreferences setPrintClip(PdfViewerPreferencesConstants pageBoundary) {
        return this.setPageBoundary(PdfViewerPreferencesConstants.PRINT_CLIP, pageBoundary);
    }

    public PdfViewerPreferences setPrintScaling(PdfViewerPreferencesConstants printScaling) {
        switch (printScaling) {
            case NONE: {
                this.put(PdfName.PrintScaling, PdfName.None);
                break;
            }
            case APP_DEFAULT: {
                this.put(PdfName.PrintScaling, PdfName.AppDefault);
                break;
            }
        }
        return this;
    }

    public PdfViewerPreferences setDuplex(PdfViewerPreferencesConstants duplex) {
        switch (duplex) {
            case SIMPLEX: {
                this.put(PdfName.Duplex, PdfName.Simplex);
                break;
            }
            case DUPLEX_FLIP_SHORT_EDGE: {
                this.put(PdfName.Duplex, PdfName.DuplexFlipShortEdge);
                break;
            }
            case DUPLEX_FLIP_LONG_EDGE: {
                this.put(PdfName.Duplex, PdfName.DuplexFlipLongEdge);
                break;
            }
        }
        return this;
    }

    public PdfViewerPreferences setPickTrayByPDFSize(boolean pickTrayByPdfSize) {
        return this.put(PdfName.PickTrayByPDFSize, new PdfBoolean(pickTrayByPdfSize));
    }

    public PdfViewerPreferences setPrintPageRange(int[] printPageRange) {
        return this.put(PdfName.PrintPageRange, new PdfArray(printPageRange));
    }

    public PdfViewerPreferences setNumCopies(int numCopies) {
        return this.put(PdfName.NumCopies, new PdfNumber(numCopies));
    }

    public PdfViewerPreferences put(PdfName key, PdfObject value) {
        ((PdfDictionary)this.getPdfObject()).put(key, value);
        return this;
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return false;
    }

    private PdfViewerPreferences setPageBoundary(PdfViewerPreferencesConstants viewerPreferenceType, PdfViewerPreferencesConstants pageBoundary) {
        PdfName type = null;
        switch (viewerPreferenceType) {
            case VIEW_AREA: {
                type = PdfName.ViewArea;
                break;
            }
            case VIEW_CLIP: {
                type = PdfName.ViewArea;
                break;
            }
            case PRINT_AREA: {
                type = PdfName.ViewArea;
                break;
            }
            case PRINT_CLIP: {
                type = PdfName.ViewArea;
                break;
            }
        }
        if (type != null) {
            switch (pageBoundary) {
                case MEDIA_BOX: {
                    this.put(type, PdfName.MediaBox);
                    break;
                }
                case CROP_BOX: {
                    this.put(type, PdfName.CropBox);
                    break;
                }
                case BLEED_BOX: {
                    this.put(type, PdfName.BleedBox);
                    break;
                }
                case TRIM_BOX: {
                    this.put(type, PdfName.TrimBox);
                    break;
                }
                case ART_BOX: {
                    this.put(type, PdfName.ArtBox);
                    break;
                }
            }
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PdfViewerPreferencesConstants {
        USE_NONE,
        USE_OUTLINES,
        USE_THUMBS,
        USE_OC,
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT,
        MEDIA_BOX,
        CROP_BOX,
        BLEED_BOX,
        TRIM_BOX,
        ART_BOX,
        VIEW_AREA,
        VIEW_CLIP,
        PRINT_AREA,
        PRINT_CLIP,
        NONE,
        APP_DEFAULT,
        SIMPLEX,
        DUPLEX_FLIP_SHORT_EDGE,
        DUPLEX_FLIP_LONG_EDGE;

    }
}

