/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf;

import com.fr.third.fr.pdf.kernel.PdfException;
import com.fr.third.fr.pdf.kernel.events.PdfDocumentEvent;
import com.fr.third.fr.pdf.kernel.geom.PageSize;
import com.fr.third.fr.pdf.kernel.geom.Rectangle;
import com.fr.third.fr.pdf.kernel.pdf.IPdfPageExtraCopier;
import com.fr.third.fr.pdf.kernel.pdf.IsoKey;
import com.fr.third.fr.pdf.kernel.pdf.PageLabelNumberingStyleConstants;
import com.fr.third.fr.pdf.kernel.pdf.PdfArray;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfNumber;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfObjectWrapper;
import com.fr.third.fr.pdf.kernel.pdf.PdfOutline;
import com.fr.third.fr.pdf.kernel.pdf.PdfPages;
import com.fr.third.fr.pdf.kernel.pdf.PdfResources;
import com.fr.third.fr.pdf.kernel.pdf.PdfStream;
import com.fr.third.fr.pdf.kernel.pdf.PdfString;
import com.fr.third.fr.pdf.kernel.pdf.action.PdfAction;
import com.fr.third.fr.pdf.kernel.pdf.annot.PdfAnnotation;
import com.fr.third.fr.pdf.kernel.pdf.annot.PdfLinkAnnotation;
import com.fr.third.fr.pdf.kernel.pdf.tagging.PdfStructTreeRoot;
import com.fr.third.fr.pdf.kernel.pdf.tagutils.TagTreePointer;
import com.fr.third.fr.pdf.kernel.pdf.xobject.PdfFormXObject;
import com.fr.third.fr.pdf.kernel.xmp.XMPException;
import com.fr.third.fr.pdf.kernel.xmp.XMPMeta;
import com.fr.third.fr.pdf.kernel.xmp.XMPMetaFactory;
import com.fr.third.fr.pdf.kernel.xmp.options.SerializeOptions;
import com.fr.third.fr.pdf.slf4j.Logger;
import com.fr.third.fr.pdf.slf4j.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfPage
extends PdfObjectWrapper<PdfDictionary> {
    private static final long serialVersionUID = -952395541908379500L;
    private PdfResources resources = null;
    private int mcid = -1;
    private int structParents = -1;
    PdfPages parentPages;
    private List<PdfName> excludedKeys = new ArrayList<PdfName>(Arrays.asList(PdfName.Parent, PdfName.Annots, PdfName.StructParents, PdfName.B));
    private boolean ignorePageRotationForContent = false;
    private boolean pageRotationInverseMatrixWritten = false;

    protected PdfPage(PdfDictionary pdfObject) {
        super(pdfObject);
        this.setForbidRelease();
        PdfPage.ensureObjectIsAddedToDocument(pdfObject);
    }

    protected PdfPage(PdfDocument pdfDocument, PageSize pageSize) {
        this(new PdfDictionary().makeIndirect(pdfDocument));
        PdfStream contentStream = new PdfStream().makeIndirect(pdfDocument);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Contents, contentStream);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Type, PdfName.Page);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.MediaBox, new PdfArray(pageSize));
        ((PdfDictionary)this.getPdfObject()).put(PdfName.TrimBox, new PdfArray(pageSize));
        if (pdfDocument.isTagged()) {
            this.structParents = pdfDocument.getNextStructParentIndex();
            ((PdfDictionary)this.getPdfObject()).put(PdfName.StructParents, new PdfNumber(this.structParents));
        }
    }

    protected PdfPage(PdfDocument pdfDocument) {
        this(pdfDocument, pdfDocument.getDefaultPageSize());
    }

    public Rectangle getPageSize() {
        PdfArray box = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.MediaBox);
        if (box == null || box.size() != 4) {
            throw new IllegalArgumentException("MediaBox");
        }
        PdfNumber llx = box.getAsNumber(0);
        PdfNumber lly = box.getAsNumber(1);
        PdfNumber urx = box.getAsNumber(2);
        PdfNumber ury = box.getAsNumber(3);
        if (llx == null || lly == null || urx == null || ury == null) {
            throw new IllegalArgumentException("MediaBox");
        }
        return new Rectangle(Math.min(llx.floatValue(), urx.floatValue()), Math.min(lly.floatValue(), ury.floatValue()), Math.abs(urx.floatValue() - llx.floatValue()), Math.abs(ury.floatValue() - lly.floatValue()));
    }

    public Rectangle getPageSizeWithRotation() {
        PageSize rect = new PageSize(this.getPageSize());
        for (int rotation = this.getRotation(); rotation > 0; rotation -= 90) {
            rect = rect.rotate();
        }
        return rect;
    }

    public int getRotation() {
        PdfNumber rotate = ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.Rotate);
        if (rotate == null) {
            return 0;
        }
        int n = rotate.intValue();
        return (n %= 360) < 0 ? n + 360 : n;
    }

    public PdfPage setRotation(int degAngle) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Rotate, new PdfNumber(degAngle));
        return this;
    }

    public PdfStream getContentStream(int index) {
        int count = this.getContentStreamCount();
        if (index >= count) {
            throw new IndexOutOfBoundsException(MessageFormat.format("Index: {0}, Size: {1}", index, count));
        }
        PdfObject contents = ((PdfDictionary)this.getPdfObject()).get(PdfName.Contents);
        if (contents instanceof PdfStream) {
            return (PdfStream)contents;
        }
        if (contents instanceof PdfArray) {
            PdfArray a = (PdfArray)contents;
            return (PdfStream)a.get(index);
        }
        return null;
    }

    public int getContentStreamCount() {
        PdfObject contents = ((PdfDictionary)this.getPdfObject()).get(PdfName.Contents);
        if (contents instanceof PdfStream) {
            return 1;
        }
        if (contents instanceof PdfArray) {
            return ((PdfArray)contents).size();
        }
        return 0;
    }

    public PdfStream getFirstContentStream() {
        if (this.getContentStreamCount() > 0) {
            return this.getContentStream(0);
        }
        return null;
    }

    public PdfStream getLastContentStream() {
        int count = this.getContentStreamCount();
        if (count > 0) {
            return this.getContentStream(count - 1);
        }
        return null;
    }

    public PdfStream newContentStreamBefore() {
        return this.newContentStream(true);
    }

    public PdfStream newContentStreamAfter() {
        return this.newContentStream(false);
    }

    public PdfResources getResources() {
        if (this.resources == null) {
            boolean readOnly = false;
            PdfDictionary resources = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Resources);
            if (resources == null) {
                this.initParentPages();
                resources = (PdfDictionary)this.getParentValue(this.parentPages, PdfName.Resources);
                if (resources != null) {
                    readOnly = true;
                }
            }
            if (resources == null) {
                resources = new PdfDictionary();
                ((PdfDictionary)this.getPdfObject()).put(PdfName.Resources, resources);
            }
            this.resources = new PdfResources(resources);
            this.resources.setReadOnly(readOnly);
        }
        return this.resources;
    }

    public PdfPage setResources(PdfResources pdfResources) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Resources, (PdfObject)pdfResources.getPdfObject());
        this.resources = pdfResources;
        return this;
    }

    public void setXmpMetadata(byte[] xmpMetadata) throws IOException {
        PdfStream xmp = new PdfStream().makeIndirect(this.getDocument());
        xmp.getOutputStream().write(xmpMetadata);
        xmp.put(PdfName.Type, PdfName.Metadata);
        xmp.put(PdfName.Subtype, PdfName.XML);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Metadata, xmp);
    }

    public void setXmpMetadata(XMPMeta xmpMeta, SerializeOptions serializeOptions) throws XMPException, IOException {
        this.setXmpMetadata(XMPMetaFactory.serializeToBuffer(xmpMeta, serializeOptions));
    }

    public void setXmpMetadata(XMPMeta xmpMeta) throws XMPException, IOException {
        SerializeOptions serializeOptions = new SerializeOptions();
        serializeOptions.setPadding(2000);
        this.setXmpMetadata(xmpMeta, serializeOptions);
    }

    public PdfStream getXmpMetadata() throws XMPException {
        return ((PdfDictionary)this.getPdfObject()).getAsStream(PdfName.Metadata);
    }

    public PdfPage copyTo(PdfDocument toDocument) {
        return this.copyTo(toDocument, null);
    }

    public PdfPage copyTo(PdfDocument toDocument, IPdfPageExtraCopier copier) {
        PdfDictionary dictionary = ((PdfDictionary)this.getPdfObject()).copyTo(toDocument, this.excludedKeys, true);
        PdfPage page = new PdfPage(dictionary);
        this.copyInheritedProperties(page, toDocument);
        for (PdfAnnotation annot : this.getAnnotations()) {
            if (annot.getSubtype().equals(PdfName.Link)) {
                this.getDocument().storeLinkAnnotation(this, (PdfLinkAnnotation)annot);
                continue;
            }
            page.addAnnotation(-1, PdfAnnotation.makeAnnotation(((PdfDictionary)annot.getPdfObject()).copyTo(toDocument, false)), false);
        }
        if (toDocument.isTagged()) {
            page.structParents = toDocument.getNextStructParentIndex();
            ((PdfDictionary)page.getPdfObject()).put(PdfName.StructParents, new PdfNumber(page.structParents));
        }
        if (copier != null) {
            copier.copy(this, page);
        } else if (!toDocument.getWriter().isUserWarnedAboutAcroFormCopying && ((PdfDictionary)this.getDocument().getCatalog().getPdfObject()).containsKey(PdfName.AcroForm)) {
            Logger logger = LoggerFactory.getLogger(PdfPage.class);
            logger.warn("Source document has AcroForm dictionary. The pages you are going to copy may have FormFields, but they will not be copied, because you have not used any IPdfPageExtraCopier");
            toDocument.getWriter().isUserWarnedAboutAcroFormCopying = true;
        }
        return page;
    }

    public PdfFormXObject copyAsFormXObject(PdfDocument toDocument) throws IOException {
        PdfFormXObject xObject = new PdfFormXObject(this.getCropBox());
        ArrayList<PdfName> excludedKeys = new ArrayList<PdfName>(Arrays.asList(PdfName.MediaBox, PdfName.CropBox, PdfName.Contents));
        excludedKeys.addAll(this.excludedKeys);
        PdfDictionary dictionary = ((PdfDictionary)this.getPdfObject()).copyTo(toDocument, excludedKeys, true);
        ((PdfStream)xObject.getPdfObject()).getOutputStream().write(this.getContentBytes());
        ((PdfStream)xObject.getPdfObject()).mergeDifferent(dictionary);
        return xObject;
    }

    public PdfDocument getDocument() {
        if (((PdfDictionary)this.getPdfObject()).getIndirectReference() != null) {
            return ((PdfDictionary)this.getPdfObject()).getIndirectReference().getDocument();
        }
        return null;
    }

    @Override
    public void flush() {
        this.flush(false);
    }

    public void flush(boolean flushXObjects) {
        if (this.isFlushed()) {
            return;
        }
        if (this.getDocument().isTagged() && !this.getDocument().getStructTreeRoot().isFlushed()) {
            this.getDocument().getTagStructureContext().flushPageTags(this);
            this.getDocument().getStructTreeRoot().createParentTreeEntryForPage(this);
        }
        this.getDocument().dispatchEvent(new PdfDocumentEvent("EndPdfPage", this));
        if (flushXObjects) {
            this.getDocument().checkIsoConformance(this, IsoKey.PAGE);
        }
        int contentStreamCount = this.getContentStreamCount();
        for (int i = 0; i < contentStreamCount; ++i) {
            this.getContentStream(i).flush(false);
        }
        Collection<PdfObject> xObjects = null;
        if (this.resources != null) {
            if (this.resources.isReadOnly() && !this.resources.isModified()) {
                ((PdfDictionary)this.getPdfObject()).remove(PdfName.Resources);
            } else if (flushXObjects) {
                PdfDictionary xObjectsDict = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Resources).getAsDictionary(PdfName.XObject);
                xObjects = xObjectsDict != null ? xObjectsDict.values() : null;
            }
        }
        this.resources = null;
        super.flush();
        if (flushXObjects && xObjects != null) {
            this.flushXObjects(xObjects);
        }
    }

    public Rectangle getMediaBox() {
        this.initParentPages();
        PdfArray mediaBox = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.MediaBox);
        if (mediaBox == null) {
            mediaBox = (PdfArray)this.getParentValue(this.parentPages, PdfName.MediaBox);
        }
        return mediaBox.toRectangle();
    }

    public PdfPage setMediaBox(Rectangle rectangle) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.MediaBox, new PdfArray(rectangle));
        return this;
    }

    public Rectangle getCropBox() {
        this.initParentPages();
        PdfArray cropBox = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.CropBox);
        if (cropBox == null && (cropBox = (PdfArray)this.getParentValue(this.parentPages, PdfName.CropBox)) == null) {
            cropBox = new PdfArray(this.getMediaBox());
        }
        return cropBox.toRectangle();
    }

    public PdfPage setCropBox(Rectangle rectangle) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.CropBox, new PdfArray(rectangle));
        return this;
    }

    public PdfPage setArtBox(Rectangle rectangle) {
        if (((PdfDictionary)this.getPdfObject()).getAsRectangle(PdfName.TrimBox) != null) {
            ((PdfDictionary)this.getPdfObject()).remove(PdfName.TrimBox);
            Logger logger = LoggerFactory.getLogger(PdfPage.class);
            logger.warn("Only one of artbox or trimbox can exist on the page. The trimbox will be deleted");
        }
        ((PdfDictionary)this.getPdfObject()).put(PdfName.ArtBox, new PdfArray(rectangle));
        return this;
    }

    public Rectangle getArtBox() {
        return ((PdfDictionary)this.getPdfObject()).getAsRectangle(PdfName.ArtBox);
    }

    public PdfPage setTrimBox(Rectangle rectangle) {
        if (((PdfDictionary)this.getPdfObject()).getAsRectangle(PdfName.ArtBox) != null) {
            ((PdfDictionary)this.getPdfObject()).remove(PdfName.ArtBox);
            Logger logger = LoggerFactory.getLogger(PdfPage.class);
            logger.warn("Only one of artbox or trimbox can exist on the page. The trimbox will be deleted");
        }
        ((PdfDictionary)this.getPdfObject()).put(PdfName.TrimBox, new PdfArray(rectangle));
        return this;
    }

    public Rectangle getTrimBox() {
        return ((PdfDictionary)this.getPdfObject()).getAsRectangle(PdfName.TrimBox);
    }

    public byte[] getContentBytes() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int streamCount = this.getContentStreamCount();
            for (int i = 0; i < streamCount; ++i) {
                baos.write(this.getStreamBytes(i));
            }
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new PdfException("cannot.get.content.bytes", ioe, this);
        }
    }

    public byte[] getStreamBytes(int index) {
        return this.getContentStream(index).getBytes();
    }

    public int getNextMcid() {
        if (!this.getDocument().isTagged()) {
            throw new PdfException("must.be.a.tagged.document");
        }
        if (this.mcid == -1) {
            PdfStructTreeRoot structTreeRoot = this.getDocument().getStructTreeRoot();
            this.mcid = structTreeRoot.getNextMcidForPage(this);
        }
        return this.mcid++;
    }

    public Integer getStructParentIndex() {
        if (this.structParents == -1) {
            PdfNumber n = ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.StructParents);
            this.structParents = n != null ? n.intValue() : this.getDocument().getNextStructParentIndex().intValue();
        }
        return this.structParents;
    }

    public PdfPage setAdditionalAction(PdfName key, PdfAction action) {
        PdfAction.setAdditionalAction(this, key, action);
        return this;
    }

    public List<PdfAnnotation> getAnnotations() {
        ArrayList<PdfAnnotation> annotations = new ArrayList<PdfAnnotation>();
        PdfArray annots = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Annots);
        if (annots != null) {
            for (int i = 0; i < annots.size(); ++i) {
                PdfDictionary annot = annots.getAsDictionary(i);
                annotations.add(PdfAnnotation.makeAnnotation(annot).setPage(this));
            }
        }
        return annotations;
    }

    public boolean containsAnnotation(PdfAnnotation annotation) {
        for (PdfAnnotation a : this.getAnnotations()) {
            if (!((PdfDictionary)a.getPdfObject()).equals(annotation.getPdfObject())) continue;
            return true;
        }
        return false;
    }

    public PdfPage addAnnotation(PdfAnnotation annotation) {
        return this.addAnnotation(-1, annotation, true);
    }

    public PdfPage addAnnotation(int index, PdfAnnotation annotation, boolean tagAnnotation) {
        if (this.getDocument().isTagged() && tagAnnotation) {
            TagTreePointer tagPointer = this.getDocument().getTagStructureContext().getAutoTaggingPointer();
            PdfPage prevPage = tagPointer.getCurrentPage();
            tagPointer.setPageForTagging(this).addAnnotationTag(annotation);
            if (prevPage != null) {
                tagPointer.setPageForTagging(prevPage);
            }
        }
        PdfArray annots = this.getAnnots(true);
        if (index == -1) {
            annots.add((PdfObject)annotation.setPage(this).getPdfObject());
        } else {
            annots.add(index, (PdfObject)annotation.setPage(this).getPdfObject());
        }
        if (annots.getIndirectReference() == null) {
            this.setModified();
        }
        return this;
    }

    public PdfPage removeAnnotation(PdfAnnotation annotation) {
        TagTreePointer tagPointer;
        PdfArray annots = this.getAnnots(false);
        if (annots != null) {
            if (annots.contains((PdfObject)annotation.getPdfObject())) {
                annots.remove((PdfObject)annotation.getPdfObject());
            } else {
                annots.remove(((PdfDictionary)annotation.getPdfObject()).getIndirectReference());
            }
            if (annots.isEmpty()) {
                ((PdfDictionary)this.getPdfObject()).remove(PdfName.Annots);
            }
        }
        if (this.getDocument().isTagged() && (tagPointer = this.getDocument().getTagStructureContext().removeAnnotationTag(annotation)) != null) {
            boolean standardAnnotTagRole;
            boolean bl = standardAnnotTagRole = tagPointer.getRole().equals(PdfName.Annot) || tagPointer.getRole().equals(PdfName.Form);
            if (tagPointer.getKidsRoles().isEmpty() && standardAnnotTagRole) {
                tagPointer.removeTag();
            }
        }
        return this;
    }

    public int getAnnotsSize() {
        PdfArray annots = this.getAnnots(false);
        if (annots == null) {
            return 0;
        }
        return annots.size();
    }

    public List<PdfOutline> getOutlines(boolean updateOutlines) {
        this.getDocument().getOutlines(updateOutlines);
        return this.getDocument().getCatalog().getPagesWithOutlines().get(this.getPdfObject());
    }

    public boolean isIgnorePageRotationForContent() {
        return this.ignorePageRotationForContent;
    }

    public PdfPage setIgnorePageRotationForContent(boolean ignorePageRotationForContent) {
        this.ignorePageRotationForContent = ignorePageRotationForContent;
        return this;
    }

    public PdfPage setPageLabel(PageLabelNumberingStyleConstants numberingStyle, String labelPrefix) {
        return this.setPageLabel(numberingStyle, labelPrefix, 1);
    }

    public PdfPage setPageLabel(PageLabelNumberingStyleConstants numberingStyle, String labelPrefix, int firstPage) {
        if (firstPage < 1) {
            throw new PdfException("in.a.page.label.the.page.numbers.must.be.greater.or.equal.to.1");
        }
        PdfDictionary pageLabel = new PdfDictionary();
        if (numberingStyle != null) {
            switch (numberingStyle) {
                case DECIMAL_ARABIC_NUMERALS: {
                    pageLabel.put(PdfName.S, PdfName.D);
                    break;
                }
                case UPPERCASE_ROMAN_NUMERALS: {
                    pageLabel.put(PdfName.S, PdfName.R);
                    break;
                }
                case LOWERCASE_ROMAN_NUMERALS: {
                    pageLabel.put(PdfName.S, PdfName.r);
                    break;
                }
                case UPPERCASE_LETTERS: {
                    pageLabel.put(PdfName.S, PdfName.A);
                    break;
                }
                case LOWERCASE_LETTERS: {
                    pageLabel.put(PdfName.S, PdfName.a);
                    break;
                }
            }
        }
        if (labelPrefix != null) {
            pageLabel.put(PdfName.P, new PdfString(labelPrefix));
        }
        if (firstPage != 1) {
            pageLabel.put(PdfName.St, new PdfNumber(firstPage));
        }
        this.getDocument().getCatalog().getPageLabelsTree(true).addEntry(this.getDocument().getPageNumber(this) - 1, pageLabel);
        return this;
    }

    public PdfPage put(PdfName key, PdfObject value) {
        ((PdfDictionary)this.getPdfObject()).put(key, value);
        return this;
    }

    public boolean isPageRotationInverseMatrixWritten() {
        return this.pageRotationInverseMatrixWritten;
    }

    public void setPageRotationInverseMatrixWritten() {
        this.pageRotationInverseMatrixWritten = true;
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    private PdfArray getAnnots(boolean create) {
        PdfArray annots = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Annots);
        if (annots == null && create) {
            annots = new PdfArray();
            this.put(PdfName.Annots, annots);
            this.setModified();
        }
        return annots;
    }

    private PdfObject getParentValue(PdfPages parentPages, PdfName pdfName) {
        if (parentPages != null) {
            PdfDictionary parentDictionary = (PdfDictionary)parentPages.getPdfObject();
            PdfObject value = parentDictionary.get(pdfName);
            if (value != null) {
                return value;
            }
            return this.getParentValue(parentPages.getParent(), pdfName);
        }
        return null;
    }

    private PdfStream newContentStream(boolean before) {
        PdfArray array;
        PdfObject contents = ((PdfDictionary)this.getPdfObject()).get(PdfName.Contents);
        if (contents instanceof PdfStream) {
            array = new PdfArray();
            array.add(contents);
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Contents, array);
            this.setModified();
        } else if (contents instanceof PdfArray) {
            array = (PdfArray)contents;
        } else {
            throw new PdfException("pdf.page.shall.have.content");
        }
        PdfStream contentStream = new PdfStream().makeIndirect(this.getDocument());
        if (before) {
            array.add(0, contentStream);
        } else {
            array.add(contentStream);
        }
        if (null != array.getIndirectReference()) {
            array.setModified();
        } else {
            this.setModified();
        }
        return contentStream;
    }

    private void flushXObjects(Collection<PdfObject> xObjects) {
        for (PdfObject obj : xObjects) {
            PdfStream xObject = (PdfStream)obj;
            PdfDictionary innerResources = xObject.getAsDictionary(PdfName.Resources);
            Collection<PdfObject> innerXObjects = null;
            if (innerResources != null) {
                PdfDictionary innerXObjectsDict = innerResources.getAsDictionary(PdfName.XObject);
                innerXObjects = innerXObjectsDict != null ? innerXObjectsDict.values() : null;
            }
            obj.flush();
            if (innerXObjects == null) continue;
            this.flushXObjects(innerXObjects);
        }
    }

    private void initParentPages() {
        if (this.parentPages == null) {
            this.parentPages = this.getDocument().getCatalog().getPageTree().findPageParent(this);
        }
    }

    private void copyInheritedProperties(PdfPage copyPdfPage, PdfDocument pdfDocument) {
        if (((PdfDictionary)copyPdfPage.getPdfObject()).get(PdfName.Resources) == null) {
            PdfObject copyResource = pdfDocument.getWriter().copyObject((PdfObject)this.getResources().getPdfObject(), pdfDocument, false);
            ((PdfDictionary)copyPdfPage.getPdfObject()).put(PdfName.Resources, copyResource);
        }
        if (((PdfDictionary)copyPdfPage.getPdfObject()).get(PdfName.MediaBox) == null) {
            copyPdfPage.setMediaBox(this.getMediaBox());
        }
        if (((PdfDictionary)copyPdfPage.getPdfObject()).get(PdfName.CropBox) == null) {
            this.initParentPages();
            PdfArray cropBox = (PdfArray)this.getParentValue(this.parentPages, PdfName.CropBox);
            if (cropBox != null) {
                copyPdfPage.setCropBox(cropBox.toRectangle());
            }
        }
    }
}

