/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf;

import com.fr.third.fr.pdf.kernel.PdfException;
import com.fr.third.fr.pdf.kernel.pdf.PdfArray;
import com.fr.third.fr.pdf.kernel.pdf.PdfCatalog;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfString;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfNameTree {
    private static final int NODE_SIZE = 40;
    private PdfCatalog catalog;
    private Map<String, PdfObject> items = new HashMap<String, PdfObject>();
    private PdfName treeType;
    private boolean modified;

    public PdfNameTree(PdfCatalog catalog, PdfName treeType) {
        this.treeType = treeType;
        this.catalog = catalog;
        this.items = this.getNames();
    }

    public Map<String, PdfObject> getNames() {
        PdfDictionary destinations;
        if (this.items.size() > 0) {
            return this.items;
        }
        PdfDictionary dictionary = ((PdfDictionary)this.catalog.getPdfObject()).getAsDictionary(PdfName.Names);
        if (dictionary != null && (dictionary = dictionary.getAsDictionary(this.treeType)) != null) {
            this.items = this.readTree(dictionary);
            Iterator<Map.Entry<String, PdfObject>> it = this.items.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, PdfObject> entry = it.next();
                PdfArray arr = this.getNameArray(entry.getValue());
                if (arr != null) {
                    entry.setValue(arr);
                    continue;
                }
                it.remove();
            }
        }
        if (this.treeType.equals(PdfName.Dests) && (destinations = ((PdfDictionary)this.catalog.getPdfObject()).getAsDictionary(PdfName.Dests)) != null) {
            Set<PdfName> keys = destinations.keySet();
            for (PdfName key : keys) {
                PdfArray array = this.getNameArray(destinations.get(key));
                if (array == null) continue;
                this.items.put(key.getValue(), array);
            }
        }
        return this.items;
    }

    public void addEntry(String key, PdfObject value) {
        if (this.items.keySet().contains(key)) {
            throw new PdfException("name.already.exist.in.the.name.tree");
        }
        this.modified = true;
        this.items.put(key, value);
    }

    public boolean isModified() {
        return this.modified;
    }

    public PdfDictionary buildTree() {
        Object[] names = new String[this.items.size()];
        names = this.items.keySet().toArray(names);
        Arrays.sort(names);
        if (names.length <= 40) {
            PdfDictionary dic = new PdfDictionary();
            PdfArray ar = new PdfArray();
            for (int k = 0; k < names.length; ++k) {
                ar.add(new PdfString((String)names[k], null));
                ar.add(this.items.get(names[k]));
            }
            dic.put(PdfName.Names, ar);
            return dic;
        }
        int skip = 40;
        PdfDictionary[] kids = new PdfDictionary[(names.length + 40 - 1) / 40];
        for (int k = 0; k < kids.length; ++k) {
            int offset;
            int end = Math.min(offset + 40, names.length);
            PdfDictionary dic = new PdfDictionary();
            PdfArray arr = new PdfArray();
            arr.add(new PdfString((String)names[offset], null));
            arr.add(new PdfString((String)names[end - 1], null));
            dic.put(PdfName.Limits, arr);
            arr = new PdfArray();
            for (offset = k * 40; offset < end; ++offset) {
                arr.add(new PdfString((String)names[offset], null));
                arr.add(this.items.get(names[offset]));
            }
            dic.put(PdfName.Names, arr);
            dic.makeIndirect(this.catalog.getDocument());
            kids[k] = dic;
        }
        int top = kids.length;
        while (true) {
            int k;
            if (top <= 40) {
                PdfArray arr = new PdfArray();
                for (k = 0; k < top; ++k) {
                    arr.add(kids[k]);
                }
                PdfDictionary dic = new PdfDictionary();
                dic.put(PdfName.Kids, arr);
                return dic;
            }
            int tt = (names.length + (skip *= 40) - 1) / skip;
            for (k = 0; k < tt; ++k) {
                int offset;
                int end = Math.min(offset + 40, top);
                PdfDictionary dic = new PdfDictionary().makeIndirect(this.catalog.getDocument());
                PdfArray arr = new PdfArray();
                arr.add(new PdfString((String)names[k * skip], null));
                arr.add(new PdfString((String)names[Math.min((k + 1) * skip, names.length) - 1], null));
                dic.put(PdfName.Limits, arr);
                arr = new PdfArray();
                for (offset = k * 40; offset < end; ++offset) {
                    arr.add(kids[offset]);
                }
                dic.put(PdfName.Kids, arr);
                kids[k] = dic;
            }
            top = tt;
        }
    }

    private Map<String, PdfObject> readTree(PdfDictionary dictionary) {
        HashMap<String, PdfObject> items = new HashMap<String, PdfObject>();
        if (dictionary != null) {
            this.iterateItems(dictionary, items, null);
        }
        return items;
    }

    private PdfString iterateItems(PdfDictionary dictionary, Map<String, PdfObject> items, PdfString leftOver) {
        block6: {
            PdfArray names;
            block5: {
                names = dictionary.getAsArray(PdfName.Names);
                if (names == null) break block5;
                for (int k = 0; k < names.size(); ++k) {
                    PdfString name;
                    if (leftOver == null) {
                        name = names.getAsString(k++);
                    } else {
                        name = leftOver;
                        leftOver = null;
                    }
                    if (k >= names.size()) {
                        return name;
                    }
                    items.put(name.toUnicodeString(), names.get(k));
                }
                break block6;
            }
            names = dictionary.getAsArray(PdfName.Kids);
            if (names == null) break block6;
            for (int k = 0; k < names.size(); ++k) {
                PdfDictionary kid = names.getAsDictionary(k);
                leftOver = this.iterateItems(kid, items, leftOver);
            }
        }
        return null;
    }

    private PdfArray getNameArray(PdfObject obj) {
        if (obj == null) {
            return null;
        }
        if (obj.isArray()) {
            return (PdfArray)obj;
        }
        if (obj.isDictionary()) {
            PdfArray arr = ((PdfDictionary)obj).getAsArray(PdfName.D);
            return arr;
        }
        return null;
    }
}

