/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.font;

import com.fr.third.fr.pdf.io.font.CidFont;
import com.fr.third.fr.pdf.io.font.FontProgram;
import com.fr.third.fr.pdf.io.font.FontProgramFactory;
import com.fr.third.fr.pdf.io.font.TrueTypeFont;
import com.fr.third.fr.pdf.io.font.Type1Font;
import com.fr.third.fr.pdf.kernel.PdfException;
import com.fr.third.fr.pdf.kernel.font.PdfFont;
import com.fr.third.fr.pdf.kernel.font.PdfTrueTypeFont;
import com.fr.third.fr.pdf.kernel.font.PdfType0Font;
import com.fr.third.fr.pdf.kernel.font.PdfType1Font;
import com.fr.third.fr.pdf.kernel.font.PdfType3Font;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import java.io.IOException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PdfFontFactory {
    private static String DEFAULT_ENCODING = "Cp1252";
    private static boolean DEFAULT_EMBEDDING = false;
    private static boolean DEFAULT_CACHED = false;

    public static PdfFont createFont() throws Exception {
        return PdfFontFactory.createFont("Helvetica", "Cp1252");
    }

    public static PdfFont createFont(PdfDictionary fontDictionary) {
        if (PdfFontFactory.checkFontDictionary(fontDictionary, PdfName.Type1, false)) {
            return new PdfType1Font(fontDictionary);
        }
        if (PdfFontFactory.checkFontDictionary(fontDictionary, PdfName.Type0, false)) {
            return new PdfType0Font(fontDictionary);
        }
        if (PdfFontFactory.checkFontDictionary(fontDictionary, PdfName.TrueType, false)) {
            return new PdfTrueTypeFont(fontDictionary);
        }
        if (PdfFontFactory.checkFontDictionary(fontDictionary, PdfName.Type3, false)) {
            return new PdfType3Font(fontDictionary);
        }
        throw new PdfException("dict.not.contain.font.data");
    }

    public static PdfFont createFont(String path) throws Exception {
        return PdfFontFactory.createFont(path, null, DEFAULT_EMBEDDING);
    }

    public static PdfFont createFont(String path, String encoding) throws Exception {
        return PdfFontFactory.createFont(path, encoding, DEFAULT_EMBEDDING);
    }

    public static PdfFont createTtcFont(byte[] ttc, int ttcIndex, String encoding, boolean embedded, boolean cached) throws IOException {
        FontProgram fontProgram = FontProgramFactory.createFont(ttc, ttcIndex, cached);
        return PdfFontFactory.createFont(fontProgram, encoding, embedded);
    }

    public static PdfFont createTtcFont(String ttcPath, int ttcIndex, String encoding, boolean embedded, boolean cached) throws Exception {
        FontProgram fontProgram = FontProgramFactory.createFont(ttcPath, ttcIndex, cached);
        return PdfFontFactory.createFont(fontProgram, encoding, embedded);
    }

    public static PdfFont createFont(String path, boolean embedded) throws Exception {
        return PdfFontFactory.createFont(path, null, embedded);
    }

    public static PdfFont createFont(String path, String encoding, boolean embedded) throws Exception {
        FontProgram fontProgram = FontProgramFactory.createFont(path);
        return PdfFontFactory.createFont(fontProgram, encoding, embedded);
    }

    public static PdfFont createFont(FontProgram fontProgram, String encoding, boolean embedded) throws IOException {
        if (fontProgram == null) {
            return null;
        }
        if (fontProgram instanceof Type1Font) {
            return new PdfType1Font((Type1Font)fontProgram, encoding, embedded);
        }
        if (fontProgram instanceof TrueTypeFont) {
            if ("Identity-H".equals(encoding) || "Identity-V".equals(encoding)) {
                return new PdfType0Font((TrueTypeFont)fontProgram, encoding);
            }
            return new PdfTrueTypeFont((TrueTypeFont)fontProgram, encoding, embedded);
        }
        if (fontProgram instanceof CidFont) {
            if (((CidFont)fontProgram).compatibleWith(encoding)) {
                return new PdfType0Font((CidFont)fontProgram, encoding);
            }
            return null;
        }
        return null;
    }

    public static PdfFont createFont(FontProgram fontProgram, String encoding) throws IOException {
        return PdfFontFactory.createFont(fontProgram, encoding, DEFAULT_EMBEDDING);
    }

    public static PdfFont createFont(FontProgram fontProgram) throws IOException {
        return PdfFontFactory.createFont(fontProgram, DEFAULT_ENCODING);
    }

    public static PdfFont createFont(byte[] font, String encoding) throws Exception {
        return PdfFontFactory.createFont(font, encoding, DEFAULT_EMBEDDING);
    }

    public static PdfFont createFont(byte[] font, boolean embedded) throws Exception {
        return PdfFontFactory.createFont(font, null, embedded);
    }

    public static PdfFont createFont(byte[] font, String encoding, boolean embedded) throws Exception {
        return PdfFontFactory.createFont(font, encoding, embedded, DEFAULT_CACHED);
    }

    public static PdfFont createFont(byte[] font, String encoding, boolean embedded, boolean cached) throws Exception {
        FontProgram fontProgram = FontProgramFactory.createFont(null, font, cached);
        return PdfFontFactory.createFont(fontProgram, encoding, embedded);
    }

    public static PdfType3Font createType3Font(PdfDocument document, boolean colorized) throws IOException {
        return new PdfType3Font(document, colorized);
    }

    public static PdfFont createRegisteredFont(String font, String encoding, boolean embedded, int style, boolean cached) throws Exception {
        FontProgram fontProgram = FontProgramFactory.createRegisteredFont(font, style, cached);
        return PdfFontFactory.createFont(fontProgram, encoding, embedded);
    }

    public static PdfFont createRegisteredFont(String font, String encoding, boolean embedded, boolean cached) throws Exception {
        return PdfFontFactory.createRegisteredFont(font, encoding, embedded, -1, cached);
    }

    public static PdfFont createRegisteredFont(String font, String encoding, boolean embedded) throws Exception {
        return PdfFontFactory.createRegisteredFont(font, encoding, embedded, -1);
    }

    public static PdfFont createRegisteredFont(String font, String encoding, boolean embedded, int style) throws Exception {
        return PdfFontFactory.createRegisteredFont(font, encoding, embedded, style, DEFAULT_CACHED);
    }

    public static PdfFont createRegisteredFont(String font, String encoding) throws Exception {
        return PdfFontFactory.createRegisteredFont(font, encoding, false, -1);
    }

    public static PdfFont createRegisteredFont(String fontName) throws Exception {
        return PdfFontFactory.createRegisteredFont(fontName, null, false, -1);
    }

    public static void registerFamily(String familyName, String fullName, String path) {
        FontProgramFactory.registerFontFamily(familyName, fullName, path);
    }

    public static void register(String path) {
        PdfFontFactory.register(path, null);
    }

    public static void register(String path, String alias) {
        FontProgramFactory.registerFont(path, alias);
    }

    public static int registerDirectory(String dir) {
        return FontProgramFactory.registerFontDirectory(dir);
    }

    public static int registerSystemDirectories() {
        return FontProgramFactory.registerSystemFontDirectories();
    }

    public static Set<String> getRegisteredFonts() {
        return FontProgramFactory.getRegisteredFonts();
    }

    public static Set<String> getRegisteredFamilies() {
        return FontProgramFactory.getRegisteredFontFamilies();
    }

    public static boolean isRegistered(String fontname) {
        return FontProgramFactory.isRegisteredFont(fontname);
    }

    protected static boolean checkFontDictionary(PdfDictionary fontDic, PdfName fontType, boolean isException) {
        if (fontDic == null || fontDic.get(PdfName.Subtype) == null || !fontDic.get(PdfName.Subtype).equals(fontType)) {
            if (isException) {
                throw new PdfException("dict.not.contain.font.data").setMessageParams(fontType.getValue());
            }
            return false;
        }
        return true;
    }
}

