/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.io.font.otf;

import com.fr.third.fr.pdf.io.font.otf.FeatureRecord;
import com.fr.third.fr.pdf.io.font.otf.FontReadingException;
import com.fr.third.fr.pdf.io.font.otf.Glyph;
import com.fr.third.fr.pdf.io.font.otf.LanguageRecord;
import com.fr.third.fr.pdf.io.font.otf.OpenTableLookup;
import com.fr.third.fr.pdf.io.font.otf.OpenTypeFeature;
import com.fr.third.fr.pdf.io.font.otf.OpenTypeGdefTableReader;
import com.fr.third.fr.pdf.io.font.otf.OpenTypeScript;
import com.fr.third.fr.pdf.io.font.otf.OtfClass;
import com.fr.third.fr.pdf.io.font.otf.OtfReadCommon;
import com.fr.third.fr.pdf.io.font.otf.ScriptRecord;
import com.fr.third.fr.pdf.io.font.otf.SubstLookupRecord;
import com.fr.third.fr.pdf.io.font.otf.TagAndLocation;
import com.fr.third.fr.pdf.io.source.RandomAccessFileOrArray;
import com.fr.third.fr.pdf.io.util.IntHashtable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OpenTypeFontTableReader {
    protected final RandomAccessFileOrArray rf;
    protected final int tableLocation;
    protected List<OpenTableLookup> lookupList;
    protected OpenTypeScript scriptsType;
    protected OpenTypeFeature featuresType;
    private final Map<Integer, Glyph> indexGlyphMap;
    private final OpenTypeGdefTableReader gdef;
    private final int unitsPerEm;

    protected OpenTypeFontTableReader(RandomAccessFileOrArray rf, int tableLocation, OpenTypeGdefTableReader gdef, Map<Integer, Glyph> indexGlyphMap, int unitsPerEm) throws IOException {
        this.rf = rf;
        this.tableLocation = tableLocation;
        this.indexGlyphMap = indexGlyphMap;
        this.gdef = gdef;
        this.unitsPerEm = unitsPerEm;
    }

    public Glyph getGlyph(int index) {
        return this.indexGlyphMap.get(index);
    }

    public OpenTableLookup getLookupTable(int idx) {
        if (idx < 0 || idx >= this.lookupList.size()) {
            return null;
        }
        return this.lookupList.get(idx);
    }

    public List<ScriptRecord> getScriptRecords() {
        return this.scriptsType.getScriptRecords();
    }

    public List<FeatureRecord> getFeatureRecords() {
        return this.featuresType.getRecords();
    }

    public List<FeatureRecord> getFeatures(String[] scripts, String language) {
        LanguageRecord rec = this.scriptsType.getLanguageRecord(scripts, language);
        if (rec == null) {
            return null;
        }
        ArrayList<FeatureRecord> ret = new ArrayList<FeatureRecord>();
        for (int f : rec.features) {
            ret.add(this.featuresType.getRecord(f));
        }
        return ret;
    }

    public List<FeatureRecord> getSpecificFeatures(List<FeatureRecord> features, String[] specific) {
        if (specific == null) {
            return features;
        }
        HashSet<String> hs = new HashSet<String>();
        for (String s : specific) {
            hs.add(s);
        }
        ArrayList<FeatureRecord> recs = new ArrayList<FeatureRecord>();
        for (FeatureRecord rec : features) {
            if (!hs.contains(rec.tag)) continue;
            recs.add(rec);
        }
        return recs;
    }

    public FeatureRecord getRequiredFeature(String[] scripts, String language) {
        LanguageRecord rec = this.scriptsType.getLanguageRecord(scripts, language);
        if (rec == null) {
            return null;
        }
        return this.featuresType.getRecord(rec.featureRequired);
    }

    public List<OpenTableLookup> getLookups(FeatureRecord[] features) {
        IntHashtable hash = new IntHashtable();
        for (FeatureRecord rec : features) {
            for (int idx : rec.lookups) {
                hash.put(idx, 1);
            }
        }
        ArrayList<OpenTableLookup> ret = new ArrayList<OpenTableLookup>();
        for (int idx : hash.toOrderedKeys()) {
            ret.add(this.lookupList.get(idx));
        }
        return ret;
    }

    public List<OpenTableLookup> getLookups(FeatureRecord feature) {
        ArrayList<OpenTableLookup> ret = new ArrayList<OpenTableLookup>(feature.lookups.length);
        for (int idx : feature.lookups) {
            ret.add(this.lookupList.get(idx));
        }
        return ret;
    }

    public boolean isSkip(int glyph, int flag) {
        return this.gdef.isSkip(glyph, flag);
    }

    public int getUnitsPerEm() {
        return this.unitsPerEm;
    }

    public LanguageRecord getLanguageRecord(String otfScriptTag) {
        LanguageRecord languageRecord = null;
        if (otfScriptTag != null) {
            for (ScriptRecord record : this.getScriptRecords()) {
                if (!otfScriptTag.equals(record.tag)) continue;
                languageRecord = record.defaultLanguage;
                break;
            }
        }
        return languageRecord;
    }

    protected abstract OpenTableLookup readLookupTable(int var1, int var2, int[] var3) throws IOException;

    protected final OtfClass readClassDefinition(int classLocation) throws IOException {
        return new OtfClass(this.rf, classLocation);
    }

    protected final int[] readUShortArray(int size, int location) throws IOException {
        return OtfReadCommon.readUShortArray(this.rf, size, location);
    }

    protected final int[] readUShortArray(int size) throws IOException {
        return OtfReadCommon.readUShortArray(this.rf, size);
    }

    protected void readCoverages(int[] locations, List<Set<Integer>> coverage) throws IOException {
        OtfReadCommon.readCoverages(this.rf, locations, coverage);
    }

    protected final List<Integer> readCoverageFormat(int coverageLocation) throws IOException {
        return OtfReadCommon.readCoverageFormat(this.rf, coverageLocation);
    }

    protected SubstLookupRecord[] readSubstLookupRecords(int substCount) throws IOException {
        return OtfReadCommon.readSubstLookupRecords(this.rf, substCount);
    }

    protected TagAndLocation[] readTagAndLocations(int baseLocation) throws IOException {
        int count = this.rf.readUnsignedShort();
        TagAndLocation[] tagslLocs = new TagAndLocation[count];
        for (int k = 0; k < count; ++k) {
            TagAndLocation tl = new TagAndLocation();
            tl.tag = this.rf.readString(4, "utf-8");
            tl.location = this.rf.readUnsignedShort() + baseLocation;
            tagslLocs[k] = tl;
        }
        return tagslLocs;
    }

    final void startReadingTable() throws FontReadingException {
        try {
            this.rf.seek(this.tableLocation);
            this.rf.readInt();
            int scriptListOffset = this.rf.readUnsignedShort();
            int featureListOffset = this.rf.readUnsignedShort();
            int lookupListOffset = this.rf.readUnsignedShort();
            this.scriptsType = new OpenTypeScript(this, this.tableLocation + scriptListOffset);
            this.featuresType = new OpenTypeFeature(this, this.tableLocation + featureListOffset);
            this.readLookupListTable(this.tableLocation + lookupListOffset);
        }
        catch (IOException e) {
            throw new FontReadingException("Error reading font file", e);
        }
    }

    private void readLookupListTable(int lookupListTableLocation) throws IOException {
        int[] lookupTableLocations;
        this.lookupList = new ArrayList<OpenTableLookup>();
        this.rf.seek(lookupListTableLocation);
        int lookupCount = this.rf.readUnsignedShort();
        for (int lookupLocation : lookupTableLocations = this.readUShortArray(lookupCount, lookupListTableLocation)) {
            this.readLookupTable(lookupLocation);
        }
    }

    private void readLookupTable(int lookupTableLocation) throws IOException {
        this.rf.seek(lookupTableLocation);
        int lookupType = this.rf.readUnsignedShort();
        int lookupFlag = this.rf.readUnsignedShort();
        int subTableCount = this.rf.readUnsignedShort();
        int[] subTableLocations = this.readUShortArray(subTableCount, lookupTableLocation);
        this.lookupList.add(this.readLookupTable(lookupType, lookupFlag, subTableLocations));
    }
}

