/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.scatter;

import com.fr.base.Utils;
import com.fr.base.background.ColorBackground;
import com.fr.base.chart.Glyph;
import com.fr.chart.base.AreaColor;
import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrBackground;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.Marker;
import com.fr.chart.chartglyph.MarkerFactory;
import com.fr.chart.chartglyph.MarkerGlyph;
import com.fr.general.Background;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.attr.MarkerType;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.base.AttrLabel;
import com.fr.plugin.chart.base.AttrTooltip;
import com.fr.plugin.chart.base.VanChartAttrLine;
import com.fr.plugin.chart.base.VanChartAttrMarker;
import com.fr.plugin.chart.glyph.VanChartDataPoint;
import com.fr.plugin.chart.glyph.VanChartDataSeries;
import com.fr.plugin.chart.glyph.VanChartLineMarkerIcon;
import com.fr.plugin.chart.glyph.axis.VanChartBaseAxisGlyph;
import com.fr.plugin.chart.glyph.marker.CustomImageMarker;
import com.fr.plugin.chart.line.VanChartLineDataPoint;
import com.fr.plugin.chart.line.VanChartLinePlotGlyph;
import com.fr.plugin.chart.range.GradualIntervalConfig;
import com.fr.plugin.chart.range.LegendType;
import com.fr.plugin.chart.range.MinAndMaxValue;
import com.fr.plugin.chart.range.SectionIntervalConfig;
import com.fr.plugin.chart.range.glyph.GradualColorDist;
import com.fr.plugin.chart.scatter.VanChartScatterDataPoint;
import com.fr.plugin.chart.scatter.VanChartScatterLegend;
import com.fr.plugin.chart.scatter.VanChartScatterPlot;
import com.fr.plugin.chart.scatter.attr.ScatterAttrLabel;
import com.fr.plugin.chart.scatter.attr.ScatterAttrTooltip;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class VanChartScatterPlotGlyph
extends VanChartLinePlotGlyph {
    protected static final double DEFAULT_MAX = -100.0;
    protected static final double DEFAULT_MIN = 100.0;

    @Override
    protected VanChartAttrMarker getAttrMarker(VanChartLineDataPoint vanChartLineDataPoint) {
        VanChartAttrMarker vanChartAttrMarker = vanChartLineDataPoint.getAttrMarker();
        if (vanChartAttrMarker == null) {
            vanChartAttrMarker = ((VanChartDataSeries)this.getSeries(vanChartLineDataPoint.getSeriesIndex())).getMarker();
            vanChartAttrMarker = vanChartAttrMarker == null ? this.getDefaultAttrMarker() : vanChartAttrMarker;
        }
        return vanChartAttrMarker;
    }

    @Override
    protected VanChartAttrMarker getAttrMarker(VanChartDataSeries vanChartDataSeries) {
        VanChartAttrMarker vanChartAttrMarker = vanChartDataSeries.getMarker();
        if (vanChartAttrMarker == null) {
            vanChartAttrMarker = this.getDefaultAttrMarker();
        }
        return vanChartAttrMarker;
    }

    @Override
    protected void initMarkerGlyph(VanChartLineDataPoint vanChartLineDataPoint, float f, float f2, Color color) {
        VanChartScatterDataPoint vanChartScatterDataPoint = (VanChartScatterDataPoint)vanChartLineDataPoint;
        MarkerGlyph markerGlyph = this.createMarkerGlyph();
        VanChartAttrMarker vanChartAttrMarker = this.getAttrMarker(vanChartLineDataPoint);
        Marker marker = null;
        marker = vanChartAttrMarker.getMarkerType() == MarkerType.MARKER_NULL ? MarkerFactory.createMarker((String)VanChartAttrHelper.getDefaultMarkerType(vanChartLineDataPoint.getSeriesIndex())) : vanChartAttrMarker.getMarkerType().getMarker();
        this.dealMarkerShapeAndColor(marker, vanChartAttrMarker, markerGlyph, vanChartScatterDataPoint, color, f, f2);
        marker.setPlotBackground(this.getMarkerBackground());
        markerGlyph.setMarker(marker);
        this.dealAlpha4MakerGlyph(markerGlyph, vanChartLineDataPoint);
        vanChartLineDataPoint.setDrawImpl((Glyph)markerGlyph);
    }

    protected void dealMarkerShapeAndColor(Marker marker, VanChartAttrMarker vanChartAttrMarker, MarkerGlyph markerGlyph, VanChartScatterDataPoint vanChartScatterDataPoint, Color color, float f, float f2) {
        if (vanChartAttrMarker.isCommon()) {
            this.dealMarkerBackGround(marker, vanChartScatterDataPoint, color);
            double d = vanChartAttrMarker.getRadius();
            marker.setSize(d);
            this.setMakerGlyphShapeWithDataPoint(markerGlyph, f, f2, d, vanChartScatterDataPoint);
        } else if (vanChartAttrMarker.getImageBackground() != null) {
            double d = vanChartAttrMarker.getWidth();
            double d2 = vanChartAttrMarker.getHeight();
            marker = new CustomImageMarker(d, d2);
            marker.setBackground((Background)vanChartAttrMarker.getImageBackground());
            markerGlyph.setShape((Rectangle2D)new Rectangle2D.Double((double)f - d / 2.0, (double)f2 - d2 / 2.0, d, d2));
        }
    }

    protected ColorBackground getRangeLegendColorBackGround4DataPoint(VanChartScatterDataPoint vanChartScatterDataPoint) {
        VanChartScatterLegend vanChartScatterLegend = (VanChartScatterLegend)((VanChartScatterPlot)this.getGeneralInfo()).getLegend();
        if (vanChartScatterLegend == null) {
            return null;
        }
        LegendType legendType = vanChartScatterLegend.getLegendType();
        switch (legendType) {
            case ORDINARY: {
                return null;
            }
            case GRADUAL: {
                Color color = this.getGradualLegendColor(vanChartScatterDataPoint, vanChartScatterLegend.getGradualLegend().getGradualIntervalConfig());
                if (color != null) {
                    return ColorBackground.getInstance((Color)color);
                }
                return null;
            }
            case SECTION: {
                Color color = this.getGradualSectionColor(vanChartScatterDataPoint, vanChartScatterLegend.getSectionLegend().getSectionIntervalConfig());
                if (color != null) {
                    return ColorBackground.getInstance((Color)color);
                }
                return null;
            }
        }
        return null;
    }

    private Color getGradualLegendColor(VanChartScatterDataPoint vanChartScatterDataPoint, GradualIntervalConfig gradualIntervalConfig) {
        MinAndMaxValue minAndMaxValue = gradualIntervalConfig.getMinAndMaxValue();
        double d = -100.0;
        double d2 = 100.0;
        double[] dArray = this.getRange(minAndMaxValue, d2, d);
        ArrayList<GradualColorDist> arrayList = gradualIntervalConfig.getGradualColorDistList();
        double d3 = this.getDataPointValue(vanChartScatterDataPoint);
        if (d3 < dArray[0] || d3 > dArray[1]) {
            return null;
        }
        return this.getColorWithColorDist(d3, dArray, arrayList);
    }

    private Color getGradualSectionColor(VanChartScatterDataPoint vanChartScatterDataPoint, SectionIntervalConfig sectionIntervalConfig) {
        double d = this.getDataPointValue(vanChartScatterDataPoint);
        if (sectionIntervalConfig.getUseType() == 1) {
            return this.dealSectionCustomColor(d, sectionIntervalConfig);
        }
        return this.dealSectionAutoColor(d, sectionIntervalConfig);
    }

    private Color dealSectionAutoColor(double d, SectionIntervalConfig sectionIntervalConfig) {
        int n = sectionIntervalConfig.getAreaNumber();
        Color color = sectionIntervalConfig.getMainColor();
        Color[] colorArray = ChartBaseUtils.createColorsWithHSB((Color)color, (int)n);
        Color[] colorArray2 = this.reverseColors(colorArray);
        double d2 = -100.0;
        double d3 = 100.0;
        double[] dArray = VanChartAttrHelper.getScatterMinAndMaxValue(this, d2, d3);
        d2 = dArray[0];
        d3 = dArray[1];
        double[] dArray2 = this.roundValueWithDivNum(d2 = VanChartAttrHelper.roundValue(d2, false), d3 = VanChartAttrHelper.roundValue(d3, true), n);
        if (d == dArray2[0]) {
            return colorArray2[0];
        }
        for (int i = 0; i < n; ++i) {
            if (!(dArray2[i] < d) || !(d <= dArray2[i + 1])) continue;
            return colorArray2[i];
        }
        return null;
    }

    private Color dealSectionCustomColor(double d, SectionIntervalConfig sectionIntervalConfig) {
        int n = sectionIntervalConfig.getAreaNumber();
        AreaColor areaColor = (AreaColor)sectionIntervalConfig.getAreaColorList().get(n - 1);
        AreaColor areaColor2 = (AreaColor)sectionIntervalConfig.getAreaColorList().get(0);
        double[] dArray = new double[]{areaColor.getMaxNum(), areaColor2.getMinNum()};
        if (d < dArray[0] || d > dArray[1]) {
            return null;
        }
        if (d == dArray[0]) {
            return areaColor.getAreaColor();
        }
        for (int i = n - 1; i >= 0; --i) {
            AreaColor areaColor3 = (AreaColor)sectionIntervalConfig.getAreaColorList().get(i);
            if (!(areaColor3.getMaxNum() < d) || !(d <= areaColor3.getMinNum())) continue;
            return areaColor3.getAreaColor();
        }
        return null;
    }

    private Color[] reverseColors(Color[] colorArray) {
        Color[] colorArray2 = new Color[colorArray.length];
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray2[i] = colorArray[colorArray.length - 1 - i];
        }
        return colorArray2;
    }

    private double[] roundValueWithDivNum(double d, double d2, int n) {
        double[] dArray = new double[n + 1];
        double d3 = (d2 - d) / (double)n;
        d3 = VanChartAttrHelper.roundValue(d3, true);
        for (int i = 0; i <= n; ++i) {
            dArray[i] = d + d3 * (double)i;
        }
        return dArray;
    }

    private Color getColorWithColorDist(double d, double[] dArray, ArrayList<GradualColorDist> arrayList) {
        if (dArray[0] == dArray[1]) {
            return arrayList.get(0).getColor();
        }
        float f = (float)((d - dArray[0]) / (dArray[1] - dArray[0]));
        int n = arrayList.size();
        float f2 = arrayList.get(0).getPosition();
        float f3 = arrayList.get(n - 1).getPosition();
        Color color = arrayList.get(0).getColor();
        Color color2 = arrayList.get(n - 1).getColor();
        if (f == f2) {
            return color;
        }
        for (int i = 0; i < n - 1; ++i) {
            if (!(arrayList.get(i).getPosition() < f) || !(f <= arrayList.get(i + 1).getPosition())) continue;
            f2 = arrayList.get(i).getPosition();
            f3 = arrayList.get(i + 1).getPosition();
            color = arrayList.get(i).getColor();
            color2 = arrayList.get(i + 1).getColor();
            break;
        }
        return this.getColorFrom2Colors(color, f2, color2, f3, f);
    }

    private Color getColorFrom2Colors(Color color, float f, Color color2, float f2, float f3) {
        float[] fArray = new float[]{color.getRed(), color.getGreen(), color.getBlue()};
        float[] fArray2 = new float[]{color2.getRed(), color2.getGreen(), color2.getBlue()};
        int[] nArray = new int[3];
        for (int i = 0; i < 3; ++i) {
            nArray[i] = Math.round(fArray[i] - (fArray[i] - fArray2[i]) / (f2 - f) * (f3 - f));
        }
        return new Color(nArray[0], nArray[1], nArray[2]);
    }

    public double getDataPointValue(VanChartScatterDataPoint vanChartScatterDataPoint) {
        return vanChartScatterDataPoint.getSizeValue();
    }

    private double[] getRange(MinAndMaxValue minAndMaxValue, double d, double d2) {
        double[] dArray = VanChartAttrHelper.getScatterMinAndMaxValue(this, d, d2);
        d = dArray[0];
        d2 = dArray[1];
        d = VanChartAttrHelper.roundValue(d, false);
        d2 = VanChartAttrHelper.roundValue(d2, true);
        if (minAndMaxValue.isCustomMin()) {
            d = minAndMaxValue.getMinNum();
        }
        if (minAndMaxValue.isCustomMax()) {
            d2 = minAndMaxValue.getMaxNum();
        }
        return new double[]{d, d2};
    }

    protected void initAllBubbleDataPoint() {
    }

    protected boolean isInCustomValueRange(VanChartScatterDataPoint vanChartScatterDataPoint) {
        double d = this.getDataPointValue(vanChartScatterDataPoint);
        VanChartScatterPlot vanChartScatterPlot = (VanChartScatterPlot)this.getGeneralInfo();
        VanChartScatterLegend vanChartScatterLegend = (VanChartScatterLegend)vanChartScatterPlot.getLegend();
        if (vanChartScatterLegend == null) {
            return true;
        }
        LegendType legendType = vanChartScatterLegend.getLegendType();
        switch (legendType) {
            case ORDINARY: {
                return true;
            }
            case GRADUAL: {
                if (vanChartScatterDataPoint.isSizeIsNull()) {
                    return false;
                }
                GradualIntervalConfig gradualIntervalConfig = vanChartScatterLegend.getGradualLegend().getGradualIntervalConfig();
                double d2 = gradualIntervalConfig.getMinAndMaxValue().getMaxNum();
                double d3 = gradualIntervalConfig.getMinAndMaxValue().getMinNum();
                if (gradualIntervalConfig.getMinAndMaxValue().isCustomMax() && d > d2) {
                    return false;
                }
                return !gradualIntervalConfig.getMinAndMaxValue().isCustomMin() || !(d < d3);
            }
            case SECTION: {
                if (vanChartScatterDataPoint.isSizeIsNull()) {
                    return false;
                }
                SectionIntervalConfig sectionIntervalConfig = vanChartScatterLegend.getSectionLegend().getSectionIntervalConfig();
                if (sectionIntervalConfig.getUseType() == 1) {
                    int n = sectionIntervalConfig.getAreaColorList().size();
                    double d4 = ((AreaColor)sectionIntervalConfig.getAreaColorList().get(0)).getMinNum();
                    double d5 = ((AreaColor)sectionIntervalConfig.getAreaColorList().get(n - 1)).getMaxNum();
                    if (d > d4 || d < d5) {
                        return false;
                    }
                }
                return true;
            }
        }
        return true;
    }

    protected void dealMarkerBackGround(Marker marker, VanChartScatterDataPoint vanChartScatterDataPoint, Color color) {
        VanChartAttrMarker vanChartAttrMarker = vanChartScatterDataPoint.getAttrMarker();
        AttrBackground attrBackground = vanChartScatterDataPoint.getColor();
        VanChartAttrMarker vanChartAttrMarker2 = ((VanChartDataSeries)this.getSeries(vanChartScatterDataPoint.getSeriesIndex())).getMarker();
        AttrBackground attrBackground2 = ((VanChartDataSeries)this.getSeries(vanChartScatterDataPoint.getSeriesIndex())).getColor();
        ColorBackground colorBackground = this.getRangeLegendColorBackGround4DataPoint(vanChartScatterDataPoint);
        if (vanChartAttrMarker != null && vanChartAttrMarker.getColorBackground() != null) {
            marker.setBackground((Background)vanChartAttrMarker.getColorBackground());
        } else if (attrBackground != null && attrBackground.getSeriesBackground() != null) {
            marker.setBackground(attrBackground.getSeriesBackground());
        } else if (vanChartAttrMarker2 != null && vanChartAttrMarker2.getColorBackground() != null) {
            marker.setBackground((Background)vanChartAttrMarker2.getColorBackground());
        } else if (attrBackground2 != null && attrBackground2.getSeriesBackground() != null) {
            marker.setBackground(attrBackground2.getSeriesBackground());
        } else if (colorBackground != null) {
            marker.setBackground((Background)colorBackground);
        } else if (this.isNegative(vanChartScatterDataPoint)) {
            marker.setBackground((Background)ColorBackground.getInstance((Color)new Color(138, 138, 138)));
        } else if (this.getDefaultAttrMarker() != null && this.getDefaultAttrMarker().getColorBackground() != null) {
            marker.setBackground((Background)this.getDefaultAttrMarker().getColorBackground());
        } else {
            marker.setBackground((Background)ColorBackground.getInstance((Color)color));
        }
    }

    protected void setMakerGlyphShapeWithDataPoint(MarkerGlyph markerGlyph, float f, float f2, double d, VanChartScatterDataPoint vanChartScatterDataPoint) {
        markerGlyph.setShape((Rectangle2D)new Rectangle2D.Double((double)f - d, (double)f2 - d, d * 2.0, d * 2.0));
    }

    @Override
    protected void dealMarkerStyle(VanChartLineMarkerIcon vanChartLineMarkerIcon, VanChartDataSeries vanChartDataSeries, Color[] colorArray) {
        VanChartAttrMarker vanChartAttrMarker = this.getAttrMarker(vanChartDataSeries);
        ColorBackground colorBackground = ColorBackground.getInstance((Color)this.getAttrLineColor(vanChartDataSeries, colorArray));
        Marker marker = null;
        if (vanChartAttrMarker.getMarkerType() == MarkerType.MARKER_NULL) {
            marker = MarkerFactory.createMarker((String)VanChartAttrHelper.getDefaultMarkerType(vanChartDataSeries.getSeriesIndex()));
            marker.setBackground((Background)colorBackground);
            marker.setPlotBackground((Background)Marker.SCATTER_PLOT_BACKROUNG);
        } else {
            marker = MarkerFactory.createMarker((String)vanChartAttrMarker.getMarkerType().getType());
            marker.setPlotBackground((Background)Marker.SCATTER_PLOT_BACKROUNG);
            if (vanChartAttrMarker.isCommon()) {
                marker.setBackground((Background)colorBackground);
            }
        }
        vanChartLineMarkerIcon.setLineStyle(0);
        vanChartLineMarkerIcon.setBackground((Background)colorBackground);
        vanChartLineMarkerIcon.setMarker(marker);
    }

    @Override
    public String getChartType() {
        return "scatter";
    }

    @Override
    protected void dealAlpha4MakerGlyph(MarkerGlyph markerGlyph, VanChartLineDataPoint vanChartLineDataPoint) {
        markerGlyph.setAlpha(this.getDefaultAttrAlpha().getAlpha());
        AttrAlpha attrAlpha = vanChartLineDataPoint.getAlpha();
        if (attrAlpha != null) {
            markerGlyph.setAlpha(attrAlpha.getAlpha());
        }
    }

    @Override
    protected AttrLabel getDefaultAttrLabel() {
        if (this.getDataProcessor().getMark() == 1) {
            return null;
        }
        if (this.defaultAttrLabel == null) {
            ConditionAttr conditionAttr = this.getConditionCollection().getDefaultAttr();
            this.defaultAttrLabel = (ScatterAttrLabel)conditionAttr.getExisted(ScatterAttrLabel.class);
        }
        return this.defaultAttrLabel;
    }

    @Override
    protected AttrLabel getAttrLabel(VanChartDataPoint vanChartDataPoint) {
        if (this.getDataProcessor().getMark() == 1) {
            return null;
        }
        AttrLabel attrLabel = vanChartDataPoint.getLabel();
        if (attrLabel == null) {
            attrLabel = this.getDefaultAttrLabel();
        }
        return attrLabel;
    }

    @Override
    protected AttrTooltip getDefaultAttrTooltip() {
        if (this.defaultAttrTooltip == null) {
            ConditionAttr conditionAttr = this.getConditionCollection().getDefaultAttr();
            this.defaultAttrTooltip = (ScatterAttrTooltip)conditionAttr.getExisted(ScatterAttrTooltip.class);
        }
        return this.defaultAttrTooltip;
    }

    @Override
    protected String getLabelText(AttrLabel attrLabel, VanChartDataPoint vanChartDataPoint) {
        return VanChartAttrHelper.getScatterLabelText(attrLabel.getContent(), vanChartDataPoint);
    }

    @Override
    protected double getPointPresentValue(double d, double d2) {
        return d;
    }

    @Override
    protected boolean samePoint(double d, double d2, double d3, double d4) {
        return false;
    }

    @Override
    protected void setSeriesColor(VanChartDataPoint vanChartDataPoint, VanChartDataSeries vanChartDataSeries) {
    }

    @Override
    public JSONObject getPlotOptionsJSON(Repository repository, boolean bl) throws JSONException {
        JSONObject jSONObject = super.getPlotOptionsJSON(repository, bl);
        AttrAlpha attrAlpha = this.getDefaultAttrAlpha();
        if (attrAlpha != null) {
            jSONObject.put("fillColorOpacity", (double)attrAlpha.getAlpha());
        }
        return jSONObject;
    }

    @Override
    protected int getAttrLineWidth(VanChartDataSeries vanChartDataSeries) {
        VanChartAttrLine vanChartAttrLine = vanChartDataSeries.getAttrLine();
        if (vanChartAttrLine == null) {
            vanChartAttrLine = this.getDefaultAttrLine();
        }
        if (vanChartAttrLine == null) {
            vanChartAttrLine = new VanChartAttrLine();
            vanChartAttrLine.setLineWidth(0);
        }
        return vanChartAttrLine.getLineWidth();
    }

    @Override
    public void layoutDataSeriesGlyph(int n) {
        this.createDataPointLabelAfterInstallAxisGlyph();
        this.initAllBubbleDataPoint();
        Map<String, List<List<Number>>> map = this.buildAxisMap(false);
        for (String string : map.keySet()) {
            this.buildSingleAxisLines(map.get(string), n);
        }
    }

    public boolean isDisplayDataPointWithAttrBubble(VanChartScatterDataPoint vanChartScatterDataPoint) {
        return true;
    }

    protected boolean isNegative(VanChartScatterDataPoint vanChartScatterDataPoint) {
        return false;
    }

    @Override
    public double[] getSeriesMinMaxCateValue(DataSeries dataSeries, double[] dArray) {
        int n = dataSeries.getDataPointCount();
        for (int i = 0; i < n; ++i) {
            Number number;
            VanChartScatterDataPoint vanChartScatterDataPoint = (VanChartScatterDataPoint)dataSeries.getDataPoint(i);
            if (!this.isDisplayDataPoint(vanChartScatterDataPoint) || (number = Utils.string2Number((String)vanChartScatterDataPoint.getCategoryName())) == null) continue;
            double d = number.doubleValue();
            dArray[0] = Math.min(dArray[0], d);
            dArray[1] = Math.max(dArray[1], d);
        }
        return dArray;
    }

    @Override
    protected void initValueAxisGlyphMinMaxValue(int n, VanChartBaseAxisGlyph vanChartBaseAxisGlyph) {
        if (vanChartBaseAxisGlyph.isPercentage()) {
            vanChartBaseAxisGlyph.initMinMaxValue(0.0, 1.0);
            return;
        }
        double d = Double.MAX_VALUE;
        double d2 = -d;
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            VanChartDataSeries vanChartDataSeries = (VanChartDataSeries)this.getSeries(i);
            int n2 = vanChartDataSeries.getDataPointCount();
            for (int j = 0; j < n2; ++j) {
                VanChartScatterDataPoint vanChartScatterDataPoint = (VanChartScatterDataPoint)vanChartDataSeries.getDataPoint(j);
                if (!this.isDisplayDataPoint(vanChartScatterDataPoint)) continue;
                Double d3 = vanChartScatterDataPoint.getValue();
                if (vanChartScatterDataPoint.isValueIsNull()) continue;
                double d4 = d3;
                d = Math.min(d, d4);
                d2 = Math.max(d2, d4);
            }
        }
        vanChartBaseAxisGlyph.initMinMaxValue(d, d2);
    }

    @Override
    protected boolean isDisplayDataPoint(VanChartLineDataPoint vanChartLineDataPoint) {
        return this.isDisplayDataPointWithAttrBubble((VanChartScatterDataPoint)vanChartLineDataPoint) && this.isInCustomValueRange((VanChartScatterDataPoint)vanChartLineDataPoint) && this.isNullDisplay((VanChartScatterDataPoint)vanChartLineDataPoint);
    }

    protected boolean isNullDisplay(VanChartScatterDataPoint vanChartScatterDataPoint) {
        return true;
    }

    public boolean isDataPointValueIsNull(VanChartScatterDataPoint vanChartScatterDataPoint) {
        return vanChartScatterDataPoint.isSizeIsNull();
    }
}

