/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.gauge.glyph;

import com.fr.chart.base.TextAttr;
import com.fr.general.FRFont;
import com.fr.plugin.chart.base.AttrLabel;
import com.fr.plugin.chart.gauge.GaugeDetailStyle;
import com.fr.plugin.chart.gauge.glyph.GaugeGlyph;
import com.fr.plugin.chart.gauge.glyph.GaugeGlyphHelper;
import com.fr.plugin.chart.glyph.axis.VanChartGaugeAxisGlyph;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;

public class RingGaugeGlyph
extends GaugeGlyph {
    private static final long serialVersionUID = -6367293164920991590L;
    private static final double INNER_BACKGROUND = 0.8;
    private Color valueColor = Color.black;
    private double percentLabelCenterY;
    private double valueLabelCenterY;

    public RingGaugeGlyph(Rectangle2D rectangle2D, AttrLabel attrLabel, GaugeDetailStyle gaugeDetailStyle, VanChartGaugeAxisGlyph vanChartGaugeAxisGlyph) {
        super(rectangle2D, attrLabel, gaugeDetailStyle, vanChartGaugeAxisGlyph);
    }

    @Override
    public void doLayout(double d, int n) {
        super.doLayout(d, n);
        if (this.attrLabel != null && this.attrLabel.isEnable()) {
            boolean bl = this.attrLabel.getAttrLabelDetail().getContent().hasLabelContent();
            boolean bl2 = this.attrLabel.getGaugeValueLabelDetail().getContent().hasLabelContent();
            double d2 = GaugeGlyphHelper.calculateOneLineHeight(this.attrLabel.getGaugeValueLabelDetail().getTextAttr().getFRFont());
            if (bl && bl2) {
                double d3 = d + d / 2.0 + d2;
                this.percentLabelCenterY = this.centerPoint.getY() - d3 / 2.0 + d / 2.0;
                this.valueLabelCenterY = this.percentLabelCenterY + d + d2 / 2.0;
            } else {
                this.percentLabelCenterY = this.centerPoint.getY();
                this.valueLabelCenterY = this.centerPoint.getY();
            }
        }
    }

    @Override
    protected void drawInfo(Graphics2D graphics2D, int n) {
        this.drawPaneBackground(graphics2D);
        this.drawPaneBorder(graphics2D);
        this.drawValueArc(graphics2D);
        this.drawInnerPaneBackground(graphics2D);
        this.drawInnerPaneBorder(graphics2D);
        this.drawCateOrPercentageLabel(graphics2D, n);
        this.drawValueLabel(graphics2D, n);
    }

    private void drawPaneBorder(Graphics2D graphics2D) {
        GaugeGlyphHelper.drawCircleStroke(graphics2D, this.centerPoint, this.radius - 2.0, this.radius, new Color(0, 0, 0, 12));
    }

    private void drawValueArc(Graphics2D graphics2D) {
        if (this.valueList.isEmpty()) {
            return;
        }
        double d = this.gaugeAxisGlyph.getMinValue();
        double d2 = this.gaugeAxisGlyph.getMaxValue();
        double d3 = ((Number)this.valueList.get(0)).doubleValue();
        this.valueColor = this.getValueColor(d3, d, d2);
        if (d3 < d) {
            return;
        }
        double d4 = (double)this.extent / (d2 - d) * (d3 - d);
        if (!this.gaugeDetailStyle.isAntiClockWise()) {
            d4 = -d4;
        }
        GaugeGlyphHelper.drawArc(graphics2D, this.centerPoint, this.radius, this.startAngle, d4, this.valueColor);
    }

    private void drawInnerPaneBackground(Graphics2D graphics2D) {
        GaugeGlyphHelper.drawCircle(graphics2D, this.centerPoint, this.radius * 0.8, this.gaugeDetailStyle.getInnerPaneBackgroundColor());
    }

    private void drawInnerPaneBorder(Graphics2D graphics2D) {
        double d = this.radius * 0.8;
        GaugeGlyphHelper.drawCircleStroke(graphics2D, this.centerPoint, d, d + 4.0, new Color(0, 0, 0, 12));
        GaugeGlyphHelper.drawCircleShadeStroke(graphics2D, this.centerPoint, d - 3.0, d, new Color(221, 221, 221), new Color(255, 255, 255));
    }

    @Override
    protected void setCateOrPercentLabelAutoFont(TextAttr textAttr) {
        textAttr.setFRFont(FRFont.getInstance((String)"verdana", (int)1, (float)18.0f, (Color)this.valueColor));
    }

    @Override
    protected Rectangle2D getCateOrPercentLabelBounds(int n, Dimension2D dimension2D) {
        double d = this.centerPoint.getX() - dimension2D.getWidth() / 2.0;
        return new Rectangle2D.Double(d, this.percentLabelCenterY - dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
    }

    @Override
    protected Rectangle2D getValueLabelBounds(int n, Dimension2D dimension2D) {
        double d = this.centerPoint.getX() - dimension2D.getWidth() / 2.0;
        return new Rectangle2D.Double(d, this.valueLabelCenterY - dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
    }
}

