/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.designer.type;

import com.fr.base.chart.chartdata.model.DataProcessor;
import com.fr.base.chart.chartdata.model.LargeDataModel;
import com.fr.base.chart.chartdata.model.NormalDataModel;
import com.fr.chart.base.AttrFillStyle;
import com.fr.chart.chartattr.Chart;
import com.fr.chart.chartattr.Legend;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.chart.chartglyph.DataSheet;
import com.fr.design.gui.icheckbox.UICheckBox;
import com.fr.design.gui.ilable.MultilineLabel;
import com.fr.design.mainframe.chart.gui.type.AbstractChartTypePane;
import com.fr.design.mainframe.chart.gui.type.ChartImagePane;
import com.fr.general.Background;
import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.js.NameJavaScriptGroup;
import com.fr.plugin.chart.attr.VanChartZoom;
import com.fr.plugin.chart.vanchart.VanChart;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JPanel;

public abstract class AbstractVanChartTypePane
extends AbstractChartTypePane {
    private static final long serialVersionUID = 7743244512351499265L;
    private UICheckBox largeModelCheckBox;

    protected String[] getTypeLayoutPath() {
        return new String[0];
    }

    protected String[] getTypeLayoutTipName() {
        return new String[0];
    }

    protected Component[][] getComponentsWithLargeData(JPanel jPanel) {
        this.largeModelCheckBox = new UICheckBox(Inter.getLocText((String)"Plugin-ChartF_OpenLargeDataModel"));
        MultilineLabel multilineLabel = new MultilineLabel(Inter.getLocText((String)"Plugin-ChartF_LargeDataModelPrompt"));
        multilineLabel.setForeground(Color.red);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.largeModelCheckBox, "Center");
        jPanel2.add((Component)multilineLabel, "South");
        return new Component[][]{{jPanel}, {this.stylePane}, {jPanel2}};
    }

    public void updateBean(Chart chart) {
        this.checkTypeChange();
        Plot plot = chart.getPlot();
        Plot plot2 = this.getSelectedClonedPlot();
        boolean bl = this.accept(chart);
        if (this.typeChanged && bl) {
            this.cloneOldPlot2New(plot, plot2);
            chart.setPlot(plot2);
        } else if (!bl) {
            chart.setPlot(plot2);
            if (plot2.isSupportZoomDirection() && !plot2.isSupportZoomCategoryAxis()) {
                ((VanChart)chart).setVanChartZoom(new VanChartZoom());
            }
            chart.setDataProcessor((DataProcessor)new NormalDataModel());
        }
    }

    protected void checkTypeChange() {
        for (int i = 0; i < this.typeDemo.size(); ++i) {
            if (((ChartImagePane)this.typeDemo.get((int)i)).isPressing && i != this.lastTypeIndex) {
                this.typeChanged = true;
                this.lastTypeIndex = i;
                break;
            }
            this.typeChanged = false;
        }
    }

    protected void cloneOldPlot2New(Plot plot, Plot plot2) {
        try {
            if (plot.getLegend() != null) {
                plot2.setLegend((Legend)plot.getLegend().clone());
            }
            this.cloneOldConditionCollection(plot, plot2);
            if (plot.getHotHyperLink() != null) {
                plot2.setHotHyperLink((NameJavaScriptGroup)plot.getHotHyperLink().clone());
            }
            if (plot.getPlotFillStyle() != null) {
                plot2.setPlotFillStyle((AttrFillStyle)plot.getPlotFillStyle().clone());
            }
            plot2.setPlotStyle(plot.getPlotStyle());
            if (plot.getDataSheet() != null) {
                plot2.setDataSheet((DataSheet)plot.getDataSheet().clone());
            }
            if (plot.getBackground() != null) {
                plot2.setBackground((Background)plot.getBackground().clone());
            }
            if (plot.getBorderColor() != null) {
                plot2.setBorderColor(plot.getBorderColor());
            }
            plot2.setBorderStyle(plot.getBorderStyle());
            plot2.setRoundRadius(plot.getRoundRadius());
            plot2.setAlpha(plot.getAlpha());
            plot2.setShadow(plot.isShadow());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRLogger.getLogger().error("Error in change plot");
        }
    }

    protected void cloneOldDefaultAttrConditionCollection(Plot plot, Plot plot2) throws CloneNotSupportedException {
        if (plot.getConditionCollection() != null) {
            ConditionCollection conditionCollection = new ConditionCollection();
            conditionCollection.setDefaultAttr((ConditionAttr)plot.getConditionCollection().getDefaultAttr().clone());
            plot2.setConditionCollection(conditionCollection);
        }
    }

    protected void cloneOldConditionCollection(Plot plot, Plot plot2) throws CloneNotSupportedException {
        if (plot.getConditionCollection() != null) {
            plot2.setConditionCollection((ConditionCollection)plot.getConditionCollection().clone());
        }
    }

    protected void populateLargeDataModel(Chart chart) {
        if (this.largeModelCheckBox != null && chart != null) {
            this.largeModelCheckBox.setSelected(chart.getDataProcessor().getMark() == 1);
        }
    }

    protected void updateLargeDataModel(Chart chart) {
        if (this.largeModelCheckBox != null && chart != null) {
            chart.setDataProcessor((DataProcessor)(this.largeModelCheckBox.isSelected() ? new LargeDataModel() : new NormalDataModel()));
        }
    }
}

