/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.designer.component.background;

import com.fr.base.background.ImageBackground;
import com.fr.chart.chartglyph.GeneralInfo;
import com.fr.design.dialog.BasicPane;
import com.fr.design.gui.frpane.UINumberDragPane;
import com.fr.design.gui.ibutton.UIToggleButton;
import com.fr.design.gui.icombobox.UIComboBox;
import com.fr.design.gui.ilable.UILabel;
import com.fr.design.layout.TableLayoutHelper;
import com.fr.design.mainframe.backgroundpane.BackgroundQuickPane;
import com.fr.design.mainframe.backgroundpane.ColorBackgroundQuickPane;
import com.fr.design.mainframe.backgroundpane.ImageBackgroundQuickPane;
import com.fr.design.mainframe.backgroundpane.NullBackgroundQuickPane;
import com.fr.general.Background;
import com.fr.general.Inter;
import com.fr.plugin.chart.designer.component.background.VanChartGradientPane;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VanChartBackgroundPane
extends BasicPane {
    private static final long serialVersionUID = 6955952013135176051L;
    private static final double ALPHA_V = 100.0;
    protected List<BackgroundQuickPane> paneList;
    protected UIComboBox typeComboBox;
    protected UINumberDragPane transparent;
    protected UIToggleButton shadow;
    protected JPanel centerPane;

    public VanChartBackgroundPane() {
        this.initComponents();
        double d = -2.0;
        double d2 = -1.0;
        double[] dArray = new double[]{d, d2};
        double[] dArray2 = new double[]{d, d, d, d, d};
        JPanel jPanel = TableLayoutHelper.createTableLayoutPane4Chart((String[])new String[]{"Background"}, (Component[][])this.getPaneComponents(), (double[])dArray2, (double[])dArray);
        this.setLayout(new BorderLayout());
        this.add(jPanel, "Center");
        this.add(new JSeparator(), "South");
    }

    protected void initComponents() {
        this.typeComboBox = new UIComboBox();
        final CardLayout cardLayout = new CardLayout();
        this.paneList = new ArrayList<BackgroundQuickPane>();
        this.initList();
        this.centerPane = new JPanel(cardLayout){

            @Override
            public Dimension getPreferredSize() {
                int n = VanChartBackgroundPane.this.typeComboBox.getSelectedIndex();
                return new Dimension(super.getPreferredSize().width, VanChartBackgroundPane.this.paneList.get((int)n).getPreferredSize().height);
            }
        };
        for (int i = 0; i < this.paneList.size(); ++i) {
            BackgroundQuickPane backgroundQuickPane = this.paneList.get(i);
            this.typeComboBox.addItem((Object)backgroundQuickPane.title4PopupWindow());
            this.centerPane.add((Component)backgroundQuickPane, backgroundQuickPane.title4PopupWindow());
        }
        this.typeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                cardLayout.show(VanChartBackgroundPane.this.centerPane, (String)VanChartBackgroundPane.this.typeComboBox.getSelectedItem());
                VanChartBackgroundPane.this.fireStateChanged();
            }
        });
        this.transparent = new UINumberDragPane(0.0, 100.0);
    }

    protected Component[][] getPaneComponents() {
        this.shadow = new UIToggleButton(Inter.getLocText((String)"plugin-ChartF_OpenShadow"));
        return new Component[][]{{this.typeComboBox, null}, {this.centerPane, null}, {new UILabel(Inter.getLocText((String)"Plugin-Chart_Alpha")), this.transparent}, {this.shadow, null}};
    }

    protected void initList() {
        this.paneList.add((BackgroundQuickPane)new NullBackgroundQuickPane());
        this.paneList.add((BackgroundQuickPane)new ColorBackgroundQuickPane());
        this.paneList.add((BackgroundQuickPane)new ImageBackgroundQuickPane(false));
        this.paneList.add((BackgroundQuickPane)new VanChartGradientPane());
    }

    private void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        ChangeEvent changeEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent((Object)this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    public String title4PopupWindow() {
        return "";
    }

    public void populate(GeneralInfo generalInfo) {
        if (generalInfo == null) {
            return;
        }
        Background background = generalInfo.getBackground();
        double d = (double)generalInfo.getAlpha() * 100.0;
        this.transparent.populateBean(Double.valueOf(d));
        if (this.shadow != null) {
            this.shadow.setSelected(generalInfo.isShadow());
        }
        for (int i = 0; i < this.paneList.size(); ++i) {
            BackgroundQuickPane backgroundQuickPane = this.paneList.get(i);
            if (!backgroundQuickPane.accept(background)) continue;
            backgroundQuickPane.populateBean(background);
            this.typeComboBox.setSelectedIndex(i);
            return;
        }
    }

    public void update(GeneralInfo generalInfo) {
        if (generalInfo == null) {
            generalInfo = new GeneralInfo();
        }
        generalInfo.setBackground(this.paneList.get(this.typeComboBox.getSelectedIndex()).updateBean());
        if (generalInfo.getBackground() instanceof ImageBackground) {
            ((ImageBackground)generalInfo.getBackground()).setLayout(2);
        }
        generalInfo.setAlpha((float)(this.transparent.updateBean() / 100.0));
        if (this.shadow != null) {
            generalInfo.setShadow(this.shadow.isSelected());
        }
    }
}

