/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.column;

import com.fr.chart.base.DataSeriesCondition;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.design.gui.frpane.UINumberDragPane;
import com.fr.design.gui.ibutton.UIButtonGroup;
import com.fr.design.gui.ilable.UILabel;
import com.fr.design.gui.ispinner.UISpinner;
import com.fr.design.layout.TableLayoutHelper;
import com.fr.design.mainframe.backgroundpane.ImageBackgroundQuickPane;
import com.fr.design.mainframe.chart.gui.ChartStylePane;
import com.fr.design.utils.gui.GUICoreUtils;
import com.fr.general.Inter;
import com.fr.plugin.chart.base.AttrSeriesImageBackground;
import com.fr.plugin.chart.column.VanChartColumnPlot;
import com.fr.plugin.chart.designer.TableLayout4VanChartHelper;
import com.fr.plugin.chart.designer.component.border.VanChartBorderPane;
import com.fr.plugin.chart.designer.component.border.VanChartBorderWithRadiusPane;
import com.fr.plugin.chart.designer.style.series.VanChartAbstractPlotSeriesPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class VanChartColumnSeriesPane
extends VanChartAbstractPlotSeriesPane {
    private static final long serialVersionUID = -8875943419420081420L;
    private UIButtonGroup<Integer> isFixedWidth;
    private UISpinner columnWidth;
    private UINumberDragPane categoryGap;
    private UINumberDragPane seriesGap;
    private UIButtonGroup<Integer> isFillWithImage;
    private ImageBackgroundQuickPane imagePane;

    public VanChartColumnSeriesPane(ChartStylePane chartStylePane, Plot plot) {
        super(chartStylePane, plot);
    }

    protected JPanel getContentInPlotType() {
        this.jSeparator = new JSeparator();
        double d = -2.0;
        double d2 = -1.0;
        double[] dArray = new double[]{d2};
        double[] dArray2 = new double[]{d, d, d, d, d, d, d, d, d, d};
        Component[][] componentArray = new Component[][]{{this.createStylePane()}, {new JSeparator()}, {this.createSeriesStylePane(new double[]{d, d}, new double[]{d, d2})}, {new JSeparator()}, {this.createBorderPane()}, {this.createStackedAndAxisPane()}, {this.jSeparator}, {this.createTrendLinePane()}};
        this.contentPane = TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray2, (double[])dArray);
        return this.contentPane;
    }

    @Override
    protected VanChartBorderPane createDiffBorderPane() {
        return new VanChartBorderWithRadiusPane();
    }

    private JPanel createSeriesStylePane(double[] dArray, double[] dArray2) {
        this.isFixedWidth = new UIButtonGroup(new String[]{Inter.getLocText((String)"Plugin-ChartF_YES"), Inter.getLocText((String)"Plugin-ChartF_NO")});
        this.columnWidth = new UISpinner(0.0, 1000.0, 1.0, 0.0);
        this.seriesGap = new UINumberDragPane(0.0, 100.0);
        this.categoryGap = new UINumberDragPane(0.0, 100.0);
        this.isFillWithImage = new UIButtonGroup(new String[]{Inter.getLocText((String)"Plugin-ChartF_YES"), Inter.getLocText((String)"Plugin-ChartF_NO")});
        this.imagePane = new ImageBackgroundQuickPane(false);
        Component[][] componentArray = new Component[][]{{new UILabel(Inter.getLocText((String)"Plugin-ChartF_Fixed_Column_Width")), this.isFixedWidth}, {null, this.columnWidth}};
        JPanel jPanel = TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray, (double[])dArray2);
        Component[][] componentArray2 = new Component[][]{{new UILabel(Inter.getLocText((String)"FR-Chart-Gap_Series")), this.seriesGap}, {new UILabel(Inter.getLocText((String)"FR-Chart-Gap_Category")), this.categoryGap}};
        JPanel jPanel2 = TableLayoutHelper.createTableLayoutPane((Component[][])componentArray2, (double[])dArray, (double[])dArray2);
        Component[][] componentArray3 = new Component[][]{{new UILabel(Inter.getLocText((String)"Plugin-ChartF_Filled_With_Image")), this.isFillWithImage}};
        JPanel jPanel3 = TableLayoutHelper.createTableLayoutPane((Component[][])componentArray3, (double[])dArray, (double[])dArray2);
        JPanel jPanel4 = new JPanel(new BorderLayout(0, 4));
        jPanel4.add((Component)jPanel, "North");
        jPanel4.add((Component)jPanel2, "Center");
        jPanel4.add((Component)jPanel3, "South");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jPanel4, "North");
        jPanel5.add((Component)this.imagePane, "Center");
        this.isFixedWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VanChartColumnSeriesPane.this.checkColumnWidth();
            }
        });
        this.isFillWithImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VanChartColumnSeriesPane.this.checkImagePane();
            }
        });
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String)"FR-Designer-Widget_Style"), jPanel5);
    }

    private void checkAll() {
        this.checkColumnWidth();
        this.checkImagePane();
    }

    private void checkColumnWidth() {
        this.columnWidth.setEnabled(this.isFixedWidth.getSelectedIndex() == 0);
    }

    private void checkImagePane() {
        GUICoreUtils.setEnabled((JComponent)this.imagePane, (this.isFillWithImage.getSelectedIndex() == 0 ? 1 : 0) != 0);
    }

    @Override
    public void populateBean(Plot plot) {
        if (plot == null) {
            return;
        }
        super.populateBean(plot);
        if (plot instanceof VanChartColumnPlot) {
            AttrSeriesImageBackground attrSeriesImageBackground;
            VanChartColumnPlot vanChartColumnPlot = (VanChartColumnPlot)plot;
            this.isFixedWidth.setSelectedIndex(vanChartColumnPlot.isFixedWidth() ? 0 : 1);
            this.columnWidth.setValue((double)vanChartColumnPlot.getColumnWidth());
            this.categoryGap.populateBean(Double.valueOf(vanChartColumnPlot.getCategoryIntervalPercent()));
            this.seriesGap.populateBean(Double.valueOf(vanChartColumnPlot.getSeriesOverlapPercent()));
            this.isFillWithImage.setSelectedIndex(vanChartColumnPlot.isFilledWithImage() ? 0 : 1);
            ConditionAttr conditionAttr = plot.getConditionCollection().getDefaultAttr();
            if (vanChartColumnPlot.isFilledWithImage() && (attrSeriesImageBackground = (AttrSeriesImageBackground)conditionAttr.getExisted(AttrSeriesImageBackground.class)) != null) {
                this.imagePane.populateBean(attrSeriesImageBackground.getSeriesBackground());
            }
        }
        this.checkAll();
    }

    @Override
    public void updateBean(Plot plot) {
        if (plot == null) {
            return;
        }
        super.updateBean(plot);
        if (plot instanceof VanChartColumnPlot) {
            VanChartColumnPlot vanChartColumnPlot = (VanChartColumnPlot)plot;
            vanChartColumnPlot.setFixedWidth(this.isFixedWidth.getSelectedIndex() == 0);
            vanChartColumnPlot.setColumnWidth((int)this.columnWidth.getValue());
            vanChartColumnPlot.setCategoryIntervalPercent(this.categoryGap.updateBean());
            vanChartColumnPlot.setSeriesOverlapPercent(this.seriesGap.updateBean());
            vanChartColumnPlot.setFilledWithImage(this.isFillWithImage.getSelectedIndex() == 0);
            ConditionAttr conditionAttr = plot.getConditionCollection().getDefaultAttr();
            if (this.isFillWithImage.getSelectedIndex() == 0) {
                AttrSeriesImageBackground attrSeriesImageBackground = (AttrSeriesImageBackground)conditionAttr.getExisted(AttrSeriesImageBackground.class);
                if (attrSeriesImageBackground == null) {
                    attrSeriesImageBackground = new AttrSeriesImageBackground();
                    conditionAttr.addDataSeriesCondition((DataSeriesCondition)attrSeriesImageBackground);
                }
                attrSeriesImageBackground.setSeriesBackground(this.imagePane.updateBean());
            } else {
                AttrSeriesImageBackground attrSeriesImageBackground = (AttrSeriesImageBackground)conditionAttr.getExisted(AttrSeriesImageBackground.class);
                if (attrSeriesImageBackground != null) {
                    conditionAttr.remove((DataSeriesCondition)attrSeriesImageBackground);
                }
            }
        }
    }
}

