/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.bar;

import com.fr.chart.base.ChartConstants;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.chart.chartattr.Chart;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.data.condition.AbstractCondition;
import com.fr.data.condition.CommonCondition;
import com.fr.data.condition.ListCondition;
import com.fr.general.Inter;
import com.fr.general.data.Condition;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.attr.VanChartPlotType;
import com.fr.plugin.chart.attr.axis.VanChartAxis;
import com.fr.plugin.chart.base.AttrSeriesStackAndAxis;
import com.fr.plugin.chart.column.VanChartColumnPlot;
import com.fr.plugin.chart.vanchart.AbstractIndependentVanChartProvider;
import com.fr.plugin.chart.vanchart.VanChart;

public class BarIndependentVanChart
extends AbstractIndependentVanChartProvider {
    public static Chart[] BarVanChartTypes = new Chart[]{BarIndependentVanChart.createVanChartBar(VanChartPlotType.NORMAL), BarIndependentVanChart.createVanChartBar(VanChartPlotType.STACK), BarIndependentVanChart.createVanChartBar(VanChartPlotType.STACK_BY_PERCENT), BarIndependentVanChart.createVanChartBar(VanChartPlotType.CUSTOM)};

    public String getChartName() {
        return "Plugin-ChartF_NewBar";
    }

    public Chart[] getChartTypes() {
        return BarVanChartTypes;
    }

    private static Chart createVanChartBar(VanChartPlotType vanChartPlotType) {
        VanChartColumnPlot vanChartColumnPlot = new VanChartColumnPlot(true, vanChartPlotType);
        BarIndependentVanChart.createDefaultPlotStyleAttr(vanChartColumnPlot);
        BarIndependentVanChart.createDefaultCondition(vanChartColumnPlot);
        VanChartAxis vanChartAxis = vanChartColumnPlot.getDefaultXAxis();
        if (vanChartColumnPlot.isCustomChart()) {
            BarIndependentVanChart.createDefaultStackAndAxisCondition(vanChartColumnPlot);
        } else if (vanChartColumnPlot.isPercentStackChart()) {
            BarIndependentVanChart.setDefaultAxisPercentAndFormat(vanChartAxis);
        }
        vanChartAxis.setMainGridColor(VanChartAttrHelper.DEFAULT_MAIN_GRID_COLOR);
        return new VanChart(vanChartColumnPlot);
    }

    private static void createDefaultStackAndAxisCondition(VanChartColumnPlot vanChartColumnPlot) {
        vanChartColumnPlot.getXAxisList().add(VanChartAttrHelper.createDefaultBarX2Axis());
        ConditionCollection conditionCollection = new ConditionCollection();
        ConditionAttr conditionAttr = new ConditionAttr();
        conditionAttr.setName(Inter.getLocText((String)"Plugin-ChartF_StackAndSeries") + "1");
        ListCondition listCondition = new ListCondition();
        listCondition.addJoinCondition(0, (Condition)new CommonCondition(ChartConstants.SERIES_INDEX, 0, (Object)new Integer(2)));
        listCondition.addJoinCondition(1, (Condition)new CommonCondition(ChartConstants.SERIES_INDEX, 0, (Object)new Integer(3)));
        conditionAttr.setCondition((AbstractCondition)listCondition);
        conditionCollection.addConditionAttr(conditionAttr);
        AttrSeriesStackAndAxis attrSeriesStackAndAxis = new AttrSeriesStackAndAxis();
        conditionAttr.addDataSeriesCondition((DataSeriesCondition)attrSeriesStackAndAxis);
        attrSeriesStackAndAxis.setXAxisIndex(1);
        attrSeriesStackAndAxis.setYAxisIndex(0);
        attrSeriesStackAndAxis.setStacked(true);
        attrSeriesStackAndAxis.setPercentStacked(false);
        vanChartColumnPlot.setStackAndAxisCondition(conditionCollection);
    }

    private static void createDefaultCondition(VanChartColumnPlot vanChartColumnPlot) {
        ConditionAttr conditionAttr = vanChartColumnPlot.getConditionCollection().getDefaultAttr();
        BarIndependentVanChart.createDefaultTooltipCondition(conditionAttr, vanChartColumnPlot);
        BarIndependentVanChart.createDefaultSeriesBorderCondition(conditionAttr);
    }
}

