/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.web;

import com.fr.data.dao.page.Page;
import com.fr.data.dao.page.PageConfiguration;
import com.fr.fs.control.UserControl;
import com.fr.fs.schedule.ScheduleContext;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.schedule.task.ScheduleTask;
import com.fr.stable.StringUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleGetAllTasksAction
extends ActionNoSessionCMD {
    public String getCMD() {
        return "get_all_tasks";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 16L)) {
            throw new NoPrivilegeException();
        }
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"start");
        String string2 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"count");
        int n = 0;
        int n2 = 0;
        if (StringUtils.isNotEmpty((String)string)) {
            n = Integer.valueOf(string);
        }
        if (StringUtils.isNotEmpty((String)string2)) {
            n2 = Integer.valueOf(string2);
        }
        PageConfiguration pageConfiguration = new PageConfiguration(n, n2);
        JSONObject jSONObject = this.getTaskInfo(pageConfiguration);
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        printWriter.print(jSONObject.toString());
        printWriter.flush();
        printWriter.close();
    }

    private JSONObject getTaskInfo(PageConfiguration pageConfiguration) throws Exception {
        JSONObject jSONObject = JSONObject.create();
        Page<ScheduleTask> page = this.getTasksByPage(pageConfiguration);
        JSONArray jSONArray = JSONArray.create();
        List list = page.getPageResult();
        for (ScheduleTask scheduleTask : list) {
            jSONArray.put((Object)scheduleTask.createJSONConfig());
        }
        jSONObject.put("total", page.getTotal());
        jSONObject.put("tasks", (Object)jSONArray);
        return jSONObject;
    }

    private Page<ScheduleTask> getTasksByPage(PageConfiguration pageConfiguration) throws JSONException {
        return ScheduleContext.createDAOSession().list(ScheduleTask.class, pageConfiguration);
    }
}

