/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.output;

import com.fr.schedule.output.impl.ExcelOutput;
import com.fr.schedule.output.impl.PdfOutput;
import com.fr.schedule.output.impl.WordOutput;
import com.fr.schedule.plugin.ExtraPlatformScheduleClassManager;
import com.fr.schedule.plugin.OutputFormatProvider;
import com.fr.stable.plugin.event.AutoRegisterPluginActiveListener;
import com.fr.stable.plugin.event.PluginChangeEvent;
import java.util.LinkedHashSet;
import java.util.Set;

public class OutputFormatFactory {
    public static final int CONVERT_TO_EXCEL = 1;
    public static final int CONVERT_TO_PDF = 2;
    public static final int CONVERT_TO_WORD = 4;
    private static final int MINIMAL_MARK_NUM = 8;
    private static final int ZERO_ASCII = 48;
    private static Set<OutputFormatProvider> set = new LinkedHashSet<OutputFormatProvider>();

    private static synchronized void load() {
        set.add(new ExcelOutput());
        set.add(new PdfOutput());
        set.add(new WordOutput());
        Set set = ExtraPlatformScheduleClassManager.getInstance().getArray("OutputFormatProvider");
        for (OutputFormatProvider outputFormatProvider : set) {
            int n = outputFormatProvider.markNumber();
            if (n < 8 || !OutputFormatFactory.isTwoN(n)) {
                throw new RuntimeException("Error to load schedule output format plugin!");
            }
            OutputFormatFactory.set.add(outputFormatProvider);
        }
    }

    public static synchronized OutputFormatProvider[] getOutputFormatProviderArray() {
        return set.toArray(new OutputFormatProvider[set.size()]);
    }

    public static boolean isTwoN(int n) {
        boolean bl = true;
        String string = Integer.toBinaryString(n);
        byte[] byArray = string.getBytes();
        for (int i = 1; i < byArray.length; ++i) {
            if (byArray[i] == 48) continue;
            bl = false;
            break;
        }
        return bl;
    }

    static {
        OutputFormatFactory.load();
        new AutoRegisterPluginActiveListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void pluginActiveStateChanged(PluginChangeEvent pluginChangeEvent) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    set.clear();
                    OutputFormatFactory.load();
                }
            }

            public int priority() {
                return 0;
            }

            protected AutoRegisterPluginActiveListener.RegisterInfo registerInfo() {
                return new AutoRegisterPluginActiveListener.RegisterInterface(new String[]{"OutputFormatProvider"});
            }
        };
    }
}

