/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.cache.Attachment;
import com.fr.data.cache.AttachmentCacheManager;
import com.fr.fs.cache.EntryCacheImpl;
import com.fr.fs.control.EntryControl;
import com.fr.fs.control.EntryPoolFactory;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.platform.entry.BaseEntry;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.FRLogger;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSMainSetReportCoverAction
extends ActionNoSessionCMD {
    private static final String FOLDER = "folder";
    private static final String REPORT = "report";
    private static final String LINK = "link";
    private static final String PROCESS_TYPE = "processType";
    private static final String BI_REPORT = "bireport";
    private static final String DEL = "del";

    public String getCMD() {
        return "set_report_cover";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 2L)) {
            throw new NoPrivilegeException();
        }
        boolean bl = true;
        try {
            object = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)FOLDER);
            this.saveEntryCover(httpServletRequest, (String)object, EntryPoolFactory.getEntry(FOLDER), l);
            String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)REPORT);
            this.saveEntryCover(httpServletRequest, string, EntryPoolFactory.getEntry(REPORT), l);
            String string2 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)LINK);
            this.saveEntryCover(httpServletRequest, string2, EntryPoolFactory.getEntry(LINK), l);
            String string3 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)PROCESS_TYPE);
            this.saveEntryCover(httpServletRequest, string3, EntryPoolFactory.getEntry(PROCESS_TYPE), l);
            String string4 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)BI_REPORT);
            this.saveEntryCover(httpServletRequest, string4, EntryPoolFactory.getEntry(BI_REPORT), l);
            String string5 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)DEL);
            this.deleteOldImages(httpServletRequest, string5);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
            bl = false;
        }
        object = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        ((PrintWriter)object).write(bl + "");
        ((PrintWriter)object).flush();
        ((PrintWriter)object).close();
    }

    private void saveEntryCover(HttpServletRequest httpServletRequest, String string, BaseEntry baseEntry, long l) throws Exception {
        if (baseEntry == null) {
            return;
        }
        JSONObject jSONObject = new JSONObject(string);
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = jSONObject.getString(string2);
            long l2 = Long.parseLong(string2.substring(baseEntry.getTypePrefix().length()));
            int n = baseEntry.getEntryType();
            BaseEntry baseEntry2 = (BaseEntry)EntryCacheImpl.getInstance().getCacheEntry(n, l2);
            baseEntry2.setMobileCoverId(string3);
            EntryControl.getInstance().checkSaveOrUpdateEntryPrivilege(baseEntry2, l);
            EntryControl.getInstance().saveOrUpdateEntry(baseEntry2);
            if (string3.length() <= 1) continue;
            this.saveCoverImageById(httpServletRequest, string3);
        }
    }

    private void saveCoverImageById(HttpServletRequest httpServletRequest, String string) throws Exception {
        Attachment attachment = AttachmentCacheManager.getAttachment((String)string);
        if (attachment != null) {
            byte[] byArray = attachment.getBytes();
            String string2 = httpServletRequest.getSession().getServletContext().getRealPath("/");
            string2 = StableUtils.pathJoin((String[])new String[]{string2, "WEB-INF", "resources", "mobile", "cover"});
            File file = new File(string2);
            String string3 = StableUtils.pathJoin((String[])new String[]{string2, string});
            if (!file.exists() && !file.isDirectory()) {
                file.mkdirs();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            ((OutputStream)fileOutputStream).write(byArray);
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
        }
    }

    private void deleteOldImages(HttpServletRequest httpServletRequest, String string) throws Exception {
        JSONArray jSONArray = new JSONArray(string);
        for (int i = 0; i < jSONArray.length(); ++i) {
            String string2 = jSONArray.getString(i);
            String string3 = httpServletRequest.getSession().getServletContext().getRealPath("/");
            File file = new File(string3 = StableUtils.pathJoin((String[])new String[]{string3, "WEB-INF", "resources", "mobile", "cover", string2}));
            if (!file.isFile() || !file.exists()) continue;
            file.delete();
        }
    }
}

