/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.platform.entry;

import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.CommonFieldColumnMapper;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.data.dao.PrimaryKeyFCMapper;
import com.fr.fs.web.platform.entry.BaseEntry;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;

public class FileEntry
extends BaseEntry {
    public static final String TYPE_PREFIX = "1";
    public static final String TABLE_NAME = "fr_fileentry";
    public static final String PATH = "path";
    public static final int PATHTYPE = 4;
    private String path;
    public static final ObjectTableMapper TABLE_MAPPER = new ObjectTableMapper(FileEntry.class, new Table("fr_fileentry"), new FieldColumnMapper[]{new PrimaryKeyFCMapper("id", 4, new ColumnSize(10)), new CommonFieldColumnMapper("parentId", 4, "parent", new ColumnSize(10), false), new CommonFieldColumnMapper("displayName", 12, "name", new ColumnSize(255), false), new CommonFieldColumnMapper("path", 12, "uri", new ColumnSize(255), false), new CommonFieldColumnMapper("description", 12, "description", new ColumnSize(255), true), new CommonFieldColumnMapper("sortindex", -5, "sortindex", new ColumnSize(10), true)}, 0);

    public FileEntry() {
    }

    public FileEntry(String string) {
        super(string);
    }

    public FileEntry(String string, String string2, String string3) {
        super(string, string2);
        this.path = string3;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getPath() {
        return this.path;
    }

    public JSONObject createShowJSONConfig() throws JSONException {
        JSONObject jSONObject = super.createJSONConfig();
        jSONObject.put("nodeicon", (Object)this.getNodeIcon());
        return jSONObject;
    }

    public JSONObject createJSONConfig() throws JSONException {
        JSONObject jSONObject = this.createShowJSONConfig();
        jSONObject.put(PATH, (Object)this.getPath());
        return jSONObject;
    }

    private String getNodeIcon() {
        if (this.getDisplayName().endsWith(".adr")) {
            return "adr";
        }
        if (this.getDisplayName().endsWith(".cpt")) {
            return "cpt";
        }
        if (this.getDisplayName().endsWith(".cpr")) {
            return "cpr";
        }
        if (this.getDisplayName().endsWith(".xls")) {
            return "excel";
        }
        if (this.getDisplayName().endsWith(".doc")) {
            return "word";
        }
        if (this.getDisplayName().endsWith(".pdf")) {
            return "pdf";
        }
        if (this.getDisplayName().endsWith(".ad")) {
            return "analy";
        }
        return "cpr";
    }

    protected String getRealDisplayName() {
        String string = this.getDisplayName();
        if (this.needRemovePrefix(string)) {
            return string.substring(0, string.lastIndexOf("."));
        }
        return string;
    }

    private boolean needRemovePrefix(String string) {
        return string.endsWith(".cpt") || string.endsWith(".cpr") || string.endsWith(".adr") || string.endsWith(".ad");
    }

    protected int hashCode4Properties() {
        int n = 31;
        int n2 = super.hashCode4Properties();
        n2 = 31 * n2 + (this.path == null ? 0 : this.path.hashCode());
        return n2;
    }

    public boolean equals4Properties(Object object) {
        if (!(object instanceof FileEntry)) {
            return false;
        }
        return super.equals4Properties(object) && ComparatorUtils.equals((String)this.path, (String)((FileEntry)object).path);
    }

    public Object clone() throws CloneNotSupportedException {
        FileEntry fileEntry = (FileEntry)super.clone();
        return fileEntry;
    }

    public String getTypePrefix() {
        return TYPE_PREFIX;
    }

    public void parseJSON(JSONObject jSONObject) throws JSONException {
        super.parseJSON(jSONObject);
        this.setPath(jSONObject.getString(PATH));
    }

    public int getEntryType() {
        return 1;
    }

    public boolean isCpr() {
        return this.path.endsWith(".cpr");
    }
}

