/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.systemmonitor.service;

import com.fr.base.ConfigManager;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.Select;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.dml.Where;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.DateUtils;
import com.fr.general.FRLevel;
import com.fr.general.FRLogger;
import com.fr.general.LogConfig;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.record.DBRecordManager;
import com.fr.stable.StringUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerConfigGetLogInfoAction
extends ActionNoSessionCMD {
    private static final int TIMESPLITLENGTH = 19;
    private static final int OMISSIONLENGTH = 35;

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        List<LogInfo> list;
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 9L)) {
            throw new NoPrivilegeException();
        }
        JSONObject jSONObject = new JSONObject();
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        LogConfig logConfig = ConfigManager.getProviderInstance().getLogConfig();
        jSONObject.put("isRecordToLogDB", logConfig.isRecordToLogDB());
        String string = String.valueOf(FRLevel.getByLevel((Level)ConfigManager.getProviderInstance().getServerLogLevel()));
        jSONObject.put("loglevel", (Object)string);
        String string2 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"startTime");
        String string3 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"endTime");
        if (StringUtils.isNotBlank((String)string3)) {
            list = Calendar.getInstance();
            ((Calendar)((Object)list)).setTime(DateUtils.string2Date((String)string3, (boolean)false));
            ((Calendar)((Object)list)).set(5, ((Calendar)((Object)list)).get(5) + 1);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            string3 = simpleDateFormat.format(((Calendar)((Object)list)).getTime());
        }
        list = this.getFilterLogInfoList(string2, string3);
        int n = WebUtils.getHTTPRequestIntParameter((HttpServletRequest)httpServletRequest, (String)"pn");
        int n2 = WebUtils.getHTTPRequestIntParameter((HttpServletRequest)httpServletRequest, (String)"pageCount");
        int n3 = (n - 1) * n2;
        int n4 = Math.min(n * n2, list.size());
        int n5 = list.size() / n2 + 1;
        if (n4 != 0) {
            list = list.subList(n3, n4);
        }
        this.generateRes(jSONObject, list, n5);
        printWriter.print(jSONObject);
        printWriter.flush();
        printWriter.close();
    }

    private void generateRes(JSONObject jSONObject, List<LogInfo> list, int n) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (LogInfo logInfo : list) {
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("reportname", (Object)logInfo.getReportname());
            String string = String.valueOf(logInfo.getLogtime());
            string = string.length() > 19 ? string.substring(0, 19) : string;
            jSONObject2.put("logtime", (Object)string);
            String string2 = String.valueOf(logInfo.getError());
            String string3 = null;
            if (StringUtils.isNotEmpty((String)string2) && string2.length() > 35) {
                string3 = string2.substring(0, 35);
                string3 = string3 + "...";
            } else {
                string3 = string2;
            }
            String string4 = String.valueOf(logInfo.getDetailError());
            jSONObject2.put("detailError", (Object)(StringUtils.isEmpty((String)string4) ? string2 : string4));
            jSONObject2.put("detailError", (Object)string2);
            jSONObject2.put("error", (Object)string3);
            jSONArray.put((Object)jSONObject2);
        }
        jSONObject.put("items", (Object)jSONArray);
        jSONObject.put("totalpages", n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LogInfo> getLogInfo(String string, String string2) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (StringUtils.isBlank((String)string)) {
            string = "1970-01-01 00:00:00";
        }
        if (StringUtils.isBlank((String)string2)) {
            string2 = simpleDateFormat.format(new Date());
        }
        Date date = simpleDateFormat.parse(string);
        Date date2 = simpleDateFormat.parse(string2);
        Connection connection = DBRecordManager.getDB().createConnection();
        Select select = this.getSelectSQL(date, date2, connection);
        ArrayList<LogInfo> arrayList = new ArrayList<LogInfo>();
        try {
            preparedStatement = select.createPreparedStatement(connection);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(new LogInfo(resultSet.getString("trace"), resultSet.getString("tname"), resultSet.getTimestamp("logtime"), resultSet.getString("msg")));
            }
        }
        catch (SQLException sQLException) {
            try {
                FRLogger.getLogger().error(sQLException.getMessage(), (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement((Statement)preparedStatement);
                DBUtils.closeConnection((Connection)connection);
                throw throwable;
            }
            DBUtils.closeResultSet((ResultSet)resultSet);
            DBUtils.closeStatement((Statement)preparedStatement);
            DBUtils.closeConnection((Connection)connection);
        }
        DBUtils.closeResultSet((ResultSet)resultSet);
        DBUtils.closeStatement((Statement)preparedStatement);
        DBUtils.closeConnection((Connection)connection);
        return arrayList;
    }

    private List<LogInfo> getFilterLogInfoList(String string, String string2) throws Exception {
        List<LogInfo> list = this.getLogInfo(string, string2);
        ArrayList<LogInfo> arrayList = new ArrayList<LogInfo>();
        for (LogInfo logInfo : list) {
            if (logInfo.getError() == null) continue;
            arrayList.add(logInfo);
        }
        return arrayList;
    }

    private Select getSelectSQL(Date date, Date date2, Connection connection) throws Exception {
        try {
            Where where = new Where();
            where.addColumn("logtime", 93, 3, (Object)date);
            where.addColumn("logtime", 93, 5, (Object)date2);
            Select select = new Select(new Table("fr_errrecord"), where, DialectFactory.generateDialect((Connection)connection));
            select.addOrderBy("logtime", false);
            return select;
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    public String getCMD() {
        return "sc_get_loginfo";
    }

    private class LogInfo {
        private String reportname;
        private String detailError;
        private String error;
        private Date logtime;

        public LogInfo(String string, String string2, Date date, String string3) {
            this.reportname = string2;
            this.detailError = string;
            this.error = string3;
            this.logtime = date;
        }

        public String getReportname() {
            return this.reportname;
        }

        public Date getLogtime() {
            return this.logtime;
        }

        public String getDetailError() {
            return this.detailError;
        }

        public String getError() {
            return this.error;
        }
    }
}

