/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache.tabledata;

import com.fr.base.FRContext;
import com.fr.cluster.rpc.RPC;
import com.fr.data.dao.ClassArrayKey;
import com.fr.data.dao.DAOBean;
import com.fr.data.dao.RelationObject;
import com.fr.data.impl.EmbeddedTableData;
import com.fr.file.BaseClusterHelper;
import com.fr.fs.FSContext;
import com.fr.fs.PlateFactory;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CompanyRoleDataConnectionPrivilege;
import com.fr.fs.base.entity.CompanyRoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.CompanyRoleESPrivilege;
import com.fr.fs.base.entity.CompanyRoleEntryPrivilege;
import com.fr.fs.base.entity.CompanyRoleHomePagePrivilege;
import com.fr.fs.base.entity.CompanyRoleModulePrivilege;
import com.fr.fs.base.entity.CompanyRoleTemplatePrivilege;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.CustomRoleDataConnectionPrivilege;
import com.fr.fs.base.entity.CustomRoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.CustomRoleESPrivilege;
import com.fr.fs.base.entity.CustomRoleEntryPrivilege;
import com.fr.fs.base.entity.CustomRoleHomePagePrivilege;
import com.fr.fs.base.entity.CustomRoleModulePrivilege;
import com.fr.fs.base.entity.CustomRoleTemplatePrivilege;
import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.FavoriteNode;
import com.fr.fs.base.entity.Post;
import com.fr.fs.base.entity.RoleDataConnectionPrivilege;
import com.fr.fs.base.entity.RoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.RoleESPrivilege;
import com.fr.fs.base.entity.RoleEntryPrivilege;
import com.fr.fs.base.entity.RoleHomePagePrivilege;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.base.entity.User;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.cache.Job;
import com.fr.fs.cache.tabledata.TableDataDAOBean;
import com.fr.fs.cache.tabledata.TableDataFavoriteNode;
import com.fr.fs.cache.tabledata.TableDataJRole;
import com.fr.fs.cache.tabledata.TableDataPersistenceAction;
import com.fr.fs.cache.tabledata.TableDataSRole_User;
import com.fr.fs.cache.tabledata.TableDataSyncAndPersistenceThreadHolder;
import com.fr.fs.cache.tabledata.TableDataSyncDBProvider;
import com.fr.fs.cache.tabledata.TableDataUser;
import com.fr.fs.control.dao.tabledata.TableDataDAOControl;
import com.fr.fs.web.FSConstants;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralContext;
import com.fr.general.GeneralUtils;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.Primitive;
import com.fr.stable.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableDataSyncDB
implements TableDataSyncDBProvider {
    private static final long DEFAULT_PID = -1L;
    public static final long SYNCROLEIDSTARTINGID = -1000L;
    private static Department ALL_DEPARTMENT = new Department(0L, FSConstants.COMPANYROLE.DEPARTMENT_ALL_NAME, "", -2L);
    private static TableDataSyncDBProvider tableDataSyncDB;
    private long postId = 1L;
    private long depId = 1L;
    private long custRoleId = -1000L;
    private long custRoleIdManualAdd = 1L;
    private long comRoleId = 1L;
    private long userId = 1L;
    private long customRoleUserId = 1L;
    private Map<Long, List<CompanyRole>> companyRoleAndUserIdRelationMap = new ConcurrentHashMap<Long, List<CompanyRole>>();
    private Map<Long, List<Long>> customRoleAndUserIdRelationMap = new ConcurrentHashMap<Long, List<Long>>();
    private final Map<Long, TableDataUser> tdUser_idListMap = new ConcurrentHashMap<Long, TableDataUser>();
    private Map<String, TableDataUser> tdUser_NameListMap = new ConcurrentHashMap<String, TableDataUser>();
    private Map<Long, Department> dp_idMap = new ConcurrentHashMap<Long, Department>();
    private Map<String, Department> dp_nameMap = new ConcurrentHashMap<String, Department>();
    private Map<String, Department> dpAndParentDpNameMap = new ConcurrentHashMap<String, Department>();
    private Map<String, Long> id_postMap = new ConcurrentHashMap<String, Long>();
    private Map<Long, CustomRole> customRoleIDListMap = new ConcurrentHashMap<Long, CustomRole>();
    private final Map<String, CustomRole> customRoleNameListMap = new ConcurrentHashMap<String, CustomRole>();
    private final Map<Long, TableDataSRole_User> customRoleUserIDMap = new ConcurrentHashMap<Long, TableDataSRole_User>();
    private final Map<Long, RoleEntryPrivilege> customRolePrivilegeIDMap = new Hashtable<Long, RoleEntryPrivilege>();
    private final Map<Long, RoleESPrivilege> customRoleESPrivilegeIDMap = new Hashtable<Long, RoleESPrivilege>();
    private final Map<Long, RoleModulePrivilege> customRoleModuleIDMap = new Hashtable<Long, RoleModulePrivilege>();
    private final Map<Long, RoleHomePagePrivilege> customRoleHomePageIDMap = new Hashtable<Long, RoleHomePagePrivilege>();
    private final Map<String, Map<Long, RoleEntryPrivilege>> customRolePlateIDMap = new ConcurrentHashMap<String, Map<Long, RoleEntryPrivilege>>();
    private final Map<Long, RoleDepAndCRolePrivilege> customRoleDepAndCRoleIDMap = new ConcurrentHashMap<Long, RoleDepAndCRolePrivilege>();
    private final Map<Long, RoleTemplatePrivilege> customRoleTemplateIDMap = new ConcurrentHashMap<Long, RoleTemplatePrivilege>();
    private final Map<Long, RoleDataConnectionPrivilege> customRoleDataConnectionIDMap = new ConcurrentHashMap<Long, RoleDataConnectionPrivilege>();
    private final Map<Long, TableDataJRole> companyRoleIDListMap = new ConcurrentHashMap<Long, TableDataJRole>();
    private final Map<Long, RoleEntryPrivilege> companyRolePrivilegeIDMap = new Hashtable<Long, RoleEntryPrivilege>();
    private final Map<Long, RoleESPrivilege> companyRoleESPrivilegeIDMap = new Hashtable<Long, RoleESPrivilege>();
    private final Map<Long, RoleModulePrivilege> companyRoleModuleIDMap = new Hashtable<Long, RoleModulePrivilege>();
    private final Map<Long, RoleHomePagePrivilege> companyRoleHomePageIDMap = new Hashtable<Long, RoleHomePagePrivilege>();
    private final Map<String, Map<Long, RoleEntryPrivilege>> companyRolePlateIDMap = new ConcurrentHashMap<String, Map<Long, RoleEntryPrivilege>>();
    private final Map<Long, RoleDepAndCRolePrivilege> companyRoleDepAndCRoleIDMap = new ConcurrentHashMap<Long, RoleDepAndCRolePrivilege>();
    private final Map<Long, RoleTemplatePrivilege> companyRoleTemplateIDMap = new ConcurrentHashMap<Long, RoleTemplatePrivilege>();
    private final Map<Long, RoleDataConnectionPrivilege> companyRoleDataConnectionIDMap = new ConcurrentHashMap<Long, RoleDataConnectionPrivilege>();
    private final Map<Long, TableDataFavoriteNode> tdFavorite_idMap = new Hashtable<Long, TableDataFavoriteNode>();
    private Map<Long, Set<RelationObject>> roleObjSet_idMap = new Hashtable<Long, Set<RelationObject>>();
    private Map<Long, Set<RelationObject>> roleNonObjSet_idMap = new Hashtable<Long, Set<RelationObject>>();
    private static long reInitTime;
    private final Object lock = new Object();

    public static synchronized TableDataSyncDBProvider getInstance() {
        if (tableDataSyncDB == null) {
            TableDataSyncDB.initSyncDB();
        }
        return tableDataSyncDB;
    }

    private static synchronized void initSyncDB() {
        switch (BaseClusterHelper.getClusterState()) {
            case LEADER: {
                tableDataSyncDB = new TableDataSyncDB();
                RPC.registerSkeleton((Object)tableDataSyncDB);
                break;
            }
            case MEMBER: {
                String string = BaseClusterHelper.getMainServiceIP();
                tableDataSyncDB = (TableDataSyncDBProvider)RPC.getProxy(TableDataSyncDB.class, (String)string);
                break;
            }
            default: {
                tableDataSyncDB = new TableDataSyncDB();
            }
        }
    }

    @Override
    public void reinit() throws Exception {
        try {
            this.initCustomRole();
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        try {
            this.addDepartOrPostAll();
            this.initCompanyRole();
            this.initPostAndDepartmentAndTableUser();
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        try {
            this.initCompanyRolePrivilege();
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        try {
            this.initFavorite();
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    private void initFavorite() {
        if (this.tdFavorite_idMap.isEmpty()) {
            EmbeddedTableData embeddedTableData = TableDataDAOControl.getInstance().getFavoriteNodeTableData();
            int n = embeddedTableData.getRowCount();
            for (int i = 0; i < n; ++i) {
                Long l = null;
                try {
                    l = GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 0)).longValue();
                }
                catch (NumberFormatException numberFormatException) {
                    FRContext.getLogger().error(numberFormatException.getMessage(), (Throwable)numberFormatException);
                    continue;
                }
                TableDataFavoriteNode tableDataFavoriteNode = new TableDataFavoriteNode(l);
                tableDataFavoriteNode.setUserName(GeneralUtils.objectToString((Object)embeddedTableData.getValueAt(i, 1)));
                try {
                    tableDataFavoriteNode.setType(GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 2)).intValue());
                    tableDataFavoriteNode.setEntryid(GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 3)).longValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.tdFavorite_idMap.put(l, tableDataFavoriteNode);
            }
        }
    }

    private void addDepartOrPostAll() {
        this.dp_idMap.put(ALL_DEPARTMENT.getId(), ALL_DEPARTMENT);
        this.dp_nameMap.put(ALL_DEPARTMENT.getName() + ALL_DEPARTMENT.getPid(), ALL_DEPARTMENT);
        this.id_postMap.put(FSConstants.COMPANYROLE.POST_ALL_NAME, 0L);
        this.saveALLDepartmentAndALLPost(ALL_DEPARTMENT, ALL_DEPARTMENT.getName(), FSConstants.COMPANYROLE.POST_ALL_NAME);
    }

    private void saveALLDepartmentAndALLPost(Department department, String string, String string2) {
        TableDataJRole tableDataJRole = new TableDataJRole(0L);
        tableDataJRole.setDpName(department.getName());
        tableDataJRole.setDpMarkValue(string);
        tableDataJRole.setDpId(department.getId());
        tableDataJRole.setPostName(string2);
        this.companyRoleIDListMap.put(tableDataJRole.getId(), tableDataJRole);
    }

    private void initCustomRole() {
        this.init_customRoleNameList(TableDataDAOControl.getInstance().getSRoleTableData());
        EmbeddedTableData embeddedTableData = TableDataDAOControl.getInstance().getSRole_UserTableData();
        long l = Long.MIN_VALUE;
        boolean bl = false;
        int n = embeddedTableData.getRowCount();
        for (int i = 0; i < n; ++i) {
            Long l2 = null;
            Long l3 = null;
            try {
                l2 = GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 0)).longValue();
                l3 = GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 1)).longValue();
            }
            catch (NumberFormatException numberFormatException) {
                FRContext.getLogger().error(numberFormatException.getMessage(), (Throwable)numberFormatException);
                continue;
            }
            String string = GeneralUtils.objectToString((Object)embeddedTableData.getValueAt(i, 2));
            TableDataSRole_User tableDataSRole_User = new TableDataSRole_User(l2, l3, string);
            if (l2 > l) {
                l = l2;
                bl = true;
            }
            this.customRoleUserIDMap.put(l2, tableDataSRole_User);
        }
        if (bl) {
            this.customRoleUserId = l + 1L;
        }
        this.initRole_privilege(TableDataDAOControl.getInstance().getSRolePrivilegeTableData(), this.customRolePrivilegeIDMap, false);
        this.initRole_ESPrivilege(TableDataDAOControl.getInstance().getSRoleESPrivilegeTableData(), this.customRoleESPrivilegeIDMap, false);
        this.initRole_ModulePrivilege(TableDataDAOControl.getInstance().getSRole_ModuleTableData(), this.customRoleModuleIDMap, false);
        this.initRole_HomePagePrivilege(TableDataDAOControl.getInstance().getCustomRoleHomePageTableData(), this.customRoleHomePageIDMap, false);
        this.initRole_DepAndCRolePrivilege(TableDataDAOControl.getInstance().getCustomRoleDepAndCRolePrivilegeTableData(), this.customRoleDepAndCRoleIDMap, false);
        this.initRole_TemplatePrivilege(TableDataDAOControl.getInstance().getSRoleTemplatePrivilegeTableData(), this.customRoleTemplateIDMap, false);
        this.initRole_DataConnectionPrivilege(TableDataDAOControl.getInstance().getSRoleDataConnectionPrivilegeTableData(), this.customRoleDataConnectionIDMap, false);
    }

    private void initCompanyRole() {
        EmbeddedTableData embeddedTableData = TableDataDAOControl.getInstance().getJRoleTableData();
        long l = Long.MIN_VALUE;
        long l2 = Long.MIN_VALUE;
        boolean bl = false;
        boolean bl2 = false;
        int n = embeddedTableData.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object object;
            Long l3 = null;
            try {
                l3 = GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 0)).longValue();
            }
            catch (NumberFormatException numberFormatException) {
                FRContext.getLogger().error(numberFormatException.getMessage(), (Throwable)numberFormatException);
                continue;
            }
            TableDataJRole tableDataJRole = new TableDataJRole(l3);
            tableDataJRole.setDpName(GeneralUtils.objectToString((Object)embeddedTableData.getValueAt(i, 1)));
            tableDataJRole.setPostName(GeneralUtils.objectToString((Object)embeddedTableData.getValueAt(i, 2)));
            tableDataJRole.setDescription(GeneralUtils.objectToString((Object)embeddedTableData.getValueAt(i, 3)));
            Object object2 = embeddedTableData.getValueAt(i, 4);
            if (object2 != Primitive.NULL && object2 != null) {
                try {
                    long l4 = GeneralUtils.objectToNumber((Object)object2).longValue();
                    tableDataJRole.setDpId(l4);
                    if (l4 > l2) {
                        l2 = l4;
                        bl2 = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    FRContext.getLogger().error(numberFormatException.getMessage(), (Throwable)numberFormatException);
                }
            }
            if ((object = embeddedTableData.getValueAt(i, 5)) != Primitive.NULL && object != null) {
                tableDataJRole.setDpMarkValue(GeneralUtils.objectToString((Object)object));
            }
            if (l3 > l) {
                l = l3;
                bl = true;
            }
            this.companyRoleIDListMap.put(l3, tableDataJRole);
        }
        if (bl) {
            this.comRoleId = l + 1L;
        }
        if (bl2) {
            this.depId = l2 + 1L;
        }
    }

    private void initCompanyRolePrivilege() {
        this.initRole_privilege(TableDataDAOControl.getInstance().getJRolePrivilegeTableData(), this.companyRolePrivilegeIDMap, true);
        this.initRole_ESPrivilege(TableDataDAOControl.getInstance().getJRoleESPrivilegeTableData(), this.companyRoleESPrivilegeIDMap, true);
        this.initRole_ModulePrivilege(TableDataDAOControl.getInstance().getJRole_ModuleTableData(), this.companyRoleModuleIDMap, true);
        this.initRole_HomePagePrivilege(TableDataDAOControl.getInstance().getCompanyRoleHomePageTableData(), this.companyRoleHomePageIDMap, true);
        this.initRole_DepAndCRolePrivilege(TableDataDAOControl.getInstance().getCompanyRoleDepAndCRolePrivilegeTableData(), this.companyRoleDepAndCRoleIDMap, true);
        this.initRole_TemplatePrivilege(TableDataDAOControl.getInstance().getJRoleTemplatePrivilegeTableData(), this.companyRoleTemplateIDMap, true);
        this.initRole_DataConnectionPrivilege(TableDataDAOControl.getInstance().getJRoleDataConnectionPrivilegeTableData(), this.companyRoleDataConnectionIDMap, true);
    }

    private void initPostAndDepartmentAndTableUser() {
        this.initPostInfo(TableDataDAOControl.getInstance().getPostTableData());
        this.initDepartmentInfo(TableDataDAOControl.getInstance().getDepartmentTableData());
        this.fillDepartmentAndParentMap();
        this.initCompanyRoleUserRelation(TableDataDAOControl.getInstance().getCompanyRoleAndUserRelation());
        this.initCustomRoleUserRelation(TableDataDAOControl.getInstance().getCustomRoleAndUserRelation());
        this.initTableDataUser(TableDataDAOControl.getInstance().getUserTableData());
    }

    private void fillDepartmentAndParentMap() {
        this.dpAndParentDpNameMap.clear();
        for (Department department : this.dp_nameMap.values()) {
            String[] stringArray = this.getParentAndFullParentName(department);
            department.setParentName(stringArray[0]);
            this.dpAndParentDpNameMap.put(department.getName() + stringArray[1], department);
        }
    }

    private String[] getParentAndFullParentName(Department department) {
        Department department2 = this.dp_idMap.get(department.getPid());
        String[] stringArray = new String[2];
        if (department2 != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(department2.getName());
            stringArray[0] = department2.getName();
            department2 = this.dp_idMap.get(department2.getPid());
            while (department2 != null) {
                stringBuilder.append(department2.getName());
                department2 = this.dp_idMap.get(department2.getPid());
            }
            stringArray[1] = stringBuilder.toString();
            return stringArray;
        }
        stringArray[0] = "";
        stringArray[1] = "";
        return stringArray;
    }

    private void initPostInfo(EmbeddedTableData embeddedTableData) {
        long l = Long.MIN_VALUE;
        boolean bl = false;
        int n = embeddedTableData.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object object = embeddedTableData.getValueAt(i, 0);
            Object object2 = embeddedTableData.getValueAt(i, 1);
            if (object2 == null) continue;
            Long l2 = null;
            try {
                l2 = GeneralUtils.objectToNumber((Object)object2).longValue();
            }
            catch (NumberFormatException numberFormatException) {
                FRContext.getLogger().error(numberFormatException.getMessage(), (Throwable)numberFormatException);
                continue;
            }
            if (l2 > l) {
                l = l2;
                bl = true;
            }
            this.id_postMap.put(GeneralUtils.objectToString((Object)object), l2);
        }
        if (bl) {
            this.postId = l + 1L;
        }
    }

    private void initDepartmentInfo(EmbeddedTableData embeddedTableData) {
        long l;
        long l2 = Long.MIN_VALUE;
        boolean bl = false;
        int n = embeddedTableData.getRowCount();
        for (int i = 0; i < n; ++i) {
            Long l3;
            Object object = embeddedTableData.getValueAt(i, 0);
            if (object == null) continue;
            Long l4 = null;
            try {
                l4 = GeneralUtils.objectToNumber((Object)object).longValue();
            }
            catch (NumberFormatException numberFormatException) {
                FRContext.getLogger().error(numberFormatException.getMessage(), (Throwable)numberFormatException);
                continue;
            }
            Object object2 = embeddedTableData.getValueAt(i, 1);
            if (object2 == null) {
                l3 = -1L;
            } else {
                try {
                    l3 = GeneralUtils.objectToNumber((Object)object2).longValue();
                }
                catch (NumberFormatException numberFormatException) {
                    FRContext.getLogger().error(numberFormatException.getMessage(), (Throwable)numberFormatException);
                    continue;
                }
            }
            Object object3 = embeddedTableData.getValueAt(i, 2);
            Object object4 = embeddedTableData.getValueAt(i, 3);
            String string = GeneralUtils.objectToString((Object)object4);
            if (l4 > l2) {
                bl = true;
                l2 = l4;
            }
            Department department = new Department(l4, GeneralUtils.objectToString((Object)object3), string, l3);
            this.dp_nameMap.put(department.getName() + department.getPid(), department);
            this.dp_idMap.put(department.getId(), department);
        }
        if (bl && (l = l2 + 1L) > this.depId) {
            this.depId = l;
        }
    }

    private void initCompanyRoleUserRelation(EmbeddedTableData embeddedTableData) {
        int n = embeddedTableData.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            Object object3 = embeddedTableData.getValueAt(i, 0);
            if (object3 == null || (object2 = embeddedTableData.getValueAt(i, 1)) == null || (object = embeddedTableData.getValueAt(i, 2)) == null) continue;
            Long l = null;
            Long l2 = null;
            Long l3 = null;
            try {
                l = GeneralUtils.objectToNumber((Object)object3).longValue();
                l2 = GeneralUtils.objectToNumber((Object)object2).longValue();
                l3 = GeneralUtils.objectToNumber((Object)object).longValue();
            }
            catch (NumberFormatException numberFormatException) {
                FRContext.getLogger().error(numberFormatException.getMessage(), (Throwable)numberFormatException);
                continue;
            }
            CompanyRole companyRole = new CompanyRole(l3, l2, "");
            List<CompanyRole> list = this.companyRoleAndUserIdRelationMap.get(l);
            if (list == null) {
                list = new ArrayList<CompanyRole>();
                list.add(companyRole);
                this.companyRoleAndUserIdRelationMap.put(l, list);
                continue;
            }
            list.add(companyRole);
        }
    }

    private void initCustomRoleUserRelation(EmbeddedTableData embeddedTableData) {
        int n = embeddedTableData.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2 = embeddedTableData.getValueAt(i, 0);
            if (object2 == null || (object = embeddedTableData.getValueAt(i, 1)) == null) continue;
            Long l = null;
            Long l2 = null;
            try {
                l = GeneralUtils.objectToNumber((Object)object2).longValue();
                l2 = GeneralUtils.objectToNumber((Object)object).longValue();
            }
            catch (NumberFormatException numberFormatException) {
                FRContext.getLogger().error(numberFormatException.getMessage(), (Throwable)numberFormatException);
                continue;
            }
            List<Long> list = this.customRoleAndUserIdRelationMap.get(l);
            if (list == null) {
                list = new ArrayList<Long>();
                list.add(l2);
                this.customRoleAndUserIdRelationMap.put(l, list);
                continue;
            }
            list.add(l2);
        }
    }

    private void initTableDataUser(EmbeddedTableData embeddedTableData) {
        Long l = Long.MIN_VALUE;
        boolean bl = false;
        int n = embeddedTableData.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object object = embeddedTableData.getValueAt(i, 0);
            if (object == null) continue;
            String string = GeneralUtils.objectToString((Object)embeddedTableData.getValueAt(i, 2));
            String string2 = GeneralUtils.objectToString((Object)embeddedTableData.getValueAt(i, 3));
            String string3 = GeneralUtils.objectToString((Object)embeddedTableData.getValueAt(i, 4));
            String string4 = GeneralUtils.objectToString((Object)embeddedTableData.getValueAt(i, 5));
            Long l2 = null;
            try {
                l2 = GeneralUtils.objectToNumber((Object)object).longValue();
            }
            catch (NumberFormatException numberFormatException) {
                FRContext.getLogger().error(numberFormatException.getMessage(), (Throwable)numberFormatException);
                continue;
            }
            String string5 = GeneralUtils.objectToString((Object)embeddedTableData.getValueAt(i, 1));
            TableDataUser tableDataUser = new TableDataUser(l2, string5, string);
            tableDataUser.setName(string2);
            tableDataUser.setEmail(string3);
            tableDataUser.setMobile(string4);
            List<CompanyRole> list = this.companyRoleAndUserIdRelationMap.get(l2);
            this.addCompanyRoleToUser(tableDataUser, list);
            List<Long> list2 = this.customRoleAndUserIdRelationMap.get(l2);
            this.addCustomRoleToUser(tableDataUser, list2);
            this.tdUser_idListMap.put(tableDataUser.getId(), tableDataUser);
            this.tdUser_NameListMap.put(tableDataUser.getUserName(), tableDataUser);
            if (l2 <= l) continue;
            l = l2;
            bl = true;
        }
        this.companyRoleAndUserIdRelationMap.clear();
        this.customRoleAndUserIdRelationMap.clear();
        if (bl) {
            this.userId = l + 1L;
        }
    }

    private void addCompanyRoleToUser(TableDataUser tableDataUser, List<CompanyRole> list) {
        if (list != null) {
            for (CompanyRole companyRole : list) {
                Department department = this.dp_idMap.get(companyRole.getDepartmentId());
                String string = null;
                for (Map.Entry<String, Long> entry : this.id_postMap.entrySet()) {
                    if (!ComparatorUtils.equals((Object)entry.getValue(), (Object)companyRole.getPostId())) continue;
                    string = entry.getKey();
                    break;
                }
                if (department == null || string == null) continue;
                try {
                    tableDataUser.addJob(department.getName(), string, department.getPid());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    FRContext.getLogger().error(cloneNotSupportedException.getMessage(), (Throwable)cloneNotSupportedException);
                }
            }
        }
    }

    private void addCustomRoleToUser(TableDataUser tableDataUser, List<Long> list) {
        if (list != null) {
            for (Long l : list) {
                CustomRole customRole = this.customRoleIDListMap.get(l);
                if (customRole == null) continue;
                try {
                    tableDataUser.addSrole(customRole.getRolename());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    FRContext.getLogger().error(cloneNotSupportedException.getMessage(), (Throwable)cloneNotSupportedException);
                }
            }
        }
    }

    private void init_customRoleNameList(EmbeddedTableData embeddedTableData) {
        long l = 0L;
        long l2 = -1000L;
        boolean bl = false;
        boolean bl2 = false;
        int n = embeddedTableData.getRowCount();
        for (int i = 0; i < n; ++i) {
            Long l3 = null;
            try {
                l3 = GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 0)).longValue();
            }
            catch (NumberFormatException numberFormatException) {
                FRContext.getLogger().error(numberFormatException.getMessage(), (Throwable)numberFormatException);
                continue;
            }
            CustomRole customRole = new CustomRole(l3);
            Object object = embeddedTableData.getValueAt(i, 1);
            if (object == null || StringUtils.isBlank((String)GeneralUtils.objectToString((Object)object))) continue;
            customRole.setRolename(GeneralUtils.objectToString((Object)object));
            Object object2 = embeddedTableData.getValueAt(i, 2);
            if (object2 != Primitive.NULL && object2 != null) {
                customRole.setDescription(GeneralUtils.objectToString((Object)object2));
            }
            if (l3 < l2) {
                l2 = l3;
                bl2 = true;
            }
            if (l3 > l) {
                l = l3;
                bl = true;
            }
            this.customRoleIDListMap.put(l3, customRole);
            this.customRoleNameListMap.put(customRole.getRolename(), customRole);
        }
        if (bl2) {
            this.custRoleId = l2 - 1L;
        }
        if (bl) {
            this.custRoleIdManualAdd = l + 1L;
        }
    }

    private void initRole_privilege(EmbeddedTableData embeddedTableData, Map<Long, RoleEntryPrivilege> map, boolean bl) {
        int n = embeddedTableData.getRowCount();
        for (int i = 0; i < n; ++i) {
            RoleEntryPrivilege roleEntryPrivilege;
            long l;
            long l2;
            long l3;
            long l4;
            int n2;
            long l5;
            long l6;
            try {
                l6 = GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 0)).longValue();
                l5 = GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 1)).longValue();
                n2 = GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 2)).intValue();
                l4 = GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 3)).longValue();
                l3 = embeddedTableData.getValueAt(i, 4) == null ? 1L : GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 4)).longValue();
                l2 = embeddedTableData.getValueAt(i, 5) == null ? 0L : GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 5)).longValue();
                l = embeddedTableData.getValueAt(i, 6) == null ? 0L : GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 6)).longValue();
            }
            catch (NumberFormatException numberFormatException) {
                FRContext.getLogger().error(numberFormatException.getMessage(), (Throwable)numberFormatException);
                continue;
            }
            if (bl) {
                if (this.companyRoleIDListMap.get(l5) == null) continue;
                roleEntryPrivilege = new CompanyRoleEntryPrivilege(l6);
            } else {
                roleEntryPrivilege = new CustomRoleEntryPrivilege(l6);
            }
            roleEntryPrivilege.setRoleId(l5);
            roleEntryPrivilege.setType(n2);
            roleEntryPrivilege.setEntryid(l4);
            roleEntryPrivilege.setView(l3);
            roleEntryPrivilege.setAuthorized(l2);
            roleEntryPrivilege.setEdit(l);
            if (!bl) {
                String string = GeneralUtils.objectToString((Object)embeddedTableData.getValueAt(i, 7));
                ((CustomRoleEntryPrivilege)roleEntryPrivilege).setRoleName(string);
            }
            map.put(l6, roleEntryPrivilege);
        }
    }

    private void initRole_ModulePrivilege(EmbeddedTableData embeddedTableData, Map<Long, RoleModulePrivilege> map, boolean bl) {
        int n = embeddedTableData.getRowCount();
        for (int i = 0; i < n; ++i) {
            long l;
            long l2;
            long l3;
            long l4;
            long l5;
            try {
                l5 = GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 0)).longValue();
                l4 = GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 1)).longValue();
                l3 = GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 3)).longValue();
                l2 = embeddedTableData.getValueAt(i, 4) == null ? 1L : GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 4)).longValue();
                l = embeddedTableData.getValueAt(i, 5) == null ? 0L : GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 5)).longValue();
            }
            catch (NumberFormatException numberFormatException) {
                FRContext.getLogger().error(numberFormatException.getMessage(), (Throwable)numberFormatException);
                continue;
            }
            RoleModulePrivilege roleModulePrivilege = bl ? new CompanyRoleModulePrivilege(l5) : new CustomRoleModulePrivilege(l5);
            roleModulePrivilege.setRoleId(l4);
            roleModulePrivilege.setModuleid(l3);
            roleModulePrivilege.setView(l2);
            roleModulePrivilege.setAuthorized(l);
            if (!bl) {
                String string = GeneralUtils.objectToString((Object)embeddedTableData.getValueAt(i, 6));
                ((CustomRoleModulePrivilege)roleModulePrivilege).setRoleName(string);
            }
            map.put(l5, roleModulePrivilege);
        }
    }

    private void initRole_HomePagePrivilege(EmbeddedTableData embeddedTableData, Map<Long, RoleHomePagePrivilege> map, boolean bl) {
        int n = embeddedTableData.getRowCount();
        for (int i = 0; i < n; ++i) {
            long l;
            long l2;
            long l3;
            long l4;
            try {
                l4 = GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 0)).longValue();
                l3 = GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 1)).longValue();
                l2 = GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 2)).longValue();
                l = embeddedTableData.getValueAt(i, 3) == null ? 1L : GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 3)).longValue();
            }
            catch (NumberFormatException numberFormatException) {
                FRContext.getLogger().error(numberFormatException.getMessage(), (Throwable)numberFormatException);
                continue;
            }
            RoleHomePagePrivilege roleHomePagePrivilege = bl ? new CompanyRoleHomePagePrivilege(l4) : new CustomRoleHomePagePrivilege(l4);
            roleHomePagePrivilege.setRoleId(l3);
            roleHomePagePrivilege.setHomePageId(l2);
            roleHomePagePrivilege.setView(l);
            if (!bl) {
                String string = GeneralUtils.objectToString((Object)embeddedTableData.getValueAt(i, 4));
                ((CustomRoleHomePagePrivilege)roleHomePagePrivilege).setRoleName(string);
            }
            map.put(l4, roleHomePagePrivilege);
        }
    }

    private void initRole_TemplatePrivilege(EmbeddedTableData embeddedTableData, Map<Long, RoleTemplatePrivilege> map, boolean bl) {
        int n = embeddedTableData.getRowCount();
        for (int i = 0; i < n; ++i) {
            long l;
            long l2;
            long l3;
            long l4;
            long l5;
            try {
                l5 = GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 0)).longValue();
                l4 = GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 1)).longValue();
                l3 = embeddedTableData.getValueAt(i, 3) == null ? 0L : GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 3)).longValue();
                l2 = embeddedTableData.getValueAt(i, 4) == null ? 0L : GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 4)).longValue();
                l = embeddedTableData.getValueAt(i, 5) == null ? 0L : GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 5)).longValue();
            }
            catch (NumberFormatException numberFormatException) {
                FRContext.getLogger().error(numberFormatException.getMessage(), (Throwable)numberFormatException);
                continue;
            }
            String string = GeneralUtils.objectToString((Object)embeddedTableData.getValueAt(i, 2));
            RoleTemplatePrivilege roleTemplatePrivilege = bl ? new CompanyRoleTemplatePrivilege(l5) : new CustomRoleTemplatePrivilege(l5);
            roleTemplatePrivilege.setRoleId(l4);
            roleTemplatePrivilege.setPath(string);
            roleTemplatePrivilege.setPage(l3);
            roleTemplatePrivilege.setWrite(l2);
            roleTemplatePrivilege.setDesign(l);
            if (!bl) {
                String string2 = GeneralUtils.objectToString((Object)embeddedTableData.getValueAt(i, 6));
                ((CustomRoleTemplatePrivilege)roleTemplatePrivilege).setRoleName(string2);
            }
            map.put(l5, roleTemplatePrivilege);
        }
    }

    private void initRole_DataConnectionPrivilege(EmbeddedTableData embeddedTableData, Map<Long, RoleDataConnectionPrivilege> map, boolean bl) {
        int n = embeddedTableData.getRowCount();
        for (int i = 0; i < n; ++i) {
            long l;
            long l2;
            long l3;
            try {
                l3 = GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 0)).longValue();
                l2 = GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 1)).longValue();
                l = embeddedTableData.getValueAt(i, 3) == null ? 0L : GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 3)).longValue();
            }
            catch (NumberFormatException numberFormatException) {
                FRContext.getLogger().error(numberFormatException.getMessage(), (Throwable)numberFormatException);
                continue;
            }
            String string = GeneralUtils.objectToString((Object)embeddedTableData.getValueAt(i, 2));
            RoleDataConnectionPrivilege roleDataConnectionPrivilege = bl ? new CompanyRoleDataConnectionPrivilege(l3) : new CustomRoleDataConnectionPrivilege(l3);
            roleDataConnectionPrivilege.setRoleId(l2);
            roleDataConnectionPrivilege.setName(string);
            roleDataConnectionPrivilege.setView(l);
            if (!bl) {
                String string2 = GeneralUtils.objectToString((Object)embeddedTableData.getValueAt(i, 4));
                ((CustomRoleDataConnectionPrivilege)roleDataConnectionPrivilege).setRoleName(string2);
            }
            map.put(l3, roleDataConnectionPrivilege);
        }
    }

    private void initRole_DepAndCRolePrivilege(EmbeddedTableData embeddedTableData, Map<Long, RoleDepAndCRolePrivilege> map, boolean bl) {
        int n = embeddedTableData.getRowCount();
        for (int i = 0; i < n; ++i) {
            long l;
            int n2;
            long l2;
            long l3;
            try {
                l3 = GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 0)).longValue();
                l2 = GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 1)).longValue();
                n2 = GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 2)).intValue();
                l = GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 3)).longValue();
            }
            catch (NumberFormatException numberFormatException) {
                FRContext.getLogger().error(numberFormatException.getMessage(), (Throwable)numberFormatException);
                continue;
            }
            RoleDepAndCRolePrivilege roleDepAndCRolePrivilege = bl ? new CompanyRoleDepAndCRolePrivilege(l3) : new CustomRoleDepAndCRolePrivilege(l3);
            roleDepAndCRolePrivilege.setRoleid(l2);
            roleDepAndCRolePrivilege.setType(n2);
            roleDepAndCRolePrivilege.setDeporcroleid(l);
            if (!bl) {
                String string = GeneralUtils.objectToString((Object)embeddedTableData.getValueAt(i, 4));
                ((CustomRoleDepAndCRolePrivilege)roleDepAndCRolePrivilege).setRoleName(string);
            }
            map.put(l3, roleDepAndCRolePrivilege);
        }
    }

    private void initRole_ESPrivilege(EmbeddedTableData embeddedTableData, Map<Long, RoleESPrivilege> map, boolean bl) {
        int n = embeddedTableData.getRowCount();
        for (int i = 0; i < n; ++i) {
            long l;
            int n2;
            long l2;
            long l3;
            try {
                l3 = GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 0)).longValue();
                l2 = GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 1)).longValue();
                n2 = GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 2)).intValue();
                l = GeneralUtils.objectToNumber((Object)embeddedTableData.getValueAt(i, 3)).longValue();
            }
            catch (NumberFormatException numberFormatException) {
                FRContext.getLogger().error(numberFormatException.getMessage(), (Throwable)numberFormatException);
                continue;
            }
            RoleESPrivilege roleESPrivilege = bl ? new CompanyRoleESPrivilege(l3) : new CustomRoleESPrivilege(l3);
            roleESPrivilege.setRoleId(l2);
            roleESPrivilege.setType(n2);
            roleESPrivilege.setEntryID(l);
            map.put(l3, roleESPrivilege);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReInit() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (reInitTime == 0L || reInitTime + TableDataDAOControl.getInstance().getInitGapTimeAsMillisecond() < new Date().getTime()) {
                TableDataDAOControl.getInstance().init();
                FSContext.resetDataOn();
                FSContext.initData();
                reInitTime = new Date().getTime();
            }
        }
    }

    public static void release() {
        tableDataSyncDB = null;
    }

    @Override
    public CustomRole findSRoleBySRoleName(String string) throws CloneNotSupportedException {
        CustomRole customRole = this.customRoleNameListMap.get(string);
        return customRole == null ? null : (CustomRole)((Object)customRole.clone());
    }

    @Override
    public CustomRole findSRoleBySRoleID(long l) throws CloneNotSupportedException {
        CustomRole customRole = this.customRoleIDListMap.get(l);
        return customRole == null ? null : (CustomRole)((Object)customRole.clone());
    }

    @Override
    public Set<RelationObject> findSRoleByUserName(String string) throws CloneNotSupportedException {
        ArrayList<CustomRole> arrayList = new ArrayList<CustomRole>();
        for (Map.Entry<Long, TableDataSRole_User> entry : this.customRoleUserIDMap.entrySet()) {
            long l;
            TableDataSRole_User tableDataSRole_User = entry.getValue();
            if (!ComparatorUtils.equals((String)tableDataSRole_User.getUserName(), (String)string) || this.customRoleIDListMap.get(l = tableDataSRole_User.getsRoleId()) == null) continue;
            arrayList.add(this.customRoleIDListMap.get(l));
        }
        return this.getSetFromList(arrayList, ClassArrayKey.getInstance((Class[])new Class[]{CustomRole.class}), false);
    }

    @Override
    public User findUserByUserId(long l) {
        TableDataUser tableDataUser = this.tdUser_idListMap.get(l);
        if (tableDataUser != null) {
            return tableDataUser.getUser();
        }
        return null;
    }

    @Override
    public List<User> findAllUser() {
        ArrayList<User> arrayList = new ArrayList<User>();
        for (Map.Entry<Long, TableDataUser> entry : this.tdUser_idListMap.entrySet()) {
            TableDataUser tableDataUser = entry.getValue();
            arrayList.add(tableDataUser.getUser());
        }
        return arrayList;
    }

    @Override
    public List<TableDataUser> getAllTableDataUsers() {
        ArrayList<TableDataUser> arrayList = new ArrayList<TableDataUser>();
        for (Map.Entry<Long, TableDataUser> entry : this.tdUser_idListMap.entrySet()) {
            TableDataUser tableDataUser = entry.getValue();
            arrayList.add(tableDataUser);
        }
        return arrayList;
    }

    @Override
    public User findUserByUserName(String string) {
        if (string == null) {
            return null;
        }
        TableDataUser tableDataUser = this.tdUser_NameListMap.get(string);
        if (tableDataUser != null) {
            return tableDataUser.getUser();
        }
        return null;
    }

    @Override
    public User findUserByMobile(String string) {
        for (Map.Entry<Long, TableDataUser> entry : this.tdUser_idListMap.entrySet()) {
            TableDataUser tableDataUser = entry.getValue();
            if (!ComparatorUtils.equals((String)string, (String)tableDataUser.getMobile())) continue;
            return tableDataUser.getUser();
        }
        return null;
    }

    @Override
    public Iterator findJobsByUserId(long l) {
        TableDataUser tableDataUser = this.tdUser_idListMap.get(l);
        if (tableDataUser == null) {
            return null;
        }
        return tableDataUser.getJobIterator();
    }

    @Override
    public String findPostNameById(long l) {
        for (Map.Entry<String, Long> entry : this.id_postMap.entrySet()) {
            long l2 = entry.getValue();
            if (l2 != l) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public Set<Long> findUserSetByDpAndPost(Department department, String string) throws CloneNotSupportedException {
        HashSet<Long> hashSet = new HashSet<Long>();
        for (Map.Entry<String, TableDataUser> entry : this.tdUser_NameListMap.entrySet()) {
            TableDataUser tableDataUser = entry.getValue();
            if (!this.hasDepartAndPost(tableDataUser, department, string)) continue;
            hashSet.add(tableDataUser.getUser().getId());
        }
        return hashSet;
    }

    private boolean hasDepartAndPost(TableDataUser tableDataUser, Department department, String string) {
        Iterator iterator = tableDataUser.getJobIterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Job job = (Job)iterator.next();
                if (!this.departEqual(job, department) || !this.postEqual(job, string)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean departEqual(Job job, Department department) {
        return department == null || ComparatorUtils.equals((Object)job.getDepartmentID(), (Object)department.getId());
    }

    private boolean postEqual(Job job, String string) {
        return string == null || ComparatorUtils.equals((Object)job.getPostID(), (Object)this.findPostByPostName(string).getId());
    }

    @Override
    public boolean addSRole(String string, CustomRole customRole) {
        if (customRole == null) {
            return false;
        }
        TableDataUser tableDataUser = this.tdUser_NameListMap.get(string);
        if (tableDataUser == null) {
            return false;
        }
        TableDataUser tableDataUser2 = this.tdUser_idListMap.get(tableDataUser.getId());
        try {
            tableDataUser.addSrole(customRole.getRolename());
            tableDataUser2.addSrole(customRole.getRolename());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRContext.getLogger().error(cloneNotSupportedException.getMessage(), (Throwable)cloneNotSupportedException);
        }
        this.addSRoleToMap(string, customRole);
        return true;
    }

    @Override
    public synchronized boolean addSRole(CustomRole customRole) {
        if (this.customRoleNameListMap.containsKey(customRole.getRolename())) {
            return false;
        }
        if (ComparatorUtils.equals((Object)customRole.getCustomRoleType(), (Object)0)) {
            customRole.setId(this.custRoleId--);
        }
        if (ComparatorUtils.equals((Object)customRole.getCustomRoleType(), (Object)1)) {
            customRole.setId(this.custRoleIdManualAdd++);
        }
        this.customRoleNameListMap.put(customRole.getRolename(), customRole);
        this.customRoleIDListMap.put(customRole.getId(), customRole);
        TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
        return true;
    }

    @Override
    public boolean updateSRole(CustomRole customRole) {
        this.customRoleNameListMap.put(customRole.getRolename(), customRole);
        this.customRoleIDListMap.put(customRole.getId(), customRole);
        TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
        return true;
    }

    @Override
    public boolean resetSortIndex() {
        for (CustomRole customRole : this.customRoleNameListMap.values()) {
            customRole.setSortindex(0L);
        }
        for (CustomRole customRole : this.customRoleIDListMap.values()) {
            customRole.setSortindex(0L);
        }
        TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
        return true;
    }

    private long generateID(Map map) {
        long l = map.size() + 1;
        while (map.get(l) != null) {
            ++l;
        }
        return l;
    }

    private synchronized void addSRoleToMap(String string, CustomRole customRole) {
        for (Map.Entry<Long, TableDataSRole_User> entry : this.customRoleUserIDMap.entrySet()) {
            if (customRole.getId() != entry.getValue().getsRoleId() || !ComparatorUtils.equals((String)string, (String)entry.getValue().getUserName())) continue;
            return;
        }
        long l = this.customRoleUserId++;
        TableDataSRole_User tableDataSRole_User = new TableDataSRole_User(l, customRole.getId(), string);
        this.customRoleUserIDMap.put(l, tableDataSRole_User);
        TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
    }

    @Override
    public boolean removeSRole(String string, CustomRole customRole) {
        boolean bl = false;
        Object object = this.customRoleUserIDMap.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry<Long, TableDataSRole_User> entry = object.next();
            TableDataSRole_User tableDataSRole_User = entry.getValue();
            if (!ComparatorUtils.equals((String)string, (String)tableDataSRole_User.getUserName()) || customRole.getId() != tableDataSRole_User.getsRoleId()) continue;
            bl = true;
            this.customRoleUserIDMap.remove(entry.getKey());
            break;
        }
        if ((object = this.tdUser_NameListMap.get(string)) != null) {
            bl = true;
            ((TableDataUser)object).removeSrole(customRole.getId());
            this.tdUser_idListMap.put(((TableDataDAOBean)object).getId(), (TableDataUser)object);
        }
        if (bl) {
            TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
        }
        return true;
    }

    @Override
    public boolean removeSRole(CustomRole customRole) {
        this.customRoleNameListMap.remove(customRole.getRolename());
        this.customRoleIDListMap.remove(customRole.getId());
        this.removeUsersFromSRole(customRole);
        TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
        return true;
    }

    private void removeUsersFromSRole(CustomRole customRole) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (Map.Entry<Long, TableDataSRole_User> object : this.customRoleUserIDMap.entrySet()) {
            TableDataSRole_User tableDataSRole_User = object.getValue();
            if (customRole.getId() != tableDataSRole_User.getsRoleId()) continue;
            arrayList.add(object.getKey());
        }
        for (Long l : arrayList) {
            this.customRoleUserIDMap.remove(l);
        }
    }

    private Set<RelationObject> getSetFromList(List list, ClassArrayKey classArrayKey, boolean bl) throws CloneNotSupportedException {
        Iterator iterator = list.iterator();
        HashSet<RelationObject> hashSet = new HashSet<RelationObject>();
        while (iterator.hasNext()) {
            DAOBean[] dAOBeanArray = new DAOBean[]{(DAOBean)((DAOBean)iterator.next()).clone()};
            hashSet.add(RelationObject.getInstance((long)dAOBeanArray[0].getId(), (ClassArrayKey)classArrayKey, (DAOBean[])dAOBeanArray, (boolean)bl));
        }
        return hashSet;
    }

    @Override
    public boolean updateSRoleName(long l, String string) throws CloneNotSupportedException {
        CustomRole customRole = this.customRoleIDListMap.get(l);
        if (customRole != null && this.findSRoleBySRoleName(string) == null) {
            this.customRoleNameListMap.remove(customRole.getRolename());
            customRole.setRolename(string);
            this.customRoleNameListMap.put(string, customRole);
            TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
            return true;
        }
        return false;
    }

    @Override
    public List<Object> findAllSRole() throws CloneNotSupportedException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Map.Entry<String, CustomRole> entry : this.customRoleNameListMap.entrySet()) {
            arrayList.add(entry.getValue().clone());
        }
        return arrayList;
    }

    @Override
    public Set<RelationObject> findUserSetBySRoleId(long l, boolean bl) throws CloneNotSupportedException {
        List<String> list = this.getUserNameListBySRoleId(l);
        if (bl) {
            ArrayList<User> arrayList = new ArrayList<User>();
            for (String string : list) {
                User user = this.findUserByUserName(string);
                if (user == null) continue;
                arrayList.add(user);
            }
            return this.getSetFromList(arrayList, ClassArrayKey.getInstance((Class[])new Class[]{User.class}), true);
        }
        HashSet<RelationObject> hashSet = new HashSet<RelationObject>();
        for (String string : list) {
            User user = this.findUserByUserName(string);
            DAOBean[] dAOBeanArray = new User[]{user};
            hashSet.add(RelationObject.getInstance((long)user.getId(), (ClassArrayKey)ClassArrayKey.getInstance((Class[])new Class[]{User.class}), (DAOBean[])dAOBeanArray, (boolean)false));
        }
        return hashSet;
    }

    private List<String> getUserNameListBySRoleId(long l) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<Long, TableDataSRole_User> entry : this.customRoleUserIDMap.entrySet()) {
            TableDataSRole_User tableDataSRole_User = entry.getValue();
            if (l != tableDataSRole_User.getsRoleId()) continue;
            arrayList.add(tableDataSRole_User.getUserName());
        }
        return arrayList;
    }

    @Override
    public void addUsersToSRole(CustomRole customRole, Set<User> set) {
        List<String> list = this.getUserNameListBySRoleId(customRole.getId());
        for (User user : set) {
            long l;
            TableDataUser tableDataUser = this.tdUser_idListMap.get(user.getId());
            if (tableDataUser == null || list.contains(tableDataUser.getUserName())) continue;
            ++this.customRoleUserId;
            TableDataSRole_User tableDataSRole_User = new TableDataSRole_User(l, customRole.getId(), tableDataUser.getUserName());
            this.customRoleUserIDMap.put(l, tableDataSRole_User);
        }
        TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
    }

    @Override
    public void removeUsersFromSRole(Set<User> set, CustomRole customRole) {
        TableDataDAOBean tableDataDAOBean;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new ArrayList();
        for (User object : set) {
            tableDataDAOBean = this.tdUser_idListMap.get(object.getId());
            if (tableDataDAOBean == null) continue;
            arrayList.add(((TableDataUser)tableDataDAOBean).getUserName());
        }
        for (Map.Entry entry : this.customRoleUserIDMap.entrySet()) {
            tableDataDAOBean = (TableDataSRole_User)entry.getValue();
            if (customRole != null && customRole.getId() != ((TableDataSRole_User)tableDataDAOBean).getsRoleId() || !arrayList.contains(((TableDataSRole_User)tableDataDAOBean).getUserName())) continue;
            arrayList2.add(entry.getKey());
        }
        for (Long l : arrayList2) {
            this.customRoleUserIDMap.remove(l);
        }
        TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
    }

    @Override
    public void removeUsersFromSRole(Set<User> set) {
        this.removeUsersFromSRole(set, null);
    }

    @Override
    public Post findPostById(long l) {
        String string = this.findPostNameById(l);
        if (string != null) {
            Post post = new Post(l);
            post.setPostname(string);
            return post;
        }
        return null;
    }

    @Override
    public List<Post> findAllPost() {
        ArrayList<Post> arrayList = new ArrayList<Post>();
        for (Map.Entry<String, Long> entry : this.id_postMap.entrySet()) {
            Post post = new Post(entry.getValue());
            post.setPostname(entry.getKey());
            arrayList.add(post);
        }
        return arrayList;
    }

    @Override
    public Post findPostByPostName(String string) {
        Long l = this.id_postMap.get(string);
        if (l != null) {
            Post post = new Post(l);
            post.setPostname(string);
            return post;
        }
        return null;
    }

    @Override
    public Department findDepartmentByID(long l) {
        return this.dp_idMap.get(l);
    }

    @Override
    public List<Department> findAllDepartment() throws CloneNotSupportedException {
        ArrayList<Department> arrayList = new ArrayList<Department>();
        for (Map.Entry<Long, Department> entry : this.dp_idMap.entrySet()) {
            Department department = (Department)((Object)entry.getValue().clone());
            arrayList.add(department);
        }
        return arrayList;
    }

    @Override
    public Department findDepartmentByDPNameAndPid(String string, long l) throws CloneNotSupportedException {
        for (Map.Entry<Long, Department> entry : this.dp_idMap.entrySet()) {
            Department department = (Department)((Object)entry.getValue().clone());
            if (!ComparatorUtils.equals((String)department.getName(), (String)string) || !ComparatorUtils.equals((Object)department.getPid(), (Object)l)) continue;
            return department;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator findUserAndPostIterator(long l, boolean bl) {
        Set<RelationObject> set;
        Set<RelationObject> set2 = set = bl ? this.roleObjSet_idMap.get(l) : this.roleNonObjSet_idMap.get(l);
        if (set == null) {
            Map<Long, TableDataUser> map = this.tdUser_idListMap;
            synchronized (map) {
                set = this.findDeptRoleSet(l, bl);
                if (bl) {
                    this.roleObjSet_idMap.put(l, set);
                } else {
                    this.roleNonObjSet_idMap.put(l, set);
                }
            }
        }
        return set.iterator();
    }

    private Set<RelationObject> findDeptRoleSet(long l, boolean bl) {
        Department department = this.findDepartmentByID(l);
        HashSet<RelationObject> hashSet = new HashSet<RelationObject>();
        if (department != null) {
            for (Map.Entry<Long, TableDataUser> entry : this.tdUser_idListMap.entrySet()) {
                TableDataUser tableDataUser = entry.getValue();
                Iterator iterator = tableDataUser.getJobIterator();
                while (iterator.hasNext()) {
                    Job job = (Job)iterator.next();
                    if (l != job.getDepartmentID()) continue;
                    Post post = this.findPostById(job.getPostID());
                    User user = tableDataUser.getUser();
                    if (post == null || user == null) continue;
                    DAOBean[] dAOBeanArray = new DAOBean[]{post, user};
                    hashSet.add(RelationObject.getInstance((long)tableDataUser.getId(), (ClassArrayKey)ClassArrayKey.getInstance((Class[])new Class[]{Post.class, User.class}), (DAOBean[])dAOBeanArray, (boolean)bl));
                }
            }
        }
        return hashSet;
    }

    @Override
    public void saveFavoriteNode(FavoriteNode favoriteNode) {
        long l = this.generateID(this.tdFavorite_idMap);
        favoriteNode.setId(l);
        long l2 = favoriteNode.getUserId();
        User user = this.findUserByUserId(l2);
        if (user != null) {
            TableDataFavoriteNode tableDataFavoriteNode = new TableDataFavoriteNode(user.getUsername(), favoriteNode);
            this.tdFavorite_idMap.put(l, tableDataFavoriteNode);
            TableDataDAOControl.getInstance().writeTableDataFavoriteMap(this.tdFavorite_idMap.entrySet());
            TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
        }
    }

    @Override
    public FavoriteNode findFavoriteById(long l) {
        TableDataUser tableDataUser;
        TableDataFavoriteNode tableDataFavoriteNode = this.tdFavorite_idMap.get(l);
        if (tableDataFavoriteNode != null && (tableDataUser = this.tdUser_NameListMap.get(tableDataFavoriteNode.getUserName())) != null) {
            return tableDataFavoriteNode.getFavoriteNode(tableDataUser.getId());
        }
        return null;
    }

    @Override
    public void deleteFavoriteNode(FavoriteNode favoriteNode) {
        ArrayList arrayList = new ArrayList();
        TableDataUser tableDataUser = this.tdUser_idListMap.get(favoriteNode.getUserId());
        if (tableDataUser != null) {
            for (Map.Entry object : this.tdFavorite_idMap.entrySet()) {
                TableDataFavoriteNode tableDataFavoriteNode = (TableDataFavoriteNode)object.getValue();
                if (!ComparatorUtils.equals((String)tableDataUser.getUserName(), (String)tableDataFavoriteNode.getUserName()) || favoriteNode.getEntryid() != tableDataFavoriteNode.getEntryid()) continue;
                arrayList.add(object.getKey());
            }
        }
        for (Long l : arrayList) {
            this.tdFavorite_idMap.remove(l);
        }
        if (arrayList.size() > 0) {
            TableDataDAOControl.getInstance().writeTableDataFavoriteMap(this.tdFavorite_idMap.entrySet());
            TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
        }
    }

    @Override
    public List<FavoriteNode> findFavoriteNodes(long l) {
        TableDataUser tableDataUser = this.tdUser_idListMap.get(l);
        ArrayList<FavoriteNode> arrayList = new ArrayList<FavoriteNode>();
        if (tableDataUser != null) {
            for (Map.Entry<Long, TableDataFavoriteNode> entry : this.tdFavorite_idMap.entrySet()) {
                TableDataFavoriteNode tableDataFavoriteNode = entry.getValue();
                if (!ComparatorUtils.equals((String)tableDataUser.getUserName(), (String)tableDataFavoriteNode.getUserName())) continue;
                arrayList.add(tableDataFavoriteNode.getFavoriteNode(l));
            }
        }
        return arrayList;
    }

    @Override
    public void deleteFavoriteNode(long l, int n, long l2) {
        TableDataUser tableDataUser = this.tdUser_idListMap.get(l);
        if (tableDataUser != null) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (Map.Entry<Long, TableDataFavoriteNode> object : this.tdFavorite_idMap.entrySet()) {
                TableDataFavoriteNode tableDataFavoriteNode = object.getValue();
                if (!ComparatorUtils.equals((String)tableDataUser.getUserName(), (String)tableDataFavoriteNode.getUserName()) || l2 != tableDataFavoriteNode.getEntryid() || tableDataFavoriteNode.getType() != n) continue;
                arrayList.add(object.getKey());
            }
            for (Long l3 : arrayList) {
                this.tdFavorite_idMap.remove(l3);
            }
            if (arrayList.size() > 0) {
                TableDataDAOControl.getInstance().writeTableDataFavoriteMap(this.tdFavorite_idMap.entrySet());
                TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
            }
        }
    }

    @Override
    public CompanyRole findJRoleByCompanyRoleID(long l) {
        TableDataJRole tableDataJRole = this.companyRoleIDListMap.get(l);
        return this.getJRoleByTdJRole(tableDataJRole);
    }

    private CompanyRole getJRoleByTdJRole(TableDataJRole tableDataJRole) {
        Long l;
        if (tableDataJRole != null && (l = tableDataJRole.getDpId()) != null) {
            Department department = this.dp_idMap.get(l);
            Long l2 = this.id_postMap.get(tableDataJRole.getPostName());
            if (department != null && l2 != null) {
                CompanyRole companyRole = new CompanyRole(tableDataJRole.getId());
                companyRole.setDepartmentId(l);
                companyRole.setPostId(l2);
                companyRole.setDescription(tableDataJRole.getDescription());
                return companyRole;
            }
        }
        return null;
    }

    @Override
    public List<CompanyRole> findAllJRole() {
        ArrayList<CompanyRole> arrayList = new ArrayList<CompanyRole>();
        for (Map.Entry<Long, TableDataJRole> entry : this.companyRoleIDListMap.entrySet()) {
            CompanyRole companyRole = this.getJRoleByTdJRole(entry.getValue());
            if (companyRole == null) continue;
            arrayList.add(companyRole);
        }
        return arrayList;
    }

    @Override
    public void saveJRole(CompanyRole companyRole) {
        Department department = this.findDepartmentByID(companyRole.getDepartmentId());
        String string = this.findPostNameById(companyRole.getPostId());
        if (department != null && string != null) {
            TableDataJRole tableDataJRole;
            boolean bl = false;
            for (Map.Entry<Long, TableDataJRole> entry : this.companyRoleIDListMap.entrySet()) {
                tableDataJRole = entry.getValue();
                if (!ComparatorUtils.equals((Object)department.getId(), (Object)tableDataJRole.getDpId()) || !ComparatorUtils.equals((String)string, (String)tableDataJRole.getPostName())) continue;
                bl = true;
            }
            if (!bl) {
                long l = this.comRoleId++;
                companyRole.setId(l);
                tableDataJRole = new TableDataJRole(l);
                tableDataJRole.setDpName(department.getName());
                tableDataJRole.setPostName(string);
                tableDataJRole.setDpId(department.getId());
                tableDataJRole.setParentId(department.getPid());
                tableDataJRole.setDescription(companyRole.getDescription());
                this.companyRoleIDListMap.put(l, tableDataJRole);
                TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
            }
        }
    }

    @Override
    public List<CompanyRole> findJRoleByPost(Post post) {
        long l;
        String string;
        ArrayList<CompanyRole> arrayList = new ArrayList<CompanyRole>();
        if (post != null && (string = this.findPostNameById(l = post.getId())) != null) {
            for (Map.Entry<Long, TableDataJRole> entry : this.companyRoleIDListMap.entrySet()) {
                CompanyRole companyRole;
                TableDataJRole tableDataJRole = entry.getValue();
                if (!ComparatorUtils.equals((String)string, (String)tableDataJRole.getPostName()) || (companyRole = this.getJRoleByTdJRole(tableDataJRole)) == null) continue;
                arrayList.add(companyRole);
            }
        }
        return arrayList;
    }

    @Override
    public List<CompanyRole> findJRoleByDepartment(Long l) {
        ArrayList<CompanyRole> arrayList = new ArrayList<CompanyRole>();
        if (l != null) {
            for (Map.Entry<Long, TableDataJRole> entry : this.companyRoleIDListMap.entrySet()) {
                TableDataJRole tableDataJRole = entry.getValue();
                CompanyRole companyRole = this.getJRoleByTdJRole(tableDataJRole);
                if (companyRole == null || !ComparatorUtils.equals((Object)l, (Object)companyRole.getDepartmentId())) continue;
                arrayList.add(companyRole);
            }
        }
        return arrayList;
    }

    @Override
    public List<CompanyRole> findJRoleByPostAndDepartment(Long l, Long[] longArray) {
        List<CompanyRole> list = this.findJRoleByPost(new Post(l));
        ArrayList<CompanyRole> arrayList = new ArrayList<CompanyRole>();
        for (CompanyRole companyRole : list) {
            boolean bl = false;
            for (Long l2 : longArray) {
                if (companyRole.getDepartmentId() != l2.longValue()) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            arrayList.add(companyRole);
        }
        return arrayList;
    }

    @Override
    public Set<RoleTemplatePrivilege> findTemplatePrivilegeByCompanyRoleId(long l) {
        return this.getTemplatePrivilegeByRoleId(this.companyRoleTemplateIDMap.entrySet(), l);
    }

    @Override
    public Set<RoleTemplatePrivilege> findTemplatePrivilegeByCustomRoleId(long l) {
        return this.getTemplatePrivilegeByRoleId(this.customRoleTemplateIDMap.entrySet(), l);
    }

    @Override
    public Set<RoleTemplatePrivilege> findTemplatePrivilegeByCustomRoleName(String string) {
        return this.getTemplatePrivilegeByRoleName(this.customRoleTemplateIDMap.entrySet(), string);
    }

    private Set<RoleTemplatePrivilege> getTemplatePrivilegeByRoleId(Set<Map.Entry<Long, RoleTemplatePrivilege>> set, long l) {
        HashSet<RoleTemplatePrivilege> hashSet = new HashSet<RoleTemplatePrivilege>();
        for (Map.Entry<Long, RoleTemplatePrivilege> entry : set) {
            RoleTemplatePrivilege roleTemplatePrivilege = entry.getValue();
            if (roleTemplatePrivilege.getRoleId() != l) continue;
            hashSet.add(roleTemplatePrivilege);
        }
        return hashSet;
    }

    private Set<RoleTemplatePrivilege> getTemplatePrivilegeByRoleName(Set<Map.Entry<Long, RoleTemplatePrivilege>> set, String string) {
        HashSet<RoleTemplatePrivilege> hashSet = new HashSet<RoleTemplatePrivilege>();
        for (Map.Entry<Long, RoleTemplatePrivilege> entry : set) {
            CustomRoleTemplatePrivilege customRoleTemplatePrivilege = (CustomRoleTemplatePrivilege)entry.getValue();
            if (!ComparatorUtils.equals((String)customRoleTemplatePrivilege.getRoleName(), (String)string)) continue;
            hashSet.add(customRoleTemplatePrivilege);
        }
        return hashSet;
    }

    @Override
    public Set<RoleDataConnectionPrivilege> findDataConnectionPrivilegesByCompanyRoleId(long l) {
        return this.getDataConnectionPrivilegeByRoleId(this.companyRoleDataConnectionIDMap.entrySet(), l);
    }

    @Override
    public Set<RoleDataConnectionPrivilege> findDataConnectionPrivilegesByCustomRoleId(long l) {
        return this.getDataConnectionPrivilegeByRoleId(this.customRoleDataConnectionIDMap.entrySet(), l);
    }

    @Override
    public Set<RoleDataConnectionPrivilege> findDataConnectionPrivilegesByCustomRoleName(String string) {
        return this.getDataConnectionPrivilegeByRoleName(this.customRoleDataConnectionIDMap.entrySet(), string);
    }

    private Set<RoleDataConnectionPrivilege> getDataConnectionPrivilegeByRoleId(Set<Map.Entry<Long, RoleDataConnectionPrivilege>> set, long l) {
        HashSet<RoleDataConnectionPrivilege> hashSet = new HashSet<RoleDataConnectionPrivilege>();
        for (Map.Entry<Long, RoleDataConnectionPrivilege> entry : set) {
            RoleDataConnectionPrivilege roleDataConnectionPrivilege = entry.getValue();
            if (roleDataConnectionPrivilege.getRoleId() != l) continue;
            hashSet.add(roleDataConnectionPrivilege);
        }
        return hashSet;
    }

    private Set<RoleDataConnectionPrivilege> getDataConnectionPrivilegeByRoleName(Set<Map.Entry<Long, RoleDataConnectionPrivilege>> set, String string) {
        HashSet<RoleDataConnectionPrivilege> hashSet = new HashSet<RoleDataConnectionPrivilege>();
        for (Map.Entry<Long, RoleDataConnectionPrivilege> entry : set) {
            CustomRoleDataConnectionPrivilege customRoleDataConnectionPrivilege = (CustomRoleDataConnectionPrivilege)entry.getValue();
            if (!ComparatorUtils.equals((String)customRoleDataConnectionPrivilege.getRoleName(), (String)string)) continue;
            hashSet.add(customRoleDataConnectionPrivilege);
        }
        return hashSet;
    }

    @Override
    public Set<RoleDepAndCRolePrivilege> findDepAndCRolePrivilegeByCompanyRoleId(long l) {
        return this.getDepAndCRolePrivilegeByRoleId(this.companyRoleDepAndCRoleIDMap.entrySet(), l);
    }

    @Override
    public Set<RoleDepAndCRolePrivilege> findDepAndCRolePrivilegeByCustomRoleId(long l) {
        return this.getDepAndCRolePrivilegeByRoleId(this.customRoleDepAndCRoleIDMap.entrySet(), l);
    }

    @Override
    public Set<RoleDepAndCRolePrivilege> findDepAndCRolePrivilegeByCustomRoleName(String string) {
        return this.getDepAndCRolePrivilegeByRoleName(this.customRoleDepAndCRoleIDMap.entrySet(), string);
    }

    private Set<RoleDepAndCRolePrivilege> getDepAndCRolePrivilegeByRoleId(Set<Map.Entry<Long, RoleDepAndCRolePrivilege>> set, long l) {
        HashSet<RoleDepAndCRolePrivilege> hashSet = new HashSet<RoleDepAndCRolePrivilege>();
        for (Map.Entry<Long, RoleDepAndCRolePrivilege> entry : set) {
            RoleDepAndCRolePrivilege roleDepAndCRolePrivilege = entry.getValue();
            if (roleDepAndCRolePrivilege.getRoleid() != l) continue;
            hashSet.add(roleDepAndCRolePrivilege);
        }
        return hashSet;
    }

    private Set<RoleDepAndCRolePrivilege> getDepAndCRolePrivilegeByRoleName(Set<Map.Entry<Long, RoleDepAndCRolePrivilege>> set, String string) {
        HashSet<RoleDepAndCRolePrivilege> hashSet = new HashSet<RoleDepAndCRolePrivilege>();
        for (Map.Entry<Long, RoleDepAndCRolePrivilege> entry : set) {
            CustomRoleDepAndCRolePrivilege customRoleDepAndCRolePrivilege = (CustomRoleDepAndCRolePrivilege)entry.getValue();
            if (!ComparatorUtils.equals((String)customRoleDepAndCRolePrivilege.getRoleName(), (String)string)) continue;
            hashSet.add(customRoleDepAndCRolePrivilege);
        }
        return hashSet;
    }

    @Override
    public Set<RoleEntryPrivilege> findEntryPrivilegesByJRoleId(long l) {
        return this.getEntryPrivilegeByRoleId(this.companyRolePrivilegeIDMap.entrySet(), l);
    }

    @Override
    public Set<RoleEntryPrivilege> findEntryPrivilegesBySRoleId(long l) {
        return this.getEntryPrivilegeByRoleId(this.customRolePrivilegeIDMap.entrySet(), l);
    }

    @Override
    public Set<RoleEntryPrivilege> findEntryPrivilegesBySRoleName(String string) {
        return this.getEntryPrivilegeByRoleName(this.customRolePrivilegeIDMap.entrySet(), string);
    }

    private Set<RoleEntryPrivilege> getEntryPrivilegeByRoleId(Set<Map.Entry<Long, RoleEntryPrivilege>> set, long l) {
        HashSet<RoleEntryPrivilege> hashSet = new HashSet<RoleEntryPrivilege>();
        for (Map.Entry<Long, RoleEntryPrivilege> entry : set) {
            RoleEntryPrivilege roleEntryPrivilege = entry.getValue();
            if (roleEntryPrivilege.getRoleId() != l) continue;
            hashSet.add(roleEntryPrivilege);
        }
        return hashSet;
    }

    private Set<RoleEntryPrivilege> getEntryPrivilegeByRoleName(Set<Map.Entry<Long, RoleEntryPrivilege>> set, String string) {
        HashSet<RoleEntryPrivilege> hashSet = new HashSet<RoleEntryPrivilege>();
        for (Map.Entry<Long, RoleEntryPrivilege> entry : set) {
            CustomRoleEntryPrivilege customRoleEntryPrivilege = (CustomRoleEntryPrivilege)entry.getValue();
            if (!ComparatorUtils.equals((String)customRoleEntryPrivilege.getRoleName(), (String)string)) continue;
            hashSet.add(customRoleEntryPrivilege);
        }
        return hashSet;
    }

    @Override
    public Set<RoleESPrivilege> findESPrivilegesByJRoleId(long l) {
        return this.getESPrivilegeByRoleId(this.companyRoleESPrivilegeIDMap.entrySet(), l);
    }

    @Override
    public Set<RoleESPrivilege> findESPrivilegesBySRoleId(long l) {
        return this.getESPrivilegeByRoleId(this.customRoleESPrivilegeIDMap.entrySet(), l);
    }

    private Set<RoleESPrivilege> getESPrivilegeByRoleId(Set<Map.Entry<Long, RoleESPrivilege>> set, long l) {
        HashSet<RoleESPrivilege> hashSet = new HashSet<RoleESPrivilege>();
        for (Map.Entry<Long, RoleESPrivilege> entry : set) {
            RoleESPrivilege roleESPrivilege = entry.getValue();
            if (roleESPrivilege.getRoleId() != l) continue;
            hashSet.add(roleESPrivilege);
        }
        return hashSet;
    }

    @Override
    public Set<RoleModulePrivilege> findModulePrivilegesByJRoleId(long l) throws CloneNotSupportedException {
        return this.getModulePrivilegeByRoldId(this.companyRoleModuleIDMap.entrySet(), l);
    }

    @Override
    public Set<RoleModulePrivilege> findModulePrivilegesBySRoleId(long l) throws CloneNotSupportedException {
        return this.getModulePrivilegeByRoldId(this.customRoleModuleIDMap.entrySet(), l);
    }

    @Override
    public Set<RoleModulePrivilege> findModulePrivilegeBySRoleName(String string) throws CloneNotSupportedException {
        return this.getModulePrivilegeByRoleName(this.customRoleModuleIDMap.entrySet(), string);
    }

    private Set<RoleModulePrivilege> getModulePrivilegeByRoleName(Set<Map.Entry<Long, RoleModulePrivilege>> set, String string) {
        HashSet<RoleModulePrivilege> hashSet = new HashSet<RoleModulePrivilege>();
        for (Map.Entry<Long, RoleModulePrivilege> entry : set) {
            CustomRoleModulePrivilege customRoleModulePrivilege = (CustomRoleModulePrivilege)entry.getValue();
            if (!ComparatorUtils.equals((String)customRoleModulePrivilege.getRoleName(), (String)string)) continue;
            hashSet.add(customRoleModulePrivilege);
        }
        return hashSet;
    }

    private Set<RoleModulePrivilege> getModulePrivilegeByRoldId(Set<Map.Entry<Long, RoleModulePrivilege>> set, long l) throws CloneNotSupportedException {
        HashSet<RoleModulePrivilege> hashSet = new HashSet<RoleModulePrivilege>();
        for (Map.Entry<Long, RoleModulePrivilege> entry : set) {
            RoleModulePrivilege roleModulePrivilege = entry.getValue();
            if (roleModulePrivilege.getRoleId() != l) continue;
            hashSet.add(roleModulePrivilege);
        }
        return hashSet;
    }

    @Override
    public Set<RoleHomePagePrivilege> findHomePagePrivilegesByJRoleId(long l) throws CloneNotSupportedException {
        return this.getHomePagePrivilegeByRoleId(this.companyRoleHomePageIDMap.entrySet(), l);
    }

    @Override
    public Set<RoleHomePagePrivilege> findHomePagePrivilegesBySRoleId(long l) throws CloneNotSupportedException {
        return this.getHomePagePrivilegeByRoleId(this.customRoleHomePageIDMap.entrySet(), l);
    }

    @Override
    public Set<RoleHomePagePrivilege> findHomePagePrivilegeBySRoleName(String string) throws CloneNotSupportedException {
        return this.getHomePagePrivilegeByRoleName(this.customRoleHomePageIDMap.entrySet(), string);
    }

    private Set<RoleHomePagePrivilege> getHomePagePrivilegeByRoleName(Set<Map.Entry<Long, RoleHomePagePrivilege>> set, String string) {
        HashSet<RoleHomePagePrivilege> hashSet = new HashSet<RoleHomePagePrivilege>();
        for (Map.Entry<Long, RoleHomePagePrivilege> entry : set) {
            CustomRoleHomePagePrivilege customRoleHomePagePrivilege = (CustomRoleHomePagePrivilege)entry.getValue();
            if (!ComparatorUtils.equals((String)customRoleHomePagePrivilege.getRoleName(), (String)string) || customRoleHomePagePrivilege.getView() <= 0L) continue;
            hashSet.add(customRoleHomePagePrivilege);
        }
        return hashSet;
    }

    private Set<RoleHomePagePrivilege> getHomePagePrivilegeByRoleId(Set<Map.Entry<Long, RoleHomePagePrivilege>> set, long l) throws CloneNotSupportedException {
        HashSet<RoleHomePagePrivilege> hashSet = new HashSet<RoleHomePagePrivilege>();
        for (Map.Entry<Long, RoleHomePagePrivilege> entry : set) {
            RoleHomePagePrivilege roleHomePagePrivilege = entry.getValue();
            if (roleHomePagePrivilege.getRoleId() != l) continue;
            hashSet.add(roleHomePagePrivilege);
        }
        return hashSet;
    }

    @Override
    public Set<RelationObject> findPrivilegesByCompanyRoleIDWithPlateName(long l, String string) throws CloneNotSupportedException {
        Map<Long, RoleEntryPrivilege> map = this.companyRolePlateIDMap.get(string);
        if (map == null) {
            return new HashSet<RelationObject>();
        }
        return this.getPrivilegesByRoleIdWithPlateName(map.entrySet(), l, string);
    }

    @Override
    public Set<RelationObject> findPrivilegesByCustomRoleIDWithPlateName(long l, String string) throws CloneNotSupportedException {
        Map<Long, RoleEntryPrivilege> map = this.customRolePlateIDMap.get(string);
        if (map == null) {
            return new HashSet<RelationObject>();
        }
        return this.getPrivilegesByRoleIdWithPlateName(map.entrySet(), l, string);
    }

    private Set<RelationObject> getPrivilegesByRoleIdWithPlateName(Set<Map.Entry<Long, RoleEntryPrivilege>> set, long l, String string) throws CloneNotSupportedException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Map.Entry<Long, RoleEntryPrivilege> entry : set) {
            RoleEntryPrivilege roleEntryPrivilege = entry.getValue();
            if (roleEntryPrivilege.getRoleId() != l) continue;
            arrayList.add(PlateFactory.createPrivilegeObject4Plate(roleEntryPrivilege.getEntryid(), string));
        }
        return this.getSetFromList(arrayList, ClassArrayKey.getInstance((Class[])new Class[]{PlateFactory.getRelationClassByName(string)}), false);
    }

    @Override
    public boolean updateSRoleTemplatePrivileges(String string, List<RoleTemplatePrivilege> list, List<RoleTemplatePrivilege> list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleName(string);
        return this.updateRoleTemplatePrivileges(customRole, list, list2, this.customRoleTemplateIDMap, false);
    }

    @Override
    public boolean updateJRoleTemplatePrivileges(long l, List<RoleTemplatePrivilege> list, List<RoleTemplatePrivilege> list2) {
        CompanyRole companyRole = this.findJRoleByCompanyRoleID(l);
        return this.updateRoleTemplatePrivileges(companyRole, list, list2, this.companyRoleTemplateIDMap, true);
    }

    @Override
    public boolean removeAllJRoleTemplatePrivileges() {
        this.companyRoleTemplateIDMap.clear();
        TableDataDAOControl.getInstance().writeJRoleTemplatePrivilegeTableData(this.customRoleTemplateIDMap.entrySet());
        TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
        return true;
    }

    @Override
    public boolean removeAllSRoleTemplatePrivileges() {
        this.customRoleTemplateIDMap.clear();
        TableDataDAOControl.getInstance().writeSRoleTemplatePrivilegeTableData(this.customRoleTemplateIDMap.entrySet());
        TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
        return true;
    }

    @Override
    public boolean removeSRoleTemplatePrivileges(long l) {
        return this.removeTemplatePrivilegesFromMap(this.customRoleTemplateIDMap, l);
    }

    private boolean removeTemplatePrivilegesFromMap(Map<Long, RoleTemplatePrivilege> map, long l) {
        Set<Map.Entry<Long, RoleTemplatePrivilege>> set = map.entrySet();
        for (Map.Entry<Long, RoleTemplatePrivilege> entry : set) {
            if (entry.getValue().getRoleId() != l) continue;
            map.remove(entry.getKey());
        }
        TableDataDAOControl.getInstance().writeJRoleTemplatePrivilegeTableData(map.entrySet());
        TableDataDAOControl.getInstance().writeSRoleTemplatePrivilegeTableData(map.entrySet());
        TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
        return true;
    }

    @Override
    public boolean removeJRoleTemplatePrivileges(long l) {
        return this.removeTemplatePrivilegesFromMap(this.companyRoleTemplateIDMap, l);
    }

    @Override
    public boolean updateSRoleTemplatePrivileges(long l, List<RoleTemplatePrivilege> list, List<RoleTemplatePrivilege> list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleID(l);
        return this.updateRoleTemplatePrivileges(customRole, list, list2, this.customRoleTemplateIDMap, false);
    }

    private boolean updateRoleTemplatePrivileges(DAOBean dAOBean, List<RoleTemplatePrivilege> list, List<RoleTemplatePrivilege> list2, Map<Long, RoleTemplatePrivilege> map, boolean bl) {
        if (dAOBean != null) {
            map = this.makeTemplateTable(dAOBean, list, list2, map, bl);
            if (bl) {
                TableDataDAOControl.getInstance().writeJRoleTemplatePrivilegeTableData(map.entrySet());
            } else {
                TableDataDAOControl.getInstance().writeSRoleTemplatePrivilegeTableData(map.entrySet());
            }
            TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private Map<Long, RoleTemplatePrivilege> makeTemplateTable(DAOBean dAOBean, List<RoleTemplatePrivilege> list, List<RoleTemplatePrivilege> list2, Map<Long, RoleTemplatePrivilege> map, boolean bl) {
        if (list2 != null && !list2.isEmpty()) {
            ArrayList arrayList = new ArrayList();
            block0: for (Map.Entry<Long, RoleTemplatePrivilege> entry : map.entrySet()) {
                RoleTemplatePrivilege roleTemplatePrivilege = entry.getValue();
                if (!this.isSameRole(roleTemplatePrivilege, dAOBean)) continue;
                for (RoleTemplatePrivilege roleTemplatePrivilege2 : list2) {
                    if (!ComparatorUtils.equals((String)roleTemplatePrivilege.getPath(), (String)roleTemplatePrivilege2.getPath())) continue;
                    arrayList.add(entry.getKey());
                    continue block0;
                }
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, RoleTemplatePrivilege> entry;
                entry = (Long)iterator.next();
                map.remove(entry);
            }
        }
        if (list != null && !list.isEmpty()) {
            for (RoleTemplatePrivilege roleTemplatePrivilege : list) {
                void var7_12;
                long l = this.generateID(map);
                roleTemplatePrivilege.setId(l);
                roleTemplatePrivilege.setRoleId(dAOBean.getId());
                if (!bl) {
                    CustomRoleTemplatePrivilege customRoleTemplatePrivilege = new CustomRoleTemplatePrivilege(dAOBean.getId(), roleTemplatePrivilege.getPath(), roleTemplatePrivilege.getPage(), roleTemplatePrivilege.getWrite(), roleTemplatePrivilege.getDesign(), ((CustomRole)dAOBean).getRolename());
                    customRoleTemplatePrivilege.setId(l);
                }
                map.put(l, (RoleTemplatePrivilege)var7_12);
            }
        }
        return map;
    }

    @Override
    public boolean updateJRoleDataConnectionPrivileges(long l, List<String> list, List<String> list2) {
        CompanyRole companyRole = this.findJRoleByCompanyRoleID(l);
        return this.updateRoleDataConnectionPrivileges(companyRole, list, list2, this.companyRoleDataConnectionIDMap, true);
    }

    @Override
    public boolean updateSRoleDataConnectionPrivileges(long l, List<String> list, List<String> list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleID(l);
        return this.updateRoleDataConnectionPrivileges(customRole, list, list2, this.customRoleDataConnectionIDMap, false);
    }

    @Override
    public boolean updateSRoleDataConnectionPrivileges(String string, List<String> list, List<String> list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleName(string);
        return this.updateRoleDataConnectionPrivileges(customRole, list, list2, this.customRoleDataConnectionIDMap, false);
    }

    private boolean updateRoleDataConnectionPrivileges(DAOBean dAOBean, List<String> list, List<String> list2, Map<Long, RoleDataConnectionPrivilege> map, boolean bl) {
        if (dAOBean != null) {
            map = this.makeDataConnectionTable(dAOBean, list, list2, map, bl);
            if (bl) {
                TableDataDAOControl.getInstance().writeJRoleDataConnectionPrivilegeTableData(map.entrySet());
            } else {
                TableDataDAOControl.getInstance().writeSRoleDataConnectionPrivilegeTableData(map.entrySet());
            }
            TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
            return true;
        }
        return false;
    }

    private Map<Long, RoleDataConnectionPrivilege> makeDataConnectionTable(DAOBean dAOBean, List<String> list, List<String> list2, Map<Long, RoleDataConnectionPrivilege> map, boolean bl) {
        Object object2;
        if (list2 != null && !list2.isEmpty()) {
            ArrayList arrayList = new ArrayList();
            block0: for (Object object2 : map.entrySet()) {
                RoleDataConnectionPrivilege roleDataConnectionPrivilege = object2.getValue();
                if (!this.isSameRole(roleDataConnectionPrivilege, dAOBean)) continue;
                for (String string : list2) {
                    if (!ComparatorUtils.equals((String)roleDataConnectionPrivilege.getName(), (String)string)) continue;
                    arrayList.add(object2.getKey());
                    continue block0;
                }
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object2 = (Long)iterator.next();
                map.remove(object2);
            }
        }
        if (list != null && !list.isEmpty()) {
            for (String string : list) {
                object2 = new RoleDataConnectionPrivilege();
                long l = this.generateID(map);
                object2.setId(l);
                ((RoleDataConnectionPrivilege)((Object)object2)).setRoleId(dAOBean.getId());
                ((RoleDataConnectionPrivilege)((Object)object2)).setName(string);
                ((RoleDataConnectionPrivilege)((Object)object2)).setView(1L);
                if (!bl) {
                    object2 = new CustomRoleDataConnectionPrivilege(dAOBean.getId(), string, 1L, ((CustomRole)dAOBean).getRolename());
                    object2.setId(l);
                }
                map.put(l, (RoleDataConnectionPrivilege)((Object)object2));
            }
        }
        return map;
    }

    @Override
    public boolean updateSRoleEntryPrivileges(long l, List<EntryTypeAndID> list, List<EntryTypeAndID> list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleID(l);
        return this.updateRoleEntryPrivileges(customRole, list, list2, this.customRolePrivilegeIDMap, false);
    }

    @Override
    public boolean updateJRoleEntryPrivileges(long l, List<EntryTypeAndID> list, List<EntryTypeAndID> list2) {
        CompanyRole companyRole = this.findJRoleByCompanyRoleID(l);
        return this.updateRoleEntryPrivileges(companyRole, list, list2, this.companyRolePrivilegeIDMap, true);
    }

    @Override
    public boolean updateSRoleEntryPrivileges(String string, List<EntryTypeAndID> list, List<EntryTypeAndID> list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleName(string);
        return this.updateRoleEntryPrivileges(customRole, list, list2, this.customRolePrivilegeIDMap, false);
    }

    private boolean updateRoleEntryPrivileges(DAOBean dAOBean, List<EntryTypeAndID> list, List<EntryTypeAndID> list2, Map<Long, RoleEntryPrivilege> map, boolean bl) {
        if (dAOBean != null) {
            map = this.makeTable(dAOBean, list, list2, map, bl);
            if (bl) {
                TableDataDAOControl.getInstance().writeJRoleEnrtyPrivilegeTableData(map.entrySet());
            } else {
                TableDataDAOControl.getInstance().writeSRoleEnrtyPrivilegeTableData(map.entrySet());
            }
            TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
            return true;
        }
        return false;
    }

    private Map<Long, RoleEntryPrivilege> makeTable(DAOBean dAOBean, List<EntryTypeAndID> list, List<EntryTypeAndID> list2, Map<Long, RoleEntryPrivilege> map, boolean bl) {
        if (list2 != null && !list2.isEmpty()) {
            ArrayList arrayList = new ArrayList();
            block0: for (Map.Entry<Long, RoleEntryPrivilege> entry : map.entrySet()) {
                RoleEntryPrivilege roleEntryPrivilege = entry.getValue();
                if (!this.isSameRole(roleEntryPrivilege, dAOBean)) continue;
                for (EntryTypeAndID entryTypeAndID : list2) {
                    if (entryTypeAndID.getId() != roleEntryPrivilege.getEntryid() || entryTypeAndID.getType() != roleEntryPrivilege.getType()) continue;
                    arrayList.add(entry.getKey());
                    continue block0;
                }
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, RoleEntryPrivilege> entry;
                entry = (Long)iterator.next();
                map.remove(entry);
            }
        }
        if (list != null && !list.isEmpty()) {
            for (EntryTypeAndID entryTypeAndID : list) {
                long l = this.generateID(map);
                RoleEntryPrivilege roleEntryPrivilege = bl ? new CompanyRoleEntryPrivilege(l) : new CustomRoleEntryPrivilege(l);
                roleEntryPrivilege.setEntryid(entryTypeAndID.getId());
                roleEntryPrivilege.setRoleId(dAOBean.getId());
                roleEntryPrivilege.setType(entryTypeAndID.getType());
                roleEntryPrivilege.setView(entryTypeAndID.getView());
                roleEntryPrivilege.setAuthorized(entryTypeAndID.getAuthorized());
                roleEntryPrivilege.setEdit(entryTypeAndID.getEdit());
                if (!bl) {
                    ((CustomRoleEntryPrivilege)roleEntryPrivilege).setRoleName(((CustomRole)dAOBean).getRolename());
                }
                map.put(l, roleEntryPrivilege);
            }
        }
        return map;
    }

    @Override
    public boolean updateJRoleESPrivileges(long l, List<EntryTypeAndID> list, List<EntryTypeAndID> list2) {
        CompanyRole companyRole = this.findJRoleByCompanyRoleID(l);
        return this.updateRoleESPrivileges(companyRole, list, list2, this.companyRoleESPrivilegeIDMap, true);
    }

    @Override
    public boolean updateSRoleESPrivileges(long l, List<EntryTypeAndID> list, List<EntryTypeAndID> list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleID(l);
        return this.updateRoleESPrivileges(customRole, list, list2, this.customRoleESPrivilegeIDMap, false);
    }

    private boolean updateRoleESPrivileges(DAOBean dAOBean, List<EntryTypeAndID> list, List<EntryTypeAndID> list2, Map<Long, RoleESPrivilege> map, boolean bl) {
        if (dAOBean != null) {
            map = this.makeESTable(dAOBean, list, list2, map, bl);
            if (bl) {
                TableDataDAOControl.getInstance().writeJRoleESPrivilegeTableData(map.entrySet());
            } else {
                TableDataDAOControl.getInstance().writeSRoleESPrivilegeTableData(map.entrySet());
            }
            TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
            return true;
        }
        return false;
    }

    private Map<Long, RoleESPrivilege> makeESTable(DAOBean dAOBean, List<EntryTypeAndID> list, List<EntryTypeAndID> list2, Map<Long, RoleESPrivilege> map, boolean bl) {
        if (list2 != null && !list2.isEmpty()) {
            ArrayList arrayList = new ArrayList();
            block0: for (Map.Entry<Long, RoleESPrivilege> entry : map.entrySet()) {
                RoleESPrivilege roleESPrivilege = entry.getValue();
                if (roleESPrivilege.getRoleId() != dAOBean.getId()) continue;
                for (EntryTypeAndID entryTypeAndID : list2) {
                    if (entryTypeAndID.getId() != roleESPrivilege.getEntryID() || entryTypeAndID.getType() != roleESPrivilege.getType()) continue;
                    arrayList.add(entry.getKey());
                    continue block0;
                }
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, RoleESPrivilege> entry;
                entry = (Long)iterator.next();
                map.remove(entry);
            }
        }
        if (list != null && !list.isEmpty()) {
            for (EntryTypeAndID entryTypeAndID : list) {
                long l = this.generateID(map);
                RoleESPrivilege roleESPrivilege = bl ? new CompanyRoleESPrivilege(l) : new CustomRoleESPrivilege(l);
                roleESPrivilege.setEntryID(entryTypeAndID.getId());
                roleESPrivilege.setRoleId(dAOBean.getId());
                roleESPrivilege.setType(entryTypeAndID.getType());
                map.put(l, roleESPrivilege);
            }
        }
        return map;
    }

    @Override
    public boolean updateCompanyRoleDepAndCRolePrivileges(long l, List<String> list, List<String> list2) {
        CompanyRole companyRole = this.findJRoleByCompanyRoleID(l);
        if (this.updateRoleDepAndCRolePrivileges(companyRole, list, list2, this.companyRoleDepAndCRoleIDMap, true)) {
            TableDataDAOControl.getInstance().writeCompanyRoleDepAndCRolePrivilegeTableData(this.companyRoleDepAndCRoleIDMap.entrySet());
            TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
            return true;
        }
        return false;
    }

    @Override
    public boolean updateCustomRoleDepAndCRolePrivileges(long l, List<String> list, List<String> list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleID(l);
        if (this.updateRoleDepAndCRolePrivileges(customRole, list, list2, this.customRoleDepAndCRoleIDMap, false)) {
            TableDataDAOControl.getInstance().writeCustomRoleDepAndCRolePrivilegeTableData(this.customRoleDepAndCRoleIDMap.entrySet());
            TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
            return true;
        }
        return false;
    }

    @Override
    public boolean updateCustomRoleDepAndCRolePrivileges(String string, List<String> list, List<String> list2) throws Exception {
        CustomRole customRole = this.findSRoleBySRoleName(string);
        if (this.updateRoleDepAndCRolePrivileges(customRole, list, list2, this.customRoleDepAndCRoleIDMap, false)) {
            TableDataDAOControl.getInstance().writeCustomRoleDepAndCRolePrivilegeTableData(this.customRoleDepAndCRoleIDMap.entrySet());
            TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
            return true;
        }
        return false;
    }

    private boolean updateRoleDepAndCRolePrivileges(DAOBean dAOBean, List<String> list, List<String> list2, Map<Long, RoleDepAndCRolePrivilege> map, boolean bl) {
        if (dAOBean != null) {
            if (map == null) {
                return true;
            }
            this.removeRoleDepAndCRolePrivilege(dAOBean, list2, map);
            this.addRoleDepAndCRolePrivilege(dAOBean, list, map, bl);
            return true;
        }
        return false;
    }

    private void addRoleDepAndCRolePrivilege(DAOBean dAOBean, List<String> list, Map<Long, RoleDepAndCRolePrivilege> map, boolean bl) {
        if (list != null && !list.isEmpty()) {
            for (String string : list) {
                RoleDepAndCRolePrivilege roleDepAndCRolePrivilege = new RoleDepAndCRolePrivilege();
                long l = this.generateID(map);
                roleDepAndCRolePrivilege.setId(l);
                roleDepAndCRolePrivilege.setRoleid(dAOBean.getId());
                roleDepAndCRolePrivilege.setType(Integer.parseInt(string.substring(0, 1)));
                if (string.substring(1).startsWith("-")) {
                    roleDepAndCRolePrivilege.setDeporcroleid(0L - Long.parseLong(string.substring(2)));
                } else {
                    roleDepAndCRolePrivilege.setDeporcroleid(Long.parseLong(string.substring(1)));
                }
                if (!bl) {
                    roleDepAndCRolePrivilege = new CustomRoleDepAndCRolePrivilege(roleDepAndCRolePrivilege.getRoleid(), roleDepAndCRolePrivilege.getType(), roleDepAndCRolePrivilege.getDeporcroleid(), ((CustomRole)dAOBean).getRolename());
                    roleDepAndCRolePrivilege.setId(l);
                }
                map.put(l, roleDepAndCRolePrivilege);
            }
        }
    }

    private void removeRoleDepAndCRolePrivilege(DAOBean dAOBean, List<String> list, Map<Long, RoleDepAndCRolePrivilege> map) {
        if (list != null && !list.isEmpty()) {
            ArrayList arrayList = new ArrayList();
            block0: for (Map.Entry<Long, RoleDepAndCRolePrivilege> entry : map.entrySet()) {
                RoleDepAndCRolePrivilege roleDepAndCRolePrivilege = entry.getValue();
                if (!this.isSameRole(roleDepAndCRolePrivilege, dAOBean)) continue;
                for (String string : list) {
                    long l;
                    long l2;
                    if (string.startsWith("2")) {
                        l2 = 2L;
                        l = string.substring(1).startsWith("-") ? 0L - Long.parseLong(string.substring(2)) : Long.parseLong(string.substring(1));
                    } else {
                        l2 = 1L;
                        l = Long.parseLong(string.substring(1));
                    }
                    if (roleDepAndCRolePrivilege.getDeporcroleid() != l || (long)roleDepAndCRolePrivilege.getType() != l2) continue;
                    arrayList.add(entry.getKey());
                    continue block0;
                }
            }
            for (Map.Entry<Long, RoleDepAndCRolePrivilege> entry : arrayList) {
                map.remove(entry);
            }
        }
    }

    private boolean isSameRole(RoleEntryPrivilege roleEntryPrivilege, DAOBean dAOBean) {
        if (dAOBean.getId() <= -1000L) {
            return roleEntryPrivilege instanceof CustomRoleEntryPrivilege && dAOBean instanceof CustomRole && ComparatorUtils.equals((String)((CustomRoleEntryPrivilege)roleEntryPrivilege).getRoleName(), (String)((CustomRole)dAOBean).getRolename());
        }
        return dAOBean.getId() == roleEntryPrivilege.getRoleId();
    }

    private boolean isSameRole(RoleModulePrivilege roleModulePrivilege, DAOBean dAOBean) {
        if (dAOBean.getId() <= -1000L) {
            return roleModulePrivilege instanceof CustomRoleModulePrivilege && dAOBean instanceof CustomRole && ComparatorUtils.equals((String)((CustomRoleModulePrivilege)roleModulePrivilege).getRoleName(), (String)((CustomRole)dAOBean).getRolename());
        }
        return dAOBean.getId() == roleModulePrivilege.getRoleId();
    }

    private boolean isSameRole(RoleHomePagePrivilege roleHomePagePrivilege, DAOBean dAOBean) {
        if (dAOBean.getId() <= -1000L) {
            return roleHomePagePrivilege instanceof CustomRoleHomePagePrivilege && dAOBean instanceof CustomRole && ComparatorUtils.equals((String)((CustomRoleHomePagePrivilege)roleHomePagePrivilege).getRoleName(), (String)((CustomRole)dAOBean).getRolename());
        }
        return dAOBean.getId() == roleHomePagePrivilege.getRoleId();
    }

    private boolean isSameRole(RoleTemplatePrivilege roleTemplatePrivilege, DAOBean dAOBean) {
        if (dAOBean.getId() <= -1000L) {
            return roleTemplatePrivilege instanceof CustomRoleTemplatePrivilege && dAOBean instanceof CustomRole && ComparatorUtils.equals((String)((CustomRoleTemplatePrivilege)roleTemplatePrivilege).getRoleName(), (String)((CustomRole)dAOBean).getRolename());
        }
        return dAOBean.getId() == roleTemplatePrivilege.getRoleId();
    }

    private boolean isSameRole(RoleDataConnectionPrivilege roleDataConnectionPrivilege, DAOBean dAOBean) {
        if (dAOBean.getId() <= -1000L) {
            return roleDataConnectionPrivilege instanceof CustomRoleDataConnectionPrivilege && dAOBean instanceof CustomRole && ComparatorUtils.equals((String)((CustomRoleDataConnectionPrivilege)roleDataConnectionPrivilege).getRoleName(), (String)((CustomRole)dAOBean).getRolename());
        }
        return dAOBean.getId() == roleDataConnectionPrivilege.getRoleId();
    }

    private boolean isSameRole(RoleDepAndCRolePrivilege roleDepAndCRolePrivilege, DAOBean dAOBean) {
        if (dAOBean.getId() <= -1000L) {
            return roleDepAndCRolePrivilege instanceof CustomRoleDepAndCRolePrivilege && dAOBean instanceof CustomRole && ComparatorUtils.equals((String)((CustomRoleDepAndCRolePrivilege)roleDepAndCRolePrivilege).getRoleName(), (String)((CustomRole)dAOBean).getRolename());
        }
        return dAOBean.getId() == roleDepAndCRolePrivilege.getRoleid();
    }

    @Override
    public boolean updateJRoleModulePrivileges(long l, List<RoleModulePrivilege> list, List<RoleModulePrivilege> list2) {
        CompanyRole companyRole = this.findJRoleByCompanyRoleID(l);
        if (this.updateRoleModulePrivileges(companyRole, list, list2, this.companyRoleModuleIDMap, true)) {
            TableDataDAOControl.getInstance().writeJRole_ModulePrivilegeTableData(this.companyRoleModuleIDMap.entrySet());
            TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
            return true;
        }
        return false;
    }

    @Override
    public boolean updateSRoleModulePrivileges(long l, List<RoleModulePrivilege> list, List<RoleModulePrivilege> list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleID(l);
        if (this.updateRoleModulePrivileges(customRole, list, list2, this.customRoleModuleIDMap, false)) {
            TableDataDAOControl.getInstance().writeSRole_ModulePrivilegeTableData(this.customRoleModuleIDMap.entrySet());
            TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
            return true;
        }
        return false;
    }

    @Override
    public boolean updateSRoleModulePrivileges(String string, List<RoleModulePrivilege> list, List<RoleModulePrivilege> list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleName(string);
        if (this.updateRoleModulePrivileges(customRole, list, list2, this.customRoleModuleIDMap, false)) {
            TableDataDAOControl.getInstance().writeSRole_ModulePrivilegeTableData(this.customRoleModuleIDMap.entrySet());
            TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean updateRoleModulePrivileges(DAOBean dAOBean, List<RoleModulePrivilege> list, List<RoleModulePrivilege> list2, Map<Long, RoleModulePrivilege> map, boolean bl) {
        if (dAOBean != null) {
            if (map == null) {
                return true;
            }
            if (list2 != null && !list2.isEmpty()) {
                ArrayList arrayList = new ArrayList();
                block0: for (Map.Entry<Long, RoleModulePrivilege> entry : map.entrySet()) {
                    RoleModulePrivilege roleModulePrivilege = entry.getValue();
                    if (!this.isSameRole(roleModulePrivilege, dAOBean)) continue;
                    for (RoleModulePrivilege roleModulePrivilege2 : list2) {
                        long l = roleModulePrivilege2.getModuleid();
                        if (l != roleModulePrivilege.getModuleid()) continue;
                        arrayList.add(entry.getKey());
                        continue block0;
                    }
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Long, RoleModulePrivilege> entry;
                    entry = (Long)iterator.next();
                    map.remove(entry);
                }
            }
            if (list != null && !list.isEmpty()) {
                for (RoleModulePrivilege roleModulePrivilege : list) {
                    void var7_12;
                    long l = this.generateID(map);
                    roleModulePrivilege.setId(l);
                    roleModulePrivilege.setRoleId(dAOBean.getId());
                    if (!bl) {
                        CustomRoleModulePrivilege customRoleModulePrivilege = new CustomRoleModulePrivilege(roleModulePrivilege.getRoleId(), roleModulePrivilege.getModuleid(), roleModulePrivilege.getView(), roleModulePrivilege.getAuthorized(), ((CustomRole)dAOBean).getRolename());
                        customRoleModulePrivilege.setId(l);
                    }
                    map.put(l, (RoleModulePrivilege)var7_12);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean updateCompanyRolePlatePrivileges(long l, List<RoleEntryPrivilege> list, List<RoleEntryPrivilege> list2, String string) {
        CompanyRole companyRole = this.findJRoleByCompanyRoleID(l);
        Map<Long, RoleEntryPrivilege> map = this.companyRolePlateIDMap.get(string);
        if (map == null) {
            return true;
        }
        if (this.updateRolePlatesPrivileges(companyRole, list, list2, map, true)) {
            TableDataDAOControl.getInstance().writeJRole_PlatePrivilegeTableData(map.entrySet(), string);
            TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
            return true;
        }
        return false;
    }

    @Override
    public boolean updateCustomRolePlatePrivileges(long l, List<RoleEntryPrivilege> list, List<RoleEntryPrivilege> list2, String string) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleID(l);
        Map<Long, RoleEntryPrivilege> map = this.customRolePlateIDMap.get(string);
        if (map == null) {
            return true;
        }
        if (this.updateRolePlatesPrivileges(customRole, list, list2, map, true)) {
            TableDataDAOControl.getInstance().writeSRole_PlatePrivilegeTableData(map.entrySet(), string);
            TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean updateRolePlatesPrivileges(DAOBean dAOBean, List<RoleEntryPrivilege> list, List<RoleEntryPrivilege> list2, Map<Long, RoleEntryPrivilege> map, boolean bl) {
        if (dAOBean != null) {
            if (map == null) {
                return true;
            }
            if (list2 != null && !list2.isEmpty()) {
                ArrayList arrayList = new ArrayList();
                block0: for (Map.Entry<Long, RoleEntryPrivilege> entry : map.entrySet()) {
                    RoleEntryPrivilege roleEntryPrivilege = entry.getValue();
                    if (!this.isSameRole(roleEntryPrivilege, dAOBean)) continue;
                    for (RoleEntryPrivilege roleEntryPrivilege2 : list2) {
                        long l = roleEntryPrivilege2.getEntryid();
                        if (l != roleEntryPrivilege.getEntryid()) continue;
                        arrayList.add(entry.getKey());
                        continue block0;
                    }
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Long, RoleEntryPrivilege> entry;
                    entry = (Long)iterator.next();
                    map.remove(entry);
                }
            }
            if (list != null && !list.isEmpty()) {
                for (RoleEntryPrivilege roleEntryPrivilege : list) {
                    void var7_12;
                    long l = this.generateID(map);
                    roleEntryPrivilege.setId(l);
                    roleEntryPrivilege.setRoleId(dAOBean.getId());
                    if (!bl) {
                        CustomRoleEntryPrivilege customRoleEntryPrivilege = new CustomRoleEntryPrivilege(roleEntryPrivilege.getRoleId(), roleEntryPrivilege.getType(), roleEntryPrivilege.getEntryid(), roleEntryPrivilege.getView(), roleEntryPrivilege.getAuthorized(), roleEntryPrivilege.getEdit());
                        customRoleEntryPrivilege.setId(l);
                    }
                    map.put(l, (RoleEntryPrivilege)var7_12);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean updateJRoleHomePagePrivileges(long l, List<RoleHomePagePrivilege> list, List<RoleHomePagePrivilege> list2) {
        CompanyRole companyRole = this.findJRoleByCompanyRoleID(l);
        if (this.updateRoleHomePagePrivileges(companyRole, list, list2, this.companyRoleHomePageIDMap, true)) {
            TableDataDAOControl.getInstance().writeJRole_HomePagePrivilegeTableData(this.companyRoleHomePageIDMap.entrySet());
            TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
            return true;
        }
        return false;
    }

    @Override
    public boolean updateSRoleHomePagePrivileges(long l, List<RoleHomePagePrivilege> list, List<RoleHomePagePrivilege> list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleID(l);
        if (this.updateRoleHomePagePrivileges(customRole, list, list2, this.customRoleHomePageIDMap, false)) {
            TableDataDAOControl.getInstance().writeSRole_HomePagePrivilegeTableData(this.customRoleHomePageIDMap.entrySet());
            TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
            return true;
        }
        return false;
    }

    @Override
    public boolean updateSRoleHomePagePrivileges(String string, List<RoleHomePagePrivilege> list, List<RoleHomePagePrivilege> list2) throws CloneNotSupportedException {
        CustomRole customRole = this.findSRoleBySRoleName(string);
        if (this.updateRoleHomePagePrivileges(customRole, list, list2, this.customRoleHomePageIDMap, false)) {
            TableDataDAOControl.getInstance().writeSRole_HomePagePrivilegeTableData(this.customRoleHomePageIDMap.entrySet());
            TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean updateRoleHomePagePrivileges(DAOBean dAOBean, List<RoleHomePagePrivilege> list, List<RoleHomePagePrivilege> list2, Map<Long, RoleHomePagePrivilege> map, boolean bl) {
        if (dAOBean != null) {
            if (map == null) {
                return true;
            }
            if (list2 != null && !list2.isEmpty()) {
                ArrayList arrayList = new ArrayList();
                block0: for (Map.Entry<Long, RoleHomePagePrivilege> entry : map.entrySet()) {
                    RoleHomePagePrivilege roleHomePagePrivilege = entry.getValue();
                    if (!this.isSameRole(roleHomePagePrivilege, dAOBean)) continue;
                    for (RoleHomePagePrivilege roleHomePagePrivilege2 : list2) {
                        long l = roleHomePagePrivilege2.getHomePageId();
                        if (l != roleHomePagePrivilege.getHomePageId()) continue;
                        arrayList.add(entry.getKey());
                        continue block0;
                    }
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Long, RoleHomePagePrivilege> entry;
                    entry = (Long)iterator.next();
                    map.remove(entry);
                }
            }
            if (list != null && !list.isEmpty()) {
                for (RoleHomePagePrivilege roleHomePagePrivilege : list) {
                    void var7_12;
                    long l = this.generateID(map);
                    roleHomePagePrivilege.setId(l);
                    roleHomePagePrivilege.setRoleId(dAOBean.getId());
                    if (!bl) {
                        CustomRoleHomePagePrivilege customRoleHomePagePrivilege = new CustomRoleHomePagePrivilege(roleHomePagePrivilege.getRoleId(), roleHomePagePrivilege.getHomePageId(), roleHomePagePrivilege.getView(), ((CustomRole)dAOBean).getRolename());
                        customRoleHomePagePrivilege.setId(l);
                    }
                    map.put(l, (RoleHomePagePrivilege)var7_12);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isUserInRole(long l, long l2) {
        User user = this.findUserByUserId(l);
        if (user == null) {
            return false;
        }
        Collection<TableDataSRole_User> collection = this.customRoleUserIDMap.values();
        for (TableDataSRole_User tableDataSRole_User : collection) {
            if (!ComparatorUtils.equals((String)user.getUsername(), (String)tableDataSRole_User.getUserName()) || tableDataSRole_User.getsRoleId() != l2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean updatePost(Post post) {
        if (post == null) {
            return false;
        }
        Set<Map.Entry<String, Long>> set = this.id_postMap.entrySet();
        for (Map.Entry<String, Long> entry : set) {
            if (entry.getValue().longValue() != post.getId()) continue;
            this.id_postMap.remove(entry.getKey());
            this.id_postMap.put(post.getPostname(), post.getId());
            return true;
        }
        return false;
    }

    @Override
    public boolean updateDepartment(Department department) {
        Object object;
        if (department.getId() == -1L) {
            object = this.companyRoleIDListMap.values().iterator();
            while (object.hasNext()) {
                TableDataJRole tableDataJRole = object.next();
                if (!ComparatorUtils.equals((String)department.getName(), (String)tableDataJRole.getDpName()) || !ComparatorUtils.equals((Object)department.getPid(), (Object)tableDataJRole.getParentId())) continue;
                department.setId(tableDataJRole.getDpId());
                break;
            }
        }
        if (department.getId() == -1L) {
            department.setId(this.depId++);
        }
        if ((object = this.dp_idMap.get(department.getId())) != null) {
            this.dp_nameMap.remove(((Department)((Object)object)).getName() + ((Department)((Object)object)).getPid());
            this.dpAndParentDpNameMap.remove(((Department)((Object)object)).getName() + this.getParentAndFullParentName((Department)((Object)object)));
        }
        this.dp_idMap.put(department.getId(), department);
        this.dp_nameMap.put(department.getName() + department.getPid(), department);
        this.dpAndParentDpNameMap.put(department.getName() + this.getParentAndFullParentName(department), department);
        TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
        return true;
    }

    @Override
    public boolean deleteDepartment(long l) {
        Department department = this.dp_idMap.get(l);
        if (department != null) {
            this.dp_nameMap.remove(department.getName() + department.getPid());
            this.dpAndParentDpNameMap.remove(department.getName() + this.getParentAndFullParentName(department));
            this.dp_idMap.remove(l);
            TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
        }
        return true;
    }

    @Override
    public void addPost(Post post) {
        if (post.getId() == -1L) {
            post.setId(this.postId++);
        }
        this.id_postMap.put(post.getPostname(), post.getId());
        TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
    }

    @Override
    public boolean deletePost(long l) {
        for (Map.Entry<String, Long> entry : this.id_postMap.entrySet()) {
            if (l != entry.getValue()) continue;
            this.id_postMap.remove(entry.getKey());
            TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
            return true;
        }
        return true;
    }

    @Override
    public boolean updateJRole(long l, Department department, Post post) {
        TableDataJRole tableDataJRole = this.companyRoleIDListMap.get(l);
        if (tableDataJRole == null) {
            tableDataJRole = new TableDataJRole(l);
        }
        tableDataJRole.setDpName(department.getName());
        tableDataJRole.setPostName(post.getPostname());
        tableDataJRole.setDpId(department.getId());
        this.companyRoleIDListMap.put(l, tableDataJRole);
        TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
        return true;
    }

    @Override
    public void deleteJRole(long l) {
        this.companyRoleIDListMap.remove(l);
        TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
    }

    @Override
    public void addUser(User user) {
        if (user.getId() == -1L) {
            user.setId(this.userId++);
        }
        TableDataUser tableDataUser = new TableDataUser(user.getId(), user.getUsername(), user.getPassword());
        tableDataUser.setName(user.getRealname());
        tableDataUser.setEmail(user.getEmail());
        tableDataUser.setMobile(user.getMobile());
        this.tdUser_idListMap.put(tableDataUser.getId(), tableDataUser);
        this.tdUser_NameListMap.put(tableDataUser.getUserName(), tableDataUser);
        this.roleObjSet_idMap.clear();
        TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
    }

    @Override
    public void deleteUser(long l) {
        TableDataUser tableDataUser = this.tdUser_idListMap.get(l);
        if (tableDataUser == null) {
            return;
        }
        this.tdUser_NameListMap.remove(tableDataUser.getUserName());
        this.tdUser_idListMap.remove(l);
        for (Map.Entry<Long, TableDataSRole_User> entry : this.customRoleUserIDMap.entrySet()) {
            if (!ComparatorUtils.equals((String)entry.getValue().getUserName(), (String)tableDataUser.getUserName())) continue;
            this.customRoleUserIDMap.remove(entry.getKey());
        }
        this.roleObjSet_idMap.clear();
        TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
    }

    @Override
    public boolean addJob2User(long l, long l2, long l3) {
        TableDataUser tableDataUser = this.tdUser_idListMap.get(l);
        TableDataUser tableDataUser2 = this.tdUser_NameListMap.get(tableDataUser.getUserName());
        if (tableDataUser == null || tableDataUser2 == null) {
            return false;
        }
        Department department = this.findDepartmentByID(l2);
        Post post = this.findPostById(l3);
        if (department == null && post == null) {
            return false;
        }
        try {
            tableDataUser.addJob(department.getName(), post.getPostname(), department.getPid());
            tableDataUser2.addJob(department.getName(), post.getPostname(), department.getPid());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRContext.getLogger().error(cloneNotSupportedException.getMessage(), (Throwable)cloneNotSupportedException);
        }
        TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
        return true;
    }

    @Override
    public Department findDepartmentByName(String string) {
        return this.dp_nameMap.get(string);
    }

    @Override
    public boolean updateTableDataUser(long l, String string, String string2, String string3, String string4, String string5) {
        TableDataUser tableDataUser = this.tdUser_idListMap.get(l);
        if (tableDataUser == null) {
            return false;
        }
        if (!ComparatorUtils.equals((String)tableDataUser.getUserName(), (String)string)) {
            this.tdUser_NameListMap.remove(tableDataUser.getUserName());
            tableDataUser.setUserName(string);
        }
        tableDataUser.setName(string3);
        tableDataUser.setPassword(string2);
        tableDataUser.setMobile(string4);
        tableDataUser.setEmail(string5);
        this.tdUser_NameListMap.put(tableDataUser.getUserName(), tableDataUser);
        TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
        return true;
    }

    @Override
    public void removeJobFromUser(long l, RelationObject relationObject) {
        long l2 = (Long)relationObject.getValue(Department.class);
        long l3 = (Long)relationObject.getValue(Post.class);
        TableDataUser tableDataUser = this.tdUser_idListMap.get(l);
        if (tableDataUser == null) {
            return;
        }
        tableDataUser.removeJob(l2, l3);
        this.tdUser_NameListMap.put(tableDataUser.getUserName(), tableDataUser);
        TableDataSyncAndPersistenceThreadHolder.getInstance().getTableDataPersistenceThread().triggerWork(new TableDataPersistenceAction());
    }

    @Override
    public void writeTableData() {
        TableDataDAOControl.getInstance().writePostTableData(this.id_postMap.entrySet());
        TableDataDAOControl.getInstance().writeDepartmentTableData(this.dp_nameMap.entrySet());
        TableDataDAOControl.getInstance().writeSRoleTableData(this.customRoleIDListMap.entrySet());
        TableDataDAOControl.getInstance().writeJRoleTableData(this.companyRoleIDListMap.entrySet());
        TableDataDAOControl.getInstance().writeUserTableData(this.tdUser_idListMap.entrySet());
        TableDataDAOControl.getInstance().writeSRole_UserTableData(this.customRoleUserIDMap.entrySet());
    }

    @Override
    public Department findDepartmentByNameAndParentName(String string, String string2) {
        return this.dpAndParentDpNameMap.get(string + string2);
    }

    static {
        GeneralContext.addEnvChangedListener((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                tableDataSyncDB = null;
            }
        });
    }
}

