/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.cluster.rpc.RPC;
import com.fr.file.BaseClusterHelper;
import com.fr.fs.base.entity.UserDeviceInfo;
import com.fr.fs.cache.UserDeviceInfoCache;
import com.fr.fs.cache.UserDeviceInfoCacheProvider;
import com.fr.general.GeneralContext;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.EnvChangedListener;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDeviceInfoCacheImpl
implements UserDeviceInfoCacheProvider {
    private static UserDeviceInfoCacheProvider userDeviceInfoCacheProvider;

    public static UserDeviceInfoCacheProvider getInstance() {
        if (userDeviceInfoCacheProvider == null) {
            UserDeviceInfoCacheImpl.initCacheImpl();
        }
        return userDeviceInfoCacheProvider;
    }

    private static synchronized void initCacheImpl() {
        switch (BaseClusterHelper.getClusterState()) {
            case LEADER: {
                userDeviceInfoCacheProvider = new UserDeviceInfoCacheImpl();
                RPC.registerSkeleton((Object)userDeviceInfoCacheProvider);
                break;
            }
            case MEMBER: {
                String string = BaseClusterHelper.getMainServiceIP();
                userDeviceInfoCacheProvider = (UserDeviceInfoCacheProvider)RPC.getProxy(UserDeviceInfoCacheImpl.class, (String)string);
                break;
            }
            default: {
                userDeviceInfoCacheProvider = new UserDeviceInfoCacheImpl();
            }
        }
    }

    @Override
    public void initUserDeviceCache() throws Exception {
        UserDeviceInfoCache.initUserDeviceInfoCache();
    }

    @Override
    public void reInit() throws Exception {
        UserDeviceInfoCache.reInit();
    }

    @Override
    public List<UserDeviceInfo> getAllUserDeviceInfoByName(String string) {
        return UserDeviceInfoCache.getAllUserDeviceInfoByName(string);
    }

    @Override
    public JSONArray getAllUserDeviceJsonByName(String string) throws JSONException {
        return UserDeviceInfoCache.getAllUserDeviceJsonByName(string);
    }

    @Override
    public void cache(UserDeviceInfo userDeviceInfo) {
        UserDeviceInfoCache.cache(userDeviceInfo);
    }

    @Override
    public void removeCache(String string) {
        UserDeviceInfoCache.removeCache(string);
    }

    @Override
    public JSONObject getSortedUserDeviceJSONObject() throws JSONException {
        return UserDeviceInfoCache.getSortedUserDeviceJSONObject();
    }

    @Override
    public boolean updateByMacAddress(UserDeviceInfo userDeviceInfo) {
        return UserDeviceInfoCache.updateByMacAddress(userDeviceInfo);
    }

    @Override
    public boolean unbind(String string, String string2, boolean bl) {
        return UserDeviceInfoCache.unbind(string, string2, bl);
    }

    @Override
    public void bind(String string, String string2, String string3) {
        UserDeviceInfoCache.bind(string, string2, string3);
    }

    @Override
    public Set<String> getAllUsers() {
        return UserDeviceInfoCache.getAllUsers();
    }

    @Override
    public boolean containCache(String string) {
        return UserDeviceInfoCache.containCache(string);
    }

    @Override
    public long getDeviceId(UserDeviceInfo userDeviceInfo) {
        return UserDeviceInfoCache.getDeviceId(userDeviceInfo);
    }

    static {
        GeneralContext.addEnvChangedListener((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                UserDeviceInfoCacheImpl.userDeviceInfoCacheProvider = null;
            }
        });
    }
}

