/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.freehep.util.io.ByteOrderOutputStream;

public class ByteCountOutputStream
extends ByteOrderOutputStream {
    private int currentBuffer = -1;
    private List bufferList = new LinkedList();

    public ByteCountOutputStream(OutputStream outputStream, boolean bl) {
        super(outputStream, bl);
    }

    public void write(int n2) throws IOException {
        if (this.currentBuffer == -1) {
            super.write(n2);
            return;
        }
        Buffer buffer = (Buffer)this.bufferList.get(this.currentBuffer);
        buffer.add((byte)n2);
    }

    public void pushBuffer() throws IOException {
        this.append();
        this.bufferList.add(new Buffer());
        ++this.currentBuffer;
    }

    public int popBuffer() throws IOException {
        if (this.currentBuffer >= 0) {
            this.append();
            int n2 = this.getBufferLength();
            --this.currentBuffer;
            return n2;
        }
        return -1;
    }

    public byte[] popBufferBytes() throws IOException {
        int n2 = this.popBuffer();
        if (n2 >= 0) {
            Buffer buffer = (Buffer)this.bufferList.remove(this.currentBuffer + 1);
            return buffer.getBytes();
        }
        return new byte[0];
    }

    public int getBufferLength() {
        return this.currentBuffer >= 0 ? ((Buffer)this.bufferList.get(this.currentBuffer)).getLength() : -1;
    }

    public int getLength() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.bufferList.size(); ++i2) {
            n2 += ((Buffer)this.bufferList.get(i2)).getLength();
        }
        return this.currentBuffer >= 0 ? n2 : -1;
    }

    public void append() throws IOException {
        super.byteAlign();
        if (this.currentBuffer + 1 >= this.bufferList.size()) {
            return;
        }
        Buffer buffer = (Buffer)this.bufferList.get(this.currentBuffer + 1);
        if (buffer.getLength() > 0) {
            if (this.currentBuffer >= 0) {
                ((Buffer)this.bufferList.get(this.currentBuffer)).add(buffer);
            } else {
                super.write(buffer.getBytes(), 0, buffer.getLength());
            }
        }
        this.bufferList.remove(this.currentBuffer + 1);
    }

    public void close() throws IOException {
        this.append();
        super.close();
    }

    static class Buffer {
        byte[] buffer = new byte[256];
        int len = 0;

        Buffer() {
        }

        void add(byte by) {
            if (this.len + 1 > this.buffer.length) {
                byte[] byArray = new byte[this.buffer.length << 1];
                System.arraycopy(this.buffer, 0, byArray, 0, this.len);
                this.buffer = byArray;
            }
            this.buffer[this.len] = by;
            ++this.len;
        }

        void add(Buffer buffer) {
            int n2 = buffer.getLength();
            int n3 = this.len + n2;
            if (n3 > this.buffer.length) {
                byte[] byArray = new byte[n3];
                System.arraycopy(this.buffer, 0, byArray, 0, this.len);
                this.buffer = byArray;
            }
            System.arraycopy(buffer.getBytes(), 0, this.buffer, this.len, n2);
            this.len += n2;
        }

        int getLength() {
            return this.len;
        }

        byte[] getBytes() {
            return this.buffer;
        }
    }
}

