/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import org.freehep.graphicsio.swf.SWFActionSet;
import org.freehep.graphicsio.swf.SWFConstants;
import org.freehep.graphicsio.swf.SWFDictionary;
import org.freehep.graphicsio.swf.SWFHeader;
import org.freehep.graphicsio.swf.SWFSpriteTagSet;
import org.freehep.graphicsio.swf.SWFTagSet;
import org.freehep.util.io.ActionHeader;
import org.freehep.util.io.TagHeader;
import org.freehep.util.io.TaggedInputStream;

public class SWFInputStream
extends TaggedInputStream
implements SWFConstants {
    private SWFDictionary dictionary = new SWFDictionary();
    private byte[] jpegTable;
    private SWFHeader header;

    public SWFInputStream(InputStream inputStream) throws IOException {
        this(inputStream, 8);
    }

    public SWFInputStream(InputStream inputStream, int n2) throws IOException {
        this(inputStream, new SWFTagSet(n2), new SWFActionSet(n2));
    }

    public SWFInputStream(InputStream inputStream, SWFSpriteTagSet sWFSpriteTagSet, SWFActionSet sWFActionSet) throws IOException {
        super(inputStream, sWFSpriteTagSet, sWFActionSet, true);
    }

    public float readFixed() throws IOException {
        this.byteAlign();
        int n2 = this.readUnsignedByte();
        int n3 = this.readUnsignedByte();
        return (float)(n3 |= this.readUnsignedByte() << 8) + (float)(n2 |= this.readUnsignedByte() << 8) / 65536.0f;
    }

    public float readFixed8() throws IOException {
        this.byteAlign();
        int n2 = this.readUnsignedByte();
        int n3 = this.readUnsignedByte();
        return (float)n3 + (float)n2 / 256.0f;
    }

    public Rectangle2D readRect() throws IOException {
        this.byteAlign();
        int n2 = (int)this.readUBits(5);
        int n3 = (int)this.readSBits(n2);
        int n4 = (int)this.readSBits(n2);
        int n5 = (int)this.readSBits(n2);
        int n6 = (int)this.readSBits(n2);
        return new Rectangle2D.Double(n3 / 20, n5 / 20, (n4 - n3) / 20, (n6 - n5) / 20);
    }

    public Color readColor(boolean bl) throws IOException {
        int n2 = this.readUnsignedByte();
        int n3 = this.readUnsignedByte();
        int n4 = this.readUnsignedByte();
        int n5 = bl ? this.readUnsignedByte() : 255;
        return new Color(n2, n3, n4, n5);
    }

    public AffineTransform readMatrix() throws IOException {
        int n2;
        this.byteAlign();
        float f2 = 1.0f;
        float f3 = 1.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        if (this.readBitFlag()) {
            n2 = (int)this.readUBits(5);
            f2 = this.readFBits(n2);
            f3 = this.readFBits(n2);
        }
        if (this.readBitFlag()) {
            n2 = (int)this.readUBits(5);
            f4 = this.readFBits(n2);
            f5 = this.readFBits(n2);
        }
        n2 = (int)this.readUBits(5);
        f6 = (float)this.readSBits(n2) / 20.0f;
        f7 = (float)this.readSBits(n2) / 20.0f;
        return new AffineTransform(f2, f5, f4, f3, f6, f7);
    }

    public String readString() throws IOException {
        if (this.getVersion() >= 6) {
            String string = this.readUTF();
            this.readByte();
            return string;
        }
        return this.readAsciiZString();
    }

    public int readLanguageCode() throws IOException {
        return this.readUnsignedByte();
    }

    protected TagHeader readTagHeader() throws IOException {
        this.byteAlign();
        int n2 = this.read();
        if (n2 == -1) {
            return null;
        }
        int n3 = (n2 |= this.readUnsignedByte() << 8) >> 6;
        long l2 = n2 & FIELD_MASK[5];
        if (l2 == 63L) {
            l2 = this.readUnsignedInt();
        }
        return new TagHeader(n3, l2);
    }

    protected ActionHeader readActionHeader() throws IOException {
        int n2 = this.readUnsignedByte();
        if (n2 == 0) {
            return null;
        }
        int n3 = 0;
        if ((n2 & 0x80) > 0) {
            n3 = this.readUnsignedShort();
        }
        return new ActionHeader(n2, n3);
    }

    public SWFHeader readHeader() throws IOException {
        if (this.header == null) {
            this.header = new SWFHeader(this);
            int n2 = this.header.getVersion();
            this.tagSet = new SWFTagSet(n2);
            this.actionSet = new SWFActionSet(n2);
        }
        return this.header;
    }

    public SWFDictionary getDictionary() {
        return this.dictionary;
    }

    public void setJPEGTable(byte[] byArray) {
        this.jpegTable = byArray;
    }

    public byte[] getJPEGTable() {
        return this.jpegTable;
    }

    public int getVersion() {
        return ((SWFSpriteTagSet)this.tagSet).getVersion();
    }
}

