/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Vector;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageWriterSpi;
import org.freehep.graphics2d.PrintColor;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphics2d.font.FontEncoder;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.swf.DefineBitsJPEG3;
import org.freehep.graphicsio.swf.DefineBitsLossless2;
import org.freehep.graphicsio.swf.DefineFont;
import org.freehep.graphicsio.swf.DefineShape4;
import org.freehep.graphicsio.swf.DefineText;
import org.freehep.graphicsio.swf.DefineText2;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.End;
import org.freehep.graphicsio.swf.FillStyle;
import org.freehep.graphicsio.swf.FillStyleArray;
import org.freehep.graphicsio.swf.Gradient;
import org.freehep.graphicsio.swf.LineStyle;
import org.freehep.graphicsio.swf.LineStyleArray;
import org.freehep.graphicsio.swf.PlaceObject;
import org.freehep.graphicsio.swf.PlaceObject2;
import org.freehep.graphicsio.swf.SWFConstants;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFPathConstructor;
import org.freehep.graphicsio.swf.SWFShape;
import org.freehep.graphicsio.swf.SWFTag;
import org.freehep.graphicsio.swf.ShowFrame;
import org.freehep.util.UserProperties;
import org.freehep.util.Value;

public class SWFGraphics2D
extends AbstractVectorGraphicsIO
implements SWFConstants {
    private static final int SWF_VERSION = 8;
    private static final String rootKey;
    public static final String TRANSPARENT;
    public static final String BACKGROUND;
    public static final String BACKGROUND_COLOR;
    public static final String WRITE_IMAGES_AS;
    private static final UserProperties defaultProperties;
    public static final String version = "$Revision: 9981 $";
    private OutputStream ros;
    private SWFOutputStream os;
    private Value id;
    private Value depth;
    private static final float frameRate = 20.0f;
    private boolean compress = true;
    private LineStyleArray lineStyles;
    private FillStyleArray fillStyles;
    private Color textColor;
    private Shape unwrittenClip = null;
    private AffineTransform clipTransform = null;
    private int clipID;
    private int clipDepthID;
    private int showClipID;
    private int showClipDepthID;
    boolean fillStroke;
    private static final boolean showBounds = false;
    private static final Properties replaceFonts;

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    public static void setDefaultProperties(Properties properties) {
        defaultProperties.setProperties(properties);
    }

    public SWFGraphics2D(File file, Dimension dimension) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), dimension);
    }

    public SWFGraphics2D(File file, Component component) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), component);
    }

    public SWFGraphics2D(OutputStream outputStream, Dimension dimension) {
        super(dimension, true);
        this.init(outputStream);
    }

    public SWFGraphics2D(OutputStream outputStream, Component component) {
        super(component, true);
        this.init(outputStream);
    }

    private void init(OutputStream outputStream) {
        this.initProperties(SWFGraphics2D.getDefaultProperties());
        this.ros = outputStream;
        this.id = new Value().set(1);
        this.depth = new Value().set(1);
        this.textColor = this.getColor();
        this.fillStroke = true;
    }

    protected SWFGraphics2D(SWFGraphics2D sWFGraphics2D, boolean bl) {
        super(sWFGraphics2D, bl);
        this.os = sWFGraphics2D.os;
        this.id = sWFGraphics2D.id;
        this.depth = sWFGraphics2D.depth;
        this.lineStyles = new LineStyleArray();
        this.lineStyles.add(sWFGraphics2D.lineStyles.get(0));
        if (this.isProperty(CLIP)) {
            this.lineStyles.add(sWFGraphics2D.lineStyles.get(1));
            this.lineStyles.add(sWFGraphics2D.lineStyles.get(2));
        }
        this.fillStyles = new FillStyleArray();
        this.fillStyles.add(sWFGraphics2D.fillStyles.get(0));
        this.textColor = sWFGraphics2D.textColor;
        this.fillStroke = sWFGraphics2D.fillStroke;
    }

    public void writeHeader() throws IOException {
        this.os = new SWFOutputStream(new BufferedOutputStream(this.ros), 8, this.getSize(), 20.0f, this.compress);
        String string = this.getCreator() + ":" + this.getClass().getName();
        if (!this.isDeviceIndependent()) {
            string = string + " " + version.substring(1, version.length() - 1);
        }
    }

    public void writeBackground() throws IOException {
        if (this.isProperty(TRANSPARENT)) {
            this.setBackground(null);
        } else if (this.isProperty(BACKGROUND)) {
            this.setBackground(this.getPropertyColor(BACKGROUND_COLOR));
            this.clearRect(0.0, 0.0, (double)this.getSize().width, (double)this.getSize().height);
        } else {
            this.setBackground(this.getComponent() != null ? this.getComponent().getBackground() : Color.WHITE);
            this.clearRect(0.0, 0.0, (double)this.getSize().width, (double)this.getSize().height);
        }
    }

    public void writeTrailer() throws IOException {
        this.os.writeTag(new ShowFrame());
        this.os.writeTag(new End());
    }

    public void closeStream() throws IOException {
        this.os.close();
    }

    public Graphics create() {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        return new SWFGraphics2D(this, true);
    }

    public Graphics create(double d2, double d3, double d4, double d5) {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        SWFGraphics2D sWFGraphics2D = new SWFGraphics2D(this, true);
        ((VectorGraphics)sWFGraphics2D).translate(d2, d3);
        ((VectorGraphics)sWFGraphics2D).clipRect(0.0, 0.0, d4, d5);
        return sWFGraphics2D;
    }

    protected void writeGraphicsSave() throws IOException {
    }

    protected void writeGraphicsRestore() throws IOException {
        this.popStreamAndWriteClip();
    }

    public void draw(Shape shape) {
        Shape shape2 = this.getStroke().createStrokedShape(shape);
        if (this.fillStroke) {
            this.fill(new Area(shape2));
            return;
        }
        try {
            Rectangle2D rectangle2D = shape2.getBounds2D();
            SWFShape sWFShape = this.createShape(shape, 1, 0, -1);
            this.os.writeTag(new DefineShape4(this.id.getInt(), rectangle2D, this.fillStyles, this.lineStyles, sWFShape));
            this.os.writeTag(new PlaceObject2(this.id.getInt(), this.depth.getInt(), this.getTransform()));
            this.id.set(this.id.getInt() + 1);
            this.depth.set(this.depth.getInt() + 1);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void fill(Shape shape) {
        try {
            Rectangle2D rectangle2D = new BasicStroke().createStrokedShape(shape).getBounds2D();
            SWFShape sWFShape = this.createShape(shape, 0, 1, -1);
            this.os.writeTag(new DefineShape4(this.id.getInt(), rectangle2D, this.fillStyles, this.lineStyles, sWFShape));
            this.os.writeTag(new PlaceObject2(this.id.getInt(), this.depth.getInt(), this.getTransform()));
            this.id.set(this.id.getInt() + 1);
            this.depth.set(this.depth.getInt() + 1);
            boolean bl = SWFPathConstructor.isEvenOdd(shape);
            if (!bl) {
                this.writeWarning(this.getClass() + ": cannot fill using non-zero winding rule, used even-odd instead.");
            }
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void fillAndDraw(Shape shape, Color color) {
        try {
            this.setFillColor(color);
            this.fill(shape);
            this.setFillColor(this.getColor());
            this.draw(shape);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void copyArea(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.writeWarning(this.getClass() + ": copyArea(int, int, int, int, int, int) not implemented.");
    }

    protected void writeImage(RenderedImage renderedImage, AffineTransform affineTransform, Color color) throws IOException {
        int n2 = this.id.getInt();
        this.os.writeTag(this.getImageTag(n2, renderedImage, color));
        this.id.set(this.id.getInt() + 1);
        Shape shape = affineTransform.createTransformedShape(new Rectangle(0, 0, renderedImage.getWidth(), renderedImage.getHeight()));
        AffineTransform affineTransform2 = new AffineTransform(20.0f, 0.0f, 0.0f, 20.0f, 0.0f, 0.0f);
        affineTransform.concatenate(affineTransform2);
        SWFShape sWFShape = this.createShape(shape, 0, 0, 1);
        FillStyleArray fillStyleArray = new FillStyleArray();
        fillStyleArray.add(new FillStyle(n2, false, affineTransform));
        LineStyleArray lineStyleArray = new LineStyleArray();
        Rectangle rectangle = shape.getBounds();
        this.os.writeTag(new DefineShape4(this.id.getInt(), rectangle, fillStyleArray, lineStyleArray, sWFShape));
        this.os.writeTag(new PlaceObject2(this.id.getInt(), this.depth.getInt(), this.getTransform()));
        this.id.set(this.id.getInt() + 1);
        this.depth.set(this.depth.getInt() + 1);
    }

    protected void writeString(String string, double d2, double d3) throws IOException {
        String string2 = this.getFont().getName();
        string = FontEncoder.getEncodedString(string, string2);
        Font font = (string2 = replaceFonts.getProperty(string2, null)) == null ? this.getFont() : new Font(string2, this.getFont().getStyle(), this.getFont().getSize());
        Font font2 = font.deriveFont(51.2f);
        GlyphVector glyphVector = font2.createGlyphVector(this.getFontRenderContext(), string);
        Rectangle2D rectangle2D = font.createGlyphVector(this.getFontRenderContext(), string).getVisualBounds();
        rectangle2D.setRect(rectangle2D.getX() + d2, rectangle2D.getY() + d3, rectangle2D.getWidth(), rectangle2D.getHeight());
        int n2 = this.id.getInt();
        DefineFont defineFont = new DefineFont(n2);
        this.id.set(this.id.getInt() + 1);
        Vector<DefineText.Record> vector = new Vector<DefineText.Record>();
        DefineText.RecordType1 recordType1 = new DefineText.RecordType1(n2, this.textColor, (int)(d2 * 20.0), (int)(d3 * 20.0), (int)(font.getSize2D() * 20.0f));
        DefineText.RecordType0 recordType0 = new DefineText.RecordType0();
        vector.add(recordType1);
        vector.add(recordType0);
        int n3 = this.id.getInt();
        DefineText2 defineText2 = new DefineText2(n3, rectangle2D, new AffineTransform(), vector);
        this.id.set(this.id.getInt() + 1);
        for (int i2 = 0; i2 < glyphVector.getNumGlyphs(); ++i2) {
            defineFont.add(this.createShape(glyphVector.getGlyphOutline(i2), -1, 1, -1));
            recordType0.add(new DefineText.GlyphEntry(i2, 0));
        }
        this.os.writeTag(defineFont);
        this.os.writeTag(defineText2);
        this.os.writeTag(new PlaceObject2(n3, this.depth.getInt(), this.getTransform()));
        this.depth.set(this.depth.getInt() + 1);
    }

    protected void writeTransform(AffineTransform affineTransform) throws IOException {
    }

    protected void writeSetTransform(AffineTransform affineTransform) throws IOException {
    }

    protected void writeSetClip(Shape shape) throws IOException {
        this.writeClip(shape);
    }

    protected void writeClip(Shape shape) throws IOException {
        this.popStreamAndWriteClip();
        this.unwrittenClip = shape;
        AffineTransform affineTransform = this.clipTransform = this.unwrittenClip != null ? new AffineTransform(this.getTransform()) : null;
        if (this.unwrittenClip != null) {
            this.clipID = this.id.getInt();
            this.id.set(this.id.getInt() + 1);
            this.clipDepthID = this.depth.getInt();
            this.depth.set(this.depth.getInt() + 1);
            if (this.isProperty(CLIP)) {
                this.showClipID = this.id.getInt();
                this.id.set(this.id.getInt() + 1);
                this.showClipDepthID = this.depth.getInt();
                this.depth.set(this.depth.getInt() + 1);
            }
            this.os.pushBuffer();
        } else {
            this.clipID = 0;
            this.clipDepthID = 0;
            if (this.isProperty(CLIP)) {
                this.showClipID = 0;
                this.showClipDepthID = 0;
            }
        }
    }

    protected void writeStroke(Stroke stroke) throws IOException {
        this.fillStroke = true;
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)stroke;
            this.setPen(basicStroke, this.getColor());
            if (basicStroke.getLineWidth() == 0.0f) {
                this.fillStroke = false;
            }
        }
    }

    public void setPaintMode() {
        this.writeWarning(this.getClass() + ": setPaintMode() not implemented.");
    }

    public void setXORMode(Color color) {
        this.writeWarning(this.getClass() + ": setXORMode(Color) not implemented.");
    }

    protected void writePaint(Color color) throws IOException {
        this.setPen((BasicStroke)this.getStroke(), color);
        this.setFillColor(color);
        this.textColor = PrintColor.createPrintColor(color);
    }

    protected void writePaint(GradientPaint gradientPaint) throws IOException {
        Gradient[] gradientArray = new Gradient[]{new Gradient(0, gradientPaint.getColor1()), new Gradient(255, gradientPaint.getColor2())};
        double d2 = gradientPaint.getPoint1().getX();
        double d3 = gradientPaint.getPoint1().getY();
        double d4 = gradientPaint.getPoint2().getX() - d2;
        double d5 = gradientPaint.getPoint2().getY() - d3;
        double d6 = gradientPaint.getPoint1().distance(gradientPaint.getPoint2()) * 20.0 / 32768.0;
        double d7 = Math.atan2(d5, d4);
        AffineTransform affineTransform = new AffineTransform(d6, 0.0, 0.0, d6, d4 / 2.0 + d2, d5 / 2.0 + d3);
        affineTransform.rotate(d7);
        int n2 = gradientPaint.isCyclic() ? 1 : 0;
        this.fillStyles = new FillStyleArray();
        this.fillStyles.add(new FillStyle(gradientArray, 16, n2, 0, 0.0f, affineTransform));
        this.textColor = PrintColor.mixColor(gradientPaint.getColor1(), gradientPaint.getColor2());
    }

    protected void writePaint(TexturePaint texturePaint) throws IOException {
        BufferedImage bufferedImage = texturePaint.getImage();
        int n2 = this.id.getInt();
        this.os.writeTag(this.getImageTag(n2, bufferedImage, null));
        this.id.set(this.id.getInt() + 1);
        Rectangle2D rectangle2D = texturePaint.getAnchorRect();
        double d2 = rectangle2D.getWidth() / (double)bufferedImage.getWidth();
        double d3 = rectangle2D.getHeight() / (double)bufferedImage.getHeight();
        this.fillStyles = new FillStyleArray();
        this.fillStyles.add(new FillStyle(n2, true, new AffineTransform(d2 * 20.0, 0.0, 0.0, d3 * 20.0, rectangle2D.getX(), rectangle2D.getY())));
        this.textColor = PrintColor.black;
    }

    protected void writePaint(Paint paint) throws IOException {
        this.writeWarning(this.getClass() + ": writePaint(Paint) not implemented for " + paint.getClass());
        this.writePaint(Color.BLACK);
    }

    protected void writeFont(Font font) throws IOException {
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        this.writeWarning(this.getClass() + ": getDeviceConfiguration() not implemented.");
        return null;
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        this.writeWarning(this.getClass() + ": hit(Rectangle, Shape, boolean) not implemented.");
        return false;
    }

    public void writeComment(String string) throws IOException {
        this.writeWarning(this.getClass() + ": writeComment(String) not implemented.");
    }

    public String toString() {
        return "SWFGraphics2D";
    }

    SWFShape createShape(Shape shape, int n2, int n3, int n4) throws IOException {
        AffineTransform affineTransform = this.getTransform();
        double d2 = 0.5 / (20.0 * Math.min(affineTransform.getScaleX(), affineTransform.getScaleY()));
        Vector vector = new Vector();
        SWFPathConstructor sWFPathConstructor = new SWFPathConstructor(vector, n2, n3, n4, d2);
        sWFPathConstructor.addPath(shape);
        return new SWFShape(vector);
    }

    private void setPen(BasicStroke basicStroke, Color color) throws IOException {
        this.lineStyles = new LineStyleArray();
        this.lineStyles.add(new LineStyle((int)(basicStroke.getLineWidth() * 20.0f), this.getPrintColor(color)));
        if (this.isProperty(CLIP)) {
            this.lineStyles.add(new LineStyle(20, Color.cyan));
            this.lineStyles.add(new LineStyle(20, Color.orange));
        }
    }

    private void setFillColor(Color color) throws IOException {
        this.fillStyles = new FillStyleArray();
        this.fillStyles.add(new FillStyle(this.getPrintColor(color)));
    }

    private void popStreamAndWriteClip() throws IOException {
        if (this.unwrittenClip == null) {
            return;
        }
        if (this.clipID == 0 || this.clipDepthID == 0) {
            System.err.println("SWFGraphics2D: internal error, invalid clipID or clipDepthID");
            return;
        }
        this.os.popBuffer();
        Rectangle2D rectangle2D = this.unwrittenClip.getBounds2D();
        SWFShape sWFShape = this.createShape(this.unwrittenClip, 0, 1, -1);
        this.os.writeTag(new DefineShape4(this.clipID, rectangle2D, this.fillStyles, this.lineStyles, sWFShape));
        int n2 = this.depth.getInt() - 1;
        this.os.writeTag(new PlaceObject2(this.clipID, this.clipDepthID, this.clipTransform, n2));
        if (this.isProperty(CLIP)) {
            if (this.showClipID == 0 || this.showClipDepthID == 0) {
                System.err.println("SWFGraphics2D: internal error, invalid showClipID or showClipDepthID");
                return;
            }
            SWFShape sWFShape2 = this.createShape(rectangle2D, 3, 0, -1);
            this.os.writeTag(new DefineShape4(this.showClipID, rectangle2D, this.fillStyles, this.lineStyles, sWFShape2));
            this.os.writeTag(new PlaceObject(this.showClipID, this.showClipDepthID, this.clipTransform));
        }
        this.os.append();
    }

    private SWFTag getImageTag(int n2, RenderedImage renderedImage, Color color) throws IOException {
        String string = this.getProperty(WRITE_IMAGES_AS);
        DefineBitsLossless2 defineBitsLossless2 = null;
        if (string.equals("ZLIB") || string.equals("Smallest Size")) {
            defineBitsLossless2 = new DefineBitsLossless2(n2, renderedImage, color);
        }
        DefineBitsJPEG3 defineBitsJPEG3 = null;
        if (string.equals("JPG") || string.equals("Smallest Size")) {
            defineBitsJPEG3 = new DefineBitsJPEG3(n2, renderedImage, color, new Properties());
        }
        DefinitionTag definitionTag = string.equals("ZLIB") ? defineBitsLossless2 : (string.equals("JPG") ? defineBitsJPEG3 : ((double)defineBitsJPEG3.getLength() < 0.5 * (double)defineBitsLossless2.getLength() ? defineBitsJPEG3 : defineBitsLossless2));
        return definitionTag;
    }

    static {
        try {
            Class<?> clazz = Class.forName("org.freehep.graphicsio.raw.RawImageWriterSpi");
            IIORegistry.getDefaultInstance().registerServiceProvider((ImageWriterSpi)clazz.newInstance(), ImageWriterSpi.class);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        rootKey = SWFGraphics2D.class.getName();
        TRANSPARENT = rootKey + "." + "Transparent";
        BACKGROUND = rootKey + "." + "Background";
        BACKGROUND_COLOR = rootKey + "." + "BackgroundColor";
        WRITE_IMAGES_AS = rootKey + "." + "WriteImagesAs";
        defaultProperties = new UserProperties();
        defaultProperties.setProperty(TRANSPARENT, true);
        defaultProperties.setProperty(BACKGROUND, false);
        defaultProperties.setProperty(BACKGROUND_COLOR, Color.GRAY);
        defaultProperties.setProperty(WRITE_IMAGES_AS, "Smallest Size");
        defaultProperties.setProperty(CLIP, false);
        defaultProperties.setProperty(TEXT_AS_SHAPES, true);
        replaceFonts = new Properties();
        replaceFonts.setProperty("Symbol", "Serif");
        replaceFonts.setProperty("ZapfDingbats", "Serif");
    }
}

