/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Vector;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFTag;
import org.freehep.util.io.BitOutputStream;

public class DefineText
extends DefinitionTag {
    protected int character;
    protected Rectangle2D bounds;
    protected AffineTransform matrix;
    protected Vector text;

    public DefineText(int n2, Rectangle2D rectangle2D, AffineTransform affineTransform, Vector vector) {
        this();
        this.character = n2;
        this.bounds = rectangle2D;
        this.matrix = affineTransform;
        this.text = vector;
    }

    public DefineText() {
        super(11, 1);
    }

    protected DefineText(int n2, int n3) {
        super(n2, n3);
    }

    public SWFTag read(int n2, SWFInputStream sWFInputStream, int n3) throws IOException {
        DefineText defineText = new DefineText();
        defineText.read(n2, sWFInputStream, n3, false);
        return defineText;
    }

    protected void read(int n2, SWFInputStream sWFInputStream, int n3, boolean bl) throws IOException {
        Record record;
        this.character = sWFInputStream.readUnsignedShort();
        sWFInputStream.getDictionary().put(this.character, this);
        this.bounds = sWFInputStream.readRect();
        this.matrix = sWFInputStream.readMatrix();
        int n4 = sWFInputStream.readUnsignedByte();
        int n5 = sWFInputStream.readUnsignedByte();
        this.text = new Vector();
        boolean bl2 = sWFInputStream.readBitFlag();
        Record record2 = record = bl2 ? new RecordType1(sWFInputStream, n4, n5, bl) : new RecordType0(sWFInputStream, n4, n5);
        while (!record.isEndRecord()) {
            this.text.add(record);
            bl2 = sWFInputStream.readBitFlag();
            record = bl2 ? new RecordType1(sWFInputStream, n4, n5, bl) : new RecordType0(sWFInputStream, n4, n5);
        }
    }

    public void write(int n2, SWFOutputStream sWFOutputStream) throws IOException {
        this.write(sWFOutputStream, false);
    }

    protected void write(SWFOutputStream sWFOutputStream, boolean bl) throws IOException {
        Record record;
        int n2;
        sWFOutputStream.writeUnsignedShort(this.character);
        sWFOutputStream.writeRect(this.bounds);
        sWFOutputStream.writeMatrix(this.matrix);
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < this.text.size(); ++n2) {
            record = (Record)this.text.get(n2);
            if (!(record instanceof RecordType0)) continue;
            RecordType0 recordType0 = (RecordType0)record;
            n3 = Math.max(n3, recordType0.getGlyphBits());
            n4 = Math.max(n4, recordType0.getAdvanceBits());
        }
        sWFOutputStream.writeUnsignedByte(n3);
        sWFOutputStream.writeUnsignedByte(n4);
        for (n2 = 0; n2 < this.text.size(); ++n2) {
            record = (Record)this.text.get(n2);
            record.write(sWFOutputStream, n3, n4, bl);
        }
        sWFOutputStream.writeUnsignedByte(0);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString() + "\n");
        stringBuffer.append("  character:  " + this.character + "\n");
        stringBuffer.append("  bounds:     " + this.bounds + "\n");
        stringBuffer.append("  matrix:     " + this.matrix + "\n");
        stringBuffer.append("  texts:      " + this.text.size() + "\n");
        for (int i2 = 0; i2 < this.text.size(); ++i2) {
            stringBuffer.append(this.text.get(i2) + "\n");
        }
        return stringBuffer.toString();
    }

    public static class GlyphEntry {
        private int index;
        private int advance;

        public GlyphEntry(int n2, int n3) {
            this.index = n2;
            this.advance = n3;
        }

        public GlyphEntry(SWFInputStream sWFInputStream, int n2, int n3) throws IOException {
            this.index = (int)sWFInputStream.readUBits(n2);
            this.advance = (int)sWFInputStream.readSBits(n3);
        }

        public void write(SWFOutputStream sWFOutputStream, int n2, int n3) throws IOException {
            sWFOutputStream.writeUBits(this.index, n2);
            sWFOutputStream.writeSBits(this.advance, n3);
        }

        public int getGlyphBits() {
            return BitOutputStream.minBits(this.index, false);
        }

        public int getAdvanceBits() {
            return BitOutputStream.minBits(this.advance, true);
        }

        public String toString() {
            return "GlyphEntry[" + this.index + "," + this.advance + "]";
        }
    }

    public static class RecordType1
    extends Record {
        private int fontID = -1;
        private Color color;
        private int xOffset;
        private int yOffset;
        private int height;
        private Vector glyphs = null;

        public RecordType1(int n2, Color color, int n3, int n4, int n5) {
            this.fontID = n2;
            this.color = color;
            this.xOffset = n3;
            this.yOffset = n4;
            this.height = n5;
            this.glyphs = new Vector();
        }

        public void add(GlyphEntry glyphEntry) {
            this.glyphs.add(glyphEntry);
        }

        RecordType1(SWFInputStream sWFInputStream, int n2, int n3, boolean bl) throws IOException {
            sWFInputStream.readUBits(3);
            boolean bl2 = sWFInputStream.readBitFlag();
            boolean bl3 = sWFInputStream.readBitFlag();
            boolean bl4 = sWFInputStream.readBitFlag();
            boolean bl5 = sWFInputStream.readBitFlag();
            if (bl2) {
                this.fontID = sWFInputStream.readUnsignedShort();
            }
            if (bl3) {
                this.color = sWFInputStream.readColor(bl);
            }
            if (bl5) {
                this.xOffset = sWFInputStream.readShort();
            }
            if (bl4) {
                this.yOffset = sWFInputStream.readShort();
            }
            if (bl2) {
                this.height = sWFInputStream.readUnsignedShort();
            }
            this.glyphs = new Vector();
            if (sWFInputStream.getVersion() >= 7) {
                int n4 = sWFInputStream.readUnsignedByte();
                for (int i2 = 0; i2 < n4; ++i2) {
                    this.glyphs.add(new GlyphEntry(sWFInputStream, n2, n3));
                }
            }
        }

        public void write(SWFOutputStream sWFOutputStream, int n2, int n3, boolean bl) throws IOException {
            sWFOutputStream.writeBitFlag(true);
            sWFOutputStream.writeUBits(0L, 3);
            sWFOutputStream.writeBitFlag(this.fontID >= 0);
            sWFOutputStream.writeBitFlag(this.color != null);
            sWFOutputStream.writeBitFlag(this.yOffset != 0);
            sWFOutputStream.writeBitFlag(this.xOffset != 0);
            if (this.fontID >= 0) {
                sWFOutputStream.writeUnsignedShort(this.fontID);
            }
            if (this.color != null) {
                sWFOutputStream.writeColor(this.color, bl);
            }
            if (this.xOffset != 0) {
                sWFOutputStream.writeShort(this.xOffset);
            }
            if (this.yOffset != 0) {
                sWFOutputStream.writeShort(this.yOffset);
            }
            if (this.fontID >= 0) {
                sWFOutputStream.writeUnsignedShort(this.height);
            }
            if (sWFOutputStream.getVersion() >= 7) {
                sWFOutputStream.writeUnsignedByte(this.glyphs.size());
                for (int i2 = 0; i2 < this.glyphs.size(); ++i2) {
                    ((GlyphEntry)this.glyphs.get(i2)).write(sWFOutputStream, n2, n3);
                }
            }
        }

        public int getGlyphBits() {
            int n2 = 0;
            for (int i2 = 0; i2 < this.glyphs.size(); ++i2) {
                n2 = Math.max(n2, ((GlyphEntry)this.glyphs.get(i2)).getGlyphBits());
            }
            return n2;
        }

        public int getAdvanceBits() {
            int n2 = 0;
            for (int i2 = 0; i2 < this.glyphs.size(); ++i2) {
                n2 = Math.max(n2, ((GlyphEntry)this.glyphs.get(i2)).getAdvanceBits());
            }
            return n2;
        }

        public boolean isEndRecord() {
            return false;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("    FontID:  " + this.fontID + "\n");
            stringBuffer.append("    Color:   " + this.color + "\n");
            stringBuffer.append("    xOffset: " + this.xOffset + "\n");
            stringBuffer.append("    yOffset: " + this.yOffset + "\n");
            stringBuffer.append("    height:  " + this.height + "\n");
            stringBuffer.append("    glyphCount (swf >= 7): " + this.glyphs.size() + "\n");
            stringBuffer.append("    ");
            for (int i2 = 0; i2 < this.glyphs.size(); ++i2) {
                stringBuffer.append(this.glyphs.get(i2) + " ");
            }
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }
    }

    public static class RecordType0
    extends Record {
        private Vector glyphs = null;

        public RecordType0() {
            this.glyphs = new Vector();
        }

        public void add(GlyphEntry glyphEntry) {
            this.glyphs.add(glyphEntry);
        }

        RecordType0(SWFInputStream sWFInputStream, int n2, int n3) throws IOException {
            int n4 = (int)sWFInputStream.readUBits(7);
            if (n4 == 0) {
                return;
            }
            this.glyphs = new Vector();
            for (int i2 = 0; i2 < n4; ++i2) {
                GlyphEntry glyphEntry = new GlyphEntry(sWFInputStream, n2, n3);
                this.glyphs.add(glyphEntry);
            }
            sWFInputStream.byteAlign();
        }

        public void write(SWFOutputStream sWFOutputStream, int n2, int n3, boolean bl) throws IOException {
            sWFOutputStream.writeUBits(0L, 1);
            sWFOutputStream.writeUBits(this.glyphs.size(), 7);
            for (int i2 = 0; i2 < this.glyphs.size(); ++i2) {
                ((GlyphEntry)this.glyphs.get(i2)).write(sWFOutputStream, n2, n3);
            }
            sWFOutputStream.byteAlign();
        }

        public boolean isEndRecord() {
            return this.glyphs == null;
        }

        public int getGlyphBits() {
            int n2 = 0;
            for (int i2 = 0; i2 < this.glyphs.size(); ++i2) {
                n2 = Math.max(n2, ((GlyphEntry)this.glyphs.get(i2)).getGlyphBits());
            }
            return n2;
        }

        public int getAdvanceBits() {
            int n2 = 0;
            for (int i2 = 0; i2 < this.glyphs.size(); ++i2) {
                n2 = Math.max(n2, ((GlyphEntry)this.glyphs.get(i2)).getAdvanceBits());
            }
            return n2;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("    glyphCount: " + this.glyphs.size() + "\n");
            stringBuffer.append("    ");
            for (int i2 = 0; i2 < this.glyphs.size(); ++i2) {
                stringBuffer.append(this.glyphs.get(i2) + " ");
            }
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }
    }

    public static abstract class Record {
        public abstract void write(SWFOutputStream var1, int var2, int var3, boolean var4) throws IOException;

        public abstract boolean isEndRecord();
    }
}

