/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.javax.xml.stream.writers;

import com.fr.third.javax.xml.stream.xerces.util.XMLChar;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public final class UTF8OutputStreamWriter
extends Writer {
    OutputStream out;
    int lastUTF16CodePoint = 0;

    public UTF8OutputStreamWriter(OutputStream outputStream) {
        this.out = outputStream;
    }

    public String getEncoding() {
        return "UTF-8";
    }

    public void write(int n2) throws IOException {
        if (this.lastUTF16CodePoint != 0) {
            int n3 = ((this.lastUTF16CodePoint & 0x3FF) << 10 | n2 & 0x3FF) + 65536;
            if (n3 < 0 || n3 >= 0x200000) {
                throw new IOException("Atttempting to write invalid Unicode code point '" + n3 + "'");
            }
            this.out.write(0xF0 | n3 >> 18);
            this.out.write(0x80 | n3 >> 12 & 0x3F);
            this.out.write(0x80 | n3 >> 6 & 0x3F);
            this.out.write(0x80 | n3 & 0x3F);
            this.lastUTF16CodePoint = 0;
            return;
        }
        if (n2 < 128) {
            this.out.write(n2);
        } else if (n2 < 2048) {
            this.out.write(0xC0 | n2 >> 6);
            this.out.write(0x80 | n2 & 0x3F);
        } else if (n2 <= 65535) {
            if (!XMLChar.isHighSurrogate(n2) && !XMLChar.isLowSurrogate(n2)) {
                this.out.write(0xE0 | n2 >> 12);
                this.out.write(0x80 | n2 >> 6 & 0x3F);
                this.out.write(0x80 | n2 & 0x3F);
            } else {
                this.lastUTF16CodePoint = n2;
            }
        }
    }

    public void write(char[] cArray) throws IOException {
        int n2 = 0;
        while (n2 < cArray.length) {
            this.write(cArray[n2]);
            ++n2;
        }
    }

    public void write(char[] cArray, int n2, int n3) throws IOException {
        int n4 = 0;
        while (n4 < n3) {
            this.write(cArray[n2 + n4]);
            ++n4;
        }
    }

    public void write(String string) throws IOException {
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            this.write(string.charAt(n3));
            ++n3;
        }
    }

    public void write(String string, int n2, int n3) throws IOException {
        int n4 = 0;
        while (n4 < n3) {
            this.write(string.charAt(n2 + n4));
            ++n4;
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        if (this.lastUTF16CodePoint != 0) {
            throw new IllegalStateException("Attempting to close a UTF8OutputStreamWriter while awaiting for a UTF-16 code unit");
        }
        this.out.close();
    }
}

