/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.JAI;

import com.fr.third.JAI.ImageCodec;
import com.fr.third.JAI.ImageDecodeParam;
import com.fr.third.JAI.ImageDecoder;
import com.fr.third.JAI.ImageEncodeParam;
import com.fr.third.JAI.ImageEncoder;
import com.fr.third.JAI.PNGDecodeParam;
import com.fr.third.JAI.PNGEncodeParam;
import com.fr.third.JAI.PNGImageDecoder;
import com.fr.third.JAI.PNGImageEncoder;
import com.fr.third.JAI.SeekableStream;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class PNGCodec
extends ImageCodec {
    public String getFormatName() {
        return "png";
    }

    public Class getEncodeParamClass() {
        return PNGEncodeParam.class;
    }

    public Class getDecodeParamClass() {
        return PNGDecodeParam.class;
    }

    public boolean canEncodeImage(RenderedImage renderedImage, ImageEncodeParam imageEncodeParam) {
        int n2;
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n3 = sampleModel.getTransferType();
        if (n3 == 4 || n3 == 5) {
            return false;
        }
        int[] nArray = sampleModel.getSampleSize();
        int n4 = nArray[0];
        for (n2 = 1; n2 < nArray.length; ++n2) {
            if (nArray[n2] == n4) continue;
            return false;
        }
        if (n4 < 1 || n4 > 16) {
            return false;
        }
        n2 = sampleModel.getNumBands();
        if (n2 < 1 || n2 > 4) {
            return false;
        }
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel && (n2 != 1 || n4 > 8)) {
            return false;
        }
        if (imageEncodeParam != null) {
            if (imageEncodeParam instanceof PNGEncodeParam) {
                if (colorModel instanceof IndexColorModel ? !(imageEncodeParam instanceof PNGEncodeParam.Palette) : (n2 < 3 ? !(imageEncodeParam instanceof PNGEncodeParam.Gray) : !(imageEncodeParam instanceof PNGEncodeParam.RGB))) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    protected ImageEncoder createImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        PNGEncodeParam pNGEncodeParam = null;
        if (imageEncodeParam != null) {
            pNGEncodeParam = (PNGEncodeParam)imageEncodeParam;
        }
        return new PNGImageEncoder(outputStream, pNGEncodeParam);
    }

    protected ImageDecoder createImageDecoder(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        PNGDecodeParam pNGDecodeParam = null;
        if (imageDecodeParam != null) {
            pNGDecodeParam = (PNGDecodeParam)imageDecodeParam;
        }
        return new PNGImageDecoder(inputStream, pNGDecodeParam);
    }

    protected ImageDecoder createImageDecoder(File file, ImageDecodeParam imageDecodeParam) throws IOException {
        PNGDecodeParam pNGDecodeParam = null;
        if (imageDecodeParam != null) {
            pNGDecodeParam = (PNGDecodeParam)imageDecodeParam;
        }
        return new PNGImageDecoder((InputStream)new FileInputStream(file), pNGDecodeParam);
    }

    protected ImageDecoder createImageDecoder(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        PNGDecodeParam pNGDecodeParam = null;
        if (imageDecodeParam != null) {
            pNGDecodeParam = (PNGDecodeParam)imageDecodeParam;
        }
        return new PNGImageDecoder((InputStream)seekableStream, pNGDecodeParam);
    }

    public int getNumHeaderBytes() {
        return 8;
    }

    public boolean isFormatRecognized(byte[] byArray) {
        return byArray[0] == -119 && byArray[1] == 80 && byArray[2] == 78 && byArray[3] == 71 && byArray[4] == 13 && byArray[5] == 10 && byArray[6] == 26 && byArray[7] == 10;
    }
}

