/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.painter.barcode.line.code128;

import com.fr.report.cell.painter.barcode.BarcodeException;
import com.fr.report.cell.painter.barcode.CompositeModule;
import com.fr.report.cell.painter.barcode.Module;
import com.fr.report.cell.painter.barcode.line.code128.Accumulator;
import com.fr.report.cell.painter.barcode.line.code128.CharBuffer;
import com.fr.report.cell.painter.barcode.line.code128.Code128Barcode;
import com.fr.report.cell.painter.barcode.line.code128.ModuleFactory;
import java.text.StringCharacterIterator;

public class UCCEAN128Barcode
extends Code128Barcode {
    public static final String SSCC_18_AI = "00";
    public static final String SCC_14_AI = "01";
    public static final String GTIN_AI = "01";
    public static final String EAN128_AI = "01";
    public static final String SHIPMENT_ID_AI = "402";
    public static final String USPS_AI = "420";
    private final String applicationIdentifier;
    private String originalData;
    private final boolean includeCheckDigit;

    public UCCEAN128Barcode(String string, String string2) throws BarcodeException {
        this(string, string2, true);
    }

    public UCCEAN128Barcode(String string, String string2, boolean bl) throws BarcodeException {
        super("\u00ca" + string + string2 + UCCEAN128Barcode.getMod10CheckDigit(string2, bl), 2);
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Application Identifier must be provided");
        }
        this.applicationIdentifier = string;
        this.originalData = string2;
        this.includeCheckDigit = bl;
    }

    protected Module getPreAmble() {
        CompositeModule compositeModule = new CompositeModule();
        compositeModule.add(QUIET_SECTION);
        compositeModule.add(START_C);
        return compositeModule;
    }

    protected String getLabel() {
        return '(' + this.applicationIdentifier + ") " + this.originalData + UCCEAN128Barcode.getMod10CheckDigit(this.originalData, this.includeCheckDigit);
    }

    static String getMod10CheckDigit(String string, boolean bl) {
        if (!bl) {
            return "";
        }
        Accumulator accumulator = new Accumulator(START_INDICES[2]);
        Accumulator accumulator2 = new Accumulator(1);
        CharBuffer charBuffer = new CharBuffer(BUF_SIZES[2]);
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c2 = stringCharacterIterator.first();
        while (c2 != '\uffff') {
            charBuffer.addChar(c2);
            if (charBuffer.isFull()) {
                int n2 = ModuleFactory.getIndex(charBuffer.toString(), 2);
                accumulator.add(n2 * accumulator2.getValue());
                accumulator2.increment();
                charBuffer.clear();
            }
            c2 = stringCharacterIterator.next();
        }
        return String.valueOf(accumulator.getValue() % 10);
    }
}

