/*
 * Decompiled with CFR 0.152.
 */
package com.fr.page.generator;

import com.fr.base.FRContext;
import com.fr.page.PG;
import com.fr.page.PaperSettingProvider;
import com.fr.page.ReportPage;
import com.fr.report.ReportHelper;
import com.fr.report.poly.AbstractResPolyReport;
import com.fr.report.poly.ClippedPolyPage;
import com.fr.report.stable.ReportSettings;
import com.fr.stable.unit.FU;
import com.fr.stable.unit.UNIT;
import com.fr.stable.unit.UNITDimension;
import com.fr.stable.unit.UnitRectangle;
import java.util.ArrayList;
import java.util.List;

public class PolyReportPageGenerator
extends PG {
    private AbstractResPolyReport result_report;
    private List pageXLocationList = new ArrayList();
    private List pageYLocationList = new ArrayList();

    public PolyReportPageGenerator(AbstractResPolyReport abstractResPolyReport, PaperSettingProvider paperSettingProvider) {
        super(abstractResPolyReport, paperSettingProvider);
        this.result_report = abstractResPolyReport;
    }

    protected void dealWithPageInforByPaperSize(UNIT uNIT, UNIT uNIT2) {
        UNITDimension uNITDimension = ReportHelper.calculateOccupiedArea(this.result_report);
        UNIT uNIT3 = uNITDimension.width;
        FU fU = UNIT.ZERO;
        this.pageXLocationList.add(fU);
        while (uNIT3.more_than_zero()) {
            uNIT3 = uNIT3.subtract(uNIT2);
            fU = fU.add(uNIT2);
            this.pageXLocationList.add(fU);
        }
        uNIT3 = uNITDimension.height;
        fU = UNIT.ZERO;
        this.pageYLocationList.add(fU);
        while (uNIT3.more_than_zero()) {
            uNIT3 = uNIT3.subtract(uNIT);
            fU = fU.add(uNIT);
            this.pageYLocationList.add(fU);
        }
        this.pageCount = (this.pageXLocationList.size() - 1) * (this.pageYLocationList.size() - 1);
    }

    protected void generatePages() {
        int n2 = 0;
        switch (this.reportSettings.getPageOrder()) {
            case 0: {
                int n3 = this.pageXLocationList.size();
                for (int i2 = 1; i2 < n3; ++i2) {
                    UNIT uNIT = (UNIT)this.pageXLocationList.get(i2 - 1);
                    UNIT uNIT2 = (UNIT)this.pageXLocationList.get(i2);
                    int n4 = this.pageYLocationList.size();
                    for (int i3 = 1; i3 < n4; ++i3) {
                        UNIT uNIT3 = (UNIT)this.pageYLocationList.get(i3 - 1);
                        UNIT uNIT4 = (UNIT)this.pageYLocationList.get(i3);
                        ReportPage reportPage = this.createGroupPages(new UnitRectangle(uNIT, uNIT3, uNIT2.subtract(uNIT), uNIT4.subtract(uNIT3)), i2 - 1, i3 - 1);
                        this.addReportPage2List(reportPage, n2);
                        ++n2;
                    }
                }
                break;
            }
            default: {
                int n5 = this.pageYLocationList.size();
                for (int i4 = 1; i4 < n5; ++i4) {
                    UNIT uNIT = (UNIT)this.pageYLocationList.get(i4 - 1);
                    UNIT uNIT5 = (UNIT)this.pageYLocationList.get(i4);
                    int n6 = this.pageXLocationList.size();
                    for (int i5 = 1; i5 < n6; ++i5) {
                        UNIT uNIT6 = (UNIT)this.pageXLocationList.get(i5 - 1);
                        UNIT uNIT7 = (UNIT)this.pageXLocationList.get(i5);
                        ReportPage reportPage = this.createGroupPages(new UnitRectangle(uNIT6, uNIT, uNIT7.subtract(uNIT6), uNIT5.subtract(uNIT)), i5 - 1, i4 - 1);
                        this.addReportPage2List(reportPage, n2);
                        ++n2;
                    }
                }
            }
        }
    }

    private ReportPage createGroupPages(UnitRectangle unitRectangle, int n2, int n3) {
        ReportSettings reportSettings;
        try {
            reportSettings = (ReportSettings)this.reportSettings.clone();
            reportSettings.setPaperSetting(this.paperSetting);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRContext.getLogger().error(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
            return null;
        }
        ReportPage reportPage = new ReportPage(this.result_report, this.pageCount, 0, 0, reportSettings);
        int n4 = this.result_report.getBlockCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            ClippedPolyPage clippedPolyPage = this.result_report.getClippedPolyBlock(i2);
            UnitRectangle unitRectangle2 = clippedPolyPage.getBounds();
            if (!unitRectangle.intersects(unitRectangle2)) continue;
            UnitRectangle unitRectangle3 = unitRectangle.intersection(unitRectangle2);
            FU fU = unitRectangle3.x.subtract(unitRectangle.x);
            FU fU2 = unitRectangle3.y.subtract(unitRectangle.y);
            reportPage.addClippedPage(clippedPolyPage.createInnerClippedPage(this.result_report, unitRectangle3, this.reportSettings, fU, fU2, n2, n3));
        }
        return reportPage;
    }
}

