/*
 * Decompiled with CFR 0.152.
 */
package com.fr.mobile.service;

import com.fr.base.Base64;
import com.fr.base.FRContext;
import com.fr.cache.Attachment;
import com.fr.cache.AttachmentSource;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.mobile.FMobileConfig;
import com.fr.mobile.FMobileConfigProvider;
import com.fr.privilege.Authentication;
import com.fr.privilege.authentication.AuthenticationFactory;
import com.fr.report.cell.painter.barcode.qrcode.QRCode;
import com.fr.stable.AttachmentIDCreator;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSMobileQRCodeAction
extends ActionNoSessionCMD {
    private static final char ERRORCORRENTLEVEL = 'L';
    private static final char ENCODEMODE = 'B';
    private static final int VERSION = 5;
    private static final int MODULESIZE = 3;
    private static final int BASICIMGSIZE = 21;
    private static final int INCREASEDNUMOFMODULESBYADDVERSION = 4;
    private BufferedImage bufImg;
    private int imgSize;

    public String getCMD() {
        return "qrcode";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l2 = ServiceUtils.getCurrentUserID((HttpServletRequest)httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l2, 17L)) {
            throw new NoPrivilegeException();
        }
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"serverName");
        String string2 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"serverUrl");
        if (StringUtils.isNotEmpty(string2) && string2.indexOf("?") > 0) {
            string2 = string2.substring(0, string2.indexOf("?"));
        }
        String string3 = this.encodeServerName(string) + "," + this.encodeServerUrl(string2);
        Authentication authentication = AuthenticationFactory.exAuth4CommonAccess(httpServletRequest);
        long l3 = ServiceUtils.getCurrentUserID((HttpServletRequest)httpServletRequest);
        if (!(authentication != null && authentication.isRoot() || UserControl.getInstance().hasModulePrivilege(l3, 17L))) {
            throw new NoPrivilegeException();
        }
        byte[] byArray = string3.getBytes("GBK");
        boolean[][] blArray = this.getCodeOut(byArray, 5);
        this.imgSize = 3 * this.getModuleNum();
        this.bufImg = new BufferedImage(this.imgSize, this.imgSize, 1);
        Graphics2D graphics2D = this.createGraphics();
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            for (int i3 = 0; i3 < blArray.length; ++i3) {
                if (!blArray[i3][i2]) continue;
                graphics2D.fillRect(i3 * 3, i2 * 3, 3, 3);
            }
        }
        String string4 = this.uploadQRImg(string, string2);
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        printWriter.print(string4);
        printWriter.flush();
        printWriter.close();
    }

    private boolean[][] getCodeOut(byte[] byArray, int n2) throws UnsupportedEncodingException {
        boolean[][] blArray;
        QRCode qRCode = this.createQRCode(n2);
        try {
            blArray = qRCode.calQrcode(byArray);
        }
        catch (Exception exception) {
            blArray = this.getCodeOut(byArray, ++n2);
        }
        return blArray;
    }

    private int getModuleNum() {
        return 37;
    }

    private QRCode createQRCode(int n2) {
        QRCode qRCode = new QRCode();
        qRCode.setQrcodeErrorCorrect('L');
        qRCode.setQrcodeEncodeMode('B');
        qRCode.setQrcodeVersion(n2);
        return qRCode;
    }

    private Graphics2D createGraphics() {
        Graphics2D graphics2D = this.bufImg.createGraphics();
        graphics2D.setBackground(Color.WHITE);
        graphics2D.clearRect(0, 0, this.imgSize, this.imgSize);
        graphics2D.setColor(Color.BLACK);
        return graphics2D;
    }

    private String uploadQRImg(String string, String string2) throws Exception {
        String string3 = StableFactory.getMarkedObject("AttachmentIDCreator", AttachmentIDCreator.class).createID();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)this.bufImg, "png", byteArrayOutputStream);
        Attachment attachment = new Attachment(string3, "image", "crcode", byteArrayOutputStream.toByteArray());
        AttachmentSource.putAttachment(string3, attachment);
        FMobileConfigProvider fMobileConfigProvider = FMobileConfig.getProviderInstance();
        fMobileConfigProvider.setQrcodeImageID4FS(string3);
        fMobileConfigProvider.setQrcodeServerName(string);
        fMobileConfigProvider.setQrcodeServerUrl(string2);
        FRContext.getCurrentEnv().writeResource(fMobileConfigProvider);
        return string3;
    }

    private String encodeServerName(String string) {
        try {
            return Base64.encode(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private String encodeServerUrl(String string) {
        String string2 = "";
        for (int i2 = 0; i2 < string.length(); ++i2) {
            Character c2 = Character.valueOf(string.charAt(i2));
            if (i2 % 2 == 0) {
                c2 = Character.valueOf((char)(c2.charValue() + '\u0001'));
                string2 = string2.concat(String.valueOf(c2));
                continue;
            }
            c2 = Character.valueOf((char)(c2.charValue() - '\u0001'));
            string2 = string2.concat(String.valueOf(c2));
        }
        return string2;
    }
}

