/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general;

import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.stable.module.Module;
import com.fr.stable.module.ModuleListener;
import com.fr.stable.web.ModuleStopListener;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleContext {
    private static Map<String, Module> startedModules = new ConcurrentHashMap<String, Module>();
    private static ModuleListener listener = null;

    public static boolean isModuleStarted(String string) {
        return startedModules.containsKey(string);
    }

    public static void startModule(String string) {
        if (ModuleContext.isModuleStarted(string)) {
            return;
        }
        try {
            Module module = (Module)GeneralUtils.classForName(string).newInstance();
            if (listener != null) {
                listener.onStartAfter(module.getRealInternationalName(), module.getClass().getName());
            }
            ModuleContext.registerStartedModule(string, module);
            module.start();
            if (listener != null) {
                listener.onStartBefore(module.getClass().getName(), module.getRealInternationalName());
            }
            FRLogger.getLogger().info("Module " + string + " is started.");
        }
        catch (InstantiationException instantiationException) {
            FRLogger.getLogger().error("Can't start the module: " + string, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            FRLogger.getLogger().error("Can't start the module: " + string, illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FRLogger.getLogger().info("Can't found the module: " + string);
        }
        catch (ClassCastException classCastException) {
            FRLogger.getLogger().error("Can't start the module: " + string, classCastException);
        }
    }

    public static Iterator<String> iteratorForStartedModule() {
        return startedModules.keySet().iterator();
    }

    public static Module getModule(String string) {
        return startedModules.get(string);
    }

    public static void registerModuleListener(ModuleListener moduleListener) {
        listener = moduleListener;
    }

    public static void clearModuleListener() {
        listener = null;
    }

    public static void registerStartedModule(String string, Module module) {
        startedModules.put(string, module);
    }

    public static void startFinish() {
        for (Map.Entry<String, Module> entry : startedModules.entrySet()) {
            entry.getValue().startFinish();
        }
    }

    public static void stopModules() {
        for (Map.Entry<String, Module> entry : startedModules.entrySet()) {
            entry.getValue().stop();
        }
        startedModules.clear();
    }

    public static void addModuleStopListener(ModuleStopListener moduleStopListener) {
    }
}

