/*
 * Decompiled with CFR 0.152.
 */
package com.fr.function;

import com.fr.base.Utils;
import com.fr.general.FArray;
import com.fr.general.script.FunctionHelper;
import com.fr.script.AbstractFunction;
import com.fr.stable.Primitive;
import com.fr.stable.StringUtils;
import com.fr.stable.script.Function;
import java.math.BigDecimal;

public class SUM
extends AbstractFunction {
    public Object run(Object[] objectArray) {
        int n2;
        if (objectArray.length < 1) {
            return Primitive.ERROR_NAME;
        }
        BigDecimal bigDecimal = null;
        long l2 = 0L;
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] == null) continue;
            if (bigDecimal == null) {
                if (objectArray[i2] instanceof Integer || objectArray[i2] instanceof Long || objectArray[i2] instanceof Short || objectArray[i2] instanceof Byte) {
                    l2 += ((Number)objectArray[i2]).longValue();
                    continue;
                }
                bigDecimal = new BigDecimal(String.valueOf(l2));
                bigDecimal = bigDecimal.add(this.parseObject(objectArray[i2]));
                continue;
            }
            bigDecimal = bigDecimal.add(this.parseObject(objectArray[i2]));
        }
        if (bigDecimal == null) {
            return FunctionHelper.asNumber(l2);
        }
        double d2 = bigDecimal.doubleValue();
        if (d2 != (double)(n2 = (int)d2)) {
            return new Double(bigDecimal.doubleValue());
        }
        return FunctionHelper.asNumber((long)d2);
    }

    protected BigDecimal parseObject(Object object) {
        if (object instanceof Number) {
            return this.parseNumber(object);
        }
        if (object instanceof Boolean) {
            return new BigDecimal((Boolean)object != false ? "1" : "0");
        }
        if (object instanceof FArray) {
            return this.parseFArray((FArray)object);
        }
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object != null) {
            return this.getBigDecimal(object);
        }
        return new BigDecimal("0");
    }

    private BigDecimal parseFArray(FArray fArray) {
        FArray fArray2 = fArray;
        BigDecimal bigDecimal = null;
        long l2 = 0L;
        int n2 = fArray2.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object t2 = fArray2.elementAt(i2);
            if (t2 == null) continue;
            if (bigDecimal == null) {
                if (t2 instanceof Integer || t2 instanceof Long || t2 instanceof Short || t2 instanceof Byte) {
                    l2 += ((Number)t2).longValue();
                    continue;
                }
                bigDecimal = new BigDecimal(String.valueOf(l2));
                bigDecimal = bigDecimal.add(this.parseObject(t2));
                continue;
            }
            bigDecimal = bigDecimal.add(this.parseObject(t2));
        }
        if (bigDecimal == null) {
            return new BigDecimal(String.valueOf(l2));
        }
        return bigDecimal;
    }

    private BigDecimal parseNumber(Object object) {
        if (object instanceof Double) {
            try {
                return new BigDecimal((Double)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String string = Utils.objectToString(object);
        try {
            return new BigDecimal(string);
        }
        catch (Exception exception) {
            return BigDecimal.ZERO;
        }
    }

    private BigDecimal getBigDecimal(Object object) {
        String string = object.toString();
        if (StringUtils.isNotBlank(string)) {
            try {
                return new BigDecimal(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new BigDecimal("0");
    }

    public Function.Type getType() {
        return MATH;
    }

    public String getCN() {
        return "SUM(number1,number2,\u2026): \u6c42\u4e00\u4e2a\u6307\u5b9a\u5355\u5143\u683c\u533a\u57df\u4e2d\u6240\u6709\u6570\u5b57\u4e4b\u548c\u3002\nNumber1,number2,\u2026:1\u523030\u4e2a\u53c2\u6570\u6216\u6307\u5b9a\u5355\u5143\u683c\u533a\u57df\u4e2d\u6240\u6709\u6570\u5b57\u3002\n\u5907\u6ce8:\n    \u51fd\u6570\u5c06\u76f4\u63a5\u952e\u5165\u53c2\u6570\u4e2d\u7684\u6570\u503c\u3001\u903b\u8f91\u503c\u53ca\u6587\u672c\u8868\u8fbe\u5f0f\u8ba1\u7b97\u5728\u5185\u3002\n    \u82e5\u53c2\u6570\u662f\u6570\u7ec4\u6216\u5f15\u7528\uff0c\u5219\u53ea\u6709\u6570\u7ec4\u6216\u5355\u5143\u683c\u5f15\u7528\u4e2d\u7684\u6570\u503c\u8fdb\u884c\u8ba1\u7b97\u3002\n\u793a\u4f8b:\nSUM(70,80)\u7b49\u4e8e150\u3002\nSUM(\"70\",80,TRUE)\u7b49\u4e8e151\uff0c\u903b\u8f91\u503c\u201cTRUE\u201d\u4f5c\u4e3a1\u6765\u8ba1\u7b97\uff1b\u201cFALSE\u201d\u4f5c\u4e3a0\u8ba1\u7b97\uff1b\u6587\u672c\u201c70\u201d\u4f5c\u4e3a70\u6765\u8ba1\u7b97\u3002";
    }

    public String getEN() {
        return "SUM(number1,number2,\u2026): Adds all the numbers in a range of cells.\nNumber1, number2, ...    are 1 to 30 arguments for which you want the total value or sum.\n\nRemarks:\n1. Numbers, logical values, and text representations of numbers that you type directly into the list of arguments are counted. See the first and second examples following. \n2. If an argument is an array or reference, only numbers in that array or reference are counted. Empty cells, logical values, text, or error values in the array or reference are ignored. See the third example following. \n\nExample:\n   SUM(70,80)=150.\n   SUM(\"70\",80,TRUE)=151, TRUE is calculated as 1, FALSE for 0, String \"70\" fo 70.";
    }
}

