/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui.container;

import com.fr.base.ResizableElement;
import com.fr.form.main.Form;
import com.fr.form.main.WidgetGatherAdapter;
import com.fr.form.ui.PaddingMargin;
import com.fr.form.ui.Widget;
import com.fr.form.ui.WidgetXmlUtils;
import com.fr.form.ui.container.WAbsoluteLayout;
import com.fr.form.ui.container.WLayout;
import com.fr.general.ComparatorUtils;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Dimension;
import java.awt.Rectangle;

public class WTitleLayout
extends WLayout {
    public static final String TITLE = "Title";
    public static final String BODY = "Body";
    public static final int TITLE_HEIGHT = 36;
    private Widget title;
    private Widget body;
    private static final long serialVersionUID = -5896314449303649779L;

    public WTitleLayout() {
        this(0);
    }

    public WTitleLayout(int n2) {
        this.setCompInterval(n2);
        this.margin = new PaddingMargin(0, 0, 0, 0);
    }

    public WTitleLayout(String string) {
        this(0);
        if (StringUtils.isNotEmpty(string)) {
            this.setWidgetName(string);
        }
    }

    public String getLayoutToolTip() {
        return null;
    }

    public Dimension getMinDesignSize() {
        int n2 = this.title == null ? MIN_HEIGHT : MIN_HEIGHT + 36 + this.compInterval;
        return new Dimension(MIN_WIDTH, n2);
    }

    public String getXType() {
        return "title";
    }

    public void addTitle(Widget widget, Rectangle rectangle) {
        this.title = widget;
        WAbsoluteLayout.BoundsWidget boundsWidget = new WAbsoluteLayout.BoundsWidget(widget, rectangle);
        if (this.widgetList.contains(boundsWidget)) {
            return;
        }
        this.widgetList.add(new WAbsoluteLayout.BoundsWidget(widget, rectangle));
    }

    public void addBody(Widget widget, Rectangle rectangle) {
        this.body = widget;
        this.widgetList.add(new WAbsoluteLayout.BoundsWidget(widget, rectangle));
    }

    public void removeWidget(Widget widget) {
        if (ComparatorUtils.equals(this.title, widget)) {
            super.removeWidget(this.getTitleBoundsWidget());
            this.title = null;
        } else if (ComparatorUtils.equals(this.body, widget)) {
            super.removeWidget(this.getBodyBoundsWidget());
            this.body = null;
        } else if (this.widgetList.size() > 1) {
            super.removeWidget(this.getTitleBoundsWidget());
            this.title = null;
        }
    }

    public void removeAll() {
        super.removeAll();
        this.title = null;
        this.body = null;
    }

    private WAbsoluteLayout.BoundsWidget getTitleBoundsWidget() {
        if (this.getWidgetCount() == 1) {
            return (WAbsoluteLayout.BoundsWidget)this.getWidget(0);
        }
        return this.isBodyWidgetIndexFirst() ? (WAbsoluteLayout.BoundsWidget)this.getWidget(1) : (WAbsoluteLayout.BoundsWidget)this.getWidget(0);
    }

    public WAbsoluteLayout.BoundsWidget getBodyBoundsWidget() {
        if (this.getWidgetCount() == 1) {
            return (WAbsoluteLayout.BoundsWidget)this.getWidget(0);
        }
        return this.isBodyWidgetIndexFirst() ? (WAbsoluteLayout.BoundsWidget)this.getWidget(0) : (WAbsoluteLayout.BoundsWidget)this.getWidget(1);
    }

    private boolean isBodyWidgetIndexFirst() {
        WAbsoluteLayout.BoundsWidget boundsWidget = (WAbsoluteLayout.BoundsWidget)this.getWidget(0);
        return ComparatorUtils.equals(boundsWidget.getWidget(), this.body);
    }

    public void updateChildBounds(Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        this.updateTitleBounds(rectangle2);
        this.updateBodyBounds(rectangle2);
    }

    private void updateTitleBounds(Rectangle rectangle) {
        if (this.getWidgetCount() > 1) {
            WAbsoluteLayout.BoundsWidget boundsWidget = this.getTitleBoundsWidget();
            boundsWidget.setBounds(new Rectangle(0, 0, rectangle.width, 36));
        }
    }

    public void resize(final double d2, final double d3, final double d4) {
        Form.traversalWidget(this, new WidgetGatherAdapter(){

            public void dealWith(Widget widget) {
                int n2 = WTitleLayout.this.title == null ? 0 : 36;
                widget.resize(d2, d3 - (double)n2, d4);
            }
        }, ResizableElement.class);
    }

    private void updateBodyBounds(Rectangle rectangle) {
        int n2 = this.getWidgetCount() > 1 ? 36 + this.compInterval : 0;
        WAbsoluteLayout.BoundsWidget boundsWidget = this.getBodyBoundsWidget();
        rectangle.y = n2;
        rectangle.height -= n2;
        boundsWidget.setBounds(rectangle);
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("title")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        WTitleLayout.this.title = WidgetXmlUtils.readWidget(xMLableReader);
                    }
                });
            } else if (string.equals("body")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        WTitleLayout.this.body = WidgetXmlUtils.readWidget(xMLableReader);
                    }
                });
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.title != null) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.title, "title");
        }
        if (this.body != null) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.body, "body");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        WTitleLayout wTitleLayout = (WTitleLayout)super.clone();
        wTitleLayout.body = this.body != null ? (Widget)this.body.clone() : null;
        wTitleLayout.title = this.title != null ? (Widget)this.title.clone() : null;
        return wTitleLayout;
    }
}

