/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.general.ComparatorUtils;
import java.util.ArrayList;
import java.util.List;

class Node {
    static final Node NULL = new NullNode("");
    static final int ROW_NULL = -1;
    private Node parent;
    private List children = new ArrayList(1);
    private int row = -1;
    private String id;
    private String nodeId;

    Node(String string) {
        this.id = string;
    }

    public Node(String string, int n2) {
        this.id = string;
        this.row = n2;
    }

    Node getParent() {
        return this.parent;
    }

    public void setParent(Node node) {
        this.parent = node;
    }

    String getId() {
        return this.id;
    }

    void setId(String string) {
        this.id = string;
    }

    int getRow() {
        return this.row;
    }

    void setRow(int n2) {
        this.row = n2;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    static boolean isNULL(Node node) {
        return node == null || node == NULL;
    }

    boolean hasIdentifyRow() {
        return this.row >= 0;
    }

    boolean hasChild(Node node) {
        return this.children.contains(node);
    }

    Node find(Node node) {
        if (ComparatorUtils.equals(this, node)) {
            return this;
        }
        int n2 = this.getChildSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node2 = this.getChild(i2).find(node);
            if (node2 == NULL) continue;
            return node2;
        }
        return NULL;
    }

    Node findSame(Node node) {
        if (this == node) {
            return this;
        }
        int n2 = this.getChildSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node2 = this.getChild(i2).findSame(node);
            if (node2 == NULL) continue;
            return node2;
        }
        return NULL;
    }

    Node getChild(int n2) {
        if (this.getChildSize() <= n2) {
            return NULL;
        }
        return (Node)this.children.get(n2);
    }

    int getChildSize() {
        return this.children.size();
    }

    int getPosteritySize() {
        int n2 = 0;
        n2 += this.children.size();
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            n2 += this.getChild(i2).getPosteritySize();
        }
        return n2;
    }

    int getPosterityDeep() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            n2 = Math.max(n2, this.getChild(i2).getPosterityDeep());
        }
        return n2 + 1;
    }

    public void addChild(Node node) {
        this.children.add(node);
        node.setParent(this);
    }

    public boolean contains(Node node) {
        Node node2 = this.find(node);
        return node2 != NULL;
    }

    public void addGivedChildren(Node node) {
        this.children.addAll(node.children);
        int n2 = node.getChildSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            node.getChild(i2).setParent(this);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Node node = (Node)object;
        return !(this.id != null ? !ComparatorUtils.equals(this.id, node.id) : node.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "Node:#" + this.id;
    }

    static class NullNode
    extends Node {
        NullNode(String string) {
            super(string);
        }

        public void addChild(Node node) {
        }

        public void setParent(Node node) {
        }

        public void setRow(int n2) {
        }
    }
}

