/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.TableData;
import com.fr.data.core.DataCoreUtils;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.impl.Connection;
import com.fr.data.impl.DBTableData;
import com.fr.data.impl.FormulaDisplayDictionary;
import com.fr.data.impl.JDBCDatabaseConnection;
import com.fr.data.impl.NameDatabaseConnection;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.data.Condition;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class DatabaseDictionary
extends FormulaDisplayDictionary {
    protected Connection databaseConnection;
    protected String tableName;
    protected String schema;
    private Class keyEditorClass;
    private Class valueEditorClass;

    public DatabaseDictionary() {
        this(new JDBCDatabaseConnection(), "", 1, 2);
    }

    public DatabaseDictionary(Connection connection, String string, int n2, int n3) {
        this.setDatabaseConnection(connection);
        this.setTableName(string);
        this.setKeyColumnIndex(n2);
        this.setValueColumnIndex(n3);
    }

    public Connection getDatabaseConnection() {
        return this.databaseConnection;
    }

    public void setDatabaseConnection(Connection connection) {
        this.databaseConnection = connection;
        this.reset();
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String string) {
        this.schema = string;
        this.reset();
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
        this.reset();
    }

    public void setKeyEditorClass(Class clazz) {
        this.keyEditorClass = clazz;
    }

    public Class getKeyEditorClass() {
        return this.keyEditorClass;
    }

    public void setValueEditorClass(Class clazz) {
        this.valueEditorClass = clazz;
    }

    public Class getValueEditorClass() {
        return this.valueEditorClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TableData asTableData(Calculator calculator) {
        DBTableData dBTableData;
        java.sql.Connection connection = null;
        try {
            connection = this.databaseConnection.createConnection();
            dBTableData = new DBTableData(this.databaseConnection, DataCoreUtils.createSelectSQL(this.schema, this.tableName, DialectFactory.generateDialect(connection)));
            Object var6_5 = null;
        }
        catch (Exception exception) {
            TableData tableData;
            try {
                FRLogger.getLogger().error(exception.getMessage(), exception);
                tableData = null;
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                DBUtils.closeConnection(connection);
                throw throwable;
            }
            DBUtils.closeConnection(connection);
            return tableData;
        }
        DBUtils.closeConnection(connection);
        return dBTableData;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            boolean bl;
            String string = xMLableReader.getTagName();
            boolean bl2 = bl = "DBDictAttr".equals(string) || "DBMapAttr".equals(string);
            if (bl || "JDBCMapAttr".equals(string)) {
                String string2 = xMLableReader.getAttrAsString("tableName", null);
                if (string2 != null) {
                    this.setTableName(string2);
                }
                if ((string2 = xMLableReader.getAttrAsString("schemaName", null)) != null) {
                    this.setSchema(string2);
                }
                this.setKeyColumnIndex(xMLableReader.getAttrAsInt("ki", 0));
                this.setValueColumnIndex(xMLableReader.getAttrAsInt("vi", 0));
            } else if ("Connection".equals(string) || "Database".equals(string)) {
                Connection connection = DataCoreXmlUtils.readXMLConnection(xMLableReader);
                this.setDatabaseConnection(connection);
            } else if ("Condition".equals(string)) {
                Condition condition = DataCoreXmlUtils.readCondition(xMLableReader);
                this.setCondition(condition);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("DBDictAttr").attr("tableName", this.getTableName()).attr("schemaName", this.getSchema()).attr("ki", this.getKeyColumnIndex()).attr("vi", this.getValueColumnIndex()).attr("kiName", this.getKeyColumnName()).attr("viName", this.getValueColumnName()).end();
        if (this.getDatabaseConnection() != null) {
            DataCoreXmlUtils.writeXMLConnection(xMLPrintWriter, this.getDatabaseConnection());
        }
        if (this.condition != null) {
            DataCoreXmlUtils.writeXMLCondition(xMLPrintWriter, this.condition);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DatabaseDictionary databaseDictionary = (DatabaseDictionary)super.clone();
        if (this.databaseConnection != null) {
            this.databaseConnection = (Connection)this.getDatabaseConnection().clone();
        }
        if (this.condition != null) {
            databaseDictionary.condition = (Condition)this.condition.clone();
        }
        return databaseDictionary;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DatabaseDictionary)) {
            return false;
        }
        return super.equals(object) && ComparatorUtils.equals(this.databaseConnection, ((DatabaseDictionary)object).databaseConnection) && ComparatorUtils.equals(this.tableName, ((DatabaseDictionary)object).tableName) && ComparatorUtils.equals(this.schema, ((DatabaseDictionary)object).schema);
    }

    public String toString() {
        return "DBDictionary" + this.databaseConnection + "[TableName:" + this.getTableName() + "]";
    }

    public JSONObject createJSON() throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("keyIndex", this.getKeyColumnIndex());
        jSONObject.put("valueIndex", this.getValueColumnIndex());
        jSONObject.put("keyName", this.getKeyColumnName());
        jSONObject.put("valueName", this.getValueColumnName());
        jSONObject.put("databaseName", ((NameDatabaseConnection)this.databaseConnection).getName());
        jSONObject.put("tableName", this.tableName);
        jSONObject.put("schema", this.schema);
        return jSONObject;
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        if (jSONObject.has("keyIndex")) {
            this.setKeyColumnIndex(jSONObject.getInt("keyIndex"));
        }
        if (jSONObject.has("valueIndex")) {
            this.setValueColumnIndex(jSONObject.getInt("valueIndex"));
        }
        if (jSONObject.has("databaseName")) {
            this.setDatabaseConnection(new NameDatabaseConnection(jSONObject.getString("databaseName")));
        }
        if (jSONObject.has("tableName")) {
            this.setTableName(jSONObject.getString("tableName"));
        }
        if (jSONObject.has("schema")) {
            this.setSchema(jSONObject.getString("schema"));
        }
    }
}

