/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.web;

import com.fr.base.Base64;
import com.fr.base.FRContext;
import com.fr.chart.base.ColorSelect4Shape;
import com.fr.chart.base.MapSvgAttr;
import com.fr.chart.base.MapSvgXMLHelper;
import com.fr.chart.chartglyph.MapPlotGlyph;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.stable.CodeUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.web.Device;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.awt.Image;
import java.awt.geom.GeneralPath;
import java.io.File;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.JPanel;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public class ChartGetSvgAction
extends ActionNoSessionCMD {
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        String string2 = CodeUtils.cjkDecode(WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"mapName"));
        String string3 = StableUtils.pathJoin(FRContext.getCurrentEnv().getPath(), MapSvgXMLHelper.relativeDefaultMapPath(), string2 + ".svg");
        File file = new File(string3);
        if (!file.exists() && !(file = new File(string3 = StableUtils.pathJoin(FRContext.getCurrentEnv().getPath(), MapSvgXMLHelper.relativeCustomMapPath(), string2 + ".svg"))).exists()) {
            return;
        }
        MapSvgAttr mapSvgAttr = MapSvgXMLHelper.getInstance().readSvgMapAttr(file);
        if (mapSvgAttr == null) {
            return;
        }
        Device device = WebUtils.getDevice((HttpServletRequest)httpServletRequest);
        if (device.isMobile()) {
            this.dealMobile(httpServletRequest, httpServletResponse, string2, mapSvgAttr, device);
            return;
        }
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        DOMSource dOMSource = new DOMSource((Node)mapSvgAttr.getSvgDocument());
        StreamResult streamResult = new StreamResult(printWriter);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            try {
                transformer.transform(dOMSource, streamResult);
            }
            catch (TransformerException transformerException) {
                FRContext.getLogger().error(transformerException.getMessage());
            }
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            FRContext.getLogger().error(transformerConfigurationException.getMessage());
        }
        printWriter.close();
        printWriter.flush();
    }

    private void dealMobile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, MapSvgAttr mapSvgAttr, Device device) throws Exception {
        JSONObject jSONObject = new JSONObject();
        String string2 = CodeUtils.cjkDecode(WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"storedID"));
        if (mapSvgAttr.getMapImage() == null) {
            return;
        }
        Image image = mapSvgAttr.getMapImage();
        int n2 = image.getWidth(new JPanel());
        int n3 = image.getHeight(new JPanel());
        ColorSelect4Shape colorSelect4Shape = new ColorSelect4Shape();
        colorSelect4Shape.makesureImage(image);
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("mapName", string);
        jSONObject2.put("mapWidth", n2);
        jSONObject2.put("mapHeight", n3);
        jSONObject2.put("img", Base64.encode(image, "png"));
        jSONArray.put(jSONObject2);
        jSONObject.put("mapName", string);
        jSONObject.put("imageBounds", jSONArray);
        jSONObject.put("versionid", 1);
        HashMap hashMap = this.dealShapePaths(mapSvgAttr, colorSelect4Shape);
        MapPlotGlyph.putPathMap2Json(device, mapSvgAttr, hashMap, jSONObject);
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        printWriter.print(jSONObject);
        printWriter.flush();
        printWriter.close();
    }

    private HashMap dealShapePaths(MapSvgAttr mapSvgAttr, ColorSelect4Shape colorSelect4Shape) {
        HashMap<String, GeneralPath> hashMap = new HashMap<String, GeneralPath>();
        Iterator iterator = mapSvgAttr.shapeValuesIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            GeneralPath generalPath = mapSvgAttr.getShapeValue(string);
            hashMap.put(string, generalPath);
        }
        return hashMap;
    }

    public String getCMD() {
        return "map_getsvg";
    }
}

