/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrBackground;
import com.fr.chart.base.AttrBorder;
import com.fr.chart.base.AttrColor;
import com.fr.chart.base.AttrContents;
import com.fr.chart.base.AttrLineStyle;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.StyleContactWithConditionCollection;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.RectangleGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Collections;
import java.util.Iterator;

public class TextGlyph
extends RectangleGlyph
implements StyleContactWithConditionCollection {
    private static final long serialVersionUID = 3174115473314167774L;
    protected String text;
    protected TextAttr textAttr;
    protected int position = 0;

    public TextGlyph() {
    }

    public TextGlyph(String string, TextAttr textAttr) {
        this.text = string;
        this.textAttr = textAttr;
    }

    public void draw(Graphics graphics, int n2) {
        Rectangle2D rectangle2D = this.getBounds();
        if (rectangle2D == null) {
            return;
        }
        double d2 = rectangle2D.getX();
        double d3 = rectangle2D.getY();
        double d4 = rectangle2D.getWidth();
        double d5 = rectangle2D.getHeight();
        if (d4 > 0.0 && d5 > 0.0) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.translate(d2, d3);
            this.drawText(graphics2D, n2);
            graphics2D.translate(-d2, -d3);
        }
    }

    public Shape getShape() {
        return this.getBounds();
    }

    public Iterator selectableChildren() {
        return Collections.EMPTY_LIST.iterator();
    }

    protected void drawBackground(Graphics2D graphics2D, int n2) {
        Paint paint = graphics2D.getPaint();
        super.draw(graphics2D, n2);
        graphics2D.setPaint(paint);
    }

    protected void drawText(Graphics2D graphics2D, int n2) {
        if (this.getBounds() != null) {
            Paint paint = graphics2D.getPaint();
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            String string = GlyphUtils.changeAllReline2Normal(this.text);
            String[] stringArray = string.split(AttrContents.RelineSeparation);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(stringArray[i2], this.textAttr, n2);
                double d2 = this.getHorizontalLabelX(this.getBounds(), dimension2D);
                double d3 = dimension2D.getHeight() * (double)i2;
                if (this.textAttr != null && this.textAttr.getAlignText() == 1) {
                    d2 = dimension2D.getWidth() * (double)i2;
                    d3 = 0.0;
                }
                Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d3, dimension2D.getWidth(), dimension2D.getHeight());
                GlyphUtils.drawStrings(graphics2D, stringArray[i2], this.textAttr, double_, n2);
            }
            graphics2D.setPaint(paint);
            graphics2D.setComposite(composite);
        }
    }

    public void drawAxisTitle(Graphics graphics, int n2) {
        if (this.getBounds() == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        this.drawAxisTitleText(graphics2D, n2);
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    private void drawAxisTitleText(Graphics2D graphics2D, int n2) {
        if (this.textAttr.getAlignText() == 1) {
            if (this.getBounds() != null) {
                Paint paint = graphics2D.getPaint();
                Composite composite = graphics2D.getComposite();
                graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
                String string = GlyphUtils.changeAllReline2Normal(this.text);
                String[] stringArray = string.split(AttrContents.RelineSeparation);
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(stringArray[i2], this.textAttr, n2);
                    double d2 = this.getHorizontalLabelX(this.getBounds(), dimension2D);
                    double d3 = dimension2D.getHeight() * (double)i2;
                    if (this.textAttr != null && this.textAttr.getAlignText() == 1) {
                        d2 = dimension2D.getWidth() * (double)i2;
                        d3 = 0.0;
                    }
                    Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d3, dimension2D.getWidth(), dimension2D.getHeight());
                    GlyphUtils.drawAxisVerticalTitle(graphics2D, stringArray[i2], this.textAttr, double_, n2);
                }
                graphics2D.setPaint(paint);
                graphics2D.setComposite(composite);
            }
        } else {
            this.drawText(graphics2D, n2);
        }
    }

    protected double getHorizontalLabelX(Rectangle2D rectangle2D, Dimension2D dimension2D) {
        double d2 = 0.0;
        if (this.position == 0) {
            d2 = (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0;
        } else if (this.position == 2) {
            d2 = 0.0;
        } else if (this.position == 4) {
            d2 = rectangle2D.getWidth() - dimension2D.getWidth();
        }
        return d2;
    }

    public Shape getOutline4Fill() {
        if (this.bounds instanceof RoundRectangle2D) {
            RoundRectangle2D roundRectangle2D = (RoundRectangle2D)this.bounds;
            return new RoundRectangle2D.Double(0.0, 0.0, this.getBounds().getWidth(), this.getBounds().getHeight(), roundRectangle2D.getArcWidth(), roundRectangle2D.getArcHeight());
        }
        return new Rectangle2D.Double(0.0, 0.0, this.getBounds().getWidth(), this.getBounds().getHeight());
    }

    public Dimension2D preferredDimension(int n2) {
        return GlyphUtils.calculateTextDimensionWithRotation(this.text, this.textAttr, n2);
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getText() {
        return this.text;
    }

    public TextAttr getTextAttr() {
        return this.textAttr;
    }

    public void setTextAttr(TextAttr textAttr) {
        this.textAttr = textAttr;
    }

    public void setPosition(int n2) {
        this.position = n2;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean equals(Object object) {
        return object instanceof TextGlyph && super.equals(object) && ComparatorUtils.equals(((TextGlyph)object).text, this.text) && ComparatorUtils.equals(((TextGlyph)object).textAttr, this.textAttr);
    }

    public Object clone() throws CloneNotSupportedException {
        TextGlyph textGlyph = (TextGlyph)super.clone();
        if (this.textAttr != null) {
            textGlyph.textAttr = (TextAttr)this.textAttr.clone();
        }
        return textGlyph;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("text", this.text);
        jSONObject.put("position", this.getPosition());
        if (this.textAttr != null) {
            jSONObject.put("textAttr", this.textAttr.toJSONObject());
        }
        return jSONObject;
    }

    public void changeStyleAttrAlpha(AttrAlpha attrAlpha) {
        this.setAlpha(attrAlpha.getAlpha());
    }

    public void changeStyleAttrBackground(AttrBackground attrBackground) {
    }

    public void changeStyleAttrBorder(AttrBorder attrBorder) {
    }

    public void changeStyleAttrColor(AttrColor attrColor) {
    }

    public void changeStyleAttrContents(AttrContents attrContents) {
    }

    public void changeStyleAttrLineStyle(AttrLineStyle attrLineStyle) {
    }
}

