/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartdata;

import com.fr.base.FRContext;
import com.fr.base.TableData;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.base.chart.chartdata.model.DataProcessor;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartdata.NormalTableDataDefinition;
import com.fr.data.core.DataCoreUtils;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.data.util.function.DataFunction;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OneValueCDDefinition
extends NormalTableDataDefinition {
    private static final long serialVersionUID = 2093363235824337628L;
    public static final String XML_TAG = "OneValueCDDefinition";
    private String seriesColumnName;
    private String valueColumnName;
    private DataFunction dataFunction = null;

    public OneValueCDDefinition() {
    }

    public OneValueCDDefinition(TableData tableData, String string, String string2, String string3, DataFunction dataFunction) {
        this.setTableData(tableData);
        this.setCategoryName(string);
        this.setSeriesColumnName(string2);
        this.setValueColumnName(string3);
        this.setDataFunction(dataFunction);
    }

    public ChartData createChartData(DataModel dataModel, DataProcessor dataProcessor) {
        NormalChartData normalChartData = null;
        ArrayList arrayList = new ArrayList();
        try {
            this.initAllCateLabels(dataModel, dataProcessor);
            ArrayList arrayList2 = new ArrayList();
            int n2 = this.add2ColumnListWithName(dataModel, arrayList2, this.seriesColumnName, dataProcessor);
            Object[] objectArray = arrayList2.toArray();
            int n3 = DataCoreUtils.getColumnIndexByName(dataModel, this.getCategoryName());
            if (n3 == -1) {
                this.whenOneCate(dataModel, arrayList, objectArray, n2);
            } else {
                this.whenNormal(dataModel, arrayList, objectArray, n2);
            }
            Object[][] objectArray2 = (Object[][])arrayList.toArray((T[])new Object[arrayList.size()][]);
            if (this.categoryLabels.length == 1 && this.categoryLabels[0] == null) {
                this.categoryLabels[0] = this.getValueColumnName();
            }
            if (objectArray.length == 1 && objectArray[0] == null) {
                objectArray[0] = this.getValueColumnName();
            }
            normalChartData = this.getNormalChartData(objectArray, objectArray2);
        }
        catch (TableDataException tableDataException) {
            FRContext.getLogger().error(tableDataException.getMessage(), tableDataException);
        }
        return normalChartData;
    }

    protected NormalChartData getNormalChartData(Object[] objectArray, Object[][] objectArray2) {
        NormalChartData normalChartData = new NormalChartData(this.categoryLabels, objectArray, objectArray2);
        normalChartData.setSecondCates(this.secondLabels);
        normalChartData.setThirdCates(this.thirdLabels);
        return normalChartData;
    }

    private void whenOneCate(DataModel dataModel, List list, Object[] objectArray, int n2) throws TableDataException {
        int n3 = DataCoreUtils.getColumnIndexByName(dataModel, this.getValueColumnName());
        int n4 = dataModel.getRowCount();
        DataFunction dataFunction = this.getDataFunction();
        if (this.categoryLabels != null && this.categoryLabels.length == 1) {
            int n5 = objectArray.length;
            for (int i2 = 0; i2 < n5; ++i2) {
                for (int i3 = 0; i3 < n4; ++i3) {
                    Object object = dataModel.getValueAt(i3, n2);
                    if (!ComparatorUtils.equals_exactly(object, objectArray[i2])) continue;
                    dataFunction.addData(dataModel.getValueAt(i3, n3));
                }
                list.add(new Object[]{dataFunction.getResult()});
                dataFunction.reset();
            }
        }
    }

    private void addValuesInValueList(DataModel dataModel, Object[] objectArray, int n2, Map map, Object object) throws TableDataException {
        int n3 = DataCoreUtils.getColumnIndexByName(dataModel, this.getValueColumnName());
        int n4 = dataModel.getRowCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5;
            ArrayList<Object> arrayList;
            HashMap<Integer, ArrayList<Object>> hashMap;
            Object object2 = dataModel.getValueAt(i2, n2);
            if (object2 == null) {
                object2 = object;
            }
            if ((hashMap = (HashMap<Integer, ArrayList<Object>>)map.get(object2)) == null) {
                hashMap = new HashMap<Integer, ArrayList<Object>>();
                map.put(object2, hashMap);
            }
            if ((arrayList = (ArrayList<Object>)hashMap.get(new Integer(n5 = this.getCategoryIndex(dataModel, i2)))) == null) {
                arrayList = new ArrayList<Object>();
                hashMap.put(new Integer(n5), arrayList);
            }
            arrayList.add(dataModel.getValueAt(i2, n3));
        }
    }

    private void whenNormal(DataModel dataModel, List list, Object[] objectArray, int n2) throws TableDataException {
        HashMap hashMap = new HashMap();
        Object object = new Object();
        this.addValuesInValueList(dataModel, objectArray, n2, hashMap, object);
        ArrayList<Object> arrayList = null;
        int n3 = objectArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            arrayList = new ArrayList<Object>();
            Map map = (Map)hashMap.get(objectArray[i2] == null ? object : objectArray[i2]);
            if (map != null) {
                int n4 = this.categoryLabels.length;
                for (int i3 = 0; i3 < n4; ++i3) {
                    List list2 = (List)map.get(new Integer(i3));
                    if (list2 != null && !list2.isEmpty()) {
                        int n5 = 0;
                        int n6 = list2.size();
                        for (int i4 = 0; i4 < n6; ++i4) {
                            if (list2.get(i4) == null) {
                                ++n5;
                            }
                            this.dataFunction.addData(list2.get(i4));
                        }
                        arrayList.add(n5 == list2.size() ? null : this.dataFunction.getResult());
                    } else {
                        arrayList.add(null);
                    }
                    this.dataFunction.reset();
                }
            }
            list.add(arrayList.toArray());
        }
    }

    public JSONObject createDataConfig() throws JSONException {
        JSONObject jSONObject = super.createDataConfig();
        jSONObject.put("seriesName", this.seriesColumnName);
        jSONObject.put("value", this.valueColumnName);
        return jSONObject;
    }

    public String getDataDefinitionType() {
        return "SingleColumnDefinition";
    }

    public void setSeriesColumnName(String string) {
        this.seriesColumnName = string;
    }

    public String getSeriesColumnName() {
        return this.seriesColumnName;
    }

    public void setValueColumnName(String string) {
        this.valueColumnName = string;
    }

    public String getValueColumnName() {
        return this.valueColumnName;
    }

    public void setDataFunction(DataFunction dataFunction) {
        this.dataFunction = dataFunction;
    }

    public DataFunction getDataFunction() {
        return this.dataFunction;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (this.seriesColumnName != null) {
            xMLPrintWriter.attr("seriesName", this.seriesColumnName);
        }
        if (this.getValueColumnName() != null) {
            xMLPrintWriter.attr("valueName", this.getValueColumnName());
        }
        if (this.getDataFunction() != null) {
            xMLPrintWriter.attr("function", this.getDataFunction().getClass().getName());
        }
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        String string2;
        super.readXML(xMLableReader);
        if (xMLableReader.isAttr()) {
            String string3 = xMLableReader.getAttrAsString("seriesName", null);
            if (string3 != null) {
                this.seriesColumnName = string3;
            }
            if ((string3 = xMLableReader.getAttrAsString("valueName", null)) != null) {
                this.setValueColumnName(string3);
            }
            if ((string3 = xMLableReader.getAttrAsString("function", null)) != null) {
                try {
                    this.setDataFunction(DataCoreXmlUtils.readXMLDataFunction(string3));
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.getMessage(), exception);
                }
            }
        } else if (xMLableReader.isChildNode() && "SeriesColumn".equals(string2 = xMLableReader.getTagName()) && (string = xMLableReader.getAttrAsString(string2, null)) != null) {
            this.seriesColumnName = string;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        OneValueCDDefinition oneValueCDDefinition = (OneValueCDDefinition)super.clone();
        if (this.getDataFunction() != null) {
            oneValueCDDefinition.setDataFunction((DataFunction)this.getDataFunction().clone());
        }
        return oneValueCDDefinition;
    }

    public boolean equals(Object object) {
        return object instanceof OneValueCDDefinition && ComparatorUtils.equals(((OneValueCDDefinition)object).dataFunction, this.dataFunction) && ComparatorUtils.equals(((OneValueCDDefinition)object).valueColumnName, this.valueColumnName) && ComparatorUtils.equals(((OneValueCDDefinition)object).seriesColumnName, this.seriesColumnName) && super.equals(object);
    }
}

