/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.MapXMLHelper;
import com.fr.base.Utils;
import com.fr.base.background.ColorBackground;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.AttrFillStyle;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.ChartEnumDefinitions;
import com.fr.chart.base.ChartFunctionProcessor;
import com.fr.chart.base.ChartTypeValueCollection;
import com.fr.chart.base.MapSvgAttr;
import com.fr.chart.base.MapSvgXMLHelper;
import com.fr.chart.chartattr.Bar2DPlot;
import com.fr.chart.chartattr.BubblePlot;
import com.fr.chart.chartattr.PiePlot;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartdata.MapAreaValue;
import com.fr.chart.chartdata.MapChartData;
import com.fr.chart.chartdata.MapTitleValue;
import com.fr.chart.chartglyph.Bar2DPlotGlyph;
import com.fr.chart.chartglyph.BubblePlotGlyph;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataPoint4Map;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.LegendGlyph;
import com.fr.chart.chartglyph.LegendItem;
import com.fr.chart.chartglyph.LineMarkerIcon;
import com.fr.chart.chartglyph.MapAttr;
import com.fr.chart.chartglyph.MapHotAreaColor;
import com.fr.chart.chartglyph.MapPlotGlyph;
import com.fr.chart.chartglyph.PiePlotGlyph;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.stable.fun.FunctionProcessor;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapPlot
extends Plot {
    public static final String XML_TAG = "MapPlot";
    private static final long serialVersionUID = 8037342693603720271L;
    private String mapName = Inter.getLocText("FR-Chart-Map_China");
    private boolean isSvgMap = true;
    private MapHotAreaColor hotAreaColor = new MapHotAreaColor();
    private String[] currentShowName = null;
    private HashMap fromMapNames = new HashMap();
    private ChartEnumDefinitions.MapType mapType = ChartEnumDefinitions.MapType.Map_Normal;
    private boolean isHeatMap = true;
    private int heatIndex = 0;
    private BubblePlot bubblePlot = new BubblePlot();
    private PiePlot piePlot = new PiePlot();
    private Bar2DPlot bar2DPlot = new Bar2DPlot();
    private Plot plot;
    public static final MapChartData MAP_CHART_DATA = new MapChartData();
    private static final HashMap XML_NAMES;

    public MapPlot() {
        XML_NAMES.put("World", Inter.getLocText("FR-Chart-World_Map"));
        XML_NAMES.put("China", Inter.getLocText("FR-Chart-Map_China"));
        XML_NAMES.put("Anhui", Inter.getLocText("FR-Chart-Map_Anhui"));
        XML_NAMES.put("Aomen", Inter.getLocText("FR-Chart-Map_Aomenbandao"));
        XML_NAMES.put("Beijing", Inter.getLocText("FR-Chart-Map_Beijing"));
        XML_NAMES.put("Tianjin", Inter.getLocText("FR-Chart-Map_Tianjing"));
        XML_NAMES.put("Hebei", Inter.getLocText("FR-Chart-Map_Hebei"));
        XML_NAMES.put("Shanxi", Inter.getLocText("FR-Chart-Map_Shanxi"));
        XML_NAMES.put("Nei Mongol", Inter.getLocText("FR-Chart-Map_Neimenggu"));
        XML_NAMES.put("Liaoning", Inter.getLocText("FR-Chart-Map_Liaoning"));
        XML_NAMES.put("Jilin", Inter.getLocText("FR-Chart-Map_Jilin"));
        XML_NAMES.put("Heilongjiang", Inter.getLocText("FR-Chart-Map_Heilongjiang"));
        XML_NAMES.put("Shanghai", Inter.getLocText("FR-Chart-Map_Shanghai"));
        XML_NAMES.put("Jiangsu", Inter.getLocText("FR-Chart-Map_Jiangsu"));
        XML_NAMES.put("Zhejiang", Inter.getLocText("FR-Chart-Map_Zhejiang"));
        XML_NAMES.put("Fujian", Inter.getLocText("FR-Chart-Map_Fujian"));
        XML_NAMES.put("Jiangxi", Inter.getLocText("FR-Chart-Map_Jiangxi"));
        XML_NAMES.put("Shandong", Inter.getLocText("FR-Chart-Map_Shandong"));
        XML_NAMES.put("Henan", Inter.getLocText("FR-Chart-Map_Henan"));
        XML_NAMES.put("Guangdong", Inter.getLocText("FR-Chart-Map_Shanghai"));
        XML_NAMES.put("Guangxi", Inter.getLocText("FR-Chart-Map_Guangxi"));
        XML_NAMES.put("Hainan", Inter.getLocText("FR-Chart-Map_Hainan"));
        XML_NAMES.put("Chongqing", Inter.getLocText("FR-Chart-Map_Shanghai"));
        XML_NAMES.put("Sichuan", Inter.getLocText("FR-Chart-Map_Sichuan"));
        XML_NAMES.put("Guizhou", Inter.getLocText("FR-Chart-Map_Guizhou"));
        XML_NAMES.put("Yunnan", Inter.getLocText("FR-Chart-Map_Yunnan"));
        XML_NAMES.put("Xizang", Inter.getLocText("FR-Chart-Map_Xizang"));
        XML_NAMES.put("Shaanxi", Inter.getLocText("FR-Chart-Map_Shaanxi"));
        XML_NAMES.put("Gansu", Inter.getLocText("FR-Chart-Map_Gansu"));
        XML_NAMES.put("Qinghai", Inter.getLocText("FR-Chart-Map_Qinghai"));
        XML_NAMES.put("Ningxia", Inter.getLocText("FR-Chart-Map_Ningxia"));
        XML_NAMES.put("Xinjiang", Inter.getLocText("FR-Chart-Map_Xinjiang"));
        XML_NAMES.put("Taiwan", Inter.getLocText("FR-Chart-Map_Taiwan"));
        XML_NAMES.put("Xianggangdao", Inter.getLocText("FR-Chart-Map_Xianggang"));
        this.bubblePlot.setMaxBubblePixel(50.0);
    }

    @Override
    public PlotGlyph createPlotGlyph(ChartData chartData) {
        MapPlotGlyph mapPlotGlyph = new MapPlotGlyph();
        this.install4PlotGlyph(mapPlotGlyph, chartData);
        mapPlotGlyph.setMapData((MapChartData)chartData);
        mapPlotGlyph.setMapName(this.mapName);
        mapPlotGlyph.setSvgMap(this.isSvgMap);
        mapPlotGlyph.setHeatMap(this.isHeatMap);
        mapPlotGlyph.setHeatIndex(this.heatIndex);
        mapPlotGlyph.setMapType(this.mapType);
        this.setCombinePlotGlyph(mapPlotGlyph);
        this.getAllStartMapName(this.currentShowName, mapPlotGlyph);
        mapPlotGlyph.setAreaColors(this.hotAreaColor);
        mapPlotGlyph.calculateGlyphFromAreaValue();
        this.createDataPointLabel4CombineGlyph(mapPlotGlyph);
        if (this.mapType == ChartEnumDefinitions.MapType.Map_Normal && this.isHeatMap) {
            mapPlotGlyph.calculateMapTitlePercentValue();
        }
        return mapPlotGlyph;
    }

    private void setCombinePlotGlyph(MapPlotGlyph mapPlotGlyph) {
        switch (this.mapType) {
            case Map_Bubble: {
                BubblePlotGlyph bubblePlotGlyph = (BubblePlotGlyph)this.bubblePlot.createPlotGlyph(BubblePlot.BUBBLE_CHART_DATA);
                bubblePlotGlyph.setCombinedSize(this.bubblePlot.getCombinedSize());
                mapPlotGlyph.setBubblePlotGlyph(bubblePlotGlyph);
                break;
            }
            case Map_Pie: {
                PiePlotGlyph piePlotGlyph = (PiePlotGlyph)this.piePlot.createPlotGlyph(this.piePlot.defaultChartData());
                piePlotGlyph.setCombinedSize(this.piePlot.getCombinedSize());
                mapPlotGlyph.setPiePlotGlyph(piePlotGlyph);
                break;
            }
            case Map_Column: {
                Bar2DPlotGlyph bar2DPlotGlyph = (Bar2DPlotGlyph)this.bar2DPlot.createPlotGlyph(this.bar2DPlot.defaultChartData());
                mapPlotGlyph.setBar2DPlotGlyph(bar2DPlotGlyph);
                bar2DPlotGlyph.setCombinedSize(this.bar2DPlot.getCombinedSize());
            }
        }
    }

    private void getAllStartMapName(String[] stringArray, MapPlotGlyph mapPlotGlyph) {
        if (stringArray == null || stringArray.length <= 0) {
            return;
        }
        if (stringArray.length == 1 && StringUtils.isNotEmpty(stringArray[0])) {
            mapPlotGlyph.setMapName(stringArray[0]);
            return;
        }
        String[] stringArray2 = stringArray;
        boolean bl = true;
        while (bl) {
            int n2;
            int n3;
            for (n3 = 0; n3 < stringArray2.length; ++n3) {
                stringArray2[n3] = Utils.objectToString(this.fromMapNames.get(stringArray2[n3]));
            }
            n3 = 1;
            for (n2 = 0; n2 < stringArray2.length - 1; ++n2) {
                if (ComparatorUtils.equals(stringArray2[n2], stringArray2[n2 + 1])) continue;
                n3 = 0;
            }
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                if (!StringUtils.isEmpty(stringArray2[n2])) continue;
                n3 = 0;
                bl = false;
                break;
            }
            if (n3 == 0) continue;
            mapPlotGlyph.setMapName(stringArray[0]);
            bl = false;
        }
    }

    @Override
    protected void addSeries2PlotGlyph(PlotGlyph plotGlyph, ChartData chartData) {
        int n2;
        MapChartData mapChartData = (MapChartData)chartData;
        this.fromMapNames.clear();
        int n3 = this.hotAreaColor.getAreaNumber();
        int n4 = 1;
        for (n2 = 0; n2 < n3 + n4; ++n2) {
            plotGlyph.addSeries(new DataSeries(n2));
        }
        n2 = 0;
        if (this.isSvgMap) {
            this.add4NextSeries4Svg(this.mapName, this.mapName, n2, plotGlyph, mapChartData, this.hotAreaColor);
        } else {
            this.add4NextSeries(this.mapName, this.mapName, n2, plotGlyph, mapChartData, this.hotAreaColor);
        }
        double d2 = Double.MAX_VALUE;
        double d3 = 0.0;
        for (int i2 = 0; i2 < plotGlyph.getSeriesSize(); ++i2) {
            DataSeries dataSeries = plotGlyph.getSeries(i2);
            int n5 = dataSeries.getDataPointCount();
            for (int i3 = 0; i3 < n5; ++i3) {
                DataPoint4Map dataPoint4Map = (DataPoint4Map)dataSeries.getDataPoint(i3);
                MapAreaValue mapAreaValue = dataPoint4Map.getAreaValue();
                if (mapAreaValue == null) continue;
                double d4 = mapAreaValue.getTitleValueByIndex(this.heatIndex);
                d2 = Math.min(d2, d4);
                d3 = Math.max(d3, d4);
            }
        }
        if (d2 == Double.MAX_VALUE) {
            d2 = 0.0;
        }
        this.hotAreaColor.refreshMinMax(d2, d3);
        this.hotAreaColor.initColor();
        this.makeSurePointIndex(plotGlyph, this.hotAreaColor);
        this.createDataPointLabel(plotGlyph);
    }

    @Override
    protected void createDataPointLabel(PlotGlyph plotGlyph) {
        this.initTotalValue(plotGlyph);
        if (this.mapType == ChartEnumDefinitions.MapType.Map_Normal) {
            this.createDataLabel4EverySeries(plotGlyph);
        }
    }

    private void createDataPointLabel4CombineGlyph(MapPlotGlyph mapPlotGlyph) {
        int n2 = mapPlotGlyph.getSeriesSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            DataSeries dataSeries = mapPlotGlyph.getSeries(i2);
            int n3 = dataSeries.getDataPointCount();
            for (int i3 = 0; i3 < n3; ++i3) {
                DataPoint4Map dataPoint4Map = (DataPoint4Map)dataSeries.getDataPoint(i3);
                if (dataPoint4Map.getCombineGlyph() == null || dataPoint4Map.getCombineGlyph().getPlotGlyph() == null) continue;
                Object t2 = dataPoint4Map.getCombineGlyph().getPlotGlyph();
                int n4 = ((PlotGlyph)t2).getSeriesSize();
                for (int i4 = 0; i4 < n4; ++i4) {
                    DataSeries dataSeries2 = ((PlotGlyph)t2).getSeries(i4);
                    for (int i5 = 0; i5 < dataSeries2.getDataPointCount(); ++i5) {
                        DataPoint dataPoint = dataSeries2.getDataPoint(i5);
                        this.createDataLabelWithDataPoint4Map(dataPoint, dataPoint4Map);
                    }
                }
            }
        }
    }

    private void initTotalValue(PlotGlyph plotGlyph) {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        int n2 = plotGlyph.getSeriesSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            DataSeries dataSeries = plotGlyph.getSeries(i2);
            int n3 = dataSeries.getDataPointCount();
            for (int i3 = 0; i3 < n3; ++i3) {
                DataPoint dataPoint = dataSeries.getDataPoint(i3);
                dataPoint.setCategoryIndex(i3);
                if (dataPoint.isValueIsNull()) continue;
                String string = dataPoint.getSeriesName();
                if (hashMap.containsKey(string)) {
                    Object v2 = hashMap.get(string);
                    double d2 = Utils.objectToNumber(v2, false).doubleValue();
                    hashMap.remove(string);
                    hashMap.put(string, new Double(d2 + dataPoint.getValue()));
                    continue;
                }
                hashMap.put(string, new Double(dataPoint.getValue()));
            }
        }
        this.dealDataPointPercent(plotGlyph, hashMap);
    }

    private void dealDataPointPercent(PlotGlyph plotGlyph, HashMap hashMap) {
        int n2 = plotGlyph.getSeriesSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            DataSeries dataSeries = plotGlyph.getSeries(i2);
            int n3 = dataSeries.getDataPointCount();
            for (int i3 = 0; i3 < n3; ++i3) {
                String string;
                Object v2;
                double d2;
                DataPoint dataPoint = dataSeries.getDataPoint(i3);
                if (dataPoint.isValueIsNull() || (d2 = Utils.objectToNumber(v2 = hashMap.get(string = dataPoint.getSeriesName()), false).doubleValue()) == 0.0) continue;
                dataPoint.setPercentValue(dataPoint.getValue() / d2);
            }
        }
    }

    @Override
    public LegendGlyph createLegendGlyph(PlotGlyph plotGlyph) {
        if (plotGlyph == null || this.getLegend() == null) {
            return null;
        }
        MapPlotGlyph mapPlotGlyph = (MapPlotGlyph)plotGlyph;
        if (!this.isSvgMap()) {
            return this.createBitMapLegendGlyph();
        }
        boolean bl = this.mapType != ChartEnumDefinitions.MapType.Map_Normal;
        DataPoint4Map dataPoint4Map = mapPlotGlyph.getCurrentMapDataPoint();
        LegendGlyph legendGlyph = new LegendGlyph();
        if (dataPoint4Map != null && bl) {
            MapAreaValue mapAreaValue = dataPoint4Map.getAreaValue();
            if (mapAreaValue != null) {
                LegendItem[] legendItemArray = this.mapType == ChartEnumDefinitions.MapType.Map_Bubble ? this.getLegendItems4Bubble(mapAreaValue) : this.getLegendItems4BarPie(mapAreaValue);
                if (this.getLegend() != null) {
                    legendGlyph = this.getLegend().createLegendGlyph(legendItemArray);
                }
            }
        } else if (!bl && !this.isHeatMap) {
            legendGlyph = null;
        } else if (this.getLegend() != null) {
            legendGlyph = this.getLegend().createLegendGlyph(new LegendItem[0]);
        }
        return legendGlyph;
    }

    private LegendItem[] getLegendItems4Bubble(MapAreaValue mapAreaValue) {
        int n2 = 1;
        int n3 = mapAreaValue.titleValueSize();
        AttrFillStyle attrFillStyle = this.bubblePlot.getPlotFillStyle();
        Color[] colorArray = ChartBaseUtils.createFillColorArray(attrFillStyle, n3);
        if (this.isHeatMap && this.heatIndex != -1 && n3 == 1) {
            n2 = 0;
        }
        LegendItem[] legendItemArray = new LegendItem[n2];
        if (n2 > 0) {
            for (int i2 = 0; i2 < n3; ++i2) {
                if (i2 == this.heatIndex && this.isHeatMap) continue;
                legendItemArray[0] = new LegendItem("");
                LineMarkerIcon lineMarkerIcon = new LineMarkerIcon();
                lineMarkerIcon.setBackground(ColorBackground.getInstance(colorArray[0]));
                legendItemArray[0].setLineMarkerIcon(lineMarkerIcon);
                legendItemArray[0].setLabel(mapAreaValue.getTitleValue(i2).getTitle());
                break;
            }
        }
        return legendItemArray;
    }

    private LegendItem[] getLegendItems4BarPie(MapAreaValue mapAreaValue) {
        int n2 = mapAreaValue.titleValueSize();
        AttrFillStyle attrFillStyle = this.mapType == ChartEnumDefinitions.MapType.Map_Column ? this.bar2DPlot.getPlotFillStyle() : this.piePlot.getPlotFillStyle();
        Color[] colorArray = ChartBaseUtils.createFillColorArray(attrFillStyle, n2);
        int n3 = this.isHeatMap && this.heatIndex != -1 ? n2 - 1 : n2;
        LegendItem[] legendItemArray = new LegendItem[n3];
        int n4 = 0;
        for (int i2 = 0; i2 < n2 && n4 < n3; ++i2) {
            if (this.isHeatMap && i2 == this.heatIndex) continue;
            legendItemArray[n4] = new LegendItem("");
            LineMarkerIcon lineMarkerIcon = new LineMarkerIcon();
            lineMarkerIcon.setBackground(ColorBackground.getInstance(colorArray[n4]));
            legendItemArray[n4].setLineMarkerIcon(lineMarkerIcon);
            legendItemArray[n4].setLabel(mapAreaValue.getTitleValue(i2).getTitle());
            ++n4;
        }
        return legendItemArray;
    }

    private LegendGlyph createBitMapLegendGlyph() {
        if (this.getLegend() == null) {
            return new LegendGlyph();
        }
        Color[] colorArray = this.hotAreaColor.initColor();
        LegendItem[] legendItemArray = new LegendItem[colorArray.length];
        for (int i2 = 0; i2 < colorArray.length; ++i2) {
            legendItemArray[i2] = new LegendItem("");
            LineMarkerIcon lineMarkerIcon = new LineMarkerIcon();
            lineMarkerIcon.setBackground(ColorBackground.getInstance(colorArray[i2]));
            legendItemArray[i2].setLineMarkerIcon(lineMarkerIcon);
            legendItemArray[i2].setLabel(this.hotAreaColor.getLabelWithInt(i2));
        }
        return this.getLegend().createLegendGlyph(legendItemArray);
    }

    private MapAreaValue add4NextSeries(String string, String string2, int n2, PlotGlyph plotGlyph, MapChartData mapChartData, MapHotAreaColor mapHotAreaColor) {
        MapAttr mapAttr = (MapAttr)MapXMLHelper.getInstance().getMapAttr(string2);
        if (mapAttr == null) {
            return new MapAreaValue();
        }
        MapAttr mapAttr2 = (MapAttr)MapXMLHelper.getInstance().getMapAttr(this.mapName);
        MapAreaValue mapAreaValue = new MapAreaValue();
        Iterator iterator = mapAttr.shapeValuesIterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            DataPoint4Map dataPoint4Map = new DataPoint4Map();
            dataPoint4Map.setNameFrom(string);
            dataPoint4Map.setLayerIndex(n2);
            dataPoint4Map.setSeriesName(string2);
            if (!ComparatorUtils.equals(string2, string)) {
                this.fromMapNames.put(string2, string);
            }
            String string4 = mapAttr2.getLayerTo(string3);
            String string5 = this.getDataUseName(mapAttr2, string3, string2);
            if (mapChartData.isHasLayerTo()) {
                dataPoint4Map.setHasNextTo(StringUtils.isNotBlank(string4));
                dataPoint4Map.setNameLayerTo(string4);
            } else {
                dataPoint4Map.setHasNextTo(false);
                dataPoint4Map.setNameLayerTo("");
            }
            dataPoint4Map.setCategoryName(string5);
            dataPoint4Map.setCategoryOriginalName(string3);
            this.initDataPoint4Map(string4, string2, string5, n2, plotGlyph, mapChartData, mapHotAreaColor, dataPoint4Map, mapAreaValue);
        }
        return mapAreaValue;
    }

    private MapAreaValue add4NextSeries4Svg(String string, String string2, int n2, PlotGlyph plotGlyph, MapChartData mapChartData, MapHotAreaColor mapHotAreaColor) {
        MapSvgAttr mapSvgAttr = MapSvgXMLHelper.getInstance().getMapAttr(string2);
        if (mapSvgAttr == null) {
            return new MapAreaValue();
        }
        MapSvgAttr mapSvgAttr2 = MapSvgXMLHelper.getInstance().getMapAttr(this.mapName);
        MapAreaValue mapAreaValue = new MapAreaValue();
        Iterator iterator = mapSvgAttr.shapeValuesIterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            DataPoint4Map dataPoint4Map = new DataPoint4Map();
            dataPoint4Map.setNameFrom(string);
            dataPoint4Map.setLayerIndex(n2);
            dataPoint4Map.setSeriesName(string2);
            if (!ComparatorUtils.equals(string2, string)) {
                this.fromMapNames.put(string2, string);
            }
            String string4 = mapSvgAttr2.getLayerTo(string3);
            String string5 = this.getDataUseName4Svg(mapSvgAttr2, string3, string2);
            if (mapChartData.isHasLayerTo()) {
                dataPoint4Map.setHasNextTo(StringUtils.isNotBlank(string4));
                dataPoint4Map.setNameLayerTo(string4);
            } else {
                dataPoint4Map.setHasNextTo(false);
                dataPoint4Map.setNameLayerTo("");
            }
            dataPoint4Map.setCategoryName(string5);
            dataPoint4Map.setCategoryOriginalName(string3);
            this.initDataPoint4Map(string4, string2, string5, n2, plotGlyph, mapChartData, mapHotAreaColor, dataPoint4Map, mapAreaValue);
        }
        return mapAreaValue;
    }

    private boolean isPointComNext(DataPoint4Map dataPoint4Map, MapChartData mapChartData, String string, String string2) {
        return dataPoint4Map.isHasNextTo() && mapChartData.isHasLayerTo() && !ComparatorUtils.equals(string, string2) && StringUtils.isNotBlank(string2);
    }

    private void initDataPoint4Map(String string, String string2, String string3, int n2, PlotGlyph plotGlyph, MapChartData mapChartData, MapHotAreaColor mapHotAreaColor, DataPoint4Map dataPoint4Map, MapAreaValue mapAreaValue) {
        int n3 = 0;
        MapAreaValue mapAreaValue2 = (MapAreaValue)mapChartData.getMapData(string3);
        if (this.isPointComNext(dataPoint4Map, mapChartData, string2, string)) {
            MapAreaValue mapAreaValue3 = this.isSvgMap ? this.add4NextSeries4Svg(string2, string, n2 + 1, plotGlyph, mapChartData, mapHotAreaColor) : this.add4NextSeries(string2, string, n2 + 1, plotGlyph, mapChartData, mapHotAreaColor);
            if (mapAreaValue3.isTitleValueNull()) {
                if (!mapAreaValue2.isTitleValueNull()) {
                    double d2 = mapAreaValue2.getTitleValueByIndex(this.heatIndex);
                    dataPoint4Map.setValue(d2);
                    dataPoint4Map.setAreaValue(mapAreaValue2);
                    this.checkMapAreaTitle(mapAreaValue, mapAreaValue2);
                    n3 = mapHotAreaColor.getColorsIndex(d2);
                } else {
                    dataPoint4Map.setValue(0.0);
                    dataPoint4Map.setValueIsNull(true);
                    n3 = plotGlyph.getSeriesSize() - 1;
                }
            } else {
                dataPoint4Map.setValue(mapAreaValue3.getTitleValueByIndex(this.heatIndex));
                dataPoint4Map.setAreaValue(mapAreaValue3);
                this.checkMapAreaTitle(mapAreaValue, mapAreaValue3);
                n3 = mapHotAreaColor.getColorsIndex(mapAreaValue3.getTitleValueByIndex(this.heatIndex));
            }
        } else if (mapAreaValue2.isTitleValueNull()) {
            dataPoint4Map.setValue(0.0);
            dataPoint4Map.setValueIsNull(true);
            n3 = plotGlyph.getSeriesSize() - 1;
        } else {
            double d3 = mapAreaValue2.getTitleValueByIndex(this.heatIndex);
            dataPoint4Map.setValue(d3);
            dataPoint4Map.setAreaValue(mapAreaValue2);
            this.checkMapAreaTitle(mapAreaValue, mapAreaValue2);
            n3 = mapHotAreaColor.getColorsIndex(d3);
        }
        dataPoint4Map.setSeriesIndex(n3);
        DataSeries dataSeries = plotGlyph.getSeries(n3);
        dataSeries.addDataPoint(dataPoint4Map);
    }

    private void checkMapAreaTitle(MapAreaValue mapAreaValue, MapAreaValue mapAreaValue2) {
        if (mapAreaValue.isTitleValueNull()) {
            int n2 = mapAreaValue2.titleValueSize();
            for (int i2 = 0; i2 < n2; ++i2) {
                MapTitleValue mapTitleValue = mapAreaValue2.getTitleValue(i2);
                mapAreaValue.addTitleValue(new MapTitleValue(mapTitleValue.getTitle(), mapTitleValue.getValue()));
            }
        } else {
            int n3 = mapAreaValue2.titleValueSize();
            for (int i3 = 0; i3 < n3; ++i3) {
                MapTitleValue mapTitleValue = mapAreaValue2.getTitleValue(i3);
                MapTitleValue mapTitleValue2 = mapAreaValue.getTitleValue(i3);
                mapTitleValue2.setValue(mapTitleValue2.getValue() + mapTitleValue.getValue());
            }
        }
    }

    private String getDataUseName(MapAttr mapAttr, String string, String string2) {
        MapAttr mapAttr2;
        String string3 = Utils.objectToString(mapAttr.getNameToValue(string));
        if (!ComparatorUtils.equals(string2, this.mapName) && (mapAttr2 = (MapAttr)MapXMLHelper.getInstance().getMapAttr(string2)) != null) {
            string3 = Utils.objectToString(mapAttr2.getNameToValue(string));
        }
        return string3;
    }

    private String getDataUseName4Svg(MapSvgAttr mapSvgAttr, String string, String string2) {
        MapSvgAttr mapSvgAttr2;
        String string3 = mapSvgAttr.getNameToValue(string);
        if (!ComparatorUtils.equals(string2, this.mapName) && (mapSvgAttr2 = MapSvgXMLHelper.getInstance().getMapAttr(string2)) != null) {
            string3 = mapSvgAttr2.getNameToValue(string);
        }
        return string3;
    }

    private void makeSurePointIndex(PlotGlyph plotGlyph, MapHotAreaColor mapHotAreaColor) {
        HashMap hashMap = new HashMap();
        int n2 = plotGlyph.getSeriesSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            DataSeries dataSeries = plotGlyph.getSeries(i2);
            for (int i3 = 0; i3 < dataSeries.getDataPointCount(); ++i3) {
                int n3;
                DataPoint dataPoint = dataSeries.getDataPoint(i3);
                if (dataPoint.isValueIsNull() || (n3 = mapHotAreaColor.getColorsIndex(dataPoint.getValue())) == i2) continue;
                dataSeries.removeDataPoint(dataPoint);
                dataPoint.setSeriesIndex(n3);
                DataSeries dataSeries2 = plotGlyph.getSeries(n3);
                dataSeries2.addDataPoint(dataPoint);
                --i3;
            }
        }
        this.dealDataPointPercent(plotGlyph, hashMap);
    }

    public void setMapAreaColor(MapHotAreaColor mapHotAreaColor) {
        this.hotAreaColor = mapHotAreaColor;
    }

    public MapHotAreaColor getMapAreaColor() {
        return this.hotAreaColor;
    }

    public ChartEnumDefinitions.MapType getMapType() {
        return this.mapType;
    }

    public void setMapType(ChartEnumDefinitions.MapType mapType) {
        this.mapType = mapType;
        this.checkMapType();
    }

    public boolean isHeatMap() {
        return this.isHeatMap;
    }

    public void setHeatMap(boolean bl) {
        this.isHeatMap = bl;
    }

    public int getHeatIndex() {
        return this.heatIndex;
    }

    public void setHeatIndex(int n2) {
        this.heatIndex = n2;
    }

    public String getPlotDataPaneName() {
        return XML_TAG;
    }

    public void setMapName(String string) {
        this.mapName = string;
    }

    public boolean isSvgMap() {
        return this.isSvgMap;
    }

    public void setSvgMap(boolean bl) {
        this.isSvgMap = bl;
    }

    public Plot getCurrentCombinedPlot() {
        this.checkMapType();
        return this.plot;
    }

    public String getMapName() {
        return this.mapName;
    }

    public String[] getCurrentShowName() {
        return this.currentShowName;
    }

    public void setCurrentShowName(String[] stringArray) {
        this.currentShowName = stringArray;
    }

    @Override
    public String getPlotName() {
        return Inter.getLocText("FR-Chart-Map_Map");
    }

    @Override
    public boolean isHaveAxis() {
        return false;
    }

    @Override
    public boolean matchPlotType(Plot plot) {
        return plot instanceof MapPlot;
    }

    @Override
    public ChartData defaultChartData() {
        return MAP_CHART_DATA;
    }

    @Override
    public ChartData createNullChartData() {
        return new MapChartData();
    }

    private static final void getFirst() {
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_China"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 1000.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Xinjiang"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 300.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Guangdong"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 200.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Fuzhou"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 100.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Tianjing"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 600.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Huhehaote"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 700.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Shenyang"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 800.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Changchun"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 900.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Haerbin"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 1000.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Hangzhou"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 1100.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Hefei"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 1200.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Nanchang"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 1300.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Jinan"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 1400.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Wuhan"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 1500.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Changsha"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 1600.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Guangzhou"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 500.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Nanning"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 600.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Haikou"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 500.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Chengdu"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 100.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Guiyang"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 200.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Kunming"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 300.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Lasa"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 400.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Xian"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 500.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Yinchuan"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 100.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Wulumuqi"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 500.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Shijiazhuang"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 300.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Taiyuan"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 300.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Shanghai"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 100.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Chongqing"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 200.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Lanzhou"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 100.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Xining"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 100.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Nanjing"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 300.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Zhengzhou"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 100.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Taibei"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 200.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Zhongxiqu"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 300.0)));
        MAP_CHART_DATA.addMapData(Inter.getLocText("FR-Chart-Map_Aomenbandao"), new MapAreaValue(new MapTitleValue(Inter.getLocText("FR-Chart-Map_Title"), 500.0)));
    }

    private static final void getSecond() {
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_China"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 800.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Xinjiang"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 600.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Guangdong"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 100.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Fuzhou"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 400.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Tianjing"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 800.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Huhehaote"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 500.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Shenyang"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 300.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Changchun"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 300.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Haerbin"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 400.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Hangzhou"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 300.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Hefei"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 600.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Nanchang"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 800.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Jinan"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 900.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Wuhan"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 900.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Changsha"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 1000.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Guangzhou"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 250.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Nanning"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 1000.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Haikou"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 800.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Chengdu"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 200.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Guiyang"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 100.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Kunming"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 400.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Lasa"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 500.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Xian"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 200.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Yinchuan"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 300.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Wulumuqi"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 300.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Shijiazhuang"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 400.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Taiyuan"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 500.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Shanghai"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 400.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Chongqing"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 400.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Lanzhou"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 600.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Xining"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 100.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Nanjing"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 500.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Zhengzhou"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 400.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Taibei"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 300.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Zhongxiqu"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 200.0));
        MAP_CHART_DATA.addTitleValue(Inter.getLocText("FR-Chart-Map_Aomenbandao"), new MapTitleValue(Inter.getLocText("FR-Chart-Map_Second_Title"), 200.0));
    }

    @Override
    public int[] getInteractivePaneArrayThatNotSurpport() {
        return new int[]{1, 2};
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (ComparatorUtils.equals("newattr201212", string)) {
                if (xMLableReader.getAttrAsString("mapName", null) != null) {
                    this.mapName = xMLableReader.getAttrAsString("mapName", null);
                }
                this.readMapInfo(xMLableReader);
            } else if (ComparatorUtils.equals("newattr201106", string)) {
                if (xMLableReader.getAttrAsString("mapName", null) != null) {
                    this.mapName = xMLableReader.getAttrAsString("mapName", null);
                    this.mapName = XML_NAMES.containsKey(this.mapName) ? Utils.objectToString(XML_NAMES.get(this.mapName)) : Inter.getLocText("FR-Chart-Map_China");
                }
                this.readMapInfo(xMLableReader);
            } else if (ComparatorUtils.equals(string, "MapHotAreaColor")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        MapPlot.this.hotAreaColor = (MapHotAreaColor)xMLableReader.readXMLObject(new MapHotAreaColor());
                    }
                });
            } else if (ComparatorUtils.equals(string, "BubblePlot")) {
                this.bubblePlot = (BubblePlot)xMLableReader.readXMLObject(new BubblePlot());
            } else if (ComparatorUtils.equals(string, "Plot")) {
                this.piePlot = (PiePlot)xMLableReader.readXMLObject(new PiePlot());
            } else if (ComparatorUtils.equals(string, "CategoryPlot")) {
                this.bar2DPlot = (Bar2DPlot)xMLableReader.readXMLObject(new Bar2DPlot());
            }
        }
        this.checkMapType();
    }

    private void readMapInfo(XMLableReader xMLableReader) {
        this.isSvgMap = xMLableReader.getAttrAsBoolean("isSvgMap", false);
        this.mapType = ChartEnumDefinitions.MapType.valueOf(xMLableReader.getAttrAsString("mapType", "Map_Normal"));
        this.isHeatMap = xMLableReader.getAttrAsBoolean("isHeatMap", false);
        this.heatIndex = xMLableReader.getAttrAsInt("heatIndex", 0);
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("newattr201212").attr("mapName", this.mapName).attr("isSvgMap", this.isSvgMap).attr("mapType", this.mapType.toString()).attr("isHeatMap", this.isHeatMap).attr("heatIndex", this.heatIndex).end();
        if (this.hotAreaColor != null) {
            this.hotAreaColor.writeXML(xMLPrintWriter);
        }
        if (this.bubblePlot != null) {
            this.bubblePlot.writeXML(xMLPrintWriter);
        }
        if (this.piePlot != null) {
            this.piePlot.writeXML(xMLPrintWriter);
        }
        if (this.bar2DPlot != null) {
            this.bar2DPlot.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof MapPlot && super.equals(object) && this.isSvgMap == ((MapPlot)object).isSvgMap && this.isHeatMap == ((MapPlot)object).isHeatMap && this.heatIndex == ((MapPlot)object).heatIndex && ComparatorUtils.equals(this.hotAreaColor, ((MapPlot)object).getMapAreaColor()) && ComparatorUtils.equals(this.mapName, ((MapPlot)object).getMapName()) && ComparatorUtils.equals((Object)this.mapType, (Object)((MapPlot)object).getMapType()) && ComparatorUtils.equals(this.getCurrentCombinedPlot(), ((MapPlot)object).getCurrentCombinedPlot());
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MapPlot mapPlot = (MapPlot)super.clone();
        if (this.bubblePlot != null) {
            mapPlot.bubblePlot = (BubblePlot)this.bubblePlot.clone();
        }
        if (this.piePlot != null) {
            mapPlot.piePlot = (PiePlot)this.piePlot.clone();
        }
        if (this.bar2DPlot != null) {
            mapPlot.bar2DPlot = (Bar2DPlot)this.bar2DPlot.clone();
        }
        if (this.hotAreaColor != null) {
            mapPlot.hotAreaColor = (MapHotAreaColor)this.hotAreaColor.clone();
        }
        mapPlot.setSvgMap(this.isSvgMap());
        mapPlot.setHeatMap(this.isHeatMap());
        mapPlot.setHeatIndex(this.getHeatIndex());
        mapPlot.setMapName(this.getMapName());
        mapPlot.setMapType(this.getMapType());
        return mapPlot;
    }

    @Override
    public String getPlotSmallIconPath() {
        return "/com/fr/design/images/toolbar/map/0";
    }

    @Override
    public ChartTypeValueCollection getPlotType() {
        return ChartTypeValueCollection.MAP;
    }

    @Override
    public boolean isMapPlot() {
        return true;
    }

    @Override
    public boolean isSupportPlotBackground() {
        return false;
    }

    private void checkMapType() {
        switch (this.mapType) {
            case Map_Bubble: {
                this.plot = this.bubblePlot;
                break;
            }
            case Map_Pie: {
                this.plot = this.piePlot;
                break;
            }
            case Map_Column: {
                this.plot = this.bar2DPlot;
                break;
            }
            default: {
                this.plot = null;
            }
        }
    }

    @Override
    public boolean isMapKindLabel() {
        return true;
    }

    @Override
    public void dependence(CalculatorProvider calculatorProvider, List<String> list) {
        super.dependence(calculatorProvider, list);
        this.hotAreaColor.dependence(calculatorProvider, list);
    }

    @Override
    public void dealFormula(Calculator calculator) {
        super.dealFormula(calculator);
        this.hotAreaColor.dealFormula(calculator);
    }

    @Override
    public String getPlotID() {
        return "FineReportMapChart";
    }

    @Override
    public FunctionProcessor getFunctionToRecord() {
        return ChartFunctionProcessor.MAP_CHART;
    }

    @Override
    public boolean accept(Class<? extends Plot> clazz) {
        return ComparatorUtils.equals(MapPlot.class, clazz);
    }

    static {
        MapPlot.getFirst();
        MapPlot.getSecond();
        XML_NAMES = new HashMap();
    }
}

