/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.base;

import com.fr.base.GraphHelper;
import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrBackground;
import com.fr.chart.base.AttrBorder;
import com.fr.chart.base.AttrColor;
import com.fr.chart.base.AttrContents;
import com.fr.chart.base.AttrLineStyle;
import com.fr.chart.base.StyleContactWithConditionCollection;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;

public class ColorInfo
implements XMLable,
StyleContactWithConditionCollection {
    private static final long serialVersionUID = -2219673427793792660L;
    public static final String XML_TAG = "ColorInfo";
    private AttrAlpha seriesAttrAlpha = new AttrAlpha();
    private AttrBorder seriesAttrBorder = new AttrBorder();
    private AttrColor seriesAttrColor = new AttrColor();

    public void setSeriesAttrColor(AttrColor attrColor) {
        this.seriesAttrColor = attrColor;
    }

    public AttrColor getSeriesAttrColor() {
        return this.seriesAttrColor;
    }

    public void setSeriesAttrBorder(AttrBorder attrBorder) {
        this.seriesAttrBorder = attrBorder;
    }

    public AttrBorder getSeriesAttrBorder() {
        return this.seriesAttrBorder;
    }

    public void setSeriesAttrAlpha(AttrAlpha attrAlpha) {
        this.seriesAttrAlpha = attrAlpha;
    }

    public AttrAlpha getSeriesAttrAlpha() {
        return this.seriesAttrAlpha;
    }

    public void changeStyleAttrColor(AttrColor attrColor) {
        this.seriesAttrColor = attrColor;
    }

    public void changeStyleAttrAlpha(AttrAlpha attrAlpha) {
        this.seriesAttrAlpha = attrAlpha;
    }

    public void changeStyleAttrBorder(AttrBorder attrBorder) {
        this.seriesAttrBorder = attrBorder;
    }

    public void changeStyleAttrContents(AttrContents attrContents) {
    }

    public void changeStyleAttrLineStyle(AttrLineStyle attrLineStyle) {
    }

    public void changeStyleAttrBackground(AttrBackground attrBackground) {
    }

    public void paint(Graphics graphics, Shape shape) {
        if (shape == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        Paint paint = graphics2D.getPaint();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.seriesAttrAlpha.getAlpha()));
        if (this.seriesAttrColor.getSeriesColor() != null) {
            graphics2D.setPaint(this.seriesAttrColor.getSeriesColor());
            graphics2D.fill(shape);
        }
        if (this.getSeriesAttrBorder().getBorderStyle() != 0 && this.getSeriesAttrBorder().getBorderColor() != null) {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setPaint(this.getSeriesAttrBorder().getBorderColor());
            graphics2D.setStroke(GraphHelper.getStroke(this.getSeriesAttrBorder().getBorderStyle()));
            graphics2D.draw(shape);
            graphics2D.setStroke(stroke);
        }
        graphics2D.setComposite(composite);
        graphics2D.setPaint(paint);
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Attr")) {
                this.getSeriesAttrBorder().setBorderStyle(xMLableReader.getAttrAsInt("borderStyle", 0));
                this.getSeriesAttrBorder().setBorderColor(xMLableReader.getAttrAsColor("borderColor", Color.black));
                this.getSeriesAttrColor().setSeriesColor(xMLableReader.getAttrAsColor("seriesColor", Color.black));
                this.getSeriesAttrAlpha().setAlpha(xMLableReader.getAttrAsFloat("defaultAlpha", 1.0f));
            } else if (string.equals("AttrAlpha")) {
                this.seriesAttrAlpha = (AttrAlpha)xMLableReader.readXMLObject(new AttrAlpha());
            } else if (string.equals("AttrBorder")) {
                this.seriesAttrBorder = (AttrBorder)xMLableReader.readXMLObject(new AttrBorder());
            } else if (string.equals("AttrColor")) {
                this.seriesAttrColor = (AttrColor)xMLableReader.readXMLObject(new AttrColor());
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (this.seriesAttrAlpha != null) {
            this.seriesAttrAlpha.writeXML(xMLPrintWriter);
        }
        if (this.seriesAttrBorder != null) {
            this.seriesAttrBorder.writeXML(xMLPrintWriter);
        }
        if (this.seriesAttrColor != null) {
            this.seriesAttrColor.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        ColorInfo colorInfo = (ColorInfo)super.clone();
        return colorInfo;
    }

    public boolean equals(Object object) {
        return object instanceof ColorInfo && ComparatorUtils.equals(((ColorInfo)object).getSeriesAttrAlpha(), this.seriesAttrAlpha) && ComparatorUtils.equals(((ColorInfo)object).getSeriesAttrBorder(), this.seriesAttrBorder) && ComparatorUtils.equals(((ColorInfo)object).getSeriesAttrColor(), this.seriesAttrColor);
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.seriesAttrAlpha != null) {
            jSONObject.put("seriesAttrAlpha", this.seriesAttrAlpha.toJSONObject(repository));
        }
        if (this.seriesAttrBorder != null) {
            jSONObject.put("seriesAttrBorder", this.seriesAttrBorder.toJSONObject(repository));
        }
        if (this.seriesAttrColor != null) {
            jSONObject.put("seriesAttrColor", this.seriesAttrColor.toJSONObject(repository));
        }
        return jSONObject;
    }
}

