/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cache;

import com.fr.cache.FRCache;
import com.fr.cache.LfuPolicyHelper;
import com.fr.cache.MemoryStore;
import com.fr.cache.Unity;
import java.util.HashMap;
import java.util.Iterator;

public class LfuMemoryStore
extends MemoryStore {
    protected LfuMemoryStore(FRCache fRCache) {
        super(fRCache);
        this.map = new HashMap();
    }

    public final synchronized void doPut(Unity unity) {
        if (this.isFull()) {
            this.removeLfuElement(unity);
        }
    }

    private void removeLfuElement(Unity unity) {
        Unity unity2 = this.findRelativelyUnused(unity);
        if (unity2.isExpired()) {
            this.remove(unity2.getObjectKey());
            this.notifyExpiry(unity2);
            return;
        }
        this.evict(unity2);
        this.remove(unity2.getObjectKey());
    }

    private final Unity findRelativelyUnused(Unity unity) {
        LfuPolicyHelper.Metadata[] metadataArray = this.sampleElements(this.map.size());
        LfuPolicyHelper.Metadata metadata = LfuPolicyHelper.leastHit(metadataArray, new UnityMetadata(unity));
        return (Unity)this.map.get(metadata.getObjectKey());
    }

    private LfuPolicyHelper.Metadata[] sampleElements(int n2) {
        int[] nArray = LfuPolicyHelper.generateRandomSample(n2);
        LfuPolicyHelper.Metadata[] metadataArray = new UnityMetadata[nArray.length];
        Iterator iterator = this.map.values().iterator();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            for (int i3 = 0; i3 < nArray[i2]; ++i3) {
                iterator.next();
            }
            metadataArray[i2] = new UnityMetadata((Unity)iterator.next());
        }
        return metadataArray;
    }

    private class UnityMetadata
    implements LfuPolicyHelper.Metadata {
        private Unity element;

        public UnityMetadata(Unity unity) {
            this.element = unity;
        }

        public Object getObjectKey() {
            return this.element.getObjectKey();
        }

        public long getHitCount() {
            return this.element.getHitCount();
        }

        public int hashCode() {
            if (this.element != null) {
                return this.element.getKey().hashCode();
            }
            return 0;
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof LfuPolicyHelper.Metadata) {
                LfuPolicyHelper.Metadata metadata = (LfuPolicyHelper.Metadata)object;
                return this.getObjectKey().equals(metadata.getObjectKey());
            }
            return false;
        }
    }
}

